/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.quark;

import cern.colt.map.OpenIntIntHashMap;
import com.neeve.ci.XRuntime;
import com.neeve.memory.MemoryStats;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlPool;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

public class QuarkBuffer
implements UtlPool.Item<QuarkBuffer> {
    private static final int BYTES_OFFSET;
    private static final int SHORTS_OFFSET;
    private static final int CHARS_OFFSET;
    private static final int INTS_OFFSET;
    private static final int FLOATS_OFFSET;
    private static final int LONGS_OFFSET;
    private static final int DOUBLES_OFFSET;
    private static final Unsafe UNSAFE;
    private static final boolean isNativeAndIOByteOrderDifferent;
    private static final PoolEvictedItemReceiver evictedItemReceiver;
    private static final long gb = 0x40000000L;
    private static final long mb = 0x100000L;
    private static final long kb = 1024L;
    private static final int SMALLEST_SLAB_SIZE = 32;
    private static final Factory[] directPoolFactories;
    private static final UtlPool<QuarkBuffer>[] directPools;
    private static final Factory[] heapPoolFactories;
    private static final UtlPool<QuarkBuffer>[] heapPools;
    private static final OpenIntIntHashMap slabTable;
    private static final byte FLG_NATIVE = 1;
    private static final byte FLG_NOWIPE = 2;
    private static final byte FLG_TAKEN = 4;
    private static final byte FLG_POOLED = 8;
    private static final byte FLG_WRAPPED = 16;
    private static final MemoryStats stats;
    private static final ThreadLocal<StringBuilder> STRING_BUILDER;
    public static final boolean DISABLE_NATIVE_BUFFERS;
    private final ByteBuffer buffer;
    private final AtomicInteger ownershipCount;
    private int length;
    private int highwater;
    private UtlPool<QuarkBuffer> pool;
    private byte flags;

    private QuarkBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.ownershipCount = new AtomicInteger(0);
        this.highwater = this.length = buffer.capacity();
        this.setIsNative(buffer.isDirect());
        this.setWrapped(true);
    }

    private QuarkBuffer(int capacity, boolean isNative) {
        this.setIsNative(isNative);
        this.buffer = isNative ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        this.ownershipCount = new AtomicInteger(0);
        stats.onIOBufferAllocated(isNative, false, capacity);
    }

    private static final StringBuilder getStringBuilder(int length) {
        StringBuilder sb = STRING_BUILDER.get();
        if (sb == null) {
            sb = new StringBuilder(Math.max(32, length));
            STRING_BUILDER.set(sb);
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    private final void setIsNative(boolean val) {
        this.flags = val ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    private final void setNoWipe(boolean val) {
        this.flags = val ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    private final boolean isNoWipe() {
        return (this.flags & 2) != 0;
    }

    private final void setTaken(boolean val) {
        this.flags = val ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    private final boolean isTaken() {
        return (this.flags & 4) != 0;
    }

    private final void setPooled(boolean val) {
        this.flags = val ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    private final boolean isPooled() {
        return (this.flags & 8) != 0;
    }

    private final void setWrapped(boolean val) {
        this.flags = val ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    private final boolean isWrapped() {
        return (this.flags & 0x10) != 0;
    }

    private static final int pow2(int exp) {
        int ret = 1;
        for (int i = 0; i < exp; ++i) {
            ret *= 2;
        }
        return ret;
    }

    private static final String memToStr(long val) {
        if (val >= 0x40000000L) {
            if (val % 0x40000000L == 0L) {
                return String.format("%d", val / 0x40000000L) + "G";
            }
            return String.format("%.1f", Float.valueOf((float)val / 1.0737418E9f)) + "G";
        }
        if (val >= 0x100000L) {
            if (val % 0x100000L == 0L) {
                return String.format("%d", val / 0x100000L) + "M";
            }
            return String.format("%.1f", Float.valueOf((float)val / 1048576.0f)) + "M";
        }
        if (val >= 1024L) {
            if (val % 1024L == 0L) {
                return String.format("%d", val / 1024L) + "K";
            }
            return String.format("%.1f", Float.valueOf((float)val / 1024.0f)) + "K";
        }
        return String.format("%d", val);
    }

    private static final int nextHighestPowerOfTwo(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return ++x;
    }

    private final QuarkBuffer undispose(int length) {
        this.highwater = this.length = length;
        this.buffer.limit(this.length);
        int val = this.ownershipCount.getAndSet(1);
        if (val != 0 && this.pool != null) {
            throw new IllegalStateException("attempt to undispose an IO buffer that's not disposed (val=" + val + ", pool=" + this.pool + ")");
        }
        if (this.isPooled()) {
            stats.onIOBufferAllocated(this.isNative(), true, this.buffer.capacity());
            this.setPooled(false);
        }
        return this;
    }

    public static QuarkBuffer create(int length, boolean isNative) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        int slab = QuarkBuffer.slab(length);
        QuarkBuffer buffer = !DISABLE_NATIVE_BUFFERS && isNative ? (slab < 0 ? new QuarkBuffer(length, isNative) : directPools[slab].get(null)) : (slab < 0 ? new QuarkBuffer(length, isNative) : heapPools[slab].get(null));
        return buffer.undispose(length);
    }

    public static QuarkBuffer createNative(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        int slab = QuarkBuffer.slab(length);
        QuarkBuffer buffer = slab < 0 ? new QuarkBuffer(length, true) : directPools[slab].get(null);
        return buffer.undispose(length);
    }

    public static QuarkBuffer wrap(ByteBuffer buffer) {
        return new QuarkBuffer(buffer).acquire();
    }

    public static final boolean isNativeXQuarkBufferEnabled() {
        return !DISABLE_NATIVE_BUFFERS;
    }

    public static final QuarkBuffer ensureCapacity(QuarkBuffer buffer, int val, boolean initFromExisting) {
        if (buffer == null) {
            return QuarkBuffer.createNative(val);
        }
        if (buffer.getCapacity() >= val) {
            buffer.highwater = buffer.length = Math.max(buffer.length, val);
            buffer.buffer.limit(buffer.length);
            return buffer;
        }
        QuarkBuffer newBuffer = QuarkBuffer.createNative(val);
        if (initFromExisting) {
            buffer.getTo(0, newBuffer, 0, buffer.length);
        }
        buffer.dispose();
        return newBuffer;
    }

    public static final int slab(int val) {
        int x = QuarkBuffer.nextHighestPowerOfTwo(Math.max(32, val));
        if (x > 32) {
            int subBucketSize;
            int remainderAfter = val - (x /= 2);
            int numWholeSubBuckets = remainderAfter % (subBucketSize = (x * 2 - x) / 8) == 0 ? remainderAfter / subBucketSize : remainderAfter / subBucketSize + 1;
            x += numWholeSubBuckets * subBucketSize;
        }
        return slabTable.containsKey(x) ? slabTable.get(x) : -1;
    }

    public static final int smallestSlabSize() {
        return 32;
    }

    public static final int numSlabs() {
        return slabTable.size();
    }

    public static final long allocateMemoryBlock(long length, boolean zeroout) {
        long addr = UNSAFE.allocateMemory(length);
        if (zeroout) {
            UNSAFE.setMemory(addr, length, (byte)0);
        }
        stats.onNativeMemoryAllocated(length);
        return addr;
    }

    public static final long allocateMemoryBlock(long length) {
        return QuarkBuffer.allocateMemoryBlock(length, true);
    }

    public static final long ensureMemoryBlockCapacity(long addr, long length, int newlength, boolean zeroout) {
        if (addr == 0L) {
            return QuarkBuffer.allocateMemoryBlock(newlength, zeroout);
        }
        if (length < (long)newlength) {
            long newaddr = UNSAFE.reallocateMemory(addr, newlength);
            if (zeroout) {
                UNSAFE.setMemory(newaddr + length, (long)newlength - length, (byte)0);
            }
            stats.onNativeMemoryReallocated((long)newlength - length);
            return newaddr;
        }
        return addr;
    }

    public static final long ensureMemoryBlockCapacity(long addr, long length, int newlength) {
        return QuarkBuffer.ensureMemoryBlockCapacity(addr, length, newlength, true);
    }

    public static final void freeMemoryBlock(long addr, long length) {
        UNSAFE.freeMemory(addr);
        stats.onNativeMemoryFreed(length);
    }

    public static final int calculateUTF8Length(char c) {
        if (c >= '\u0001' && c <= '\u007f') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        if (!Character.isSurrogate(c)) {
            return 3;
        }
        return 0;
    }

    public static final int calculateUTF8Length(CharSequence str) {
        if (str == null) {
            return 0;
        }
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            int cutflen = QuarkBuffer.calculateUTF8Length(str.charAt(i));
            if (cutflen == 0) {
                if (i == strlen - 1) {
                    throw new IllegalArgumentException("supplied char sequence has an incomplete surrogate character pair");
                }
                utflen += 4;
                ++i;
                continue;
            }
            utflen += cutflen;
        }
        return utflen;
    }

    public static final void putByte(long addr, int offset, byte val) {
        UNSAFE.putByte(null, addr + (long)offset, val);
    }

    public static final byte getByte(long addr, int offset) {
        return UNSAFE.getByte(null, addr + (long)offset);
    }

    public static final int getUnsignedByte(long addr, int offset) {
        return QuarkBuffer.getByte(addr, offset) & 0xFF;
    }

    public static final void putShort(long addr, int offset, short val) {
        short v = isNativeAndIOByteOrderDifferent ? Short.reverseBytes(val) : val;
        UNSAFE.putShort(null, addr + (long)offset, v);
    }

    public static final short getShort(long addr, int offset) {
        short val = UNSAFE.getShort(null, addr + (long)offset);
        return isNativeAndIOByteOrderDifferent ? Short.reverseBytes(val) : val;
    }

    public static final void putChar(long addr, int offset, char val) {
        char v = isNativeAndIOByteOrderDifferent ? Character.reverseBytes(val) : val;
        UNSAFE.putChar(null, addr + (long)offset, v);
    }

    public static final int putASCIIChar(long addr, int offset, char val) {
        if (val < '\u0001' || val > '\u007f') {
            throw new IllegalArgumentException("character (" + val + ") a non-ASCII character");
        }
        QuarkBuffer.putByte(addr, offset, (byte)val);
        return 1;
    }

    public static final int putUTF8Char(long addr, int offset, char val) {
        int utflen = QuarkBuffer.calculateUTF8Length(val);
        if (utflen == 0) {
            throw new IllegalArgumentException(val + " is a surrogate character");
        }
        if (val >= '\u0001' && val <= '\u007f') {
            QuarkBuffer.putByte(addr, offset, (byte)val);
            return 1;
        }
        if (val <= '\u07ff') {
            QuarkBuffer.putByte(addr, offset, (byte)(0xC0 | val >> 6 & 0x1F));
            QuarkBuffer.putByte(addr, offset + 1, (byte)(0x80 | val & 0x3F));
            return 2;
        }
        QuarkBuffer.putByte(addr, offset, (byte)(0xE0 | val >> 12 & 0xF));
        QuarkBuffer.putByte(addr, offset + 1, (byte)(0x80 | val >> 6 & 0x3F));
        QuarkBuffer.putByte(addr, offset + 2, (byte)(0x80 | val & 0x3F));
        return 3;
    }

    public static final char getChar(long addr, int offset) {
        char val = UNSAFE.getChar(null, addr + (long)offset);
        return isNativeAndIOByteOrderDifferent ? Character.reverseBytes(val) : val;
    }

    public static final void putInt(long addr, int offset, int val) {
        int v = isNativeAndIOByteOrderDifferent ? Integer.reverseBytes(val) : val;
        UNSAFE.putInt(null, addr + (long)offset, v);
    }

    public static final int getInt(long addr, int offset) {
        int val = UNSAFE.getInt(null, addr + (long)offset);
        return isNativeAndIOByteOrderDifferent ? Integer.reverseBytes(val) : val;
    }

    public static final void putFloat(long addr, int offset, float val) {
        if (isNativeAndIOByteOrderDifferent) {
            UNSAFE.putInt(null, addr + (long)offset, Integer.reverseBytes(Float.floatToRawIntBits(val)));
        } else {
            UNSAFE.putFloat(null, addr + (long)offset, val);
        }
    }

    public static final float getFloat(long addr, int offset) {
        if (isNativeAndIOByteOrderDifferent) {
            return Float.intBitsToFloat(Integer.reverseBytes(UNSAFE.getInt(null, addr + (long)offset)));
        }
        return UNSAFE.getFloat(null, addr + (long)offset);
    }

    public static final void putLong(long addr, int offset, long val) {
        long v = isNativeAndIOByteOrderDifferent ? Long.reverseBytes(val) : val;
        UNSAFE.putLong(null, addr + (long)offset, v);
    }

    public static final long getLong(long addr, int offset) {
        long val = UNSAFE.getLong(null, addr + (long)offset);
        return isNativeAndIOByteOrderDifferent ? Long.reverseBytes(val) : val;
    }

    public static final void putDouble(long addr, int offset, double val) {
        if (isNativeAndIOByteOrderDifferent) {
            UNSAFE.putLong(null, addr + (long)offset, Long.reverseBytes(Double.doubleToRawLongBits(val)));
        } else {
            UNSAFE.putDouble(null, addr + (long)offset, val);
        }
    }

    public static final double getDouble(long addr, int offset) {
        if (isNativeAndIOByteOrderDifferent) {
            return Double.longBitsToDouble(Long.reverseBytes(UNSAFE.getLong(null, addr + (long)offset)));
        }
        return UNSAFE.getDouble(null, addr + (long)offset);
    }

    public static final int putASCIICharSequence(long addr, int offset, CharSequence val, int start, int end) {
        if (val == null) {
            return 0;
        }
        int pos = offset;
        for (int i = start; i < end; ++i) {
            char c = val.charAt(i);
            if (c < '\u0001' || c > '\u007f') {
                throw new IllegalArgumentException("character sequence contains a non-ASCII character (idx=" + i + ", val=" + c + ")");
            }
            QuarkBuffer.putByte(addr, pos++, (byte)c);
        }
        return end - start;
    }

    public static final int putASCIICharSequence(long addr, int offset, CharSequence val) {
        if (val == null) {
            return 0;
        }
        return QuarkBuffer.putASCIICharSequence(addr, offset, val, 0, val.length());
    }

    public static final String getASCIICharSequence(long addr, int offset, int len) {
        StringBuilder sb = QuarkBuffer.getStringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)QuarkBuffer.getByte(addr, offset + i));
        }
        return sb.toString();
    }

    static final int putUTF8CharSequence(long addr, int offset, CharSequence val, int utflen, int start, int end) {
        char c;
        int i;
        if (utflen == 0) {
            return 0;
        }
        int pos = offset;
        for (i = start; i < end && (c = val.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            QuarkBuffer.putByte(addr, pos++, (byte)c);
        }
        while (i < end) {
            c = val.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                QuarkBuffer.putByte(addr, pos++, (byte)c);
            } else if (c <= '\u07ff') {
                QuarkBuffer.putByte(addr, pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                QuarkBuffer.putByte(addr, pos++, (byte)(0x80 | c & 0x3F));
            } else if (Character.isSurrogate(c)) {
                if (i == end - 1) {
                    throw new IllegalArgumentException("supplied char sequence has an incomplete surrogate character pair");
                }
                int uc = Character.toCodePoint(c, val.charAt(++i));
                QuarkBuffer.putByte(addr, pos++, (byte)(0xF0 | uc >> 18 & 7));
                QuarkBuffer.putByte(addr, pos++, (byte)(0x80 | uc >> 12 & 0x3F));
                QuarkBuffer.putByte(addr, pos++, (byte)(0x80 | uc >> 6 & 0x3F));
                QuarkBuffer.putByte(addr, pos++, (byte)(0x80 | uc & 0x3F));
            } else {
                QuarkBuffer.putByte(addr, pos++, (byte)(0xE0 | c >> 12 & 0xF));
                QuarkBuffer.putByte(addr, pos++, (byte)(0x80 | c >> 6 & 0x3F));
                QuarkBuffer.putByte(addr, pos++, (byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
        return utflen;
    }

    public static final int putUTF8CharSequence(long addr, int offset, CharSequence val, int start, int end) {
        return QuarkBuffer.putUTF8CharSequence(addr, offset, val, QuarkBuffer.calculateUTF8Length(val), start, end);
    }

    public static final int putUTF8CharSequence(long addr, int offset, CharSequence val) {
        return QuarkBuffer.putUTF8CharSequence(addr, offset, val, QuarkBuffer.calculateUTF8Length(val), 0, val.length());
    }

    public static final String getUTF8CharSequence(long addr, int offset, int len) {
        StringBuilder sb = QuarkBuffer.getStringBuilder(len);
        try {
            byte c;
            int pos;
            for (pos = 0; pos < len && (c = QuarkBuffer.getByte(addr, offset + pos)) >= 0; ++pos) {
                sb.append((char)c);
            }
            block9: while (pos < len) {
                int c1 = QuarkBuffer.getUnsignedByte(addr, offset + pos++);
                switch (c1 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        sb.append((char)c1);
                        continue block9;
                    }
                    case 12: 
                    case 13: {
                        int c2;
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        if (((c2 = QuarkBuffer.getUnsignedByte(addr, offset + pos++)) & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + pos);
                        }
                        sb.append((char)((c1 & 0x1F) << 6 | c2 & 0x3F));
                        continue block9;
                    }
                    case 14: {
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        int c2 = QuarkBuffer.getUnsignedByte(addr, offset + pos++);
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        int c3 = QuarkBuffer.getByte(addr, offset + pos++);
                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (pos - 1));
                        }
                        sb.append((char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F));
                        continue block9;
                    }
                    case 15: {
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        int c2 = QuarkBuffer.getUnsignedByte(addr, offset + pos++);
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        int c3 = QuarkBuffer.getUnsignedByte(addr, offset + pos++);
                        if (pos == len) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte c4 = QuarkBuffer.getByte(addr, offset + pos++);
                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (pos - 1));
                        }
                        int c5 = (c1 & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F;
                        sb.append(Character.highSurrogate(c5));
                        sb.append(Character.lowSurrogate(c5));
                        continue block9;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + --pos);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final int varint32SerializedLength(int val) {
        if ((val & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((val & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((val & 0xFFE00000) == 0) {
            return 3;
        }
        if ((val & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static final int putVarint32(long addr, int offset, int val) {
        int len = 0;
        while (true) {
            if ((val & 0xFFFFFF80) == 0) {
                QuarkBuffer.putByte(addr, offset + len, (byte)val);
                return ++len;
            }
            QuarkBuffer.putByte(addr, offset + len, (byte)(val & 0x7F | 0x80));
            val >>>= 7;
            ++len;
        }
    }

    public static final int getVarint32(long addr, int offset, VarintDeserializeLength deserializeLength) {
        byte tmp;
        deserializeLength.value = 0;
        if ((tmp = QuarkBuffer.getByte(addr, offset + deserializeLength.value++)) >= 0) {
            return tmp;
        }
        int value = tmp & 0x7F;
        if ((tmp = QuarkBuffer.getByte(addr, offset + deserializeLength.value++)) >= 0) {
            value |= tmp << 7;
        } else {
            value |= (tmp & 0x7F) << 7;
            if ((tmp = QuarkBuffer.getByte(addr, offset + deserializeLength.value++)) >= 0) {
                value |= tmp << 14;
            } else {
                value |= (tmp & 0x7F) << 14;
                if ((tmp = QuarkBuffer.getByte(addr, offset + deserializeLength.value++)) >= 0) {
                    value |= tmp << 21;
                } else {
                    value |= (tmp & 0x7F) << 21;
                    tmp = QuarkBuffer.getByte(addr, offset + deserializeLength.value++);
                    value |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (QuarkBuffer.getByte(addr, offset + deserializeLength.value++) < 0) continue;
                            return value;
                        }
                        throw new IllegalArgumentException("address does not contain a serialized varint");
                    }
                }
            }
        }
        return value;
    }

    public static final int varint64SerializedLength(long val) {
        if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (val < 0L) {
            return 10;
        }
        int n = 2;
        if ((val & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            val >>>= 28;
        }
        if ((val & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            val >>>= 14;
        }
        if ((val & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static final int putVarint64(long addr, int offset, long val) {
        int len = 0;
        while (true) {
            if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
                QuarkBuffer.putByte(addr, offset + len, (byte)val);
                return ++len;
            }
            QuarkBuffer.putByte(addr, offset + len, (byte)((int)val & 0x7F | 0x80));
            val >>>= 7;
            ++len;
        }
    }

    public static final long getVarint64(long addr, int offset, VarintDeserializeLength deserializeLength) {
        deserializeLength.value = 0;
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = QuarkBuffer.getByte(addr, offset + deserializeLength.value++);
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IllegalArgumentException("address does not contain a serialized varint");
    }

    public static final void putFrom(long addr, int offset, byte[] array, int arrayoffset, int numelem) {
        UNSAFE.copyMemory(array, BYTES_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 1);
    }

    public static final void getTo(long addr, int offset, byte[] array, int arrayoffset, int numelem) {
        UNSAFE.copyMemory(null, addr + (long)offset, array, BYTES_OFFSET + arrayoffset, numelem * 1);
    }

    public static final void putFrom(long addr, int offset, short[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                QuarkBuffer.putShort(addr, offset + i * 2, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, SHORTS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 2);
        }
    }

    public static final void getTo(long addr, int offset, short[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = QuarkBuffer.getShort(addr, offset + i * 2);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, SHORTS_OFFSET + arrayoffset, numelem * 2);
        }
    }

    public static final void putFrom(long addr, int offset, char[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                QuarkBuffer.putChar(addr, offset + i * 2, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, CHARS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 2);
        }
    }

    public static final void getTo(long addr, int offset, char[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = QuarkBuffer.getChar(addr, offset + i * 2);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, CHARS_OFFSET + arrayoffset, numelem * 2);
        }
    }

    public static final void putFrom(long addr, int offset, int[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                QuarkBuffer.putInt(addr, offset + i * 4, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, INTS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 4);
        }
    }

    public static final void getTo(long addr, int offset, int[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = QuarkBuffer.getInt(addr, offset + i * 4);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, INTS_OFFSET + arrayoffset, numelem * 4);
        }
    }

    public static final void putFrom(long addr, int offset, float[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                QuarkBuffer.putFloat(addr, offset + i * 4, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, FLOATS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 4);
        }
    }

    public static final void getTo(long addr, int offset, float[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = QuarkBuffer.getFloat(addr, offset + i * 4);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, FLOATS_OFFSET + arrayoffset, numelem * 4);
        }
    }

    public static final void putFrom(long addr, int offset, long[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                QuarkBuffer.putLong(addr, offset + i * 8, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, LONGS_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 8);
        }
    }

    public static final void getTo(long addr, int offset, long[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = QuarkBuffer.getLong(addr, offset + i * 8);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, LONGS_OFFSET + arrayoffset, numelem * 8);
        }
    }

    public static final void putFrom(long addr, int offset, double[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                QuarkBuffer.putDouble(addr, offset + i * 8, array[arrayoffset + i]);
            }
        } else {
            UNSAFE.copyMemory(array, DOUBLES_OFFSET + arrayoffset, null, addr + (long)offset, numelem * 8);
        }
    }

    public static final void getTo(long addr, int offset, double[] array, int arrayoffset, int numelem) {
        if (isNativeAndIOByteOrderDifferent) {
            for (int i = 0; i < numelem; ++i) {
                array[arrayoffset + i] = QuarkBuffer.getDouble(addr, offset + i * 8);
            }
        } else {
            UNSAFE.copyMemory(null, addr + (long)offset, array, DOUBLES_OFFSET + arrayoffset, numelem * 8);
        }
    }

    public static final void putFrom(long addr, int offset, ByteBuffer buffer) {
        int len = buffer.remaining();
        long bufaddr = buffer.isDirect() ? UtlBuffer.getNativeBufferAddress(buffer) : (long)BYTES_OFFSET;
        byte[] bufobj = buffer.isDirect() ? null : buffer.array();
        UNSAFE.copyMemory(bufobj, bufaddr + (long)buffer.position(), null, addr + (long)offset, len);
    }

    public static final void getTo(long addr, int offset, ByteBuffer buffer, int len) {
        long bufaddr = buffer.isDirect() ? UtlBuffer.getNativeBufferAddress(buffer) : (long)BYTES_OFFSET;
        byte[] bufobj = buffer.isDirect() ? null : buffer.array();
        UNSAFE.copyMemory(null, addr + (long)offset, bufobj, bufaddr + (long)buffer.position(), len);
    }

    public static final void copy(long src, int srcoff, long dest, int destoff, int len) {
        UNSAFE.copyMemory(null, src + (long)srcoff, null, dest + (long)destoff, len);
    }

    public final QuarkBuffer copy() {
        QuarkBuffer copy = QuarkBuffer.create(this.length, this.isNative());
        this.takeBuffer();
        try {
            UtlBuffer.copy(this.buffer, 0, copy.buffer, 0, this.length);
        }
        finally {
            this.releaseBuffer();
        }
        return copy;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getCapacity() {
        return this.buffer.capacity();
    }

    public final ByteBuffer takeBuffer() {
        if (this.isTaken()) {
            throw new IllegalStateException("buffer already taken");
        }
        this.setTaken(true);
        return this.buffer;
    }

    public final QuarkBuffer releaseBuffer() {
        if (!this.isTaken()) {
            throw new IllegalStateException("buffer not taken");
        }
        this.setTaken(false);
        this.buffer.position(0).limit(this.length);
        return this;
    }

    public final ByteBuffer getBufferUnsafe() {
        if (this.isTaken()) {
            throw new IllegalStateException("operation not permitted while buffer is taken");
        }
        return this.buffer;
    }

    @Deprecated
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Deprecated
    public final QuarkBuffer getIOBuffer() {
        return this;
    }

    public final long getNativeAddress() {
        return this.isNative() ? UtlBuffer.getNativeBufferAddress(this.buffer) : 0L;
    }

    public final Object getHeapAddress() {
        return this.isNative() ? null : this.buffer.array();
    }

    public final boolean isNative() {
        return (this.flags & 1) != 0;
    }

    public final QuarkBuffer setNoWipe() {
        this.setNoWipe(true);
        return this;
    }

    public final void putFrom(int offset, byte[] array, int arrayoffset, int numelem) {
        QuarkBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, byte[] array, int arrayoffset, int numelem) {
        QuarkBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, short[] array, int arrayoffset, int numelem) {
        QuarkBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, short[] array, int arrayoffset, int numelem) {
        QuarkBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, char[] array, int arrayoffset, int numelem) {
        QuarkBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, char[] array, int arrayoffset, int numelem) {
        QuarkBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, int[] array, int arrayoffset, int numelem) {
        QuarkBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, int[] array, int arrayoffset, int numelem) {
        QuarkBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, float[] array, int arrayoffset, int numelem) {
        QuarkBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, float[] array, int arrayoffset, int numelem) {
        QuarkBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, long[] array, int arrayoffset, int numelem) {
        QuarkBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, long[] array, int arrayoffset, int numelem) {
        QuarkBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, double[] array, int arrayoffset, int numelem) {
        QuarkBuffer.putFrom(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void getTo(int offset, double[] array, int arrayoffset, int numelem) {
        QuarkBuffer.getTo(this.getNativeAddress(), offset, array, arrayoffset, numelem);
    }

    public final void putFrom(int offset, long addr, int addroffset, int len) {
        QuarkBuffer.copy(addr, addroffset, this.getNativeAddress(), offset, len);
    }

    public final void getTo(int offset, long addr, int addroffset, int len) {
        QuarkBuffer.copy(this.getNativeAddress(), offset, addr, addroffset, len);
    }

    public final void putFrom(int offset, ByteBuffer src) {
        QuarkBuffer.putFrom(this.getNativeAddress(), offset, src);
    }

    public final void getTo(int offset, ByteBuffer dest, int len) {
        QuarkBuffer.getTo(this.getNativeAddress(), offset, dest, len);
    }

    public final void putFrom(int offset, QuarkBuffer src, int srcoff, int len) {
        QuarkBuffer.copy(src.getNativeAddress(), srcoff, this.getNativeAddress(), offset, len);
    }

    public final void getTo(int offset, QuarkBuffer dest, int destoff, int len) {
        QuarkBuffer.copy(this.getNativeAddress(), offset, dest.getNativeAddress(), destoff, len);
    }

    public final QuarkBuffer acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed IO buffer");
        }
        return this;
    }

    public final int getOwnerCount() {
        return this.ownershipCount.get();
    }

    public final void dispose(int highwater) {
        if (this.isTaken()) {
            throw new IllegalStateException("operation not permitted while buffer is taken");
        }
        int val = this.ownershipCount.decrementAndGet();
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed IO buffer");
        }
        if (val == 0) {
            if (this.pool != null) {
                stats.onIOBufferDisposed(this.isNative(), true, this.buffer.capacity());
                this.setPooled(true);
                this.highwater = highwater;
                this.pool.put(this);
            } else if (this.isWrapped()) {
                if (this.buffer instanceof MappedByteBuffer) {
                    UtlBuffer.releaseBuffer(this.buffer);
                }
            } else {
                stats.onIOBufferDisposed(this.isNative(), false, this.buffer.capacity());
            }
        }
    }

    public final void dispose() {
        this.dispose(this.highwater);
    }

    @Override
    public final QuarkBuffer init() {
        this.buffer.clear();
        if (!this.isNoWipe()) {
            UtlBuffer.wipe(this.buffer, this.highwater);
            this.setNoWipe(false);
        }
        return this;
    }

    @Override
    public final QuarkBuffer setPool(UtlPool<QuarkBuffer> pool) {
        this.pool = pool;
        return this;
    }

    @Override
    public final UtlPool<QuarkBuffer> getPool() {
        return this.pool;
    }

    public final String toString() {
        return "[native=" + this.isNative() + ", ownerCount=" + this.ownershipCount.get() + ", buf=" + UtlBuffer.toString(this.buffer) + ", highwater=" + this.highwater + "]";
    }

    static {
        int j;
        int i;
        isNativeAndIOByteOrderDifferent = !ByteOrder.nativeOrder().toString().equalsIgnoreCase(XRuntime.getValue("nv.io.byteorder", ByteOrder.LITTLE_ENDIAN.toString()));
        DISABLE_NATIVE_BUFFERS = UtlEnv.getValue("nv.quarkbuf.disablenative", false);
        Field theUnsafe = null;
        try {
            theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            BYTES_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            SHORTS_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
            CHARS_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
            INTS_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            FLOATS_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
            LONGS_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            DOUBLES_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
        }
        catch (Throwable thrown) {
            throw new RuntimeException(thrown);
        }
        evictedItemReceiver = new PoolEvictedItemReceiver();
        ArrayList<Factory> factories = new ArrayList<Factory>();
        for (i = 0; i < 20; ++i) {
            for (j = 0; j < 8; ++j) {
                factories.add(new Factory(32 * QuarkBuffer.pow2(i) + 32 * (QuarkBuffer.pow2(i + 1) - QuarkBuffer.pow2(i)) * j / 8, false));
            }
        }
        heapPoolFactories = factories.toArray(new Factory[factories.size()]);
        heapPools = UtlPool.createPoolArray(heapPoolFactories.length);
        for (i = 0; i < heapPoolFactories.length; ++i) {
            QuarkBuffer.heapPools[i] = UtlPool.create("quarkbuf", "heap-" + QuarkBuffer.memToStr(QuarkBuffer.heapPoolFactories[i].slabSize), heapPoolFactories[i], UtlPool.Params.create().setThreaded(true).setDetachedWash(true)).setEvictedItemReceiver(evictedItemReceiver);
        }
        factories = new ArrayList();
        for (i = 0; i < 20; ++i) {
            for (j = 0; j < 8; ++j) {
                factories.add(new Factory(32 * QuarkBuffer.pow2(i) + 32 * (QuarkBuffer.pow2(i + 1) - QuarkBuffer.pow2(i)) * j / 8, true));
            }
        }
        directPoolFactories = factories.toArray(new Factory[factories.size()]);
        directPools = UtlPool.createPoolArray(directPoolFactories.length);
        for (i = 0; i < directPoolFactories.length; ++i) {
            QuarkBuffer.directPools[i] = UtlPool.create("quarkbuf", "native-" + QuarkBuffer.memToStr(QuarkBuffer.directPoolFactories[i].slabSize), directPoolFactories[i], UtlPool.Params.create().setThreaded(true).setDetachedWash(true)).setEvictedItemReceiver(evictedItemReceiver);
        }
        slabTable = new OpenIntIntHashMap();
        for (i = 0; i < heapPoolFactories.length; ++i) {
            slabTable.put(QuarkBuffer.heapPoolFactories[i].slabSize, i);
        }
        stats = MemoryStats.getInstance();
        STRING_BUILDER = new ThreadLocal();
        if (UtlEnv.getValue("nv.native.configtrace", false)) {
            System.out.println("NATIVE IO BUFFERS ARE " + (!DISABLE_NATIVE_BUFFERS ? "ENABLED" : "DISABLED"));
        }
    }

    public static final class VarintDeserializeLength {
        public int value;
    }

    private static final class PoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<QuarkBuffer> {
        private PoolEvictedItemReceiver() {
        }

        @Override
        public final void process(QuarkBuffer evictedItem) {
            stats.onIOBufferLeaked(evictedItem.isNative(), evictedItem.getCapacity());
        }
    }

    private static final class Factory
    implements UtlPool.Factory<QuarkBuffer> {
        final int slabSize;
        final boolean isNative;

        Factory(int slabSize, boolean isNative) {
            this.slabSize = slabSize;
            this.isNative = isNative;
        }

        @Override
        public final QuarkBuffer createItem(Object object) {
            return new QuarkBuffer(this.slabSize, this.isNative);
        }

        public final QuarkBuffer[] createItemArray(int size) {
            return new QuarkBuffer[size];
        }
    }
}

