/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollectionIterator;
import com.neeve.lang.XIterator;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Spliterator;

public abstract class XCollection<E>
implements Collection<E> {
    private XIterator<E> reusableIterator;
    private static final Object NULL = new Object();

    protected XCollection() {
    }

    @Override
    public abstract int size();

    public abstract Record head();

    public abstract Record tail();

    public abstract E valueOf(Record var1);

    public abstract void delete(Record var1);

    public Collection<E> unmodifiable() {
        return new Unmodifiable();
    }

    public Collection<E> shared() {
        return new Shared();
    }

    @Override
    public XIterator<E> iterator() {
        return XCollectionIterator.valueOf(this);
    }

    public boolean supportsIteratorModifications() {
        return true;
    }

    public XIterator<E> reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = this.iterator();
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean add(E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object value) {
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (!XCollection.equals(value, this.valueOf(r))) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Record head = this.head();
        for (Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object value) {
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (!XCollection.equals(value, this.valueOf(r))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Record head = this.head();
        Record r = this.tail().getPrevious();
        while (r != head) {
            Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Record head = this.head();
        Record r = this.tail().getPrevious();
        while (r != head) {
            Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    public void copyTo(Collection<? super E> c) {
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            c.add(this.valueOf(r));
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        Object[] objectArray = array = array.length >= size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        if (array.length > size) {
            array[size] = null;
        }
        int i = 0;
        T[] arrayView = array;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof List) {
            return obj instanceof List ? this.equalsOrder((List)obj) : false;
        }
        if (obj instanceof List) {
            return false;
        }
        if (!(obj instanceof Collection)) {
            return false;
        }
        Collection that = (Collection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(List<E> that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        Iterator<E> thatIterator = that.iterator();
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            E o2;
            E o1 = this.valueOf(r);
            if (XCollection.equals(o1, o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += XCollection.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + XCollection.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    private static final int hashCodeFor(Object value) {
        return value == null ? 0 : value.hashCode();
    }

    protected static boolean equals(Object o1, Object o2) {
        if (o1 == null != (o2 == null)) {
            return false;
        }
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private class Shared
    implements Collection<E> {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XCollection.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XCollection.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(Object o) {
            return XCollection.this.contains(o);
        }

        @Override
        public synchronized Object[] toArray() {
            return XCollection.this.toArray();
        }

        @Override
        public synchronized <T> T[] toArray(T[] a) {
            return XCollection.this.toArray(a);
        }

        @Override
        public synchronized Iterator<E> iterator() {
            if (XCollection.this instanceof List) {
                return new ListArrayIterator(XCollection.this.toArray());
            }
            return new CollectionArrayIterator(XCollection.this.toArray());
        }

        @Override
        public synchronized boolean add(E e) {
            return XCollection.this.add(e);
        }

        @Override
        public synchronized boolean remove(Object o) {
            return XCollection.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(Collection<?> c) {
            return XCollection.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(Collection<? extends E> c) {
            return XCollection.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(Collection<?> c) {
            return XCollection.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(Collection<?> c) {
            return XCollection.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XCollection.this.clear();
        }

        public synchronized String toString() {
            return XCollection.this.toString();
        }

        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
        }

        private class CollectionArrayIterator
        implements Iterator<E> {
            private final E[] _elements;
            private int _index;
            private E _next;

            public CollectionArrayIterator(E[] elements) {
                this._elements = elements;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public E next() {
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this._next == null) {
                    throw new IllegalStateException();
                }
                Shared.this.remove(this._next);
                this._next = null;
            }
        }

        private class ListArrayIterator
        implements Iterator<E> {
            private final Object[] _elements;
            private int _index;
            private int _removed;

            public ListArrayIterator(E[] elements) {
                this._elements = elements;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public E next() {
                Object elem;
                if ((elem = this._elements[this._index++]) == null) {
                    return null;
                }
                return elem;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this._index == 0) {
                    throw new IllegalStateException();
                }
                Object removed = this._elements[this._index - 1];
                if (removed == NULL) {
                    throw new IllegalStateException();
                }
                this._elements[this._index - 1] = NULL;
                ++this._removed;
                Shared shared = Shared.this;
                synchronized (shared) {
                    ((List)((Object)XCollection.this)).remove(this._index - this._removed);
                }
            }
        }
    }

    class Unmodifiable
    extends XCollection<E>
    implements List<E>,
    Set<E> {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XCollection.this.size();
        }

        @Override
        public Record head() {
            return XCollection.this.head();
        }

        @Override
        public Record tail() {
            return XCollection.this.tail();
        }

        @Override
        public E valueOf(Record record) {
            return XCollection.this.valueOf(record);
        }

        @Override
        public boolean contains(Object value) {
            return XCollection.this.contains(value);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return XCollection.this.containsAll(c);
        }

        @Override
        public boolean add(E obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public E get(int index) {
            return ((List)((Object)XCollection.this)).get(index);
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, Object element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(Object o) {
            return ((List)((Object)XCollection.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((List)((Object)XCollection.this)).lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }

        @Override
        public Spliterator<E> spliterator() {
            throw new UnsupportedOperationException("Split iterator not supported for unmodifiable collection");
        }
    }

    public static interface Record {
        public Record getPrevious();

        public Record getNext();
    }
}

