/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.test.unit.AepEngineTestLoopbackController;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestMessagingController;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.IAepEngineTestApp;
import com.neeve.ci.XRuntime;
import com.neeve.event.IEventHandler;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreInterClusterReplicatorDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.impl.loopback.LoopbackBus;
import com.neeve.test.UnitTest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public class AepEngineTest
extends UnitTest {
    public static final int B1_C1_BestEffort = 1;
    public static final int B1_C2_BestEffort = 2;
    public static final int B1_C3_BestEffort = 4;
    public static final int B1_C4_Guaranteed = 8;
    public static final int B1_C5_Guaranteed = 16;
    public static final int B1_C6_Guaranteed = 32;
    public static final int B2_C1_BestEffort = 64;
    public static final int B2_C2_Guaranteed = 128;
    public static final int NO_CHANNEL_INTEREST = 0;
    public static final int NO_CHANNEL_JOINS = 0;
    public static final int B1_BEST_EFFORT_CHANNELS = 7;
    public static final int B1_GUARANTEED_CHANNELS = 56;
    public static final int B1_ALL_CHANNELS = 63;
    public static final int B2_BEST_EFFORT_CHANNELS = 64;
    public static final int B2_GUARANTEED_CHANNELS = 128;
    public static final int B2_ALL_CHANNELS = 192;
    protected final List<AepEngine> engines = new ArrayList<AepEngine>();
    protected final List<StorePersisterDescriptor> persisterDescriptors = new ArrayList<StorePersisterDescriptor>();
    protected final List<StoreDescriptor> storeDescriptors = new ArrayList<StoreDescriptor>();
    protected final List<IAepEngineTestApp> testApps = new ArrayList<IAepEngineTestApp>();
    protected final Random random = new Random(System.currentTimeMillis());
    protected final AepEngineTestMessagingController messagingController = new AepEngineTestLoopbackController();
    protected BaseEngineCusomizer engineCustomizer;
    protected final String DISCOVERY_BUS = "discovery";
    protected String storeDiscoveryParams = "&initWaitTime=2000&discoveryInitWaitTime=1";
    public static int engineCounter = 1;

    protected final <T extends IAepEngineTestApp> T registerTestApp(T app) {
        this.testApps.add(app);
        return app;
    }

    protected final AepEngine createEngine(AepEngineDescriptor descriptor, Object annotatedHandlers, IEventHandler defaultEventHandler, IAepApplicationStateFactory stateFactory) throws Exception {
        HashSet<Object> objects = new HashSet<Object>();
        if (annotatedHandlers != null) {
            objects.add(annotatedHandlers);
        }
        AepEngine engine = AepEngine.create(descriptor, stateFactory, objects, defaultEventHandler, null);
        this.engines.add(engine);
        return engine;
    }

    protected final AepEngine createEngine(String engineName, AepEngine.HAPolicy haPolicy, AepEngine.MessagingStartFailPolicy messagingStartFailPolicy, AepEngine.MessageBusBindingFailPolicy messageBusBindingFailPolicy, AepEngine.InboundMessageLoggingPolicy inboundMessageLoggingPolicy, AepEngine.OutboundMessageLoggingPolicy outboundMessageLoggingPolicy, boolean hasStore, boolean hasStorePersister, boolean detachedStorePersister, boolean persisterFlushOnCommit, String storeRoot, int channelInterestMask, int channelJoinMask, Object annotatedHandlers, IEventHandler defaultEventHandler, IAepApplicationStateFactory stateFactory, int adaptiveCommitBatchCeiling, boolean dispatchTransactionStageEvents, boolean enableTransactionCommitSuspension, AepEngine.AppExceptionHandlingPolicy appExceptionHandlingPolicy, String quarantineChannel, AepEngine.MessageSendExceptionHandlingPolicy sendExceptionHandlingPolicy, boolean failOnMultiplePrimaries, boolean sequenceUnsolicitedSends, IEngineCustomizer customizer) throws Exception {
        boolean join;
        boolean interest;
        int i;
        if (hasStorePersister) {
            StorePersisterDescriptor persisterDescriptor = StorePersisterDescriptor.create((String)engineName, (String)"com.neeve.rog.log.RogLog");
            this.persisterDescriptors.add(persisterDescriptor);
            if (storeRoot != null) {
                persisterDescriptor.setProperty("storeRoot", storeRoot);
            }
            persisterDescriptor.setProperty("detachedPersist", detachedStorePersister ? "true" : "false");
            persisterDescriptor.setProperty("flushOnCommit", persisterFlushOnCommit ? "true" : "false");
            persisterDescriptor.setProperty("initialLogLength", "0.01");
            if (customizer != null) {
                customizer.customizePersister(persisterDescriptor);
            }
            persisterDescriptor.save();
        }
        if (hasStore) {
            StoreDescriptor storeDescriptor = StoreDescriptor.create((String)engineName);
            this.storeDescriptors.add(storeDescriptor);
            if (hasStorePersister) {
                storeDescriptor.setPersister(engineName);
                storeDescriptor.setPersistenceQuorum(1);
            }
            StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.create((String)engineName);
            replicatorDescriptor.setProperty("discoveryDescriptor", "loopback://discovery" + this.storeDiscoveryParams);
            replicatorDescriptor.setProperty("failOnMultiplePrimaries", failOnMultiplePrimaries ? "true" : "false");
            replicatorDescriptor.setProperty("detachedDispatch", "true");
            replicatorDescriptor.save();
            storeDescriptor.setReplicator(engineName);
            if (customizer != null) {
                customizer.customizeStore(storeDescriptor);
            }
            storeDescriptor.save();
        }
        AepEngineDescriptor descriptor = AepEngineDescriptor.create(engineName);
        if (haPolicy != null) {
            descriptor.setHAPolicy(haPolicy);
        }
        if (messagingStartFailPolicy != null) {
            descriptor.setMessagingStartFailPolicy(messagingStartFailPolicy);
        }
        if (messageBusBindingFailPolicy != null) {
            descriptor.setMessageBusBindingFailPolicy(messageBusBindingFailPolicy);
        }
        if (inboundMessageLoggingPolicy != null) {
            descriptor.setInboundMessageLoggingPolicy(inboundMessageLoggingPolicy);
        }
        if (storeRoot != null) {
            descriptor.setInboundMessageLoggingProperty("storeRoot", storeRoot);
        }
        descriptor.setInboundMessageLoggingProperty("initialLogLength", "0.01");
        if (outboundMessageLoggingPolicy != null) {
            descriptor.setOutboundMessageLoggingPolicy(outboundMessageLoggingPolicy);
        }
        if (storeRoot != null) {
            descriptor.setOutboundMessageLoggingProperty("storeRoot", storeRoot);
        }
        descriptor.setOutboundMessageLoggingProperty("initialLogLength", "0.01");
        if (hasStore) {
            descriptor.setStore(engineName);
        }
        for (i = 0; i < 6; ++i) {
            interest = (channelInterestMask & 1 << i) == 1 << i;
            boolean bl = join = (channelJoinMask & 1 << i) == 1 << i;
            if (!interest) continue;
            descriptor.addChannel("aeptest1", "channel" + (i + 1), AepEngineDescriptor.ChannelConfig.from("join=" + join));
        }
        for (i = 6; i < 8; ++i) {
            interest = (channelInterestMask & 1 << i) == 1 << i;
            boolean bl = join = (channelJoinMask & 1 << i) == 1 << i;
            if (!interest) continue;
            descriptor.addChannel("aeptest2", "channel" + (i + 1), AepEngineDescriptor.ChannelConfig.from("join=" + join));
        }
        if (adaptiveCommitBatchCeiling > 0) {
            descriptor.setAdaptiveCommitBatchCeiling(adaptiveCommitBatchCeiling);
        }
        descriptor.setDispatchTransactionStageEvents(dispatchTransactionStageEvents);
        descriptor.setEnableTransactionCommitSuspension(enableTransactionCommitSuspension);
        if (appExceptionHandlingPolicy != null) {
            descriptor.setAppExceptionHandlingPolicy(appExceptionHandlingPolicy);
        }
        if (sendExceptionHandlingPolicy != null) {
            descriptor.setMessageSendExceptionHandlingPolicy(sendExceptionHandlingPolicy);
        }
        descriptor.setSequenceUnsolicitedSends(sequenceUnsolicitedSends);
        descriptor.setQuarantineChannel(quarantineChannel);
        if (customizer != null && customizer != null) {
            customizer.customizeEngine(descriptor);
        }
        return this.createEngine(descriptor, annotatedHandlers, defaultEventHandler, stateFactory);
    }

    protected final AepEngine createEngine(String engineName, AepEngine.HAPolicy haPolicy, AepEngine.MessagingStartFailPolicy messagingStartFailPolicy, AepEngine.MessageBusBindingFailPolicy messageBusBindingFailPolicy, AepEngine.InboundMessageLoggingPolicy inboundMessageLoggingPolicy, AepEngine.OutboundMessageLoggingPolicy outboundMessageLoggingPolicy, boolean hasStore, boolean hasStorePersister, boolean detachedStorePersister, boolean persisterFlushOnCommit, String storeRoot, int channelInterestMask, int channelJoinMask, Object annotatedHandlers, IEventHandler defaultEventHandler, IAepApplicationStateFactory stateFactory, int adaptiveCommitBatchCeiling, boolean dispatchTransactionStageEvents, boolean enableTransactionCommitSuspension, AepEngine.AppExceptionHandlingPolicy appExceptionHandlingPolicy, String quarantineChannel, AepEngine.MessageSendExceptionHandlingPolicy sendExceptionHandlingPolicy, boolean failOnMultiplePrimaries, boolean sequenceUnsolicitedSends) throws Exception {
        return this.createEngine(engineName, haPolicy, messagingStartFailPolicy, messageBusBindingFailPolicy, inboundMessageLoggingPolicy, outboundMessageLoggingPolicy, hasStore, hasStorePersister, detachedStorePersister, persisterFlushOnCommit, storeRoot, channelInterestMask, channelJoinMask, annotatedHandlers, defaultEventHandler, stateFactory, adaptiveCommitBatchCeiling, dispatchTransactionStageEvents, enableTransactionCommitSuspension, appExceptionHandlingPolicy, quarantineChannel, sendExceptionHandlingPolicy, failOnMultiplePrimaries, sequenceUnsolicitedSends, this.engineCustomizer);
    }

    protected final AepEngine createEngine(String engineName) throws Exception {
        return this.createEngine(engineName, null, null, null, null, null, false, false, false, false, null, 0, 0, null, null, null, 0, false, false, null, null, null, false, false);
    }

    protected final void startSenderStandaloneReceiverStandalone(Object app1, IEventHandler defaultHandler1, String app2Name, Object app2, IEventHandler defaultHandler2, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStore, boolean hasStorePersister, boolean detachedStorePersister, int adaptiveCommitBatchCeiling, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, senderChannelMask, senderJoinMask, app1, defaultHandler1, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        String engineName = app2Name == null ? "engine-" + System.currentTimeMillis() + "-" + engineCounter++ : app2Name;
        AepEngine engine2 = this.createEngine(engineName, haPolicy, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", receiverChannelMask, receiverJoinMask, app2, defaultHandler2, null, adaptiveCommitBatchCeiling, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
    }

    protected final void startSenderStandaloneReceiverStandalone(Object app1, IEventHandler defaultHandler1, String app2Name, Object app2, IEventHandler defaultHandler2, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStore, boolean hasStorePersister, AepEngineTestObject.EncodingType encodingType) throws Exception {
        this.startSenderStandaloneReceiverStandalone(app1, defaultHandler1, app2Name, app2, defaultHandler2, receiverChannelMask, receiverJoinMask, senderChannelMask, senderJoinMask, haPolicy, hasStore, hasStorePersister, false, 0, encodingType);
    }

    protected final void startSenderStandaloneReceiverStandalone(Object app1, IEventHandler defaultHandler1, String app2Name, Object app2, IEventHandler defaultHandler2, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStore, boolean hasStorePersister) throws Exception {
        this.startSenderStandaloneReceiverStandalone(app1, defaultHandler1, app2Name, app2, defaultHandler2, receiverChannelMask, receiverJoinMask, senderChannelMask, senderJoinMask, haPolicy, hasStore, hasStorePersister, AepEngineTestObject.EncodingType.Proto);
    }

    protected final void startSenderStandaloneTwoReceiversStandalone(Object app1, IEventHandler defaultHandler1, String app2Name, Object app2, IEventHandler defaultHandler2, String app3Name, Object app3, IEventHandler defaultHandler3, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStore, boolean hasStorePersister, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, senderChannelMask, senderJoinMask, app1, defaultHandler1, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        String engineName = app2Name == null ? "engine-" + System.currentTimeMillis() + "-" + engineCounter++ : app2Name;
        AepEngine engine2 = this.createEngine(engineName, haPolicy, null, null, null, null, hasStore, hasStorePersister, false, false, XRuntime.getDataDirectory() + File.separator + "m1", receiverChannelMask, receiverJoinMask, app2, defaultHandler2, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        engineName = app3Name == null ? "engine-" + System.currentTimeMillis() + "-" + engineCounter++ : app3Name;
        AepEngine engine3 = this.createEngine(engineName, haPolicy, null, null, null, null, hasStore, hasStorePersister, false, false, XRuntime.getDataDirectory() + File.separator + "m2", receiverChannelMask, receiverJoinMask, app3, defaultHandler3, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine3.start();
        engine3.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine3.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine3.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
    }

    protected final void startSenderStandaloneTwoReceiversStandalone(Object app1, IEventHandler defaultHandler1, String app2Name, Object app2, IEventHandler defaultHandler2, String app3Name, Object app3, IEventHandler defaultHandler3, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStore, boolean hasStorePersister) throws Exception {
        this.startSenderStandaloneTwoReceiversStandalone(app1, defaultHandler1, app2Name, app2, defaultHandler2, app3Name, app3, defaultHandler3, receiverChannelMask, receiverJoinMask, senderChannelMask, senderJoinMask, haPolicy, hasStore, hasStorePersister, AepEngineTestObject.EncodingType.Proto);
    }

    protected final int startSenderStandaloneReceiverRedundant(Object sender, IEventHandler defaultSenderHandler, String receiverName, Object primaryReceiver, IEventHandler defaultPrimaryReceiverHandler, Object backupReceiver, IEventHandler defaultBackupReceiverHandler, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStorePersister, boolean detachedStorePersister, boolean parallelReceiverStart, int adaptiveCommitBatchCeiling, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, senderChannelMask, senderJoinMask, sender, defaultSenderHandler, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        String engineName = receiverName != null ? receiverName : "engine-" + System.currentTimeMillis() + "-" + engineCounter++;
        final AepEngine engine2 = this.createEngine(engineName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", receiverChannelMask, receiverJoinMask, primaryReceiver, defaultPrimaryReceiverHandler, null, adaptiveCommitBatchCeiling, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        Thread thread = null;
        if (parallelReceiverStart) {
            thread = new Thread(){

                @Override
                public final void run() {
                    try {
                        engine2.start();
                        engine2.waitForMessagingToStart();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        } else {
            engine2.start();
            engine2.waitForMessagingToStart();
            Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
            Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        }
        AepEngine engine3 = this.createEngine(engineName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m2", receiverChannelMask, receiverJoinMask, backupReceiver, defaultBackupReceiverHandler, null, adaptiveCommitBatchCeiling, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine3.start();
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((String)"Receiver engine not started", (Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((String)"Receiver engine messaging not started", (Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        return engine2.isPrimary() ? 0 : 1;
    }

    protected final int startSenderStandaloneReceiverRedundantWithICRReceiver(Object sender, IEventHandler defaultSenderHandler, String receiverName, Object primaryReceiver, IEventHandler defaultPrimaryReceiverHandler, Object backupReceiver, IEventHandler defaultBackupReceiverHandler, Object icrReceiver, IEventHandler defaultICRReceiverHandler, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStorePersister, boolean detachedStorePersister, boolean parallelReceiverStart, int adaptiveCommitBatchCeiling, AepEngineTestObject.EncodingType encodingType, final int clusterHearbeatInterval) throws Exception {
        BaseEngineCusomizer senderCustomizer = new BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setSequenceUnsolicitedSends(true);
                descriptor.setSequenceUnsolicitedWithSolicitedSends(true);
            }
        };
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, senderChannelMask, senderJoinMask, sender, defaultSenderHandler, null, 0, false, false, null, null, null, false, false, senderCustomizer);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        StoreInterClusterReplicatorDescriptor icrSender2Descriptor = StoreInterClusterReplicatorDescriptor.create((String)"icrSender2", (IStoreBinding.InterClusterReplicationRole)IStoreBinding.InterClusterReplicationRole.Sender, (String)"loopback://store");
        if (detachedStorePersister) {
            icrSender2Descriptor.setProperty("detachedSend", "true");
        }
        icrSender2Descriptor.save();
        BaseEngineCusomizer icrSender2Customizer = new BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setInterClusterReplicationQuorum(2);
                descriptor.setInterClusterReplicator("icrSender2");
            }

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setClusterHeartbeatInterval(clusterHearbeatInterval);
            }
        };
        StoreInterClusterReplicatorDescriptor icrSender3Descriptor = StoreInterClusterReplicatorDescriptor.create((String)"icrSender3", (IStoreBinding.InterClusterReplicationRole)IStoreBinding.InterClusterReplicationRole.Sender, (String)"loopback://store");
        if (detachedStorePersister) {
            icrSender3Descriptor.setProperty("detachedSend", "true");
        }
        icrSender3Descriptor.save();
        BaseEngineCusomizer icrSender3Customizer = new BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setInterClusterReplicationQuorum(2);
                descriptor.setInterClusterReplicator("icrSender3");
            }

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setClusterHeartbeatInterval(clusterHearbeatInterval);
            }
        };
        StoreInterClusterReplicatorDescriptor icrReceiverDescriptor = StoreInterClusterReplicatorDescriptor.create((String)"icrReceiver", (IStoreBinding.InterClusterReplicationRole)IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, (String)"loopback://store");
        icrReceiverDescriptor.save();
        BaseEngineCusomizer icrReceiverCustomizer = new BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setReplicator(null);
                descriptor.setInterClusterReplicationQuorum(2);
                descriptor.setInterClusterReplicator("icrReceiver");
            }

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setClusterHeartbeatInterval(clusterHearbeatInterval);
            }
        };
        String engineName = receiverName != null ? receiverName : "engine-" + System.currentTimeMillis() + "-" + engineCounter++;
        final AepEngine engine2 = this.createEngine(engineName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", receiverChannelMask, receiverJoinMask, primaryReceiver, defaultPrimaryReceiverHandler, null, adaptiveCommitBatchCeiling, false, false, null, null, null, false, false, icrSender2Customizer);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        AepEngine engine3 = this.createEngine(engineName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m2", receiverChannelMask, receiverJoinMask, backupReceiver, defaultBackupReceiverHandler, null, adaptiveCommitBatchCeiling, false, false, null, null, null, false, false, icrSender3Customizer);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        final AepEngine engine4 = this.createEngine(engineName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m3ICR", receiverChannelMask, receiverJoinMask, icrReceiver, defaultICRReceiverHandler, null, adaptiveCommitBatchCeiling, false, false, null, null, null, false, false, icrReceiverCustomizer);
        engine4.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        Thread icrStarter = new Thread(){

            @Override
            public void run() {
                try {
                    engine4.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        icrStarter.start();
        Thread thread = null;
        if (parallelReceiverStart) {
            thread = new Thread(){

                @Override
                public final void run() {
                    try {
                        engine2.start();
                        engine2.waitForMessagingToStart();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        } else {
            engine2.start();
            engine2.waitForMessagingToStart();
            Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
            Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        }
        engine3.start();
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((String)"Receiver engine not started", (Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((String)"Receiver engine messaging not started", (Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        return engine2.isPrimary() ? 0 : 1;
    }

    protected final int startSenderStandaloneReceiverRedundant(Object sender, IEventHandler defaultSenderHandler, String receiverName, Object primaryReceiver, IEventHandler defaultPrimaryReceiverHandler, Object backupReceiver, IEventHandler defaultBackupReceiverHandler, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStorePersister, boolean parallelReceiverStart, int adaptiveCommitBatchCeiling, AepEngineTestObject.EncodingType encodingType) throws Exception {
        return this.startSenderStandaloneReceiverRedundant(sender, defaultSenderHandler, receiverName, primaryReceiver, defaultPrimaryReceiverHandler, backupReceiver, defaultBackupReceiverHandler, receiverChannelMask, receiverJoinMask, senderChannelMask, senderJoinMask, haPolicy, hasStorePersister, false, parallelReceiverStart, adaptiveCommitBatchCeiling, encodingType);
    }

    protected final int startSenderStandaloneReceiverRedundant(Object sender, IEventHandler defaultSenderHandler, String receiverName, Object primaryReceiver, IEventHandler defaultPrimaryReceiverHandler, Object backupReceiver, IEventHandler defaultBackupReceiverHandler, int receiverChannelMask, int receiverJoinMask, int senderChannelMask, int senderJoinMask, AepEngine.HAPolicy haPolicy, boolean hasStorePersister, boolean parallelReceiverStart, int adaptiveCommitBatchCeiling) throws Exception {
        return this.startSenderStandaloneReceiverRedundant(sender, defaultSenderHandler, receiverName, primaryReceiver, defaultPrimaryReceiverHandler, backupReceiver, defaultBackupReceiverHandler, receiverChannelMask, receiverJoinMask, senderChannelMask, senderJoinMask, haPolicy, hasStorePersister, parallelReceiverStart, adaptiveCommitBatchCeiling, AepEngineTestObject.EncodingType.Proto);
    }

    protected final void waitForTransactionPipelineToEmpty(AepEngine engine) throws Exception {
        long numCommitsPending;
        int i;
        for (i = 0; i < 100 && (numCommitsPending = engine.getStats().getNumCommitsStarted() - engine.getStats().getNumCommitsCompleted()) != 0L; ++i) {
            System.out.println("num commits pending = " + numCommitsPending);
            Thread.sleep(100L);
        }
        Assert.assertTrue((i < 100 ? 1 : 0) != 0);
    }

    public final AepEngine createEngine(String engineName, AepEngine.HAPolicy haPolicy, AepEngine.InboundMessageLoggingPolicy inboundMessageLoggingPolicy, AepEngine.OutboundMessageLoggingPolicy outboundMessageLoggingPolicy, boolean hasStore, boolean hasStorePersister, int channelInterestMask, int channelJoinMask, Object annotatedHandlers, IEventHandler defaultEventHandler, IAepApplicationStateFactory stateFactory, IEngineCustomizer customizer) throws Exception {
        return this.createEngine(engineName, haPolicy, null, null, inboundMessageLoggingPolicy, outboundMessageLoggingPolicy, hasStore, hasStorePersister, false, false, null, channelInterestMask, channelJoinMask, annotatedHandlers, defaultEventHandler, stateFactory, 0, false, false, null, null, null, false, false, customizer);
    }

    @BeforeClass
    public static void initialize() throws Exception {
    }

    @AfterClass
    public static void cleanup() {
    }

    @Before
    public void testInitialize() throws Exception {
        this.messagingController.resetBus("aeptest1").resetBus("aeptest2");
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)"aeptest1");
        MessageChannelDescriptor bestEffortChannel1Descriptor = MessageChannelDescriptor.create((String)"channel1", (MessageBusDescriptor)busDescriptor);
        bestEffortChannel1Descriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        MessageChannelDescriptor bestEffortChannel2Descriptor = MessageChannelDescriptor.create((String)"channel2", (MessageBusDescriptor)busDescriptor);
        bestEffortChannel2Descriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        MessageChannelDescriptor bestEffortChannel3Descriptor = MessageChannelDescriptor.create((String)"channel3", (MessageBusDescriptor)busDescriptor);
        bestEffortChannel3Descriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        bestEffortChannel3Descriptor.setChannelKey("${stringField}/constant1/${child3Field.longField}/${intField}/constant2/${child2Field.child3Field.stringField}");
        MessageChannelDescriptor guaranteedChannel1Descriptor = MessageChannelDescriptor.create((String)"channel4", (MessageBusDescriptor)busDescriptor);
        guaranteedChannel1Descriptor.setChannelQos(MessageChannel.Qos.Guaranteed);
        MessageChannelDescriptor guaranteedChannel2Descriptor = MessageChannelDescriptor.create((String)"channel5", (MessageBusDescriptor)busDescriptor);
        guaranteedChannel2Descriptor.setChannelQos(MessageChannel.Qos.Guaranteed);
        MessageChannelDescriptor guaranteedChannel3Descriptor = MessageChannelDescriptor.create((String)"channel6", (MessageBusDescriptor)busDescriptor);
        guaranteedChannel3Descriptor.setChannelQos(MessageChannel.Qos.Guaranteed);
        busDescriptor.addChannel(bestEffortChannel1Descriptor);
        busDescriptor.addChannel(bestEffortChannel2Descriptor);
        busDescriptor.addChannel(bestEffortChannel3Descriptor);
        busDescriptor.addChannel(guaranteedChannel1Descriptor);
        busDescriptor.addChannel(guaranteedChannel2Descriptor);
        busDescriptor.addChannel(guaranteedChannel3Descriptor);
        busDescriptor.setProviderConfig("loopback://aeptest1");
        bestEffortChannel3Descriptor.setChannelFilter("intField=1*");
        busDescriptor.save("engine-p1");
        bestEffortChannel3Descriptor.setChannelFilter("intField=2*");
        busDescriptor.save("engine-p2");
        busDescriptor = MessageBusDescriptor.create((String)"aeptest2");
        MessageChannelDescriptor bestEffortChannel4Descriptor = MessageChannelDescriptor.create((String)"channel7", (MessageBusDescriptor)busDescriptor);
        bestEffortChannel1Descriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        MessageChannelDescriptor guaranteedChannel4Descriptor = MessageChannelDescriptor.create((String)"channel8", (MessageBusDescriptor)busDescriptor);
        guaranteedChannel4Descriptor.setChannelQos(MessageChannel.Qos.Guaranteed);
        busDescriptor.addChannel(bestEffortChannel4Descriptor);
        busDescriptor.addChannel(guaranteedChannel4Descriptor);
        busDescriptor.setProviderConfig("loopback://aeptest2");
        busDescriptor.save();
    }

    @After
    public void testCleanup() throws Exception {
        for (AepEngine engine : this.engines) {
            engine.stop();
            Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Stopped));
            Assert.assertEquals((Object)((Object)engine.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Stopped));
        }
        this.engines.clear();
        for (StoreDescriptor storeDescriptor : this.storeDescriptors) {
            storeDescriptor.delete();
        }
        this.storeDescriptors.clear();
        for (StorePersisterDescriptor persisterDescriptor : this.persisterDescriptors) {
            persisterDescriptor.delete();
        }
        this.persisterDescriptors.clear();
        MessageBusDescriptor.load((String)"aeptest1", null).delete();
        MessageBusDescriptor.load((String)"aeptest2", null).delete();
        for (IAepEngineTestApp app : this.testApps) {
            app.clear();
        }
        this.testApps.clear();
        LoopbackBus.clearAllInstances();
    }

    static {
        System.setProperty("nv.discovery.descriptor", "loopback://discovery&initWaitTime=1");
    }

    protected static class BaseEngineCusomizer
    implements IEngineCustomizer {
        protected BaseEngineCusomizer() {
        }

        @Override
        public void customizeStore(StoreDescriptor descriptor) {
        }

        @Override
        public void customizePersister(StorePersisterDescriptor descriptor) {
        }

        @Override
        public void customizeEngine(AepEngineDescriptor descriptor) {
        }
    }

    protected static interface IEngineCustomizer {
        public void customizeStore(StoreDescriptor var1);

        public void customizePersister(StorePersisterDescriptor var1);

        public void customizeEngine(AepEngineDescriptor var1);
    }
}

