/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.test.unit.AepEngineLogTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.sma.MessageView;
import com.neeve.test.util.ProcessWrapper;
import com.neeve.tools.TransactionLogTool;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTableFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AepEngineLogTest
extends AepEngineTest {
    private static final RogLogUtil.FieldFilter comparisonFilter;
    @Rule
    public ExpectedException invalidInboundMode = ExpectedException.none();
    @Rule
    public ExpectedException invalidOutboundMode = ExpectedException.none();
    private final AepEngine.HAPolicy haPolicy;
    private final boolean hasStore;
    private final boolean runBackup;
    private final FailureType failureType;
    private AepEngineTestObject.EncodingType encoding = AepEngineTestObject.EncodingType.Proto;
    private EngineApp[] engineApps;

    @Parameterized.Parameters(name="{index}: hasStore={0}, haPolicy={1}, runBackup={2}, failureType={3}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false, AepEngine.HAPolicy.EventSourcing, false, FailureType.NONE}, {false, AepEngine.HAPolicy.StateReplication, false, FailureType.NONE}, {true, AepEngine.HAPolicy.EventSourcing, false, FailureType.NONE}, {true, AepEngine.HAPolicy.StateReplication, false, FailureType.NONE}, {true, AepEngine.HAPolicy.EventSourcing, true, FailureType.NONE}, {true, AepEngine.HAPolicy.StateReplication, true, FailureType.NONE}, {true, AepEngine.HAPolicy.StateReplication, false, FailureType.GRACEFUL_PRIMARY_RESTART}, {true, AepEngine.HAPolicy.EventSourcing, true, FailureType.GRACEFUL_FAILOVER}, {true, AepEngine.HAPolicy.StateReplication, true, FailureType.GRACEFUL_FAILOVER}};
        return Arrays.asList(data);
    }

    public AepEngineLogTest(boolean hasStore, AepEngine.HAPolicy haPolicy, boolean runBackup, FailureType failureType) {
        this.haPolicy = haPolicy;
        this.hasStore = hasStore;
        this.runBackup = runBackup;
        this.failureType = failureType;
    }

    final List<AepEngineTestMessage> createMessagesToSend(AepEngineTestObject.EncodingType encodingType) {
        ArrayList<AepEngineTestMessage> list = new ArrayList<AepEngineTestMessage>();
        for (int i = 0; i < 2000; ++i) {
            list.add(new AepEngineTestMessage(encodingType));
        }
        return list;
    }

    @Before
    public void sleepToEnsureUniqueEngineName() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private EngineApp[] createEngines(AepEngine.InboundMessageLoggingPolicy inboundPolicy, AepEngine.OutboundMessageLoggingPolicy outboundPolicy) throws Exception {
        String appName = "engine-" + System.currentTimeMillis();
        EngineApp[] engineApps = this.runBackup ? new EngineApp[2] : new EngineApp[1];
        engineApps[0] = new EngineApp(appName, inboundPolicy, outboundPolicy, false);
        if (this.runBackup) {
            engineApps[1] = new EngineApp(appName, inboundPolicy, outboundPolicy, true);
        }
        block8: for (EngineApp ea : engineApps) {
            if (inboundPolicy == null) {
                Assert.assertNull((String)("Inbound logger should be null for " + ea), (Object)ea.engine.getInboundMessageLogger());
            } else {
                switch (inboundPolicy) {
                    case Off: {
                        Assert.assertNull((String)("Inbound logger should be null for " + ea), (Object)ea.engine.getInboundMessageLogger());
                        break;
                    }
                    case UseDedicated: {
                        Assert.assertNotNull((String)("Inbound Logger shouldn't be null for " + ea), (Object)ea.engine.getInboundMessageLogger());
                        break;
                    }
                }
            }
            if (outboundPolicy == null) {
                Assert.assertNull((String)("Outbound logger should be null for " + ea), (Object)ea.engine.getOutboundMessageLogger());
                continue;
            }
            switch (outboundPolicy) {
                case Off: {
                    Assert.assertNull((String)("Outbound logger should be null for " + ea), (Object)ea.engine.getOutboundMessageLogger());
                    continue block8;
                }
                case UseDedicated: {
                    Assert.assertNotNull((String)("Outbound logger shouldn't be null for " + ea), (Object)ea.engine.getOutboundMessageLogger());
                    Assert.assertNotSame((Object)ea.engine.getInboundMessageLogger(), (Object)ea.engine.getOutboundMessageLogger());
                    continue block8;
                }
            }
        }
        return engineApps;
    }

    public void sendMessages(List<AepEngineTestMessage> messages) throws Exception {
        int count = 0;
        AepEngine engine = this.engineApps[0].engine;
        AepEngineLogTestApp app = this.engineApps[0].app;
        block6: for (AepEngineTestMessage message : messages) {
            message.getMessage().setMessageBus("aeptest1");
            message.getMessage().setMessageChannel("channel1");
            if (++count == messages.size() / 2) {
                switch (this.failureType) {
                    case GRACEFUL_FAILOVER: {
                        System.out.println("GRACEFULLY SHUTDOWN OF PRIMARY");
                        UtlReflection.setNonNestedProperty((Object)message.getMessage(), (String)"stringField", (Object)"DOLAST");
                        engine.sendMessage(app.channel1, message.getMessage());
                        int tries = 0;
                        while (engine.getState() != AepEngine.State.Stopped) {
                            Thread.sleep(1000L);
                            if (tries > 50) {
                                System.out.println("Waiting for engine to stop...");
                            }
                            ++tries;
                        }
                        if (engine.getState() != AepEngine.State.Stopping) {
                            engine.stop();
                        }
                        if (engine.getState() != AepEngine.State.Stopped) {
                            Assert.fail((String)"Failed to stop engine");
                        }
                        engine = this.engineApps[1].engine;
                        app = this.engineApps[1].app;
                        if (this.haPolicy == AepEngine.HAPolicy.StateReplication) {
                            this.engineApps[0].app.passCountsToBackup(app);
                        }
                        engine.waitForMessagingToStart();
                        continue block6;
                    }
                    case HARD_FAILOVER: {
                        System.out.println("HARD FAILOVER OF PRIMARY");
                        UtlReflection.setNonNestedProperty((Object)message.getMessage(), (String)"stringField", (Object)"FORCEFAIL");
                        engine.sendMessage(app.channel1, message.getMessage());
                        int tries = 0;
                        while (engine.getState() != AepEngine.State.Stopped) {
                            Thread.sleep(1000L);
                            if (tries > 50) {
                                System.out.println("Waiting for engine to stop...");
                            }
                            ++tries;
                        }
                        if (engine.getState() != AepEngine.State.Stopping) {
                            engine.stop();
                        }
                        if (engine.getState() != AepEngine.State.Stopped) {
                            Assert.fail((String)"Failed to stop engine");
                        }
                        engine = this.engineApps[1].engine;
                        app = this.engineApps[1].app;
                        if (this.haPolicy == AepEngine.HAPolicy.StateReplication) {
                            this.engineApps[0].app.passCountsToBackup(app);
                        }
                        engine.waitForMessagingToStart();
                        continue block6;
                    }
                    case FAIL_ALL_RECOVER_BACKUP: {
                        throw new UnsupportedOperationException("Not yet implemented");
                    }
                    case GRACEFUL_PRIMARY_RESTART: 
                    case GRACEFUL_PRIMARY_RESTART_WITH_CHECKPOINT: {
                        System.out.println("TRIGGERING GRACEFUL PRIMARY RESTART");
                        UtlReflection.setNonNestedProperty((Object)message.getMessage(), (String)"stringField", (Object)"DOLAST");
                        engine.sendMessage(app.channel1, message.getMessage());
                        int tries = 0;
                        while (engine.getState() != AepEngine.State.Stopped) {
                            Thread.sleep(1000L);
                            if (tries > 50) {
                                System.out.println("Waiting for engine to stop...");
                            }
                            ++tries;
                        }
                        if (engine.getState() != AepEngine.State.Stopping) {
                            engine.stop();
                        }
                        if (engine.getState() != AepEngine.State.Stopped) {
                            Assert.fail((String)"Failed to stop engine");
                        }
                        if (this.failureType == FailureType.GRACEFUL_PRIMARY_RESTART_WITH_CHECKPOINT) {
                            RogLog log = RogLogFactory.createLog((String)this.engineApps[0].persister.getName(), (Properties)this.engineApps[0].persister.getDescriptor().getProperties());
                            log.open();
                            log.getCompactor().compact();
                            this.engineApps[0].persister.close();
                        }
                        this.engineApps[0].createEngine();
                        engine = this.engineApps[0].engine;
                        System.out.println("ENGINE RESTARTED");
                        continue block6;
                    }
                }
            }
            engine.sendMessage(app.channel1, message.getMessage());
        }
        app.waitForExpectedMessageReceipt(messages.size());
        if (this.hasStore && this.runBackup && this.failureType == FailureType.NONE) {
            this.engineApps[0].app.passCountsToBackup(this.engineApps[1].app);
        }
    }

    private final void runSingleAppLogTest() throws Exception {
        List<AepEngineTestMessage> messages = this.createMessagesToSend(this.encoding);
        this.sendMessages(messages);
        for (EngineApp ea : this.engineApps) {
            ea.waitForCommitStability(5000L);
            if (ea.engine.getState() != AepEngine.State.Started || ea.engine.isPrimary()) continue;
            ea.engine.stop();
        }
        for (EngineApp ea : this.engineApps) {
            ea.engine.stop();
        }
        for (EngineApp ea : this.engineApps) {
            ea.validateInboundLog();
            ea.validateOutboundLog();
            ea.validateRecoveryLog();
        }
    }

    @Test
    public final void testLogAppInboundDefaultOutboundDefault() throws Exception {
        this.engineApps = this.createEngines(null, null);
        this.runSingleAppLogTest();
    }

    @Test
    public final void testLogAppInboundOffOutboundOff() throws Exception {
        this.engineApps = this.createEngines(AepEngine.InboundMessageLoggingPolicy.Off, AepEngine.OutboundMessageLoggingPolicy.Off);
        this.runSingleAppLogTest();
    }

    @Test
    public final void testLogAppInboundUseDedicatedOutboundOff() throws Exception {
        this.engineApps = this.createEngines(AepEngine.InboundMessageLoggingPolicy.UseDedicated, AepEngine.OutboundMessageLoggingPolicy.Off);
        this.runSingleAppLogTest();
    }

    @Test
    public final void testLogAppInboundOffOutboundUseDedicated() throws Exception {
        this.engineApps = this.createEngines(AepEngine.InboundMessageLoggingPolicy.Off, AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
        this.runSingleAppLogTest();
    }

    @Test
    public final void testLogAppInboundUseDedicatedOutboundUseDedicated() throws Exception {
        this.engineApps = this.createEngines(AepEngine.InboundMessageLoggingPolicy.UseDedicated, AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
        this.runSingleAppLogTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Stats getLogStats(String name, Properties props) throws Exception {
        Stats stats = new Stats();
        log.open();
        try (RogLog log = RogLog.create((String)name, (Properties)props);){
            Stats stats2;
            RogLogReader reader = log.createReader();
            try {
                RogLog.Entry entry;
                RogLogReader.Transaction transaction;
                long lastTxnId = 0L;
                while ((transaction = reader.nextTransaction()) != null) {
                    if (transaction.getId() == -1L) {
                        ++stats.numOrphans;
                        continue;
                    }
                    ++stats.numTransactions;
                    if (lastTxnId == 0L) {
                        lastTxnId = transaction.getId();
                        continue;
                    }
                    if (transaction.getId() <= lastTxnId) {
                        ++stats.dups;
                        continue;
                    }
                    if (transaction.getId() != lastTxnId + 1L) {
                        stats.gaps = true;
                    }
                    lastTxnId = transaction.getId();
                }
                reader.rewind();
                long persistTs = 0L;
                while ((entry = reader.next()) != null) {
                    if (entry.getTimestamp() < persistTs) {
                        Assert.fail((String)("Non sequential entry timestamp in " + name + " for " + entry + " " + entry.getTimestamp() + " < " + persistTs));
                    }
                    persistTs = entry.getTimestamp();
                    switch (entry.getEntryType()) {
                        case Put: {
                            ++stats.numPuts;
                            break;
                        }
                        case Update: {
                            ++stats.numUpdates;
                            break;
                        }
                        case Remove: {
                            ++stats.numRemoves;
                            break;
                        }
                        case Send: {
                            ++stats.numSends;
                            break;
                        }
                        case Message: {
                            ++stats.numMessages;
                        }
                    }
                }
                reader.rewind();
                RogLog.Stats computed = reader.computeStats();
                try {
                    Assert.assertEquals((String)("Stats discrepancy, Wrong tx count for " + log.getName()), (long)stats.numTransactions, (long)computed.getNumTransactions());
                    Assert.assertEquals((String)("Stats discrepancy, Wrong orphan count for " + log.getName()), (long)stats.numOrphans, (long)computed.getNumOrphans());
                    Assert.assertEquals((String)("Stats discrepancy, unexpected dups for " + log.getName()), (long)stats.dups, (long)computed.getNumDupTransactions());
                    Assert.assertEquals((String)("Stats discrepancy, Wrong put count for " + log.getName()), (long)stats.numPuts, (long)computed.getNumPuts());
                    Assert.assertEquals((String)("Stats discrepancy, Wrong update count for " + log.getName()), (long)stats.numUpdates, (long)computed.getNumUpdates());
                    Assert.assertEquals((String)("Stats discrepancy, Wrong remove count for " + log.getName()), (long)stats.numRemoves, (long)computed.getNumRemoves());
                    Assert.assertEquals((String)("Stats discrepancy, Wrong send count for " + log.getName()), (long)stats.numSends, (long)computed.getNumSends());
                    Assert.assertEquals((String)("Stats discrepancy, Wrong message count for " + log.getName()), (long)stats.numMessages, (long)computed.getNumMessages());
                }
                catch (AssertionError ae) {
                    System.out.println("Expected Stats: " + log.getName() + " stats: " + stats);
                    System.out.println("Reader Stats  : " + log.getName() + " stats: " + computed);
                    throw ae;
                }
                stats2 = stats;
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return stats2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTransactionLogTool(String filename, boolean isRecoveryLog) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-DNVROOT=" + AepEngineLogTest.getTestbedRoot());
        cmd.add("-Djansi.strip=true");
        cmd.add("-Dnv.console.jline.disable=true");
        cmd.add("-classpath");
        cmd.add(System.getProperty("java.class.path"));
        cmd.add(TransactionLogTool.class.getName());
        cmd.add("-i");
        cmd.add(this.createInitScript().toString());
        File rdatFolder = new File(AepEngineLogTest.getTestbedRoot(), "rdat");
        if (!rdatFolder.exists()) {
            rdatFolder.mkdirs();
        }
        pw.setOutputEchoEnabled(AepEngineLogTest.verbose());
        try (ProcessWrapper pw = ProcessWrapper.launch(cmd, (File)new File(AepEngineLogTest.getTestbedRoot(), "rdat"));){
            ArrayList<String> commands = new ArrayList<String>();
            ArrayList<String> prompts = new ArrayList<String>();
            String filePrompt = filename.replace('\\', '/') + ">";
            commands.add("open " + filename);
            prompts.add(filePrompt);
            commands.add("stats -a");
            prompts.add(filePrompt);
            commands.add("dump -g " + (isRecoveryLog && this.haPolicy == AepEngine.HAPolicy.StateReplication ? "-s " : "") + filename + ".dump");
            prompts.add(filePrompt);
            commands.add("close");
            prompts.add(">");
            for (int i = 0; i < commands.size(); ++i) {
                pw.markOutputPosistions();
                String command = (String)commands.get(i);
                pw.writeLn(command);
                if (pw.waitForOutputAndQuiesence(1000L, 60000L, (String)prompts.get(i))) continue;
                Assert.fail((String)("Command '" + command + "' didn't finish: Output:\n" + pw.getOutput() + "\nErrors:\n" + pw.getErrorOutput()));
            }
            File dumpFile = new File(AepEngineLogTest.getTestbedRoot() + File.separator + "rdat" + File.separator + filename + ".dump");
            Assert.assertFalse((String)("Dump file " + dumpFile + " not created"), (!dumpFile.exists() ? 1 : 0) != 0);
            pw.resetOutputMarks();
            Assert.assertEquals((String)("Errors in Log Reader Tool for " + filename), (Object)"", (Object)pw.getErrorOutput());
            if (pw.checkForOutput("Exception")) {
                if (!AepEngineLogTest.verbose()) {
                    Assert.fail((String)("Exception detected in TransactionLogTool output: " + pw.getOutput()));
                } else {
                    Assert.fail((String)"Exception detected in TransactionLogTool output");
                }
            }
            if (pw.checkForOutput("Error")) {
                if (!AepEngineLogTest.verbose()) {
                    Assert.fail((String)("Error detected in TransactionLogTool output: " + pw.getOutput()));
                } else {
                    Assert.fail((String)"Error detected in TransactionLogTool output");
                }
            }
            if (pw.checkForOutput("Fail")) {
                if (!AepEngineLogTest.verbose()) {
                    Assert.fail((String)("Fail detected in TransactionLogTool output: " + pw.getOutput()));
                } else {
                    Assert.fail((String)"Fail detected in TransactionLogTool output");
                }
            }
        }
    }

    private File createInitScript() throws IOException {
        File file = new File(AepEngineLogTest.getTestbedRoot(), "tlt-init-script.tlt");
        if (!file.exists()) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write("set stacktraces on");
            bw.newLine();
            bw.flush();
            bw.close();
        }
        return file;
    }

    static {
        RogLogUtil.FileBasedFieldFilter filter = null;
        try {
            AepEngineLogTest.initializeUnitTest();
            filter = RogLogUtil.loadComparisonFilter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        comparisonFilter = filter;
    }

    private final class EngineApp
    extends AepEngineTest.BaseEngineCusomizer
    implements IEventHandler {
        final AepEngineLogTestApp app = new AepEngineLogTestApp();
        AepEngine engine;
        IStorePersister persister;
        final String appName;
        final boolean isBackup;
        final AepEngine.InboundMessageLoggingPolicy inboundPolicy;
        final AepEngine.OutboundMessageLoggingPolicy outboundPolicy;
        public RogLog.Stats checkpointionStats;

        EngineApp(String appName, AepEngine.InboundMessageLoggingPolicy inboundPolicy, AepEngine.OutboundMessageLoggingPolicy outboundPolicy, boolean isBackup) throws Exception {
            this.appName = appName;
            this.isBackup = isBackup;
            this.inboundPolicy = inboundPolicy;
            this.outboundPolicy = outboundPolicy;
            this.createEngine();
        }

        private void createEngine() throws Exception {
            this.app.engine = this.engine = AepEngineLogTest.this.createEngine(this.appName, AepEngineLogTest.this.haPolicy, this.inboundPolicy, this.outboundPolicy, AepEngineLogTest.this.hasStore, true, 15, 1, this.app, this, new IAepApplicationStateFactory(){

                @Override
                public IRogNode createState(MessageView message) throws Exception {
                    switch (AepEngineLogTest.this.encoding) {
                        case Json: {
                            return com.neeve.aep.test.unit.generated.json.Repository.create();
                        }
                        case Proto: {
                            return Repository.create();
                        }
                        case Xbuf: {
                            return com.neeve.aep.test.unit.generated.xbuf.Repository.create();
                        }
                    }
                    throw new UnsupportedOperationException((Object)((Object)AepEngineLogTest.this.encoding) + " encoding is not supported in this test");
                }
            }, this);
            switch (AepEngineLogTest.this.encoding) {
                case Json: {
                    this.engine.registerFactory(new com.neeve.aep.test.unit.generated.json.Factory());
                    break;
                }
                case Proto: {
                    this.engine.registerFactory(new com.neeve.aep.test.unit.generated.proto.Factory());
                    break;
                }
                case Xbuf: {
                    this.engine.registerFactory(new Factory());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)AepEngineLogTest.this.encoding) + " encoding is not supported in this test");
                }
            }
            this.engine.start();
            if (AepEngineLogTest.this.hasStore) {
                this.persister = this.engine.getStore().getPersister();
            }
            if (!AepEngineLogTest.this.hasStore || this.engine.getStore().getRole() == IStoreBinding.Role.Primary) {
                this.engine.waitForMessagingToStart();
            }
        }

        @Override
        public void customizeStore(StoreDescriptor descriptor) {
            if (AepEngineLogTest.this.failureType == FailureType.GRACEFUL_PRIMARY_RESTART_WITH_CHECKPOINT) {
                descriptor.setCheckpointingType(IStoreCheckpointingController.Type.CDC);
                descriptor.setCheckpointThreshold(1000);
            }
        }

        @Override
        public void customizePersister(StorePersisterDescriptor descriptor) {
            if (AepEngineLogTest.this.failureType == FailureType.GRACEFUL_PRIMARY_RESTART_WITH_CHECKPOINT) {
                descriptor.setProperty("cdcEnabled", String.valueOf(true));
            }
            if (this.isBackup) {
                descriptor.setProperty("storeRoot", XRuntime.getDataDirectory() + File.separator + "backupRdat");
            }
        }

        @Override
        public void customizeEngine(AepEngineDescriptor descriptor) {
            if (AepEngineLogTest.this.haPolicy == AepEngine.HAPolicy.StateReplication && AepEngineLogTest.this.runBackup) {
                descriptor.setAdaptiveCommitBatchCeiling(1);
            }
            if (this.isBackup) {
                descriptor.setInboundMessageLoggingProperty("storeRoot", XRuntime.getDataDirectory() + File.separator + "backupRdat");
                descriptor.setOutboundMessageLoggingProperty("storeRoot", XRuntime.getDataDirectory() + File.separator + "backupRdat");
            }
        }

        public String getLogName() {
            return this.isBackup ? "backupRdat" + File.separator + this.appName : this.appName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateLog(String logName, Stats expected, boolean isRecoveryLog) throws Exception {
            Stats stats = AepEngineLogTest.this.getLogStats(logName, null);
            System.out.println("Expecting: " + logName + " stats: " + expected);
            System.out.println("Got      : " + logName + " stats: " + stats);
            Assert.assertEquals((String)("Wrong tx count for " + logName), (long)expected.numTransactions, (long)stats.numTransactions);
            Assert.assertEquals((String)("Wrong orphan count for " + logName), (long)expected.numOrphans, (long)stats.numOrphans);
            Assert.assertEquals((String)("Unexpected dups for " + logName), (long)expected.dups, (long)stats.dups);
            Assert.assertEquals((String)("Wrong put count for " + logName), (long)expected.numPuts, (long)stats.numPuts);
            Assert.assertEquals((String)("Wrong update count for " + logName), (long)expected.numUpdates, (long)stats.numUpdates);
            Assert.assertEquals((String)("Wrong remove count for " + logName), (long)expected.numRemoves, (long)stats.numRemoves);
            Assert.assertEquals((String)("Wrong send count for " + logName), (long)expected.numSends, (long)stats.numSends);
            Assert.assertEquals((String)("Wrong message count for " + logName), (long)expected.numMessages, (long)stats.numMessages);
            System.out.println("Testing Transaction Log Tool for " + logName);
            AepEngineLogTest.this.testTransactionLogTool(logName, isRecoveryLog);
            if (AepEngineLogTest.this.runBackup && isRecoveryLog && !this.isBackup) {
                System.out.println("Checking for log divergence");
                StringWriter diffSummary = new StringWriter();
                BufferedWriter writer = new BufferedWriter(new StringWriter());
                RogLog primary = RogLog.create((String)((AepEngine)((Object)AepEngineLogTest.this.engines.get(0))).getDescriptor().getName());
                primary.open();
                RogLog backup = RogLog.create((String)((AepEngine)((Object)AepEngineLogTest.this.engines.get(1))).getDescriptor().getName());
                backup.open();
                try {
                    if (!RogLogUtil.compareEntries((RogLog)primary, (RogLog)backup, null, (BufferedWriter)writer, (int)10, (boolean)true, (boolean)AepEngineLogTest.verbose(), (UtlTableFormatter.Format)UtlTableFormatter.Format.TABULAR)) {
                        writer.flush();
                        writer.close();
                        Assert.fail((String)("Divergence detected in recovery logs\n" + diffSummary));
                    }
                    if (AepEngineLogTest.this.haPolicy == AepEngine.HAPolicy.StateReplication) {
                        System.out.println("Checking for log state divergence");
                        if (!RogLogUtil.compareState((RogLog)primary, (RogLog)backup, (RogLogUtil.FieldFilter)comparisonFilter, (BufferedWriter)writer, (boolean)true, (boolean)AepEngineLogTest.verbose(), (UtlTableFormatter.Format)UtlTableFormatter.Format.TABULAR)) {
                            writer.flush();
                            writer.close();
                            Assert.fail((String)("Divergence detected in recovery state:\n" + diffSummary));
                        }
                    }
                }
                finally {
                    primary.close();
                    backup.close();
                }
            }
        }

        public void validateInboundLog() throws Exception {
            if (this.engine.getInboundMessageLoggingPolicy() != AepEngine.InboundMessageLoggingPolicy.UseDedicated) {
                Assert.assertNull((Object)RogLog.backupLog((String)(this.getLogName() + ".in"), null, (boolean)false));
                return;
            }
            Stats expected = new Stats();
            expected.numTransactions = this.app.primaryInMessageCount;
            expected.numOrphans = 0;
            expected.gaps = false;
            expected.dups = 0;
            expected.numPuts = 0;
            expected.numUpdates = 0;
            expected.numRemoves = 0;
            expected.numSends = 0;
            expected.numSends += this.app.primaryInMessageCount;
            expected.numMessages = 0;
            this.validateLog(this.getLogName() + ".in", expected, false);
        }

        public void validateOutboundLog() throws Exception {
            if (this.engine.getOutboundMessageLoggingPolicy() != AepEngine.OutboundMessageLoggingPolicy.UseDedicated) {
                Assert.assertNull((Object)RogLog.backupLog((String)(this.getLogName() + ".out"), null, (boolean)false));
                return;
            }
            Stats expected = new Stats();
            int numResends = (int)this.engine.getStats().getNumMsgsResent();
            expected.numTransactions = (AepEngineLogTest.this.haPolicy == AepEngine.HAPolicy.EventSourcing ? this.app.outMessageCount : this.app.primaryOutMessageCount) + (numResends > 0 ? 1 : 0);
            expected.numOrphans = this.app.primaryInMessageCount;
            expected.gaps = true;
            expected.dups = 0;
            expected.numPuts = 0;
            expected.numUpdates = 0;
            expected.numRemoves = 0;
            expected.numSends = 0;
            expected.numMessages = AepEngineLogTest.this.haPolicy == AepEngine.HAPolicy.EventSourcing ? this.app.outMessageCount + this.app.primaryInMessageCount + numResends : this.app.primaryOutMessageCount + this.app.primaryInMessageCount + numResends;
            expected.numSends = expected.numMessages;
            expected.numMessages = 0;
            this.validateLog(this.getLogName() + ".out", expected, false);
        }

        public final void validateRecoveryLog() throws Exception {
            if (!AepEngineLogTest.this.hasStore) {
                Assert.assertNull((Object)RogLog.backupLog((String)this.getLogName(), null, (boolean)false));
                return;
            }
            Stats expected = new Stats();
            expected.numTransactions = this.app.txnCount;
            expected.numOrphans = 0;
            expected.gaps = this.app.numGaps > 0;
            expected.dups = 0;
            if (AepEngineLogTest.this.haPolicy == AepEngine.HAPolicy.StateReplication) {
                expected.numPuts = this.app.numPuts + 3;
                expected.numUpdates = this.app.numUpdates;
                expected.numRemoves = this.app.numRemoves;
            } else {
                expected.numPuts = 0;
                expected.numUpdates = 0;
                expected.numRemoves = 0;
            }
            expected.numSends = AepEngineLogTest.this.haPolicy == AepEngine.HAPolicy.EventSourcing ? this.app.inMessageCount : this.app.outMessageCount;
            expected.numSends += expected.numOrphans;
            expected.numMessages = 0;
            if (this.checkpointionStats != null) {
                expected.numMessages += this.checkpointionStats.getNumMessages();
                expected.numSends += this.checkpointionStats.getNumSends();
                expected.numUpdates += this.checkpointionStats.getNumUpdates();
                expected.numPuts += this.checkpointionStats.getNumPuts();
                expected.numRemoves += this.checkpointionStats.getNumRemoves();
                expected.numOrphans += this.checkpointionStats.getNumOrphans();
                expected.numTransactions += this.checkpointionStats.getNumTransactions();
            }
            this.validateLog(this.getLogName(), expected, true);
        }

        public String toString() {
            return this.isBackup ? "Backup Engine" : "Primary Engine";
        }

        public void onEvent(Event event) {
        }

        public void waitForCommitStability(long timeoutMillis) throws InterruptedException {
            if (this.engine.getState() == AepEngine.State.Started) {
                long tte = System.currentTimeMillis() + timeoutMillis;
                while (this.engine.getStats().getNumCommitsStarted() < (long)this.app.txnCount) {
                    if (System.currentTimeMillis() > tte) {
                        System.err.println(this.appName + ": Fewer transactions started than reported by app " + this.engine.getStats().getNumCommitsStarted() + " / " + this.app.txnCount);
                        break;
                    }
                    Thread.sleep(100L);
                }
                while (this.engine.getStats().getNumCommitsStarted() > this.engine.getStats().getNumCommitsCompleted()) {
                    Thread.sleep(100L);
                    if (System.currentTimeMillis() > tte) {
                        System.err.println(this.appName + ": Uncompleted commits reported: " + this.engine.getStats().getNumCommitsCompleted() + " / " + this.engine.getStats().getNumCommitsStarted());
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
        }
    }

    private final class Stats {
        int numTransactions = 0;
        int numOrphans = 0;
        boolean gaps = false;
        int dups = 0;
        int numPuts = 0;
        int numUpdates = 0;
        int numRemoves = 0;
        int numSends = 0;
        int numMessages = 0;

        private Stats() {
        }

        public final String toString() {
            return "<Txn=" + this.numTransactions + ", Orph=" + this.numOrphans + ", Gap=" + this.gaps + ", Dup=" + this.dups + ", Put=" + this.numPuts + ", Upd=" + this.numUpdates + ", Rem=" + this.numRemoves + ", Snd=" + this.numSends + ", Msg=" + this.numMessages + ">";
        }
    }

    public static enum FailureType {
        NONE,
        GRACEFUL_PRIMARY_RESTART,
        GRACEFUL_PRIMARY_RESTART_WITH_CHECKPOINT,
        GRACEFUL_FAILOVER,
        HARD_FAILOVER,
        FAIL_ALL_RECOVER_BACKUP;

    }
}

