/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepEngineStoppingEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.test.unit.AepEngineLastTransactionTest;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.proto.Message;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class AepEngineLastTransactionTestApp
extends AepEngineTestApp {
    AepEngine engine;
    String name;
    Throwable setAsLastTransactionFromNonMessageHandlerStatus;
    Throwable setAsLastTransactionFromNonTransactionThreadStatus;
    volatile Exception lastTransactionCause = null;
    volatile AepEngineLastTransactionTest.PreserveChannelJoinBehavior preserveChannelJoinBehavior;
    volatile int stopCount1;
    volatile int stopCount2;
    volatile int inMessageCount;
    volatile boolean engineStopping;
    Exception engineStoppingCause;
    volatile boolean engineStopped;
    Exception engineStoppedCause;
    Object waitOnPrestartObject = new Object();
    boolean releaseFromPrestart;
    boolean clusterShutdown;
    CountDownLatch sendLatch = new CountDownLatch(1);

    final boolean waitForEngineStopped() {
        for (int i = 0; i < 10; ++i) {
            if (!this.engineStopped) {
                System.out.println("Engine not stopped");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void releaseFromPrestart() {
        Object object = this.waitOnPrestartObject;
        synchronized (object) {
            this.releaseFromPrestart = true;
            this.waitOnPrestartObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onMessagingPrestart(AepMessagingPrestartEvent event) {
        try {
            this.engine.setAsLastTransaction(null, false);
        }
        catch (Throwable e) {
            this.setAsLastTransactionFromNonMessageHandlerStatus = e;
        }
        Object object = this.waitOnPrestartObject;
        synchronized (object) {
            while (!this.releaseFromPrestart) {
                try {
                    this.waitOnPrestartObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @EventHandler(source="channel5@aeptest1")
    public void onChannel5UpEventHandler(AepChannelUpEvent event) {
        this.channel5 = event.getMessageChannel();
    }

    @EventHandler(source="channel5@aeptest1")
    public void onChannel5DownEventHandler(AepChannelDownEvent event) {
        this.channel5 = null;
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4UpEventHandler(AepChannelUpEvent event) {
        this.channel4 = event.getMessageChannel();
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4DownEventHandler(AepChannelDownEvent event) {
        this.channel4 = null;
    }

    @EventHandler
    public void onProtoMessageHandler(Message message) {
        ++this.inMessageCount;
        if (this.inMessageCount == this.stopCount1 || this.inMessageCount == this.stopCount2) {
            Thread thread = new Thread(){

                @Override
                public final void run() {
                    try {
                        AepEngineLastTransactionTestApp.this.engine.setAsLastTransaction(null, true, AepEngineLastTransactionTestApp.this.clusterShutdown);
                    }
                    catch (Throwable e) {
                        AepEngineLastTransactionTestApp.this.setAsLastTransactionFromNonTransactionThreadStatus = e;
                    }
                }
            };
            thread.start();
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            AepEngineTestMessage out = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
            out.getMessage().setMessageBus("aeptest1");
            out.getMessage().setMessageChannel("channel4");
            this.engine.sendMessage(this.channel4, out.getMessage());
            this.engine.setAsLastTransaction(this.lastTransactionCause, true, this.clusterShutdown);
            try {
                this.sendLatch.await(60L, TimeUnit.SECONDS);
                this.sendLatch = new CountDownLatch(1);
            }
            catch (InterruptedException e) {
                System.err.println("Timed out waiting for messages to be sent");
            }
        }
    }

    @EventHandler
    public void onEngineStopping(AepEngineStoppingEvent event) {
        this.engineStopping = true;
        this.engineStoppingCause = event.getCause();
        if (this.preserveChannelJoinBehavior == AepEngineLastTransactionTest.PreserveChannelJoinBehavior.PreserveViaStoppingEvent) {
            event.setPreserveChannelJoins(true);
        } else if (this.preserveChannelJoinBehavior == AepEngineLastTransactionTest.PreserveChannelJoinBehavior.LeaveViaStoppingEventOverridesEngine) {
            event.setPreserveChannelJoins(false);
        }
        System.out.println("Got stopping event: " + (Object)((Object)event));
    }

    @EventHandler
    public void onEngineStopped(AepEngineStoppedEvent event) {
        this.engineStopped = true;
        this.engineStoppedCause = event.getCause();
    }

    public void onMessagesSent() {
        this.sendLatch.countDown();
    }
}

