/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.test.unit.AepEngineStateReplicationTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.AepEngineTestState;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Child1;
import com.neeve.aep.test.unit.generated.xbuf.Child4;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.aep.test.unit.generated.xbuf.GracefulShutdownTriggerMessage;
import com.neeve.aep.test.unit.generated.xbuf.UpdateStateMessage;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCompactor;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineStateReplicationTest
extends AepEngineTest {
    private static final int MESSAGE_COUNT = XRuntime.getValue((String)"AepEngineStateReplicationTest.messageCount", (int)10000);

    private final IAepApplicationStateFactory createStateFactory(final AepEngineTestObject.EncodingType encodingType) {
        return new IAepApplicationStateFactory(){

            @Override
            public final IRogNode createState(MessageView message) throws Exception {
                switch (encodingType) {
                    case Json: {
                        return com.neeve.aep.test.unit.generated.json.Repository.create();
                    }
                    case Proto: {
                        return Repository.create();
                    }
                    case Xbuf: {
                        return com.neeve.aep.test.unit.generated.xbuf.Repository.create();
                    }
                }
                throw new IllegalArgumentException("unknown encoding type '" + (Object)((Object)encodingType) + "'");
            }
        };
    }

    private final Object createObjectFactory(AepEngineTestObject.EncodingType encodingType) {
        switch (encodingType) {
            case Xbuf: {
                return Factory.create(null);
            }
            case Proto: {
                return com.neeve.aep.test.unit.generated.proto.Factory.create(null);
            }
            case Json: {
                return com.neeve.aep.test.unit.generated.json.Factory.create(null);
            }
        }
        throw new InternalError("unknown message encoding type '" + (Object)((Object)encodingType) + "'");
    }

    private final IRogMessage createMessage(AepEngineTestObject.EncodingType encodingType) {
        switch (encodingType) {
            case Xbuf: {
                return UpdateStateMessage.create();
            }
            case Proto: {
                return com.neeve.aep.test.unit.generated.proto.UpdateStateMessage.create();
            }
            case Json: {
                return com.neeve.aep.test.unit.generated.json.UpdateStateMessage.create();
            }
        }
        throw new InternalError("unknown message encoding type '" + (Object)((Object)encodingType) + "'");
    }

    private final List<IRogMessage> createMessages(AepEngineTestObject.EncodingType encodingType) {
        ArrayList<IRogMessage> list = new ArrayList<IRogMessage>();
        for (int i = 0; i < MESSAGE_COUNT; ++i) {
            list.add(this.createMessage(encodingType));
        }
        return list;
    }

    private final void scheduleShutdown(AepEngine engine, AepEngineTestObject.EncodingType encodingType) {
        switch (encodingType) {
            case Xbuf: {
                engine.injectMessage(GracefulShutdownTriggerMessage.create());
                break;
            }
            case Proto: {
                engine.injectMessage(com.neeve.aep.test.unit.generated.proto.GracefulShutdownTriggerMessage.create());
                break;
            }
            case Json: {
                engine.injectMessage(com.neeve.aep.test.unit.generated.json.GracefulShutdownTriggerMessage.create());
                break;
            }
            default: {
                throw new InternalError("unknown message encoding type '" + (Object)((Object)encodingType) + "'");
            }
        }
    }

    private final void validateState(com.neeve.aep.test.unit.generated.xbuf.Repository expected, com.neeve.aep.test.unit.generated.xbuf.Repository actual, boolean serializedDeserialized) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        }
        if (expected != null) {
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((long)expected.getFixlenField(), (long)actual.getFixlenField());
            Assert.assertEquals((Object)expected.getVarlenField(), (Object)actual.getVarlenField());
            AepEngineTestState.compare(expected.getEntityField(), actual.getEntityField(), serializedDeserialized);
            Assert.assertEquals((long)expected.getStringMapField().size(), (long)actual.getStringMapField().size());
            for (Object key : expected.getStringMapField().keySet()) {
                AepEngineTestState.compare((Child1)expected.getStringMapField().get((String)key), (Child1)actual.getStringMapField().get((String)key), serializedDeserialized);
            }
            Assert.assertEquals((long)expected.getLongMapField().size(), (long)actual.getLongMapField().size());
            for (Object key : expected.getLongMapField().keySet()) {
                Child4 expectedChild4 = (Child4)expected.getLongMapField().get((Long)key);
                Child4 actualChild4 = (Child4)actual.getLongMapField().get((Long)key);
                AepEngineTestState.compare(expectedChild4, actualChild4, serializedDeserialized);
                if (expectedChild4 == null) continue;
                AepEngineTestState.compare(expectedChild4.getChild1Field(), actualChild4.getChild1Field(), serializedDeserialized);
            }
        }
    }

    private final void validateState(Repository expected, Repository actual, boolean serializedDeserialized) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        }
        if (expected != null) {
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((long)expected.getFixlenField(), (long)actual.getFixlenField());
            Assert.assertEquals((Object)expected.getVarlenField(), (Object)actual.getVarlenField());
            AepEngineTestState.compare(expected.getEntityField(), actual.getEntityField(), serializedDeserialized);
            Assert.assertEquals((long)expected.getStringMapField().size(), (long)actual.getStringMapField().size());
            for (Object key : expected.getStringMapField().keySet()) {
                AepEngineTestState.compare((com.neeve.aep.test.unit.generated.proto.Child1)expected.getStringMapField().get((String)key), (com.neeve.aep.test.unit.generated.proto.Child1)actual.getStringMapField().get((String)key), serializedDeserialized);
            }
            Assert.assertEquals((long)expected.getLongMapField().size(), (long)actual.getLongMapField().size());
            for (Object key : expected.getLongMapField().keySet()) {
                com.neeve.aep.test.unit.generated.proto.Child4 expectedChild4 = (com.neeve.aep.test.unit.generated.proto.Child4)expected.getLongMapField().get((Long)key);
                com.neeve.aep.test.unit.generated.proto.Child4 actualChild4 = (com.neeve.aep.test.unit.generated.proto.Child4)actual.getLongMapField().get((Long)key);
                AepEngineTestState.compare(expectedChild4, actualChild4, serializedDeserialized);
                if (expectedChild4 == null) continue;
                AepEngineTestState.compare(expectedChild4.getChild1Field(), actualChild4.getChild1Field(), serializedDeserialized);
            }
        }
    }

    private final void validateState(com.neeve.aep.test.unit.generated.json.Repository expected, com.neeve.aep.test.unit.generated.json.Repository actual, boolean serializedDeserialized) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        }
        if (expected != null) {
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((long)expected.getFixlenField(), (long)actual.getFixlenField());
            Assert.assertEquals((Object)expected.getVarlenField(), (Object)actual.getVarlenField());
            AepEngineTestState.compare(expected.getEntityField(), actual.getEntityField(), serializedDeserialized);
            Assert.assertEquals((long)expected.getStringMapField().size(), (long)actual.getStringMapField().size());
            for (Object key : expected.getStringMapField().keySet()) {
                AepEngineTestState.compare((com.neeve.aep.test.unit.generated.json.Child1)expected.getStringMapField().get((String)key), (com.neeve.aep.test.unit.generated.json.Child1)actual.getStringMapField().get((String)key), serializedDeserialized);
            }
            Assert.assertEquals((long)expected.getLongMapField().size(), (long)actual.getLongMapField().size());
            for (Object key : expected.getLongMapField().keySet()) {
                com.neeve.aep.test.unit.generated.json.Child4 expectedChild4 = (com.neeve.aep.test.unit.generated.json.Child4)expected.getLongMapField().get((Long)key);
                com.neeve.aep.test.unit.generated.json.Child4 actualChild4 = (com.neeve.aep.test.unit.generated.json.Child4)actual.getLongMapField().get((Long)key);
                AepEngineTestState.compare(expectedChild4, actualChild4, serializedDeserialized);
                if (expectedChild4 == null) continue;
                AepEngineTestState.compare(expectedChild4.getChild1Field(), actualChild4.getChild1Field(), serializedDeserialized);
            }
        }
    }

    private final void validateState(IStoreBinding binding1, IStoreBinding binding2) {
        if (binding1 == null) {
            Assert.assertNull((Object)binding2);
        } else if (binding2 == null) {
            Assert.assertNull((Object)binding1);
        } else {
            Assert.assertEquals((long)binding1.size(), (long)binding2.size());
        }
    }

    private final void validateState(AepEngineTestObject.EncodingType encodingType, AepEngineStateReplicationTestApp expectedApp, AepEngineStateReplicationTestApp actualApp, boolean serializedDeserialized) {
        this.validateState(expectedApp.engine.getStore(), actualApp.engine.getStore());
        switch (encodingType) {
            case Xbuf: {
                this.validateState(expectedApp.xbufExpectedRepository, actualApp.xbufActualRepository, serializedDeserialized);
                break;
            }
            case Proto: {
                this.validateState(expectedApp.protoExpectedRepository, actualApp.protoActualRepository, serializedDeserialized);
                break;
            }
            case Json: {
                this.validateState(expectedApp.jsonExpectedRepository, actualApp.jsonActualRepository, serializedDeserialized);
                break;
            }
            default: {
                throw new InternalError("unknown message encoding type '" + (Object)((Object)encodingType) + "'");
            }
        }
    }

    private final RogLog clone(RogLog log) throws Exception {
        return RogLog.create((String)log.getName(), (StorePersisterDescriptor)log.getDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testStateReplication_StandaloneReceiver(boolean hasStore, boolean hasStorePersister, boolean detachedStorePersister, boolean adaptiveBatching, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine2;
        AepEngineStateReplicationTestApp receiver;
        AepEngine engine1;
        AepEngineStateReplicationTestApp sender = new AepEngineStateReplicationTestApp();
        sender.engine = engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineStateReplicationTestApp expected = receiver = new AepEngineStateReplicationTestApp();
        String receiverName = "engine-" + System.currentTimeMillis();
        receiver.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                descriptor.setCheckpointThreshold(10);
            }

            @Override
            public void customizePersister(StorePersisterDescriptor descriptor) {
                descriptor.setProperty("cdcEnabled", "true");
            }
        });
        engine2.registerFactory(this.createObjectFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        for (IRogMessage message : this.createMessages(encodingType)) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, message);
        }
        Assert.assertTrue((boolean)receiver.waitForMessageReceipt(MESSAGE_COUNT));
        System.out.println(receiver.stats.toString());
        this.validateState(encodingType, expected, receiver, false);
        RogLog log = null;
        if (hasStorePersister) {
            log = (RogLog)engine2.getStore().getPersister();
            System.out.println("ABOUT TO COMPACT: " + UtlFile.readableFileSize((long)log.getSize()));
            log.getCompactor().compact();
            while (log.getCompactor().getState() == RogLogCompactor.State.InProgress) {
                Thread.sleep(1000L);
            }
            System.out.println("COMPACTED: " + UtlFile.readableFileSize((long)log.getSize()));
        }
        this.scheduleShutdown(engine1, encodingType);
        Assert.assertTrue((boolean)sender.waitForEngineToStop());
        this.scheduleShutdown(engine2, encodingType);
        Assert.assertTrue((boolean)receiver.waitForEngineToStop());
        if (hasStorePersister) {
            receiver = new AepEngineStateReplicationTestApp();
            receiver.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }

                @Override
                public void customizePersister(StorePersisterDescriptor descriptor) {
                    descriptor.setProperty("maxCompactionWindowSize", "0.1");
                }
            });
            engine2.registerFactory(this.createObjectFactory(encodingType));
            engine2.start();
            this.validateState(encodingType, expected, receiver, true);
            log = (RogLog)engine2.getStore().getPersister();
            this.scheduleShutdown(engine2, encodingType);
            Assert.assertTrue((boolean)receiver.waitForEngineToStop());
            log = this.clone(log);
            log.open();
            try {
                log.getCompactor().compact().waitForCompactionToComplete();
            }
            finally {
                log.close();
            }
            receiver = new AepEngineStateReplicationTestApp();
            receiver.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }
            });
            engine2.registerFactory(this.createObjectFactory(encodingType));
            engine2.start();
            this.validateState(encodingType, expected, receiver, true);
            this.scheduleShutdown(engine2, encodingType);
            Assert.assertTrue((boolean)receiver.waitForEngineToStop());
            log = this.clone(log);
            log.open();
            try {
                log.getCompactor().compact().waitForCompactionToComplete();
            }
            finally {
                log.close();
            }
            receiver = new AepEngineStateReplicationTestApp();
            receiver.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }
            });
            engine2.registerFactory(this.createObjectFactory(encodingType));
            engine2.start();
            this.validateState(encodingType, expected, receiver, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testStateReplication_ClusteredReceiver(boolean hasStorePersister, boolean detachedStorePersister, boolean adaptiveBatching, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        System.out.println("**** STARTING SENDER AND RECEIVER CLUSTER ****");
        AepEngineStateReplicationTestApp sender = new AepEngineStateReplicationTestApp();
        sender.engine = engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineStateReplicationTestApp receiver1 = new AepEngineStateReplicationTestApp();
        AepEngineStateReplicationTestApp receiver2 = new AepEngineStateReplicationTestApp();
        AepEngineStateReplicationTestApp expected = receiver1;
        receiver1.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver1, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                descriptor.setCheckpointThreshold(10);
            }

            @Override
            public void customizePersister(StorePersisterDescriptor descriptor) {
                descriptor.setProperty("cdcEnabled", "true");
            }
        });
        engine2.registerFactory(this.createObjectFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        receiver2.engine = engine3 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, receiver2, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                descriptor.setCheckpointThreshold(10);
            }

            @Override
            public void customizePersister(StorePersisterDescriptor descriptor) {
                descriptor.setProperty("cdcEnabled", "true");
            }
        });
        engine3.registerFactory(this.createObjectFactory(encodingType));
        engine3.start();
        System.out.println("**** SENDING MESSAGES TO CLUSTER ****");
        for (IRogMessage message : this.createMessages(encodingType)) {
            engine1.sendMessage(sender.channel1, message);
        }
        System.out.println("**** WAITING FOR RECEIVER1 (PRIMARY) TO RECEIVE ALL ****");
        Assert.assertTrue((boolean)receiver1.waitForMessageReceipt(MESSAGE_COUNT));
        System.out.println("**** WAITING FOR TRANSACTION PIPELINE TO EMPTY (RECEIVER2 (BACKUP) TO BE IN SYNC WITH PRIMARY) ****");
        this.waitForTransactionPipelineToEmpty(engine2);
        Thread.sleep(10000L);
        System.out.println(receiver1.stats.toString());
        System.out.println("**** VALIDATING RECEIVER1 (PRIMARY) AND RECEIVER2 (BACKUP) STATE ****");
        this.validateState(encodingType, expected, receiver1, false);
        this.validateState(encodingType, expected, receiver2, true);
        if (hasStorePersister) {
            System.out.println("**** VALIDATING PRIMARY AND BACKUP STORE LOG SIZES ARE IDENTICAL ****");
            Assert.assertEquals((long)((RogLog)engine2.getStore().getPersister()).getSize(), (long)((RogLog)engine3.getStore().getPersister()).getSize());
        }
        System.out.println("**** STOPPING SENDER AND RECEIVER CLUSTER ****");
        this.scheduleShutdown(engine1, encodingType);
        Assert.assertTrue((boolean)sender.waitForEngineToStop());
        this.scheduleShutdown(engine2, encodingType);
        Assert.assertTrue((boolean)receiver1.waitForEngineToStop());
        Assert.assertTrue((boolean)receiver2.waitForEngineToStop());
        Thread.sleep(1000L);
        if (hasStorePersister) {
            System.out.println("**** RESTARTING RECEIVER1 FROM LOG ****");
            receiver1 = new AepEngineStateReplicationTestApp();
            receiver1.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver1, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }
            });
            engine2.registerFactory(this.createObjectFactory(encodingType));
            engine2.start();
            System.out.println("**** VALIDATING RECEIVER1 (PRIMARY) STATE ****");
            this.validateState(encodingType, expected, receiver1, true);
            System.out.println("**** STOPPING RECEIVER1 (PRIMARY) ****");
            this.scheduleShutdown(engine2, encodingType);
            Assert.assertTrue((boolean)receiver1.waitForEngineToStop());
            System.out.println("**** RESTARTING RECEIVER2 FROM LOG ****");
            receiver2 = new AepEngineStateReplicationTestApp();
            receiver2.engine = engine3 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, receiver2, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }
            });
            engine3.registerFactory(this.createObjectFactory(encodingType));
            engine3.start();
            System.out.println("**** VALIDATING RECEIVER2 (PRIMARY) STATE ****");
            this.validateState(encodingType, expected, receiver2, true);
            System.out.println("**** STARTING RECEIVER1 AS BACKUP ****");
            receiver1 = new AepEngineStateReplicationTestApp();
            receiver1.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver1, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }

                @Override
                public void customizePersister(StorePersisterDescriptor descriptor) {
                    descriptor.setProperty("maxCompactionWindowSize", "0.1");
                }
            });
            engine2.registerFactory(this.createObjectFactory(encodingType));
            engine2.start();
            System.out.println("**** VALIDATING RECEIVER1 (BACKUP) STATE ****");
            this.validateState(encodingType, expected, receiver1, true);
            System.out.println("**** VALIDATING RECEIVER1 (PRIMARY) AND RECEIVER2 (BACKUP) STORE LOG SIZES ARE IDENTICAL ****");
            Assert.assertEquals((long)((RogLog)engine3.getStore().getPersister()).getSize(), (long)((RogLog)engine2.getStore().getPersister()).getSize());
            RogLog log = (RogLog)engine2.getStore().getPersister();
            System.out.println("**** SHUTTING DOWN RECEIVER CLUSTER ****");
            this.scheduleShutdown(engine3, encodingType);
            Assert.assertTrue((boolean)receiver2.waitForEngineToStop());
            Assert.assertTrue((boolean)receiver1.waitForEngineToStop());
            log = this.clone(log);
            log.open();
            try {
                System.out.println("**** COMPACTING RECEIVER1'S LOG ****");
                log.getCompactor().compact().waitForCompactionToComplete();
            }
            finally {
                log.close();
            }
            System.out.println("**** STARTING RECEIVER1 ****");
            receiver1 = new AepEngineStateReplicationTestApp();
            receiver1.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver1, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }
            });
            engine2.registerFactory(this.createObjectFactory(encodingType));
            engine2.start();
            System.out.println("**** VALIDATING RECEIVER1 (PRIMARY) STATE ****");
            this.validateState(encodingType, expected, receiver1, true);
            System.out.println("**** STOPPING RECEIVER1 (PRIMARY) ****");
            this.scheduleShutdown(engine2, encodingType);
            Assert.assertTrue((boolean)receiver1.waitForEngineToStop());
            log = this.clone(log);
            log.open();
            try {
                System.out.println("**** COMPACTING RECEIVER1'S LOG ****");
                log.getCompactor().compact().waitForCompactionToComplete();
            }
            finally {
                log.close();
            }
            System.out.println("**** STARTING RECEIVER1 ****");
            receiver1 = new AepEngineStateReplicationTestApp();
            receiver1.engine = engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver1, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }
            });
            engine2.registerFactory(this.createObjectFactory(encodingType));
            engine2.start();
            engine2.waitForMessagingToStart();
            System.out.println("**** VALIDATING RECEIVER1 (PRIMARY) STATE ****");
            this.validateState(encodingType, expected, receiver1, true);
            System.out.println("**** STARTING RECEIVER2 ****");
            receiver2 = new AepEngineStateReplicationTestApp();
            receiver2.engine = engine3 = this.createEngine(receiverName, AepEngine.HAPolicy.StateReplication, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, receiver2, null, this.createStateFactory(encodingType), adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

                @Override
                public void customizeStore(StoreDescriptor descriptor) {
                    descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
                    descriptor.setCheckpointThreshold(10);
                }
            });
            engine3.registerFactory(this.createObjectFactory(encodingType));
            engine3.start();
            System.out.println("**** VALIDATING RECEIVER2 (BACKUP) STATE ****");
            this.validateState(encodingType, expected, receiver2, true);
            System.out.println("**** VALIDATING RECEIVER1 (PRIMARY) AND RECEIVER2 (BACKUP) STORE LOG SIZES ARE IDENTICAL ****");
            Assert.assertEquals((long)((RogLog)engine2.getStore().getPersister()).getSize(), (long)((RogLog)engine3.getStore().getPersister()).getSize());
        }
    }

    @Test
    public void testStateReplication_StandaloneNonHAReceiver_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_StandaloneReceiver(false, false, false, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_StandaloneNonHAReceiver_NoAdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_StandaloneReceiver(false, false, false, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_StandaloneNonHAReceiver_NoAdaptiveBatching_Json() throws Exception {
        this.testStateReplication_StandaloneReceiver(false, false, false, false, AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testStateReplication_StandaloneNonHAReceiver_AdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_StandaloneReceiver(false, false, false, true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_StandaloneNonHAReceiver_AdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_StandaloneReceiver(false, false, false, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_StandaloneNonHAReceiver_AdaptiveBatching_Json() throws Exception {
        this.testStateReplication_StandaloneReceiver(false, false, false, true, AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testStateReplication_StandaloneHANonPersistentReceiver_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, false, false, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_StandaloneHANonPersistentReceiver_NoAdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, false, false, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_StandaloneHANonPersistentReceiver_NoAdaptiveBatching_Json() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, false, false, false, AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testStateReplication_StandaloneHANonPersistentReceiver_AdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, false, false, true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_StandaloneHANonPersistentReceiver_AdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, false, false, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_StandaloneHANonPersistentReceiver_AdaptiveBatching_Json() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, false, false, true, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testStateReplication_StandaloneHAAttachedPersistentReceiver_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, false, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_StandaloneHAAttachedPersistentReceiver_NoAdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, false, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_StandaloneHAAttachedPersistentReceiver_NoAdaptiveBatching_Json() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, false, false, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testStateReplication_StandaloneHADetachedPersistentReceiver_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, true, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_StandaloneHADetachedPersistentReceiver_NoAdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, true, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_StandaloneHADetachedPersistentReceiver_NoAdaptiveBatching_Json() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, true, false, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testStateReplication_StandaloneHAAttachedPersistentReceiver_AdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, false, true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_StandaloneHAAttachedPersistentReceiver_AdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, false, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_StandaloneHAAttachedPersistentReceiver_AdaptiveBatching_Json() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, false, true, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testStateReplication_StandaloneHADetachedPersistentReceiver_AdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, true, true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_StandaloneHADetachedPersistentReceiver_AdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, true, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_StandaloneHADetachedPersistentReceiver_AdaptiveBatching_Json() throws Exception {
        this.testStateReplication_StandaloneReceiver(true, true, true, true, AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testStateReplication_ClusteredNonPersistentReceiver_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_ClusteredReceiver(false, false, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_ClusteredNonPersistentReceiver_NoAdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_ClusteredReceiver(false, false, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_ClusteredNonPersistentReceiver_NoAdaptiveBatching_Json() throws Exception {
        this.testStateReplication_ClusteredReceiver(false, false, false, AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testStateReplication_ClusteredNonPersistentReceiver_AdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_ClusteredReceiver(false, false, true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_ClusteredNonPersistentReceiver_AdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_ClusteredReceiver(false, false, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_ClusteredNonPersistentReceiver_AdaptiveBatching_Json() throws Exception {
        this.testStateReplication_ClusteredReceiver(false, false, true, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testStateReplication_ClusteredAttachedPersistentReceiver_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, false, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_ClusteredAttachedPersistentReceiver_NoAdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, false, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_ClusteredAttachedPersistentReceiver_NoAdaptiveBatching_Json() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, false, false, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testStateReplication_ClusteredDetachedPersistentReceiver_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, true, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_ClusteredDetachedPersistentReceiver_NoAdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, true, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_ClusteredDetachedPersistentReceiver_NoAdaptiveBatching_Json() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, true, false, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testStateReplication_ClusteredAttachedPersistentReceiver_AdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, false, true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_ClusteredAttachedPersistentReceiver_AdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, false, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_ClusteredAttachedPersistentReceiver_AdaptiveBatching_Json() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, false, true, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testStateReplication_ClusteredDetachedPersistentReceiver_AdaptiveBatching_Xbuf() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, true, true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testStateReplication_ClusteredDetachedPersistentReceiver_AdaptiveBatching_Proto() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, true, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testStateReplication_ClusteredDetachedPersistentReceiver_AdaptiveBatching_Json() throws Exception {
        this.testStateReplication_ClusteredReceiver(true, true, true, AepEngineTestObject.EncodingType.Json);
    }
}

