/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.test.unit.AepEngineOutOfOrderSendCommitCompletionTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import com.neeve.sma.impl.loopback.LoopbackBus;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AepEngineOutOfOrderSendCommitCompletionTest
extends AepEngineTest {
    String senderName;
    AepEngineOutOfOrderSendCommitCompletionTestApp sender;
    String receiverName;
    AepEngineOutOfOrderSendCommitCompletionTestApp receiver;
    AepEngineOutOfOrderSendCommitCompletionTestApp receiverbackup;

    @BeforeClass
    public static void setup() {
        XRuntime.getProps().put("nv.aep.enablesendcommitcompletesequencealerts", "true");
    }

    @AfterClass
    public static void teardown() {
        XRuntime.getProps().remove("nv.aep.enablesendcommitcompletesequencealerts");
    }

    private final void setup(AepEngine.HAPolicy haPolicy, boolean clustered) throws Exception {
        this.senderName = "sender-" + System.currentTimeMillis();
        this.sender = new AepEngineOutOfOrderSendCommitCompletionTestApp();
        this.receiverName = "receiver-" + System.currentTimeMillis();
        this.receiver = new AepEngineOutOfOrderSendCommitCompletionTestApp();
        if (!clustered) {
            this.startSenderStandaloneReceiverStandalone(this.sender, null, this.receiverName, this.receiver, null, 63, 17, 63, 10, haPolicy, true, true, AepEngineTestObject.EncodingType.Proto);
        } else {
            this.receiverbackup = new AepEngineOutOfOrderSendCommitCompletionTestApp();
            this.startSenderStandaloneReceiverRedundant(this.sender, null, this.receiverName, this.receiver, null, this.receiverbackup, null, 63, 17, 63, 10, haPolicy, true, false, 64, AepEngineTestObject.EncodingType.Proto);
        }
        this.sender.engine = (AepEngine)((Object)this.engines.get(0));
        this.receiver.engine = (AepEngine)((Object)this.engines.get(1));
        if (clustered) {
            this.receiverbackup.engine = (AepEngine)((Object)this.engines.get(2));
        }
    }

    private final void sendMessage(boolean guaranteed, boolean wait) {
        this.sender.messageReceived = false;
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        if (guaranteed) {
            message.getMessage().setMessageChannel("channel5");
            this.sender.engine.sendMessage(this.sender.channel5, message.getMessage());
        } else {
            message.getMessage().setMessageChannel("channel1");
            this.sender.engine.sendMessage(this.sender.channel1, message.getMessage());
        }
        if (wait) {
            Assert.assertTrue((boolean)this.sender.waitForMessageReceipt());
        }
    }

    private final void testInOrderSendCommitCompletion(AepEngine.HAPolicy haPolicy, boolean mixedQOS, boolean clustered) throws Exception {
        this.setup(haPolicy, clustered);
        boolean guaranteed = true;
        for (int i = 0; i < 100; ++i) {
            this.sendMessage(guaranteed, false);
            if (!mixedQOS) continue;
            guaranteed = !guaranteed;
        }
        this.sender.waitForMessageReceipt(100);
        Assert.assertFalse((boolean)this.receiver.waitForOooSendCommitCompletionAlert(1));
        if (clustered) {
            Assert.assertFalse((boolean)this.receiverbackup.waitForOooSendCommitCompletionAlert(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testInOrderSendCommitCompletionWithBackupStoreFailure(AepEngine.HAPolicy haPolicy) throws Exception {
        LoopbackBus.getInstance((String)"aeptest1").enableWaitForQuiescence(true);
        this.setup(haPolicy, true);
        final CountDownLatch killLatch = new CountDownLatch(1);
        Thread backupKiller = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AepEngineOutOfOrderSendCommitCompletionTest.this.sender.waitForMessageReceipt(1);
                    killLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AepEngineOutOfOrderSendCommitCompletionTest.this.receiverbackup.engine.getStore().fail(new Exception("Intentional Failure"));
            }
        });
        backupKiller.start();
        try {
            int i;
            int sendCount = 1000;
            for (i = 0; i < sendCount / 2; ++i) {
                this.sendMessage(true, false);
            }
            killLatch.countDown();
            for (i = 0; i < sendCount / 2; ++i) {
                this.sendMessage(true, false);
            }
        }
        finally {
            backupKiller.interrupt();
        }
        this.sender.waitForMessageReceipt(100);
        Assert.assertFalse((boolean)this.receiver.waitForOooSendCommitCompletionAlert(1));
        Assert.assertFalse((boolean)this.receiverbackup.waitForOooSendCommitCompletionAlert(1));
    }

    private final void testOutOfOrderSendCommitCompletion_MissingAck(AepEngine.HAPolicy haPolicy) throws Exception {
        this.setup(haPolicy, false);
        this.messagingController.dropNextAck("aeptest1", this.receiverName);
        this.sendMessage(true, false);
        this.sendMessage(true, false);
        Assert.assertTrue((boolean)this.receiver.waitForOooSendCommitCompletionAlert(1));
        Assert.assertEquals((long)3L, (long)this.receiver.oooSendCommitCompletionAlerts.get(0).getCompletedCommitTxnId());
        Assert.assertEquals((long)-1L, (long)this.receiver.oooSendCommitCompletionAlerts.get(0).getFirstReleasedCommitTxnId());
        Assert.assertEquals((long)-1L, (long)this.receiver.oooSendCommitCompletionAlerts.get(0).getLastReleasedCommitTxnId());
        Assert.assertEquals((long)2L, (long)this.receiver.oooSendCommitCompletionAlerts.get(0).getFirstIncompleteCommitTxnId());
    }

    private final void testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy haPolicy, int gap, boolean sendBeforeGap, boolean sendAfterGap) throws Exception {
        int i;
        this.setup(haPolicy, false);
        int sentBeforeGap = sendBeforeGap ? 5 : 0;
        for (i = 0; i < sentBeforeGap; ++i) {
            this.sendMessage(true, true);
        }
        this.messagingController.oooAckGap("aeptest1", this.receiverName, gap);
        for (i = 0; i <= gap; ++i) {
            this.sendMessage(true, false);
        }
        int sentAfterGap = sendAfterGap ? 5 : 0;
        for (int i2 = 0; i2 < sentAfterGap; ++i2) {
            this.sendMessage(true, false);
        }
        Assert.assertTrue((boolean)this.receiver.waitForOooSendCommitCompletionAlert(2));
        Assert.assertEquals((long)(2 + sentBeforeGap + gap), (long)this.receiver.oooSendCommitCompletionAlerts.get(0).getCompletedCommitTxnId());
        Assert.assertEquals((long)-1L, (long)this.receiver.oooSendCommitCompletionAlerts.get(0).getFirstReleasedCommitTxnId());
        Assert.assertEquals((long)-1L, (long)this.receiver.oooSendCommitCompletionAlerts.get(0).getLastReleasedCommitTxnId());
        Assert.assertEquals((long)(2 + sentBeforeGap), (long)this.receiver.oooSendCommitCompletionAlerts.get(0).getFirstIncompleteCommitTxnId());
        Assert.assertEquals((long)(2 + sentBeforeGap + gap - 1), (long)this.receiver.oooSendCommitCompletionAlerts.get(1).getCompletedCommitTxnId());
        Assert.assertEquals((long)(2 + sentBeforeGap + gap - 1), (long)this.receiver.oooSendCommitCompletionAlerts.get(1).getFirstReleasedCommitTxnId());
        Assert.assertEquals((long)(2 + sentBeforeGap + gap), (long)this.receiver.oooSendCommitCompletionAlerts.get(1).getLastReleasedCommitTxnId());
        if (sentAfterGap == 0) {
            Assert.assertEquals((long)-1L, (long)this.receiver.oooSendCommitCompletionAlerts.get(1).getFirstIncompleteCommitTxnId());
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)this.receiver.oooSendCommitCompletionAlerts.size());
    }

    @Test
    public void testInOrderSendCommitCompletionEventSourcing() throws Exception {
        this.testInOrderSendCommitCompletion(AepEngine.HAPolicy.EventSourcing, false, false);
    }

    @Test
    public void testInOrderSendCommitCompletionStateReplication() throws Exception {
        this.testInOrderSendCommitCompletion(AepEngine.HAPolicy.StateReplication, false, false);
    }

    @Test
    public void testInOrderSendCommitCompletionMixedQosEventSourcing() throws Exception {
        this.testInOrderSendCommitCompletion(AepEngine.HAPolicy.EventSourcing, true, false);
    }

    @Test
    public void testInOrderSendCommitCompletionMixedQosStateReplication() throws Exception {
        this.testInOrderSendCommitCompletion(AepEngine.HAPolicy.StateReplication, true, false);
    }

    @Test
    public void testInOrderSendCommitCompletionClusteredMixedQosEventSourcing() throws Exception {
        this.testInOrderSendCommitCompletion(AepEngine.HAPolicy.EventSourcing, true, true);
    }

    @Test
    public void testInOrderSendCommitCompletionClusteredMixedQosStateReplication() throws Exception {
        this.testInOrderSendCommitCompletion(AepEngine.HAPolicy.StateReplication, true, true);
    }

    @Test
    public void testInOrderSendCommitCompletionWithBackupStoreFailureEventSourcing() throws Exception {
        this.testInOrderSendCommitCompletionWithBackupStoreFailure(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testInOrderSendCommitCompletionWithBackupStoreFailureFailureStateReplication() throws Exception {
        this.testInOrderSendCommitCompletionWithBackupStoreFailure(AepEngine.HAPolicy.StateReplication);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_MissingAck() throws Exception {
        this.testOutOfOrderSendCommitCompletion_MissingAck(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_MissingAck() throws Exception {
        this.testOutOfOrderSendCommitCompletion_MissingAck(AepEngine.HAPolicy.StateReplication);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_OutOfOrderAcks_SingleGap_NoBefore_NoAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.EventSourcing, 1, false, false);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_OutOfOrderAcks_SingleGap_NoBefore_NoAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.StateReplication, 1, false, false);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_OutOfOrderAcks_SingleGap_YesBefore_NoAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.EventSourcing, 1, true, false);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_OutOfOrderAcks_SingleGap_YesBefore_NoAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.StateReplication, 1, true, false);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_OutOfOrderAcks_SingleGap_NoBefore_YesAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.EventSourcing, 1, false, true);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_OutOfOrderAcks_SingleGap_NoBefore_YesAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.StateReplication, 1, false, true);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_OutOfOrderAcks_SingleGap_YesBefore_YesAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.EventSourcing, 1, true, true);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_OutOfOrderAcks_SingleGap_YesBefore_YesAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.StateReplication, 1, true, true);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_OutOfOrderAcks_MultiGap_NoBefore_NoAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.EventSourcing, 5, false, false);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_OutOfOrderAcks_MultiGap_NoBefore_NoAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.StateReplication, 5, false, false);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_OutOfOrderAcks_MultiGap_YesBefore_NoAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.EventSourcing, 5, true, false);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_OutOfOrderAcks_MultiGap_YesBefore_NoAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.StateReplication, 5, true, false);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_OutOfOrderAcks_MultiGap_NoBefore_YesAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.EventSourcing, 5, false, true);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_OutOfOrderAcks_MultiGap_NoBefore_YesAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.StateReplication, 5, false, true);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionEventSourcing_OutOfOrderAcks_MultiGap_YesBefore_YesAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.EventSourcing, 5, true, true);
    }

    @Test
    public void testOutOfOrderSendCommitCompletionStateReplication_OutOfOrderAcks_MultiGap_YesBefore_YesAfter() throws Exception {
        this.testOutOfOrderSendCommitCompletion_OutOfOrderAcks(AepEngine.HAPolicy.StateReplication, 5, true, true);
    }
}

