/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.test.unit.AepEngineCommitSuspensionTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageChannel;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineCommitSuspensionTest
extends AepEngineTest {
    static final void compareSequenceNumbers(ArrayList<IRogMessage> list1, ArrayList<IRogMessage> list2) {
        Assert.assertEquals((long)list1.size(), (long)list2.size());
        int size = list1.size();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)list1.get(i).getMessageSequenceNumber(), (long)list2.get(i).getMessageSequenceNumber());
        }
    }

    private final void send(MessageChannel channel, ArrayList<IRogMessage> messages, AepEngineTestObject.EncodingType encodingType) {
        IRogMessage message = new AepEngineTestMessage(encodingType).getMessage();
        messages.add(message);
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(channel, message);
    }

    private final void testCore(boolean guaranteed, boolean suspend, AepEngineTestObject.EncodingType encodingType) throws Exception {
        int i;
        AepEngine engine2;
        this.messagingController.enableWaitForQuiescence("aeptest1", true);
        AepEngineCommitSuspensionTestApp sender = new AepEngineCommitSuspensionTestApp();
        AepEngineCommitSuspensionTestApp receiver = new AepEngineCommitSuspensionTestApp();
        receiver.suspend = suspend;
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 15, 15, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        receiver.engine = engine2 = this.createEngine("engine2", AepEngine.HAPolicy.EventSourcing, null, null, null, null, false, false, false, false, null, 15, 15, receiver, null, null, 0, true, true, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        ArrayList<IRogMessage> messages = new ArrayList<IRogMessage>();
        for (i = 0; i < 10; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 10; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 100; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 1000; ++i) {
            this.send(guaranteed ? sender.channel4 : sender.channel1, messages, encodingType);
        }
        Assert.assertTrue((boolean)receiver.waitForExpectedMessageReceipt(1120));
        this.messagingController.waitForQuiescence("aeptest1");
        receiver.shutdown();
        Assert.assertEquals((long)1120L, (long)receiver.numStageEventMessages);
        Assert.assertEquals((long)1120L, (long)receiver.messages.size());
        AepEngineCommitSuspensionTest.compareSequenceNumbers(messages, receiver.messages);
    }

    @Test
    public void testReplicationEventSourcingBestEffortProtoNoSuspend() throws Exception {
        this.testCore(false, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testCommitSuspensionEventSourcingGuaranteedProtoNoSuspend() throws Exception {
        this.testCore(true, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testReplicationEventSourcingBestEffortProtoWithSuspend() throws Exception {
        this.testCore(false, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testCommitSuspensionEventSourcingGuaranteedProtoWithSuspend() throws Exception {
        this.testCore(true, true, AepEngineTestObject.EncodingType.Proto);
    }
}

