/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery.impl.sma;

import com.neeve.ci.XRuntime;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.impl.DiscoveryCacheBase;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.pkt.PktPacket;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.RawMessageViewFactory;
import com.neeve.sma.event.MessageBusBindingFailedEvent;
import com.neeve.sma.event.MessageBusBindingReconnectedEvent;
import com.neeve.sma.event.MessageBusBindingReconnectingEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.sma.event.UnhandledMessageEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

final class SmaDiscoveryCache
extends DiscoveryCacheBase
implements IEventHandler {
    private static final String DISCOVERY_CHANNEL = UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.sma.discovery.channel", (String)"_XEDP_");
    private static final int ON_EVENT_AND_CLOSE_STATE_NORMAL = 0;
    private static final int ON_EVENT_AND_CLOSE_STATE_INEVENTHANDLER = 1;
    private static final int ON_EVENT_AND_CLOSE_STATE_CLOSING = 2;
    private static final int ON_EVENT_AND_CLOSE_STATE_CLOSED = 3;
    private RawMessageViewFactory rawViewFactory;
    private MessageBusBinding binding;
    private MessageChannel channel;
    private Reconnector reconnector;
    private AtomicInteger onEventAndCloseSynchronizer;

    SmaDiscoveryCache(UtlAddressDescriptor descriptor, int flags) throws EDiscoveryException {
        super(descriptor, flags);
    }

    private final String getTracePrefix() {
        return "[SmaDiscoveryCache-" + this.getLocalMemberName() + "]";
    }

    private final void startReconnector() {
        this.reconnector = new Reconnector();
        this.reconnector.start();
        this.suspendAgeing();
        this.tracer.log(this.getTracePrefix() + " Started bus reconnector.", Tracer.Level.INFO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void stopReconnector() {
        if (this.tracer.debug) {
            this.tracer.log(this.getTracePrefix() + " Stopping bus reconnector...", Tracer.Level.DEBUG);
        }
        if (this.reconnector != null) {
            try {
                this.reconnector.shutdown();
                if (!this.tracer.debug) return;
                this.tracer.log(this.getTracePrefix() + " Bus reconnector stopped successfully.", Tracer.Level.DEBUG);
                return;
            }
            finally {
                this.reconnector = null;
            }
        } else {
            if (!this.tracer.debug) return;
            this.tracer.log(this.getTracePrefix() + " Bus reconnector is not active.", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean connect() {
        SmaDiscoveryCache smaDiscoveryCache = this;
        synchronized (smaDiscoveryCache) {
            try {
                String busName;
                int protocolPos;
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix() + " Opening bus connection...", Tracer.Level.DEBUG);
                }
                if ((protocolPos = (busName = this.descriptor.address.equals(".") ? "discovery" : this.descriptor.address).lastIndexOf("://")) != -1) {
                    if (busName.length() > protocolPos + 3) {
                        busName = busName.substring(protocolPos + 3);
                    } else {
                        throw new IllegalArgumentException("Invalid discovery address: '" + busName + "' expected name after ://");
                    }
                }
                busName = busName.replace('/', '_');
                busName = busName.replace('\\', '_');
                MessageBusDescriptor busDescriptor = MessageBusDescriptor.create(busName);
                String discoveryChannel = DISCOVERY_CHANNEL;
                if (this.descriptor.props.get("discoveryChannel") != null) {
                    discoveryChannel = (String)this.descriptor.props.get("discoveryChannel");
                }
                busDescriptor.addChannel(MessageChannelDescriptor.create(discoveryChannel, busDescriptor));
                busDescriptor.setProviderConfig(this.descriptor.toFullString());
                busDescriptor.getProviderConfig().remove("discoveryChannel");
                busDescriptor.getProviderConfig().keySet().removeAll(DISCOVERY_PROPERTIES);
                if (this.tracer.debug) {
                    this.tracer.log(this.getTracePrefix() + " Connecting to the discovery bus '" + busDescriptor.getName() + "'...", Tracer.Level.DEBUG);
                }
                this.binding = MessageBusBindingFactory.getInstance().createBinding(this.getLocalMemberName(), busDescriptor, (IEventHandler)this);
                this.channel = this.binding.getMessageChannel(discoveryChannel);
                this.channel.join(0);
                this.binding.start();
                this.tracer.log(this.getTracePrefix() + " Bus connect successful.", Tracer.Level.INFO);
                return true;
            }
            catch (Exception e) {
                this.tracer.log(this.getTracePrefix() + " Bus connect failed [" + e.toString() + "].", Tracer.Level.WARNING);
                this.disconnect();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void disconnect() {
        SmaDiscoveryCache smaDiscoveryCache = this;
        synchronized (smaDiscoveryCache) {
            if (this.binding != null) {
                try {
                    if (this.tracer.debug) {
                        this.tracer.log(this.getTracePrefix() + " Closing bus connection...", Tracer.Level.DEBUG);
                    }
                    this.binding.close();
                }
                catch (Exception e) {
                    this.tracer.log(this.getTracePrefix() + " Failed to close bus connection [" + e.toString() + "].", Tracer.Level.WARNING);
                }
                finally {
                    this.binding = null;
                    this.channel = null;
                }
            } else if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix() + " Bus connection is already closed.", Tracer.Level.DEBUG);
            }
        }
    }

    private final void closeCore() {
        if (this.tracer.debug) {
            this.tracer.log(this.getTracePrefix() + " Closing...", Tracer.Level.DEBUG);
        }
        if (this.onEventAndCloseSynchronizer.getAndSet(3) != 3) {
            this.stopReconnector();
            this.disconnect();
            if (this.tracer.debug) {
                this.tracer.log(this.getTracePrefix() + " Closed.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.getTracePrefix() + " Already closed.", Tracer.Level.DEBUG);
        }
    }

    protected final void doOpen() throws EDiscoveryException {
        this.rawViewFactory = RawMessageViewFactory.create(null);
        this.onEventAndCloseSynchronizer = new AtomicInteger(0);
        if (!this.connect()) {
            this.startReconnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doBroadcast(PktPacket packet) throws EDiscoveryException {
        SmaDiscoveryCache smaDiscoveryCache = this;
        synchronized (smaDiscoveryCache) {
            if (this.binding != null) {
                try {
                    MessageView view = this.rawViewFactory.wrap((short)0, 1, packet);
                    this.channel.sendMessage(view, null, 1);
                    view.dispose();
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Failed to send discovery packet [" + e.toString() + "].\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                }
            } else {
                this.tracer.log(this.getTracePrefix() + " Failed to send discovery packet [bus connection is down].", Tracer.Level.WARNING);
            }
        }
    }

    protected final void doClose() {
        if (this.onEventAndCloseSynchronizer.getAndSet(2) == 0) {
            this.closeCore();
        }
    }

    public final void onEvent(Event event) {
        if (this.onEventAndCloseSynchronizer.compareAndSet(0, 1)) {
            try {
                if (event instanceof MessageEvent) {
                    this.onPacket((PktPacket)((MessageEvent)event).getMessageView().getMessage());
                } else if (event instanceof UnhandledMessageEvent) {
                    Object message = ((UnhandledMessageEvent)event).getUnwrappedMessage();
                    this.tracer.log(this.getTracePrefix() + " Received an unhandled message'" + message + "'.", Tracer.Level.WARNING);
                } else if (event instanceof MessageBusBindingReconnectingEvent) {
                    this.tracer.log(this.getTracePrefix() + " Bus connection is reconnecting...", Tracer.Level.WARNING);
                    this.suspendAgeing();
                } else if (event instanceof MessageBusBindingReconnectedEvent) {
                    this.tracer.log(this.getTracePrefix() + " Bus connection has successfully reconnected.", Tracer.Level.WARNING);
                    this.resumeAgeing();
                } else if (event instanceof MessageBusBindingFailedEvent) {
                    Exception cause = ((MessageBusBindingFailedEvent)event).getCause();
                    this.tracer.log(this.getTracePrefix() + " Bus connection has failed (cause=" + (cause != null ? cause.toString() : "null") + ").", Tracer.Level.SEVERE);
                    this.disconnect();
                    this.startReconnector();
                } else if (this.tracer.verbose) {
                    this.tracer.log(this.getTracePrefix() + " Received an unknown event '" + event.getClass().getSimpleName() + "'.", Tracer.Level.VERBOSE);
                }
            }
            finally {
                if (this.onEventAndCloseSynchronizer.getAndSet(0) == 2) {
                    this.closeCore();
                }
            }
        }
    }

    private final class Reconnector
    extends Thread {
        private boolean done = false;
        private volatile boolean sleeping = false;

        Reconnector() {
            this.setName("X-EDP-SMA-Reconnector");
            this.setDaemon(true);
        }

        final void shutdown() {
            this.done = true;
            if (this.sleeping) {
                this.interrupt();
            }
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            while (!this.done) {
                try {
                    this.sleeping = true;
                    try {
                        Reconnector.sleep(300L);
                    }
                    finally {
                        this.sleeping = false;
                    }
                    if (!SmaDiscoveryCache.this.connect()) continue;
                    SmaDiscoveryCache.this.resumeAgeing();
                    this.done = true;
                }
                catch (InterruptedException e) {
                    this.done = true;
                }
            }
            SmaDiscoveryCache.this.tracer.log(SmaDiscoveryCache.this.getTracePrefix() + " Bus reconnector stopped.", Tracer.Level.INFO);
        }
    }
}

