/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufStringField
extends XbufField {
    private final XString value = XString.create((int)1, (boolean)true, (boolean)true);

    private XbufStringField(short id, String name) {
        super(XbufField.Type.STRING, id, name, false);
    }

    public static XbufStringField create(short id, String name) {
        return new XbufStringField(id, name);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        XString val = (XString)this.container.fieldValues[this.index];
        if (val == null) {
            throw new InternalError("attempt to sync null content!");
        }
        val.copyInto((IOElasticBuffer)buffer, offset);
        return val.getSerializedLength();
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length < 0) {
            throw new InternalError("attempt to desync content using length < 0");
        }
        this.value.setValue((IOElasticBuffer)buffer, offset, length);
        this.container.setValue(this, this.value);
        return length;
    }

    @Override
    protected void contentFramed() {
        this.value.reset();
    }

    @Override
    protected final int contentLength() {
        XString val = (XString)this.container.fieldValues[this.index];
        if (val == null) {
            throw new InternalError("attempt to get length for null content!");
        }
        return val.getSerializedLength();
    }

    @Override
    protected final String contentAsString() {
        String val = this.getValue();
        return val != null ? val : "null";
    }

    @Override
    protected final boolean contentClear() {
        this.value.reset();
        return this.container.clearValue(this);
    }

    public final void setValue(String val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.setValue(val);
        this.container.setValue(this, this.value.isNull() ? null : this.value);
    }

    public final void setValue(XString val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.container.setValue(this, val.isNull() ? null : val);
        val.getBackingBuffer();
    }

    public final void setValueFrom(long val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.setValue(val);
        this.container.setValue(this, this.value.isNull() ? null : this.value);
    }

    public final <T extends XString> void setValueFrom(T val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (val == this.value) {
            return;
        }
        val.copyInto(this.value);
        this.container.setValue(this, this.value.isNull() ? null : this.value);
    }

    public final void setValueFrom(XbufStringField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field.hasValue()) {
            field.getValueTo(this.value);
            this.container.setValue(this, this.value.isNull() ? null : this.value);
        } else {
            this.clearValue();
        }
    }

    public final String getValue() {
        Object val = this.getRawValue();
        if (val == null) {
            return null;
        }
        return val.getValue();
    }

    public final <T extends XString> void getValueTo(T val) {
        if (val == null) {
            throw new IllegalArgumentException("val is null");
        }
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            val.setValue((IOElasticBuffer)this.buffer, this.contentOffset, this.contentLength);
        } else {
            val.setValue((XString)this.container.fieldValues[this.index]);
        }
    }

    public final <T extends XString> T getRawValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            if (!this.value.isInitialized()) {
                this.value.setValue((IOElasticBuffer)this.buffer, this.contentOffset, this.contentLength);
            }
            if (this.value.isNull()) {
                return null;
            }
            return (T)this.value;
        }
        return (T)((XString)this.container.fieldValues[this.index]);
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, String v) {
        int valueLength = XbufStringField.serializedValueLength(v);
        int headerLength = XbufStringField.syncHeader(buffer, offset, id, XbufField.Type.STRING, valueLength);
        return headerLength + buffer.putCharSequenceUTF(offset + headerLength, (CharSequence)v);
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, XString v) {
        int valueLength = v == null ? -1 : v.getSerializedLength();
        int headerLength = XbufStringField.syncHeader(buffer, offset, id, XbufField.Type.STRING, valueLength);
        if (v != null) {
            v.copyInto((IOElasticBuffer)buffer, offset);
        }
        return headerLength + Math.max(valueLength, 0);
    }

    public static final int serializedValueLength(String v) {
        return v == null ? -1 : IOElasticBuffer.calculateUTFLength((CharSequence)v);
    }

    public static int serializedFieldLength(short id, String v) {
        int len = XbufStringField.serializedValueLength(v);
        return Math.max(len, 0) + XbufStringField.headerLength(id, XbufField.Type.STRING, len);
    }

    public static final int deserializeStringLength(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int headerLength;
        int tag = XbufStringField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufStringField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        int len = XbufStringField.fieldLength(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value = headerLength = tagLength + varintDesyncLength.value;
        return len;
    }

    static final String deserializeField(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int len = XbufStringField.deserializeStringLength(buffer, offset, id, varintDesyncLength);
        if (len >= 0) {
            String v = buffer.getString(offset + varintDesyncLength.value, len);
            varintDesyncLength.value += len;
            return v;
        }
        return null;
    }
}

