/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import java.util.Date;

public final class XbufDateField
extends XbufField {
    private final Value value = new Value();

    private XbufDateField(short id, String name, boolean pinned) {
        super(XbufField.Type.DATE, id, name, pinned);
    }

    public static final XbufDateField create(short id, String name, boolean pinned) {
        return new XbufDateField(id, name, pinned);
    }

    private final void serialize(PktBuffer buffer, int offset, long val) {
        buffer.putLong(offset, val);
    }

    private final long deserialize(PktBuffer buffer, int offset) {
        return buffer.getLong(offset);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        this.serialize(buffer, offset, this.getValueAsTimestamp());
        return 8;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length != 8) {
            throw new InternalError("request to deserialize date with length != 8 (length=" + length + ")");
        }
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return 8;
    }

    @Override
    protected final int contentLength() {
        return 8;
    }

    @Override
    protected final String contentAsString() {
        Date val = this.getValue();
        return val == null ? null : val.toString();
    }

    @Override
    protected final boolean contentClear() {
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, -1L);
            return true;
        }
        this.value.val = -1L;
        return this.container.clearValue(this);
    }

    public final void setValue(Date val) {
        long valAsTimestamp;
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        long l = valAsTimestamp = val == null ? -1L : val.getTime();
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, valAsTimestamp);
        } else {
            this.value.val = valAsTimestamp;
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueAsTimestamp(long val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, val);
        } else {
            this.value.val = val;
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueFrom(XbufDateField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final Date getValue() {
        long valAsTimestamp = this.getValueAsTimestamp();
        return valAsTimestamp >= 0L ? new Date(valAsTimestamp) : null;
    }

    public final long getValueAsTimestamp() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.pinned || this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : -1L;
    }

    private final class Value {
        long val;

        private Value() {
        }
    }
}

