/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmDeprecation;
import com.neeve.adm.AdmDocumentation;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmModelElement;
import com.neeve.adm.AdmType;

public class AdmSemanticType
extends AdmModelElement {
    private final AdmModel model;
    private final String name;
    private final AdmType baseType;
    private AdmDocumentation doc;
    private AdmDeprecation deprecation;
    private boolean poolable;
    private int length;

    public AdmSemanticType(AdmModel model, String name, AdmType baseType) {
        this.model = model;
        this.name = name;
        this.baseType = baseType;
    }

    public final AdmModel getModel() {
        return this.model;
    }

    public final String getName() {
        return this.name;
    }

    public final String getJavaTypeName() {
        if (AdmModel.RESERVED_TYPE_NAMES.contains(this.name)) {
            return this.getFullName();
        }
        return this.name;
    }

    public String getFullName() {
        return this.model.getNamespace() + "." + this.name;
    }

    public String getQualifiedName(AdmModel model) {
        if (!model.getNamespace().equals(this.model.getNamespace())) {
            return model.getNamespace() + "." + this.name;
        }
        return this.name;
    }

    public final AdmType getBaseType() {
        return this.baseType;
    }

    public void setDocumentation(AdmDocumentation doc) {
        this.doc = doc;
    }

    public final AdmDocumentation getDocumentation() {
        return this.doc;
    }

    public AdmDeprecation getDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(AdmDeprecation deprecation) {
        this.deprecation = deprecation;
    }

    public boolean isPoolable() {
        return this.poolable;
    }

    public void setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String toString() {
        return "Semantic Type [name: " + this.getFullName() + "length: " + this.length + "baseType: " + (Object)((Object)this.baseType) + "]";
    }
}

