/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.jms;

import com.google.protobuf.Message;
import com.neeve.jms.JmsBindingProperties;
import com.neeve.jms.JmsMessageBusBinding;
import com.neeve.lang.XString;
import com.neeve.rog.impl.RogNode;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

public class JmsMessageChannel
extends MessageChannelBase
implements MessageListener {
    private final JmsMessageBusBinding binding;
    private String[] filters;
    private int ackQueueIndex = 0;
    private final ArrayList<javax.jms.Message>[] ackQueue;

    protected JmsMessageChannel(MessageChannelDescriptor descriptor, JmsMessageBusBinding binding) throws SmaException {
        super(null, descriptor, (MessageBusBindingBase)binding);
        this.binding = binding;
        if (descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
            this.ackQueue = new ArrayList[2];
            this.ackQueue[0] = new ArrayList();
            this.ackQueue[1] = new ArrayList();
        } else {
            this.ackQueue = null;
        }
    }

    private final void subscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String destination = this.normalizeDestination(filter == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + filter : filter));
        if (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Subscribing to (guaranteed) topic '" + destination + "'...", Tracer.Level.DEBUG);
            }
            this.binding.subscribeGuaranteed(this, destination);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Subscribing to (best effort) topic '" + destination + "'...", Tracer.Level.DEBUG);
            }
            this.binding.subscribe(this, destination);
        }
    }

    private final void unsubscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String destination = this.normalizeDestination(filter == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + filter : filter));
        if (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Unsubscribing from (guaranteed) topic '" + destination + "'...", Tracer.Level.DEBUG);
            }
            this.binding.unsubscribeGuaranteed(this, destination);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Unsubscribing from (best effort) topic '" + destination + "'...", Tracer.Level.DEBUG);
            }
            this.binding.unsubscribe(this, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onMessage(javax.jms.Message message, JmsMessageChannel ackChannel, MessageMetadata metadata, long originTs, long preWireTs, long postWireTs) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received from binding. Payload is " + message + ". Metadata is " + metadata, Tracer.Level.DEBUG);
        }
        try {
            String destinationName;
            Object smaMessage;
            short vtype;
            long preDeserializeTs;
            block39: {
                block40: {
                    block38: {
                        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.d1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)message);
                        preDeserializeTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
                        vtype = 0;
                        smaMessage = null;
                        if (!(message instanceof BytesMessage)) break block38;
                        if (metadata.getVersion() == 1) {
                            throw new RuntimeException("JMS binding only supports the V1 header with TextMessage payload");
                        }
                        BytesMessage bytesMessage = (BytesMessage)message;
                        int len = (int)bytesMessage.getBodyLength();
                        byte[] data = new byte[len];
                        if (len > 0) {
                            bytesMessage.readBytes(data);
                        }
                        vtype = metadata.getMessageViewType();
                        switch (metadata.getMessageEncodingType()) {
                            case 1: {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "Encoding type is CUSTOM. Dispatching as is...", Tracer.Level.DEBUG);
                                }
                                smaMessage = data;
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + data == null ? "<nodata>" : UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(data)), Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    break;
                                }
                                break block39;
                            }
                            case 6: {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "Encoding type is QUARK. Dispatching as is...", Tracer.Level.DEBUG);
                                }
                                smaMessage = data;
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + data == null ? "<nodata>" : UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(data)), Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    break;
                                }
                                break block39;
                            }
                            case 3: {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "Encoding type is XBUF. Dispatching as is...", Tracer.Level.DEBUG);
                                }
                                smaMessage = data;
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + data == null ? "<nodata>" : UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(data)), Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    break;
                                }
                                break block39;
                            }
                            case 7: {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "Encoding type is XBUF2. Dispatching as is...", Tracer.Level.DEBUG);
                                }
                                smaMessage = data;
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + data == null ? "<nodata>" : UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(data)), Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    break;
                                }
                                break block39;
                            }
                            case 4: {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "Encoding type is PROTOBUF. Dispatching as is...", Tracer.Level.DEBUG);
                                }
                                smaMessage = data;
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + data == null ? "<nodata>" : UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(data)), Tracer.Level.DEBUG);
                                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                    break;
                                }
                                break block39;
                            }
                            default: {
                                throw new RuntimeException("unknown encoding type: " + metadata.getMessageEncodingType());
                            }
                        }
                        break block39;
                    }
                    if (!(message instanceof TextMessage)) break block40;
                    TextMessage textMessage = (TextMessage)message;
                    switch (metadata.getMessageEncodingType()) {
                        case 5: {
                            if (this.tracer.debug) {
                                this.tracer.log(this.tracePrefix + "Encoding type is json.", Tracer.Level.DEBUG);
                            }
                            smaMessage = textMessage.getText();
                            short s = vtype = metadata.getVersion() == 1 ? RogNode.getTypeFromJson((String)smaMessage) : metadata.getMessageViewType();
                            if (this.tracer.debug) {
                                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                this.tracer.log(this.tracePrefix + smaMessage, Tracer.Level.DEBUG);
                                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                                break;
                            }
                            break block39;
                        }
                        default: {
                            throw new RuntimeException("unknown encoding type");
                        }
                    }
                    break block39;
                }
                throw new RuntimeException("Unable to handle JMS message type '" + message.getClass().getSimpleName() + "' [unsupported message type]");
            }
            XString messageKey = this.binding.isSetKeyOnReceipt() ? ((destinationName = this.binding.extractDestinationName(message)) != null ? XString.create((String)destinationName, (boolean)false, (boolean)false) : null) : null;
            MessageTransportHeaders transportHeaders = null;
            try {
                if (this.binding.isEnableInboundTransportHeaders()) {
                    transportHeaders = MessageTransportHeaders.create();
                    transportHeaders.addHeader(JmsBindingProperties.TRANSPORT_HEADER_JMS_MESSAGE_ID, message.getJMSMessageID());
                    if (this.getId() == Short.MAX_VALUE) {
                        XString receivedMessageChannel = metadata.getMessageChannelNameAsRaw();
                        if (receivedMessageChannel == null || receivedMessageChannel.isNull() || receivedMessageChannel.length() == 0) {
                            transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, metadata.getMessageChannelId());
                        } else {
                            transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, receivedMessageChannel);
                        }
                    }
                } else {
                    transportHeaders = null;
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Dispatching...", Tracer.Level.DEBUG);
                }
                this.onMessage(smaMessage, transportHeaders, metadata.getMessageViewFactory(), vtype, metadata.getMessageEncodingType(), metadata.getMessageSender(), metadata.getMessageFlow(), metadata.getMessageSno(), messageKey, ackChannel != null && ackChannel.getQos() == MessageChannel.Qos.Guaranteed ? this.binding.createAcknowledger(ackChannel, message) : null, originTs, preWireTs, postWireTs, preDeserializeTs);
                this.flushReceivedAcks();
            }
            finally {
                if (transportHeaders != null) {
                    transportHeaders.dispose();
                }
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(this.tracePrefix + "JMS Error processing received message: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushReceivedAcks() throws JMSException {
        if (this.getQos() == MessageChannel.Qos.Guaranteed) {
            ArrayList<javax.jms.Message> toAck = null;
            ArrayList<javax.jms.Message>[] arrayListArray = this.ackQueue;
            synchronized (this.ackQueue) {
                if (!this.ackQueue[this.ackQueueIndex].isEmpty()) {
                    toAck = this.ackQueue[this.ackQueueIndex];
                    this.ackQueueIndex = this.ackQueueIndex == 0 ? 1 : 0;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                if (toAck != null) {
                    boolean acked = false;
                    for (int i = 0; i < toAck.size(); ++i) {
                        if (this.tracer.debug) {
                            this.tracer.log("Acking message " + toAck.get(i).getJMSMessageID(), Tracer.Level.DEBUG);
                        }
                        toAck.get(i).acknowledge();
                        acked = true;
                    }
                    toAck.clear();
                    return acked;
                }
                return false;
            }
        }
        return false;
    }

    final void onAckNack(MessageView view, Exception status) {
        this.onMessageStability(view, status);
    }

    protected final boolean doSend(MessageView view, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        try {
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
            if (MessageLatencyManager.captureMsgLatencyStats) {
                view.setPreSerializeTs(UtlTime.now());
            }
            MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
            int messageEncodingType = view.getMessageEncodingType();
            metadata.serializeV2((byte)(messageEncodingType == 3 || messageEncodingType == 7 ? 4 : messageEncodingType), view.getVfid(), view.getType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
            TextMessage message = null;
            switch (messageEncodingType) {
                case 1: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is CUSTOM. Serializing...", Tracer.Level.DEBUG);
                    }
                    byte[] serializedCustomMessage = view.serializeToByteArray();
                    message = this.binding.createBytesMessage();
                    ((BytesMessage)message).writeBytes(serializedCustomMessage);
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(serializedCustomMessage)), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    break;
                }
                case 6: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is QUARK. Serializing...", Tracer.Level.DEBUG);
                    }
                    byte[] serializedQuarkMessage = view.serializeToByteArray();
                    message = this.binding.createBytesMessage();
                    ((BytesMessage)message).writeBytes(serializedQuarkMessage);
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(serializedQuarkMessage)), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    break;
                }
                case 3: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is XBUF. Serializing...", Tracer.Level.DEBUG);
                    }
                    byte[] serializedXbufMessage = view.serializeToByteArray();
                    message = this.binding.createBytesMessage();
                    ((BytesMessage)message).writeBytes(serializedXbufMessage);
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(serializedXbufMessage)), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    break;
                }
                case 7: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is XBUF2. Serializing...", Tracer.Level.DEBUG);
                    }
                    byte[] serializedXbuf2Message = view.serializeToByteArray();
                    message = this.binding.createBytesMessage();
                    ((BytesMessage)message).writeBytes(serializedXbuf2Message);
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(serializedXbuf2Message)), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    break;
                }
                case 4: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is PROTOBUF. Serializing...", Tracer.Level.DEBUG);
                    }
                    Message protoMessage = (Message)view.getMessage();
                    byte[] serializedProtoMessage = protoMessage.toByteArray();
                    message = this.binding.createBytesMessage();
                    ((BytesMessage)message).writeBytes(serializedProtoMessage);
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(serializedProtoMessage)), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    break;
                }
                case 5: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is JSON.", Tracer.Level.DEBUG);
                    }
                    message = this.binding.createTextMessage();
                    message.setText((String)view.getMessage());
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + message.getText(), Tracer.Level.DEBUG);
                    this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                    break;
                }
                default: {
                    throw new SmaException("unknown encoding type");
                }
            }
            String key = view.getMessageKey();
            boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
            if (key == null && !topicStartsWithChannel) {
                throw new SmaException("send performed with null key but binding configured to not prepend topic with channel");
            }
            String destination = this.normalizeDestination(key == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + key : key));
            if (MessageLatencyManager.captureMsgLatencyStats) {
                view.setPostSerializeTs(UtlTime.now());
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s2, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)message);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Sending through binding. Payload is " + message + ". Metadata is " + metadata + ", topic is '" + destination + "'", Tracer.Level.DEBUG);
            }
            this.binding.send(this, view, (javax.jms.Message)message, metadata, destination, this.descriptor.getChannelQos(), view.getOriginTs(), flags);
            if (this.getQos() == MessageChannel.Qos.Guaranteed) {
                this.onMessageStability(view);
            }
            return this.binding.markAsComplete(flushContext);
        }
        catch (JMSException e) {
            throw new SmaException((Throwable)e);
        }
    }

    protected String normalizeDestination(String destination) {
        return destination;
    }

    protected final void doJoin(String[] filters, int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(filters != null && filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("join performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (filters == null || filters.length == 0) {
            this.subscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : filters) {
                this.subscribe(filter, topicStartsWithChannel);
            }
        }
        this.filters = filters;
    }

    protected final void doLeave(int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(this.filters != null && this.filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("leave performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (this.filters == null || this.filters.length == 0) {
            this.unsubscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : this.filters) {
                this.unsubscribe(filter, topicStartsWithChannel);
            }
        }
    }

    protected final void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing channel...", Tracer.Level.DEBUG);
        }
        this.binding.onChannelClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void acknowledgeMessage(javax.jms.Message message) {
        ArrayList<javax.jms.Message>[] arrayListArray = this.ackQueue;
        synchronized (this.ackQueue) {
            this.ackQueue[this.ackQueueIndex].add(message);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public final void onMessage(javax.jms.Message message) {
        this.binding.onMessage(this, message);
    }

    public final String getType() {
        return "Jms";
    }
}

