/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.IndexColumn;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.QueryTreeNodeList;

public class IndexColumnList
extends QueryTreeNodeList<IndexColumn> {
    private FunctionApplication functionApplication;

    public void applyFunction(Object functionType, int firstArgumentPosition, int nArguments) throws StandardException {
        if (this.functionApplication != null) {
            throw new StandardException("Cannot use multiple functions in one index definition");
        }
        this.functionApplication = new FunctionApplication((FunctionType)((Object)functionType), firstArgumentPosition, nArguments);
    }

    public int firstFunctionArg() {
        return this.functionApplication == null ? Integer.MAX_VALUE : this.functionApplication.firstArgumentPosition;
    }

    public int lastFunctionArg() {
        return this.functionApplication == null ? Integer.MIN_VALUE : this.functionApplication.lastArgumentPosition;
    }

    public FunctionType functionType() {
        return this.functionApplication == null ? null : this.functionApplication.functionType;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        IndexColumnList that = (IndexColumnList)node;
        this.functionApplication = that.functionApplication;
    }

    @Override
    public String toString() {
        return this.functionApplication != null ? String.format("\nmethodName: %s\nfirstArg: %s\nlastArg: %s\n", new Object[]{this.functionApplication.functionType, this.functionApplication.firstArgumentPosition, this.functionApplication.lastArgumentPosition}) : super.toString();
    }

    private static class FunctionApplication {
        public final FunctionType functionType;
        public final int firstArgumentPosition;
        public final int lastArgumentPosition;
        public final int nArguments;

        public FunctionApplication(FunctionType functionType, int firstArgumentPosition, int nArguments) {
            this.functionType = functionType;
            this.firstArgumentPosition = firstArgumentPosition;
            this.lastArgumentPosition = firstArgumentPosition + nArguments - 1;
            this.nArguments = nArguments;
        }
    }

    public static enum FunctionType {
        Z_ORDER_LAT_LON,
        FULL_TEXT;

    }
}

