/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public final class CharTypeCompiler
extends TypeCompiler {
    protected CharTypeCompiler(TypeId typeId) {
        super(typeId);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isAnsiUDT()) {
            return false;
        }
        if (this.getTypeId().isLongVarcharTypeId()) {
            return otherType.isStringTypeId() || otherType.isBooleanTypeId();
        }
        if (forDataTypeFunction && otherType.isDoubleTypeId()) {
            return this.getTypeId().isStringTypeId();
        }
        return !otherType.isFloatingPointTypeId() && !otherType.isBitTypeId() && !otherType.isBlobTypeId() && !otherType.isXMLTypeId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return otherType.isStringTypeId() || otherType.isDateTimeTimeStampTypeId() && !this.getTypeId().isLongVarcharTypeId();
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.lang.String";
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getString";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }
}

