/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery;

import com.neeve.ci.XRuntime;
import com.neeve.discovery.DiscoveryObject;
import com.neeve.discovery.DiscoveryProviderRegistry;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.util.Properties;

public final class DiscoveryCacheFactory
extends DiscoveryObject {
    private static final DiscoveryCacheFactory instance;
    private Object defaultCacheLock = new Object();
    private IDiscoveryCache defaultCache;
    public static final String DEFAULT_CACHE_DESCRIPTOR;
    public static final int FLG_NO_AUTOOPEN = 1;

    private DiscoveryCacheFactory() {
    }

    public static final DiscoveryCacheFactory getInstance() {
        return instance;
    }

    public final IDiscoveryCache createCache(String descriptorStr, int flags) throws EDiscoveryException {
        if (descriptorStr == null) {
            throw new IllegalArgumentException("descriptor string cannot be null");
        }
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse((String)descriptorStr, null);
        return DiscoveryProviderRegistry.getInstance().getProvider(descriptor.type).createCache(descriptor, flags);
    }

    public final IDiscoveryCache createCache(String descriptorStr) throws EDiscoveryException {
        return this.createCache(descriptorStr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IDiscoveryCache getDefaultCache() {
        Object object = this.defaultCacheLock;
        synchronized (object) {
            if (this.defaultCache == null) {
                try {
                    this.defaultCache = this.createCache(DEFAULT_CACHE_DESCRIPTOR);
                }
                catch (Exception e) {
                    this.tracer.log("Failed to create discovery cache '" + DEFAULT_CACHE_DESCRIPTOR + "' [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                    throw new RuntimeException("Failed to create default discovery cache '" + DEFAULT_CACHE_DESCRIPTOR + "' [" + e.toString() + "]", e);
                }
            }
        }
        return this.defaultCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDefaultCache(IDiscoveryCache cache) {
        Object object = this.defaultCacheLock;
        synchronized (object) {
            return this.defaultCache != null && cache == this.getDefaultCache();
        }
    }

    public final void close() {
        if (this.defaultCache != null) {
            if (this.tracer.debug) {
                this.tracer.log("Closing discovery cache '" + DEFAULT_CACHE_DESCRIPTOR + "'...", Tracer.Level.DEBUG);
            }
            try {
                this.defaultCache.close();
            }
            finally {
                this.defaultCache = null;
            }
        }
    }

    static {
        DEFAULT_CACHE_DESCRIPTOR = UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.discovery.descriptor", (String)"mcast://224.0.1.200:4090");
        instance = new DiscoveryCacheFactory();
    }
}

