/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.sto.StoTypeFactoryDescriptor;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.trace.Tracer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class PktConfigToolPlugin {
    private final InteractiveTool interactiveTool;
    private final IConfigRepository repo;
    private final LinkedHashMap<String, StoTypeFactoryDescriptor> typeFactories;
    private final Tracer tracer;

    private PktConfigToolPlugin(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        this.tracer = tracer;
        this.repo = repo;
        this.interactiveTool = interactiveTool;
        interactiveTool.registerCommand((Command)new CreatePacket());
        interactiveTool.registerCommand((Command)new DeletePacket());
        interactiveTool.registerCommand((Command)new CreateTypeFactory());
        interactiveTool.registerCommand((Command)new ListTypeFactories());
        interactiveTool.registerCommand((Command)new DeleteTypeFactory());
        this.typeFactories = new LinkedHashMap();
        this.initTypeFactoryDescriptorTable();
    }

    protected final void run() throws Exception {
        Thread.currentThread().setName("PktConfigTool Main");
        this.interactiveTool.run();
    }

    private final void initTypeFactoryDescriptorTable() throws Exception {
        this.tracer.log("Loading configured type factories...", Tracer.Level.INFO);
        this.typeFactories.clear();
        Collection<StoTypeFactoryDescriptor> typeFactoryCollection = StoTypeFactoryDescriptor.loadAll(this.repo).values();
        if (typeFactoryCollection.size() > 0) {
            for (StoTypeFactoryDescriptor typeFactory : typeFactoryCollection) {
                this.tracer.log("...." + typeFactory.getName().toLowerCase(), Tracer.Level.INFO);
                this.typeFactories.put(typeFactory.getName().toLowerCase(), typeFactory);
            }
        } else {
            this.tracer.log("....No configured STO type factories", Tracer.Level.INFO);
        }
    }

    public static final Object create(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        return new PktConfigToolPlugin(interactiveTool, repo, tracer);
    }

    public final class DeleteTypeFactory
    extends Command {
        public final void doDelete(String typeFactoryName) {
            StoTypeFactoryDescriptor typeFactory = (StoTypeFactoryDescriptor)((Object)PktConfigToolPlugin.this.typeFactories.get(typeFactoryName.toLowerCase()));
            if (typeFactory != null) {
                PktConfigToolPlugin.this.tracer.log("Deleting STO type factory '" + typeFactory.getName() + "'...", Tracer.Level.INFO);
                try {
                    typeFactory.delete(PktConfigToolPlugin.this.repo);
                    PktConfigToolPlugin.this.typeFactories.remove(typeFactoryName);
                    PktConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    PktConfigToolPlugin.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
                }
            } else {
                PktConfigToolPlugin.this.tracer.log("STO type factory '" + typeFactoryName + "' does not exist.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: type_factory_delete <typeFactoryName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("type_factory_delete");
            System.out.println("  Deletes a STO type factory from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"type_factory_delete"};
        }
    }

    public final class ListTypeFactories
    extends Command {
        public final void doList() {
            if (PktConfigToolPlugin.this.typeFactories.size() > 0) {
                Iterator iterator = PktConfigToolPlugin.this.typeFactories.keySet().iterator();
                while (iterator.hasNext()) {
                    StoTypeFactoryDescriptor typeFactory = (StoTypeFactoryDescriptor)((Object)PktConfigToolPlugin.this.typeFactories.get(((String)iterator.next()).toLowerCase()));
                    System.out.println("  " + typeFactory.getName() + " - " + (Object)((Object)typeFactory));
                }
            } else {
                PktConfigToolPlugin.this.tracer.log("No STO type factories in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: type_factories");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("type_factories");
            System.out.println("  Lists the STO type factories in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"type_factories"};
        }
    }

    public final class CreateTypeFactory
    extends Command {
        public final void doCreate(String typeFactoryName, short typeFactoryId, String typeFactoryClassName) {
            if (PktConfigToolPlugin.this.typeFactories.get(typeFactoryName.toLowerCase()) == null) {
                PktConfigToolPlugin.this.tracer.log("Creating new STO type factory '" + typeFactoryName + "'...", Tracer.Level.INFO);
                try {
                    StoTypeFactoryDescriptor typeFactory = StoTypeFactoryDescriptor.create(typeFactoryName.toLowerCase(), typeFactoryId, typeFactoryClassName);
                    typeFactory.save(PktConfigToolPlugin.this.repo);
                    PktConfigToolPlugin.this.typeFactories.put(typeFactoryName.toLowerCase(), typeFactory);
                    PktConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    PktConfigToolPlugin.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
                }
            } else {
                PktConfigToolPlugin.this.tracer.log("STO type factory '" + typeFactoryName + "' already exists.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: type_factory_create <typeFactoryName> <typeFactoryId> <typeFactoryClassName>");
            } else {
                this.doCreate(args[0], Short.valueOf(args[1]), args[2]);
            }
        }

        public final void help() {
            System.out.println("type_factory_create");
            System.out.println("  Creates a new STO type factory in the repository");
        }

        public final String[] keywords() {
            return new String[]{"type_factory_create"};
        }
    }

    public final class DeletePacket
    extends Command {
        public final void doDelete(String name) {
            PktConfigToolPlugin.this.tracer.log("Deleting packet '" + name + "' from repository...", Tracer.Level.INFO);
            try {
                IConfigSimpleEntityContainer container = PktConfigToolPlugin.this.repo.getSimpleEntityContainer("/packets");
                if (container != null) {
                    container.removeEntity(name);
                }
            }
            catch (Exception e) {
                PktConfigToolPlugin.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: packet_delete <name>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("packet_delete");
            System.out.println("  Deletes a packet from the repository");
        }

        public final String[] keywords() {
            return new String[]{"packet_delete"};
        }
    }

    public final class CreatePacket
    extends Command {
        public final void doCreate(String name, int id, String className) {
            PktConfigToolPlugin.this.tracer.log("Creating packet '" + name + "' in repository (id=" + id + ", class=" + className + ")...", Tracer.Level.INFO);
            try {
                IConfigSimpleEntity entity;
                IConfigSimpleEntityContainer container = PktConfigToolPlugin.this.repo.getSimpleEntityContainer("/packets");
                if (container == null) {
                    container = PktConfigToolPlugin.this.repo.createSimpleEntityContainer("/packets");
                }
                if ((entity = (IConfigSimpleEntity)container.getEntity(name)) == null) {
                    PktConfigToolPlugin.this.tracer.log("Packet not found in repository. Creating a new one...", Tracer.Level.INFO);
                    entity = (IConfigSimpleEntity)container.createEntity(name);
                    entity.setProperties(null);
                    entity.setProperty("Id", String.valueOf(id));
                    entity.setProperty("BodyClass", className);
                    entity.setProperty("SerializationPolicy", "default");
                    entity.setProperty("DeserializationPolicy", "default");
                } else {
                    PktConfigToolPlugin.this.tracer.log("Packet of supplied name already exists in repository.", Tracer.Level.INFO);
                }
            }
            catch (Exception e) {
                PktConfigToolPlugin.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: packet_create <name> <id> <className>");
            } else {
                this.doCreate(args[0], Integer.parseInt(args[1]), args[2]);
            }
        }

        public final void help() {
            System.out.println("packet_create");
            System.out.println("  Creates a new packet in the repository");
        }

        public final String[] keywords() {
            return new String[]{"packet_create"};
        }
    }
}

