/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.log;

import com.neeve.io.IOBuffer;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktObject;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.log.EPktLogCorruptException;
import com.neeve.pkt.log.EPktLogExpectationNotMetException;
import com.neeve.pkt.log.EPktLogInvalidException;
import com.neeve.pkt.log.EPktLogInvalidPositionException;
import com.neeve.pkt.log.EPktLogNotFoundException;
import com.neeve.pkt.types.PktBodyRecoveryLogCheckpointState;
import com.neeve.quark.QuarkBuffer;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public final class PktRecoveryLog
extends PktObject {
    public static final int PREAMBLE_LENGTH = 9;
    public static final int FLG_SYNC = 1;
    public static final int FLG_AUTOREPAIR = 2;
    public static final int FLG_EXPECT_LOGEMPTY = 4;
    public static final int FLG_EXPECT_LOGPRESENT = 8;
    public static final int FLG_EXPECT_LOGABSENT = 16;
    public static final int FLG_EXPECT_LOGNOTEMPTY = 32;
    public static final int FLG_DISABLE_PACKET_BODY_DESYNC = 64;
    public static final int FLG_SUPPORT_TAILING = 128;
    public static final int FLG_SKIP_INTEGRITY_CHECK = 256;
    @Deprecated
    public static final int FLG_SKIP_WRITE_SEEK = 256;
    public static final String BACKUP_DIRECTORY = "$archive$";
    private static final byte V1 = 1;
    private static final byte VERSION = 1;
    private final String dirname;
    private final String filenameOnly;
    private final String filename;
    private final FileOpenMode openMode;
    private final long initialLength;
    private final boolean zeroOutInitial;
    private final boolean flushUsingMappedMemory;
    private final int autoFlushSize;
    private final int pageSize;
    private PktSerializable.SerializeContext serializeContext;
    private PktPacket checkpointState;
    private IOBuffer eof;
    private int eofLength;
    private RandomAccessFile file;
    private FileChannel fileChannel;
    private long nfile;
    private MappedByteBuffer mappedFileBuffer;
    private Preamble preamble;
    private int numDirtyBytes;
    private long logSize;
    private long logFlushPointer;
    private boolean supportTailing;
    private boolean wasRepaired;
    private RandomAccessFile fileForStats;
    private static final boolean nativeFileIOEnabled = UtlFile.isNativeFileIOEnabled();
    private static final boolean enableWriteChecks = UtlEnv.getValue((String)"nv.packet.log.enablewritechecks", (boolean)true);
    private static final boolean enableSerializationChecks = UtlEnv.getValue((String)"nv.packet.log.enableserializationchecks", (boolean)false);

    private PktRecoveryLog(String dirname, String filename, FileOpenMode openMode, long initialLength, boolean zeroOutInitial, boolean flushUsingMappedMemory, int autoFlushSize, int pageSize) {
        super(null);
        this.dirname = dirname;
        this.filenameOnly = filename;
        this.filename = PktRecoveryLog.filename(dirname, filename);
        this.openMode = openMode;
        this.zeroOutInitial = zeroOutInitial;
        this.flushUsingMappedMemory = flushUsingMappedMemory;
        this.autoFlushSize = autoFlushSize;
        this.pageSize = pageSize;
        if (this.pageSize <= 0) {
            throw new IllegalArgumentException("page size must be > 0");
        }
        this.initialLength = initialLength % (long)pageSize == 0L ? initialLength : (initialLength / (long)pageSize + 1L) * (long)pageSize;
    }

    private static final String filename(String dirname, String filename) {
        if (dirname == null) {
            throw new IllegalArgumentException("recovery log directory cannot be null");
        }
        return dirname + File.separator + (filename == null ? "recovery.log" : filename);
    }

    private static final void scavenge(String dirname, int retentionCount) {
        File[] files = new File(dirname).listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public final int compare(File f1, File f2) {
                if (f1.lastModified() == f2.lastModified()) {
                    return 0;
                }
                return f1.lastModified() < f2.lastModified() ? -1 : 1;
            }
        });
        for (int i = retentionCount; i < files.length; ++i) {
            files[i].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String backup(String dirname, String filename, boolean deleteOriginal, boolean shrinkToSize, boolean repair, int retentionCount) throws IOException {
        if (dirname == null) {
            throw new IllegalArgumentException("directory name cannot be null");
        }
        File logFile = new File(PktRecoveryLog.filename(dirname, filename));
        if (logFile.exists()) {
            String backupDirname = dirname + File.separator + BACKUP_DIRECTORY;
            new File(backupDirname).mkdirs();
            File backupFile = new File(PktRecoveryLog.filename(backupDirname, filename) + "." + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()));
            if (deleteOriginal) {
                if (shrinkToSize) {
                    PktRecoveryLog log = PktRecoveryLog.create(dirname, filename, FileOpenMode.rw, 0L, 8192, 8192);
                    log.open(repair ? 2 : 0, -1L);
                    try {
                        log.file.setLength(log.getSize());
                    }
                    finally {
                        try {
                            log.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                logFile.renameTo(backupFile);
            } else {
                UtlFile.copyFile((File)logFile, (File)backupFile);
            }
            PktRecoveryLog.scavenge(backupDirname, retentionCount);
            return backupFile.getAbsolutePath();
        }
        return null;
    }

    public static String backup(String dirname, String filename, boolean deleteOriginal, boolean shrinkToSize, boolean repair) throws IOException {
        return PktRecoveryLog.backup(dirname, filename, deleteOriginal, shrinkToSize, repair, 1);
    }

    public static PktRecoveryLog create(String dirname, String filename, FileOpenMode openMode, long initialLength, boolean zeroOutInitial, boolean flushUsingMappedMemory, int autoFlushSize, int pageSize) {
        return new PktRecoveryLog(dirname, filename, openMode, initialLength, zeroOutInitial, flushUsingMappedMemory, autoFlushSize, pageSize);
    }

    public static PktRecoveryLog create(String dirname, String filename, FileOpenMode openMode, long initialLength, boolean zeroOutInitial, int autoFlushSize, int pageSize) {
        return PktRecoveryLog.create(dirname, filename, openMode, initialLength, false, false, autoFlushSize, pageSize);
    }

    public static PktRecoveryLog create(String dirname, String filename, FileOpenMode openMode, long initialLength, int autoFlushSize, int pageSize) {
        return PktRecoveryLog.create(dirname, filename, openMode, initialLength, false, autoFlushSize, pageSize);
    }

    private final void prepareEOFMarker() throws EPktException {
        try {
            PktPacket eofPacket = PktFactory.getInstance().createPacket(262);
            this.eofLength = eofPacket.getSerializedLength();
            this.eof = this.createWriteBuffer(this.eofLength);
            eofPacket.serialize(this.eof, 0);
        }
        catch (Exception e) {
            throw new EPktException("Failed to create EOF marker packet for recovery log [" + e.toString() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeEof() throws IOException {
        long nextWritePos = this.file.getFilePointer();
        if (this.tracer.debug) {
            this.tracer.log("Writing EOF.. (pos=" + nextWritePos + ")", Tracer.Level.DEBUG);
        }
        ByteBuffer eofBuffer = this.eof.takeBuffer();
        try {
            this.fileChannel.write(eofBuffer);
            this.file.seek(nextWritePos);
        }
        finally {
            this.eof.releaseBuffer();
        }
    }

    private final void checkLogPresenceExpectations(int openFlags, boolean logfileExists) {
        if ((openFlags & 8) == 8 && !logfileExists) {
            throw new EPktLogExpectationNotMetException(8, null, "log presence expectation mismatch (log is absent when expected to be present)");
        }
        if ((openFlags & 0x10) == 16 && logfileExists) {
            throw new EPktLogExpectationNotMetException(16, null, "log presence expectation mismatch (log is present when expected to be absent)");
        }
    }

    private final void checkLogEmptinessExpectations(int openFlags, boolean hasEntries) {
        if ((openFlags & 4) == 4 && hasEntries) {
            throw new EPktLogExpectationNotMetException(4, hasEntries, "log emptiness expectation not met (entries in the log)");
        }
        if ((openFlags & 0x20) == 32 && !hasEntries) {
            throw new EPktLogExpectationNotMetException(32, hasEntries, "log not empty expectation not met (no entries in the log)");
        }
    }

    private final void completeOpen(long eofPointer, boolean writeEof) throws IOException {
        this.file.seek(eofPointer);
        if (writeEof) {
            this.writeEof();
        }
        this.logSize = this.file.getFilePointer() - (long)this.preamble.getSerializedLength();
    }

    private final MappedByteBuffer mapFileAt(long position, int bytesNeeded) throws EPktException {
        long ts = System.nanoTime();
        FileChannel.MapMode mode = null;
        long bytesRemaining = -1L;
        int bytesToMap = -1;
        try {
            mode = this.openMode == FileOpenMode.r ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            bytesRemaining = this.file.length() - position;
            bytesToMap = Math.max(Math.max((int)Math.min(Integer.MAX_VALUE, bytesRemaining), bytesNeeded), (int)Math.min(Integer.MAX_VALUE, this.initialLength));
            if ((long)bytesToMap > bytesRemaining) {
                long ts1 = System.nanoTime();
                this.file.setLength(this.file.length() + ((long)bytesToMap - bytesRemaining));
                if (this.tracer.debug) {
                    this.tracer.log("Extended recovery log length by " + ((long)bytesToMap - bytesRemaining) + " bytes (" + (System.nanoTime() - ts1) / 1000L + " us).", Tracer.Level.DEBUG);
                }
            }
            MappedByteBuffer ret = this.fileChannel.map(mode, position, bytesToMap);
            if (this.tracer.debug) {
                this.tracer.log("Mapped " + bytesToMap + " bytes of recovery log at pos=" + position + " to memory (" + (System.nanoTime() - ts) / 1000L + " us (includes file length increase time))", Tracer.Level.DEBUG);
            }
            return ret;
        }
        catch (IOException e) {
            throw new EPktException("I/O error while memory mapping the recovery log [" + e.toString() + " (" + mode + "," + position + "," + bytesRemaining + ")]", e);
        }
    }

    private final void prepareMappedFileBufferForFlush(int bytesToFlush) {
        if (bytesToFlush > this.mappedFileBuffer.remaining()) {
            this.mappedFileBuffer = this.mapFileAt(this.logFlushPointer, bytesToFlush + this.eofLength);
            if (bytesToFlush > this.mappedFileBuffer.remaining()) {
                throw new EPktException("no more space in file");
            }
            if (this.autoFlushSize <= 0) {
                this.serializeContext.dropBuffers().addBuffer(IOBuffer.wrap((ByteBuffer)this.mappedFileBuffer));
            }
        }
    }

    private final IOBuffer createWriteBuffer(int length) {
        return nativeFileIOEnabled ? IOBuffer.createNative((int)length) : IOBuffer.create((int)length, (boolean)true);
    }

    public boolean isFlushUsingMappedMemory() {
        return this.flushUsingMappedMemory;
    }

    public final int getAutoFlushSize() {
        return this.autoFlushSize;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final long getInitialLength() {
        return this.initialLength;
    }

    public final boolean isZeroOutInitial() {
        return this.zeroOutInitial;
    }

    public final String getDirname() {
        return this.dirname;
    }

    public final String getFilename() {
        return this.filenameOnly;
    }

    public final void shrinkToSize() throws IOException {
        if (this.eof != null) {
            if (this.tracer.debug) {
                this.tracer.log("Shrinking log '" + this.filename + "' to size.", Tracer.Level.DEBUG);
            }
        } else {
            throw new IllegalStateException("Can't shrink a closed log");
        }
        this.file.setLength(this.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(int flags, long startingPos, ILogIntegrityChecker logIntegrityChecker) throws EPktException {
        try {
            this.checkpointState = PktFactory.getInstance().createPacket(261);
            ((PktBodyRecoveryLogCheckpointState)this.checkpointState.getBody()).setState(CheckpointState.DONE.toString());
        }
        catch (Exception e) {
            throw new EPktException("Failed to create checkpoint state packet for recovery log [" + e.toString() + "]");
        }
        this.supportTailing = (flags & 0x80) == 128;
        boolean skipIntegrityCheck = this.openMode == FileOpenMode.r && (flags & 0x100) == 256;
        boolean autoRepair = (flags & 2) == 2;
        this.prepareEOFMarker();
        try {
            String mode;
            boolean logfileExists = new File(this.filename).exists();
            this.checkLogPresenceExpectations(flags, logfileExists);
            File dir = new File(this.dirname);
            if (!dir.exists()) {
                if (this.tracer.debug) {
                    this.tracer.log("Creating recovery log directory '" + this.dirname + "'", Tracer.Level.DEBUG);
                }
                if (!dir.mkdirs()) {
                    throw new EPktException("Failed to create recovery log directory '" + this.dirname + "'");
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Directory already exists.", Tracer.Level.DEBUG);
            }
            switch (this.openMode) {
                case r: {
                    mode = "r";
                    break;
                }
                case rw: {
                    mode = "rw";
                    break;
                }
                case rws: {
                    mode = "rws";
                    break;
                }
                case rwd: {
                    mode = "rwd";
                    break;
                }
                default: {
                    throw new EPktException("Unsupported file open mode '" + (Object)((Object)this.openMode) + "'");
                }
            }
            if (this.tracer.debug) {
                this.tracer.log("Opening recovery log '" + this.filename + "' using open mode='" + mode + "' (supportTailing = " + this.supportTailing + ")", Tracer.Level.DEBUG);
                if ((flags & 0x20) == 32) {
                    this.tracer.log("...emptiness expectation is 'Not Empty'", Tracer.Level.DEBUG);
                } else if ((flags & 4) == 4) {
                    this.tracer.log("...emptiness expectation is 'Empty'", Tracer.Level.DEBUG);
                } else {
                    this.tracer.log("...emptiness expectation is 'No Expectation'", Tracer.Level.DEBUG);
                }
            }
            this.file = new RandomAccessFile(this.filename, mode);
            this.fileChannel = this.file.getChannel();
            if (nativeFileIOEnabled) {
                try {
                    FileDescriptor fileDescriptor = this.file.getFD();
                    Field field = fileDescriptor.getClass().getDeclaredField("fd");
                    if (field != null) {
                        field.setAccessible(true);
                        Integer fd = (Integer)field.get(fileDescriptor);
                        if (fd != null) {
                            this.nfile = UtlFile.nativeWrap((int)fd);
                            this.tracer.log("...successfully configured to use native file IO (fd = " + fd + ")", Tracer.Level.DEBUG);
                        }
                        this.nfile = -1L;
                        this.tracer.log("...native file IO enabled but could not obtain value for 'fd' field", Tracer.Level.DEBUG);
                    }
                    this.nfile = -1L;
                    this.tracer.log("...native file IO enabled but could not find field named 'fd' in file descriptor class", Tracer.Level.DEBUG);
                }
                catch (Exception e) {
                    throw new EPktException(e);
                }
            } else {
                this.nfile = -1L;
                this.tracer.log("...cannot use native file IO [native file IO not enabled]", Tracer.Level.CONFIG);
            }
            if (!logfileExists) {
                if (this.openMode == FileOpenMode.r) {
                    throw new EPktLogInvalidException("no preamble");
                }
                this.checkLogEmptinessExpectations(flags, false);
                if (this.tracer.debug) {
                    this.tracer.log("Creating new recovery log...", Tracer.Level.DEBUG);
                }
                try {
                    long ts = System.currentTimeMillis();
                    if (this.zeroOutInitial) {
                        byte[] data = new byte[this.pageSize];
                        long numBlocks = this.initialLength / (long)this.pageSize;
                        if (this.tracer.debug) {
                            this.tracer.log("Preallocating log by zeroing out (" + numBlocks + " blocks, " + data.length + " bytes each)...", Tracer.Level.DEBUG);
                        }
                        int i = 0;
                        while ((long)i < numBlocks) {
                            this.file.write(data, 0, data.length);
                            ++i;
                        }
                        this.file.getFD().sync();
                    } else {
                        if (this.tracer.debug) {
                            this.tracer.log("Preallocating log by setting length to " + this.initialLength + ".", Tracer.Level.DEBUG);
                        }
                        this.file.setLength(this.initialLength);
                    }
                    this.tracer.log("Log creation (length=" + this.initialLength + ", mode=" + (this.zeroOutInitial ? "zeroOut" : "setLength") + ") took " + (System.currentTimeMillis() - ts) + " milliseconds.", Tracer.Level.INFO);
                    this.file.seek(0L);
                    this.preamble = new Preamble(1);
                    this.preamble.write(this.file);
                    this.writeEof();
                }
                catch (IOException e) {
                    throw new EPktException("Recovery log '" + this.filename + "' init failure [" + e.toString() + "]");
                }
                if (this.tracer.debug) {
                    this.tracer.log("Recovery log created <initialLength=" + this.initialLength + " preamble=" + this.preamble + ">", Tracer.Level.DEBUG);
                }
            } else {
                long ts = System.currentTimeMillis();
                byte formatVersion = this.file.readByte();
                if (formatVersion == 1) {
                    this.preamble = new Preamble(formatVersion);
                    this.preamble.read(this.file);
                    if (!skipIntegrityCheck) {
                        int numValidEntries;
                        boolean skippedValidatedEntries;
                        block63: {
                            IntegrityCheckPacketHandler packetHandler = new IntegrityCheckPacketHandler(logIntegrityChecker);
                            MemoryMappedReader reader = new MemoryMappedReader(this.filename, packetHandler, null, this.supportTailing ? 50 : 0, this.tracer);
                            if (!autoRepair || (flags & 0x40) == 64) {
                                reader.setPacketBodyDesyncDisabled(true);
                            }
                            skippedValidatedEntries = false;
                            try {
                                MemoryMappedReader.ReadCompletionReason readCompletionReason;
                                if (this.file.length() == (long)this.preamble.getSerializedLength()) {
                                    throw new EPktLogCorruptException("EOF but no EOF marker");
                                }
                                if (startingPos >= 0L && !autoRepair) {
                                    if (!reader.isValidAt(startingPos)) {
                                        reader.reset();
                                        this.tracer.log("Unable to open log from specified starting position: " + startingPos + ", attempt to start from begining instead", Tracer.Level.WARNING);
                                    } else {
                                        boolean bl = skippedValidatedEntries = startingPos > (long)this.preamble.getSerializedLength();
                                    }
                                }
                                if ((readCompletionReason = reader.read()) != MemoryMappedReader.ReadCompletionReason.EndOfFile) {
                                    throw new InternalError("read completed with an unexpected completion code '" + (Object)((Object)readCompletionReason) + "'");
                                }
                                packetHandler.done();
                                this.completeOpen(reader.filePointer(), false);
                                numValidEntries = packetHandler.numValidEntries();
                                this.checkLogEmptinessExpectations(flags, numValidEntries > 0 || skippedValidatedEntries);
                                this.tracer.log("Log open (size=" + this.logSize + ", entries=" + (skippedValidatedEntries ? ">" : "") + numValidEntries + ") took " + (System.currentTimeMillis() - ts) + " milliseconds.", Tracer.Level.INFO);
                            }
                            catch (EPktLogCorruptException e) {
                                numValidEntries = packetHandler.numValidEntries();
                                long recoverableFileLength = packetHandler.validatedFileLength();
                                this.tracer.log("***** Log '" + this.filename + "' is corrupt [" + e.toString() + "].", Tracer.Level.WARNING);
                                this.tracer.log("***** ...[preamble=" + this.preamble + ", recoverableEntries=" + (skippedValidatedEntries ? ">" : "") + numValidEntries + ", recoverableLength=" + recoverableFileLength + "]", Tracer.Level.WARNING);
                                if (autoRepair) {
                                    this.tracer.log("***** ...auto-repairing and continuing...", Tracer.Level.WARNING);
                                    String backedUpFilename = PktRecoveryLog.backup(this.dirname, this.filenameOnly, false, false, false);
                                    this.tracer.log("***** ...corrupt file backed up to '" + backedUpFilename + "'...", Tracer.Level.WARNING);
                                    this.completeOpen(recoverableFileLength, true);
                                    this.tracer.log("***** ...recovered " + numValidEntries + " entries.", Tracer.Level.WARNING);
                                    this.wasRepaired = true;
                                    this.checkLogEmptinessExpectations(flags, numValidEntries > 0);
                                    break block63;
                                }
                                throw e;
                            }
                            finally {
                                reader.close();
                            }
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Loaded recovery log from disk <preamble=" + this.preamble + ", numEntries=" + (skippedValidatedEntries ? ">" : "") + numValidEntries + ", fp=" + this.file.getFilePointer() + ">", Tracer.Level.DEBUG);
                        }
                    } else {
                        this.logSize = -1L;
                        if (this.tracer.fine) {
                            this.tracer.log("Log '" + this.filename + "' open with integrity checks bypassed.", Tracer.Level.FINE);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Opened recovery log for pure read (EOF not validated)", Tracer.Level.DEBUG);
                        }
                    }
                } else {
                    throw new EPktLogInvalidException("unsupported version [exp=1 actual=" + formatVersion + "]");
                }
            }
            if (!skipIntegrityCheck && this.openMode != FileOpenMode.r) {
                MappedByteBuffer mappedByteBuffer;
                if (this.flushUsingMappedMemory) {
                    this.logFlushPointer = this.file.getFilePointer();
                    mappedByteBuffer = this.mapFileAt(this.logFlushPointer, 0);
                } else {
                    mappedByteBuffer = null;
                }
                this.mappedFileBuffer = mappedByteBuffer;
                this.serializeContext = PktSerializable.SerializeContext.create();
                this.serializeContext.addBuffer(this.flushUsingMappedMemory && this.autoFlushSize <= 0 ? IOBuffer.wrap((ByteBuffer)this.mappedFileBuffer) : this.createWriteBuffer(Math.max(this.autoFlushSize, 8192)));
                this.serializeContext.setPolicy(0);
            }
        }
        catch (FileNotFoundException e) {
            throw new EPktLogNotFoundException(this.filename);
        }
        catch (IOException e) {
            throw new EPktException("I/O error during recovery log open [" + e.toString() + "]");
        }
        this.numDirtyBytes = 0;
        try {
            this.fileForStats = new RandomAccessFile(this.filename, "r");
        }
        catch (Throwable thrown) {
            this.tracer.log("Unable to open file '" + this.filename + "' for stats [" + thrown.getMessage() + "]", Tracer.Level.WARNING);
        }
    }

    public final void open(int flags, long startingPos) throws EPktException {
        this.open(flags, startingPos, null);
    }

    public final void open() throws EPktException {
        this.open(0, -1L);
    }

    public final void open(int flags) throws EPktException {
        this.open(flags, -1L);
    }

    public final Reader createReader() throws IOException {
        if (this.tracer.debug) {
            this.tracer.log("Opening private reader for '" + this.filename + "' (supportTailing=" + this.supportTailing + ")", Tracer.Level.DEBUG);
        }
        return new Reader(this.filename, this.supportTailing ? 50 : 0, this.pageSize, this.tracer);
    }

    public final MemoryMappedReader createMemoryMappedReader(IPacketBufferReceiver receiver) throws IOException {
        if (this.tracer.debug) {
            this.tracer.log("Opening private memory mapped reader for '" + this.filename + "' (supportTailing=" + this.supportTailing + ")", Tracer.Level.DEBUG);
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        return new MemoryMappedReader(this.filename, receiver, this.supportTailing ? 50 : 0, this.tracer);
    }

    public final MemoryMappedReader createMemoryMappedReader(IPacketReceiver receiver) throws IOException {
        if (this.tracer.debug) {
            this.tracer.log("Opening private memory mapped reader for '" + this.filename + "' (supportTailing=" + this.supportTailing + ")", Tracer.Level.DEBUG);
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        return new MemoryMappedReader(this.filename, receiver, this.supportTailing ? 50 : 0, this.tracer);
    }

    public final boolean wasRepaired() {
        if (this.file == null) {
            throw new IllegalStateException("log not opened");
        }
        return this.wasRepaired;
    }

    public final boolean supportsTailing() {
        return this.supportTailing;
    }

    public final long getCheckpointCount() {
        return this.preamble.checkpointCount;
    }

    public final long getSize() {
        return this.logSize + (long)this.preamble.getSerializedLength() + (long)this.eofLength;
    }

    public final long getAllocatedSize() {
        RandomAccessFile currentFile = this.fileForStats;
        if (currentFile == null || !currentFile.getChannel().isOpen()) {
            return 0L;
        }
        try {
            return currentFile.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public final long getNextWritePointer() {
        return this.logSize + (long)this.preamble.getSerializedLength();
    }

    public final void write(PktPacket packet, int flags) throws EPktException {
        if (this.tracer.debug) {
            this.tracer.log("Writing " + (Object)((Object)packet.getHeader()) + " to recovery log...", Tracer.Level.DEBUG);
        }
        int serializedLength = packet.getSerializedLength();
        FilePosition position = (FilePosition)packet.getTag(4);
        if (position == null) {
            position = new FilePosition();
            packet.setTag(4, position);
        }
        position.setPosition(this.logSize + (long)this.preamble.getSerializedLength());
        position.setSize(serializedLength);
        if (this.autoFlushSize > 0 || !this.flushUsingMappedMemory) {
            long bufferedAfter;
            long bufferedBefore = enableSerializationChecks ? this.serializeContext.getBuffered() : 0L;
            packet.serialize(this.serializeContext.setSerializeWithoutMagic(this.supportTailing && this.numDirtyBytes == 0), null);
            this.numDirtyBytes += serializedLength;
            long l = bufferedAfter = enableSerializationChecks ? this.serializeContext.getBuffered() : 0L;
            if (enableSerializationChecks) {
                if (bufferedAfter - bufferedBefore != (long)serializedLength) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Bytes buffered for packet(" + (bufferedAfter - bufferedBefore) + ") does not match serialized packet length (" + serializedLength + ")!\n");
                    sb.append("  Packet:").append((Object)packet).append("\n");
                    this.serializeContext.dump("  ", sb);
                    throw new EPktException(sb.toString());
                }
                if (bufferedAfter != (long)this.numDirtyBytes) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Bytes buffered (" + bufferedAfter + ") does not match serialized packets length (" + this.numDirtyBytes + ")!\n");
                    sb.append("  Packet:").append((Object)packet).append("\n");
                    this.serializeContext.dump("  ", sb);
                    throw new EPktException(sb.toString());
                }
            }
            if (this.tracer.debug) {
                this.tracer.log("Serialize complete [numSerializedBytes=" + serializedLength + ", numDirtyBytes=" + this.numDirtyBytes + "]", Tracer.Level.DEBUG);
            }
            if (this.numDirtyBytes >= this.autoFlushSize) {
                if (this.tracer.debug) {
                    this.tracer.log("Auto flush size (" + this.autoFlushSize + ") exceeded. Flushing...", Tracer.Level.DEBUG);
                }
                this.flush(flags);
                if (enableWriteChecks && !this.flushUsingMappedMemory) {
                    try {
                        if (this.file.getFilePointer() != position.getPosition() + (long)position.getSize()) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Unexpected file pointer after flush: " + this.file.getFilePointer() + " but expected " + (position.getPosition() + (long)position.getSize()) + "!\n");
                            sb.append("POSSIBLE LOG CORRUPTION\n");
                            sb.append("  Packet:").append((Object)packet).append("\n");
                            this.serializeContext.dump("  ", sb);
                            throw new EPktException(sb.toString());
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            this.prepareMappedFileBufferForFlush(serializedLength + this.eofLength);
            packet.serialize(this.serializeContext.setSerializeWithoutMagic(this.supportTailing), null);
            this.logFlushPointer += (long)serializedLength;
            if (this.tracer.debug) {
                this.tracer.log("Write complete [numSerializedBytes=" + serializedLength + ", numDirtyBytes=" + this.numDirtyBytes + "]", Tracer.Level.DEBUG);
            }
            UtlBuffer.copy((ByteBuffer)this.eof.getBufferUnsafe(), (int)0, (ByteBuffer)this.mappedFileBuffer, (int)this.mappedFileBuffer.position(), (int)this.eofLength);
            if (this.supportTailing) {
                PktHeader.restoreClearedMagic(this.mappedFileBuffer, this.mappedFileBuffer.position() - serializedLength);
            }
        }
        this.logSize += (long)serializedLength;
    }

    public final void setCheckpointState(CheckpointState state) throws EPktException {
        if (state == CheckpointState.DONE) {
            if (this.tracer.debug) {
                this.tracer.log("Truncating recovery log...", Tracer.Level.DEBUG);
            }
            try {
                ++this.preamble.checkpointCount;
                this.file.seek(0L);
                this.preamble.write(this.file);
                this.writeEof();
            }
            catch (IOException e) {
                throw new EPktException("Recovery log truncate failure [" + e.toString() + "]");
            }
            this.numDirtyBytes = 0;
            this.logSize = 0L;
            if (this.tracer.debug) {
                this.tracer.log("  Done <preamble=" + this.preamble + ">.", Tracer.Level.DEBUG);
            }
        } else {
            ((PktBodyRecoveryLogCheckpointState)this.checkpointState.getBody()).setState(state.toString());
            this.write(this.checkpointState, 1);
            this.flush(1);
        }
    }

    public final CheckpointState getCheckpointState() {
        return CheckpointState.valueOf(((PktBodyRecoveryLogCheckpointState)this.checkpointState.getBody()).getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void flush(int flags) throws EPktException {
        if (this.tracer.debug) {
            this.tracer.log("Flushing recovery log to disk...", Tracer.Level.DEBUG);
        }
        try {
            block33: {
                if (this.numDirtyBytes > 0) {
                    try {
                        if (this.flushUsingMappedMemory) {
                            int bytesToFlush;
                            this.prepareMappedFileBufferForFlush(this.numDirtyBytes + this.eofLength);
                            ByteBuffer[] buffers = this.serializeContext.flipBuffers().getByteBuffers();
                            int bufferCount = this.serializeContext.getBufferCount();
                            if (this.tracer.debug) {
                                this.tracer.log("Flushing to file [numBuffers=" + bufferCount + ", filePos=" + this.logFlushPointer + ", bufferPos=" + this.mappedFileBuffer.position() + "]...", Tracer.Level.DEBUG);
                            }
                            long totalFlushed = 0L;
                            for (int i = 0; i < bufferCount; this.logFlushPointer += (long)bytesToFlush, totalFlushed += (long)bytesToFlush, ++i) {
                                bytesToFlush = buffers[i].remaining();
                                UtlBuffer.copy((ByteBuffer)buffers[i], (int)buffers[i].position(), (ByteBuffer)this.mappedFileBuffer, (int)this.mappedFileBuffer.position(), (int)bytesToFlush);
                                buffers[i].position(buffers[i].position() + bytesToFlush);
                                this.mappedFileBuffer.position(this.mappedFileBuffer.position() + bytesToFlush);
                            }
                            if (totalFlushed != (long)this.numDirtyBytes) {
                                throw new IOException("failed to persist full data block (expected=" + this.numDirtyBytes + " bytes, actual=" + totalFlushed + " bytes) (out of disk space?)");
                            }
                            if (this.tracer.debug) {
                                this.tracer.log(totalFlushed + " bytes flushed.", Tracer.Level.DEBUG);
                            }
                            UtlBuffer.copy((ByteBuffer)this.eof.getBufferUnsafe(), (int)0, (ByteBuffer)this.mappedFileBuffer, (int)this.mappedFileBuffer.position(), (int)this.eofLength);
                            if (this.supportTailing) {
                                if (this.tracer.debug) {
                                    this.tracer.log("Restoring magic at pos=" + (this.mappedFileBuffer.position() - this.numDirtyBytes) + "...", Tracer.Level.DEBUG);
                                }
                                PktHeader.restoreClearedMagic(this.mappedFileBuffer, this.mappedFileBuffer.position() - this.numDirtyBytes);
                            }
                            if (this.tracer.debug) {
                                this.tracer.log("Flush complete [numBuffers=" + bufferCount + ", filePos=" + this.logFlushPointer + ", bufferPos=" + this.mappedFileBuffer.position() + "]...", Tracer.Level.DEBUG);
                            }
                            break block33;
                        }
                        long totalToWrite = this.serializeContext.flipBuffers().addBuffer(this.eof).getRemaining();
                        try {
                            long totalWritten;
                            if (totalToWrite != (long)(this.numDirtyBytes + this.eofLength)) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("Bytes prepared for write does not match expected length (expected=" + this.numDirtyBytes + " bytes, actual=" + totalToWrite + " bytes) (packet buffer corruption?)\n");
                                this.serializeContext.dump("  ", sb);
                                throw new EPktException(sb.toString());
                            }
                            long fpBefore = this.file.getFilePointer();
                            ByteBuffer[] buffers = this.serializeContext.getByteBuffers();
                            int bufferCount = this.serializeContext.getBufferCount();
                            if (this.tracer.debug) {
                                this.tracer.log("Flushing " + bufferCount + " buffers to file at pos=" + this.file.getFilePointer() + "...", Tracer.Level.DEBUG);
                            }
                            long l = totalWritten = this.nfile >= 0L ? UtlFile.nativeWrite((long)this.nfile, (ByteBuffer[])buffers, (int)bufferCount) : this.fileChannel.write(buffers, 0, bufferCount);
                            if (totalWritten != totalToWrite) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("failed to persist full data block (expected=" + totalToWrite + " bytes, actual=" + totalWritten + " bytes) (out of disk space?)\n");
                                this.serializeContext.dump("  ", sb);
                                throw new IOException(sb.toString());
                            }
                            long fpAfter = this.file.getFilePointer();
                            if (fpAfter - fpBefore != totalWritten) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("Unexpected file pointer (" + this.file.getFilePointer() + ") after " + (this.nfile >= 0L ? "(native)" : "") + " flush of " + totalWritten + " bytes. Expected " + (fpBefore + totalWritten) + " but is " + this.file.getFilePointer() + " (off by " + (fpAfter - fpBefore + totalWritten) + ")!\n");
                                this.serializeContext.dump("  ", sb);
                                throw new IOException(sb.toString());
                            }
                            if (this.tracer.debug) {
                                this.tracer.log(totalWritten + " bytes flushed.", Tracer.Level.DEBUG);
                            }
                            long justBeforeEofFp = this.file.getFilePointer() - (long)this.eofLength;
                            if (this.supportTailing) {
                                long totalMagicWritten;
                                this.file.seek(this.file.getFilePointer() - totalWritten);
                                if (this.tracer.debug) {
                                    this.tracer.log("Restoring magic at pos=" + this.file.getFilePointer() + "...", Tracer.Level.DEBUG);
                                }
                                buffers[0].position(0);
                                buffers[0].limit(3);
                                PktHeader.restoreClearedMagic(buffers[0], 0);
                                long l2 = totalMagicWritten = this.nfile >= 0L ? UtlFile.nativeWrite((long)this.nfile, (ByteBuffer[])buffers, (int)1) : this.fileChannel.write(buffers, 0, 1);
                                if (totalMagicWritten != 3L) {
                                    throw new IOException("failed to persist full data block (expected=3 bytes, actual=" + totalMagicWritten + " bytes) (out of disk space?)");
                                }
                                if (this.tracer.debug) {
                                    this.tracer.log(totalMagicWritten + " magic bytes flushed.", Tracer.Level.DEBUG);
                                }
                            }
                            this.file.seek(justBeforeEofFp);
                            if (this.tracer.debug) {
                                this.tracer.log("Flush complete [numBuffers=" + bufferCount + ", pos=" + this.file.getFilePointer() + "]...", Tracer.Level.DEBUG);
                            }
                            break block33;
                        }
                        finally {
                            this.serializeContext.dropLastBuffer();
                        }
                    }
                    finally {
                        this.serializeContext.compactBuffers().setBufferCount(1);
                        this.numDirtyBytes = 0;
                    }
                }
                if (this.tracer.debug) {
                    this.tracer.log("Nothing to flush.", Tracer.Level.DEBUG);
                }
            }
            if ((flags & 1) != 1) {
                if (!this.tracer.debug) return;
                this.tracer.log("Not force sync to file...", Tracer.Level.DEBUG);
                return;
            }
            if (this.tracer.debug) {
                this.tracer.log("Force sync to file...", Tracer.Level.DEBUG);
            }
            if (this.flushUsingMappedMemory) {
                if (this.mappedFileBuffer == null) return;
                this.mappedFileBuffer.force();
                return;
            }
            this.file.getFD().sync();
            return;
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("FATAL ERROR: Log write/sync faulted with error [" + e.toString() + "].\n");
            sb.append("Stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            if (e instanceof IOException) {
                sb.append("**** LOG CORRUPTION MAY HAVE OCCURRED ****\n");
            }
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
            throw new EPktException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close() throws EPktException {
        if (this.file != null) {
            try {
                this.flush(1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.file != null) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Closing recovery log file...", Tracer.Level.DEBUG);
                }
                this.file.close();
                this.file = null;
            }
            catch (IOException e) {
                throw new EPktException("Recovery log file close failure [" + e.toString() + "]");
            }
            finally {
                if (this.nfile >= 0L) {
                    UtlFile.nativeDestroy((long)this.nfile);
                }
                if (this.fileForStats != null) {
                    try {
                        this.fileForStats.close();
                    }
                    catch (IOException e) {
                        this.tracer.log("Recovery log stats file instance close failure [" + e.toString() + "]", Tracer.Level.WARNING);
                    }
                    finally {
                        this.fileForStats = null;
                    }
                }
            }
        }
        if (this.mappedFileBuffer == null) return;
        try {
            UtlBuffer.releaseBuffer((ByteBuffer)this.mappedFileBuffer);
            return;
        }
        catch (RuntimeException re) {
            throw new EPktException("Recovery log file unmap failure [" + re.toString() + "]", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(Appendable w) throws IOException {
        try (Reader reader = this.createReader();){
            PktPacket packet = reader.next();
            long nextReadPos = -1L;
            boolean eof = false;
            try {
                while (packet != null) {
                    FilePosition fp = (FilePosition)packet.getTag(4);
                    if (fp != null) {
                        w.append("[fp:").append(String.valueOf(fp.getPosition())).append(", size:").append(String.valueOf(fp.getSize())).append("]");
                    }
                    PktFactory.PktType type = null;
                    try {
                        type = PktFactory.getInstance().getPacketType(packet.getBody().getType());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    w.append("[").append(String.valueOf(type)).append("]").append(packet.toString()).append("\n");
                    nextReadPos = fp.position + (long)fp.size;
                    packet = reader.readAt(nextReadPos);
                    if (packet != null) continue;
                    w.append("[EOF]\n");
                    eof = true;
                    packet = reader.readAt(nextReadPos + (long)this.eofLength);
                    eof = false;
                }
            }
            catch (EPktLogInvalidPositionException e) {
                if (eof) {
                    w.append("EOF reached ... no additional packets immediately after it.\n");
                } else {
                    w.append("Corrupted Packet detected: ").append(UtlThrowable.prepareStackTrace((Throwable)((Object)e))).append("\n");
                }
            }
            catch (EPktLogCorruptException e) {
                if (eof) {
                    w.append("EOF reached ... no additional packets immediately after it.\n");
                }
                w.append("Corrupted Packet detected: ").append(UtlThrowable.prepareStackTrace((Throwable)((Object)e))).append("\n");
            }
            w.append("Read ").append(String.valueOf(nextReadPos)).append("/").append(String.valueOf(reader.file.length())).append(" bytes worth of packets from log.\n");
            if (nextReadPos < reader.file.length()) {
                ByteBuffer buffer = ByteBuffer.allocate(1024);
                int read = reader.file.getChannel().read(buffer, nextReadPos);
                buffer.flip();
                w.append("First ").append(String.valueOf(read)).append(" bytes after last packet:").append(UtlBuffer.dump((String)"", (ByteBuffer)buffer, (int)0, (int)read)).append("\n");
            }
        }
    }

    public static interface ILogIntegrityChecker {
        public void init(long var1);

        public void onPacket(QuarkBuffer var1, int var2, int var3, long var4);

        public void done();

        public boolean corruptionDetected();

        public int numValidEntries();

        public long validatedFileLength();
    }

    public static interface IPacketReceiver {
        public void onPacket(PktPacket var1);
    }

    public static interface IPacketBufferReceiver {
        public void onPacket(QuarkBuffer var1, int var2, int var3, long var4);

        public void onBufferChange(QuarkBuffer var1, QuarkBuffer var2);
    }

    public static final class Reader {
        private final Tracer tracer;
        private final String filename;
        private final int pageSize;
        private final int maxReadFailsForCorruption;
        private final RandomAccessFile file;
        private final FileChannel fileChannel;
        private final PktSerializable.DeserializeContext deserializeContext;
        private final Marker marker;
        private final ReadContext readContext;
        private ReadContext readOneContext;

        Reader(String filename, int maxReadFailsForCorruption, int pageSize, Tracer tracer) throws IOException {
            this.filename = filename;
            this.tracer = tracer;
            this.pageSize = pageSize;
            this.maxReadFailsForCorruption = maxReadFailsForCorruption;
            this.file = new RandomAccessFile(filename, "r");
            this.fileChannel = this.file.getChannel();
            this.deserializeContext = PktSerializable.DeserializeContext.create();
            this.deserializeContext.setPolicy(1);
            this.marker = new Marker();
            this.readContext = new ReadContext(pageSize);
            this.reset();
        }

        private final void waitForMoreDataToBeWritten() {
            if (this.tracer.debug) {
                this.tracer.log("  ...assuming log data is partial. Waiting for more data to arrive in log...", Tracer.Level.DEBUG);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log("  ...done waiting.", Tracer.Level.DEBUG);
                }
            }
        }

        private final void onReadFail(int numReadFails, Throwable e, String reason) {
            if (numReadFails > this.maxReadFailsForCorruption) {
                if (this.tracer.debug) {
                    if (this.maxReadFailsForCorruption > 0) {
                        this.tracer.log("  ...timed out waiting for partial data issue to resolve.", Tracer.Level.DEBUG);
                    } else {
                        this.tracer.log("  ...log is corrupt.", Tracer.Level.DEBUG);
                    }
                }
                if (e != null) {
                    throw new EPktLogCorruptException(e);
                }
                throw new EPktLogCorruptException(reason);
            }
            this.waitForMoreDataToBeWritten();
        }

        private final void tagPacketWithFilePositionAndSize(PktPacket packet, long packetFilePointer, int packetSize) {
            FilePosition position = (FilePosition)packet.getTag(4);
            if (position == null) {
                position = new FilePosition();
                packet.setTag(4, position);
            }
            position.setPosition(packetFilePointer);
            position.setSize(packetSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final Reader read(int maxToRead) throws IOException {
            numReadFails = 0;
            eofReached = false;
            this.readContext.init(this.file.getFilePointer());
            if (this.tracer.debug) {
                this.tracer.log("Reading from recovery log...", Tracer.Level.DEBUG);
            }
            try {
                block9: while (!eofReached && ReadContext.access$400(this.readContext).count() == 0) {
                    block27: {
                        buffer = ReadContext.access$800(this.readContext);
                        if (this.tracer.debug) {
                            this.tracer.log("  Reading " + this.readContext + "...", Tracer.Level.DEBUG);
                        }
                        if ((bytesRead = this.fileChannel.read(buffer)) <= 0) break block27;
                        if (this.tracer.debug) {
                            this.tracer.log("  Read " + bytesRead + " bytes " + this.readContext + ".", Tracer.Level.DEBUG);
                        }
                        buffer.flip();
                        this.deserializeContext.setBuffer(buffer);
                        if (this.tracer.debug) {
                            this.tracer.log("  Prepared buffer for deserialize " + this.readContext + ".", Tracer.Level.DEBUG);
                        }
                        ** GOTO lbl33
                    }
                    if (bytesRead == 0) {
                        throw new InternalError("Zero bytes read [buffer=" + buffer + "]!");
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("  Hit EOF with no EOF marker", Tracer.Level.DEBUG);
                    }
                    try {
                        this.onReadFail(++numReadFails, null, "EOF but no EOF marker");
                    }
                    catch (EPktLogCorruptException e) {
                        if (ReadContext.access$400(this.readContext).count() <= 0) {
                            throw e;
                        }
                        break;
lbl33:
                        // 1 sources

                        do {
                            this.deserializeContext.reset();
                            if (this.tracer.debug) {
                                this.tracer.log("  Deserializing...", Tracer.Level.DEBUG);
                            }
                            packet = null;
                            try {
                                packet = PktFactory.getInstance().createPacket(this.deserializeContext, null);
                            }
                            catch (Throwable e) {
                                packetBufferPos = buffer.position();
                                packetBufferLimit = buffer.limit();
                                try {
                                    if (this.tracer.debug) {
                                        this.tracer.log("  LOG READ ERROR [Deserialization failed]", Tracer.Level.DEBUG);
                                    }
                                    this.readContext.rollback();
                                    this.onReadFail(++numReadFails, e, null);
                                    if (!this.tracer.debug) continue block9;
                                    this.tracer.log("  ...buffer prepared for next read " + this.readContext + ".", Tracer.Level.DEBUG);
                                    continue block9;
                                }
                                catch (EPktLogCorruptException e1) {
                                    if (ReadContext.access$400(this.readContext).count() <= 0) {
                                        PktSerializable.DeserializeContext.dumpCorruptedPacketBuffer("Corrupted packet in file '" + this.filename + "' at offset " + ReadContext.access$900(this.readContext), buffer, packetBufferPos, packetBufferLimit, e, this.tracer);
                                        throw e1;
                                    }
                                    if (!this.tracer.debug) continue block9;
                                    this.tracer.log("  ..." + ReadContext.access$400(this.readContext).count() + " packets have been succesfully read before the error. dispatching those...", Tracer.Level.DEBUG);
                                    continue block9;
                                }
                            }
                            if (packet != null) {
                                packetSize = this.deserializeContext.getNumBytes();
                                if (this.tracer.debug) {
                                    this.tracer.log("  Deserialized full packet of size = " + packetSize + " bytes (type=" + packet.getBody().getType() + ")" + this.readContext + ".", Tracer.Level.DEBUG);
                                }
                                if (eofReached = packet.getBody().getType() == 262) {
                                    this.readContext.rollback();
                                    if (!this.tracer.debug) continue;
                                    this.tracer.log("  EOF reached " + this.readContext + ".", Tracer.Level.DEBUG);
                                    continue;
                                }
                                this.tagPacketWithFilePositionAndSize(packet, ReadContext.access$900(this.readContext), packetSize);
                                this.readContext.commit(packet, packetSize);
                                if (!this.tracer.debug) continue;
                                this.tracer.log("  EOF not reached " + this.readContext + ".", Tracer.Level.DEBUG);
                                continue;
                            }
                            numCurrentPacketBytesInBuffer = ReadContext.access$800(this.readContext).remaining();
                            numAdditionalBytesNeededForCurrentPacket = this.deserializeContext.getNumBytes();
                            minBytesNeeded = numCurrentPacketBytesInBuffer + numAdditionalBytesNeededForCurrentPacket;
                            if (this.tracer.debug) {
                                this.tracer.log("  Deserialized partial packet (addtnl=" + numAdditionalBytesNeededForCurrentPacket + ") " + this.readContext + ".", Tracer.Level.DEBUG);
                            }
                            this.readContext.compact(minBytesNeeded);
                            continue block9;
                        } while (!eofReached && ReadContext.access$400(this.readContext).count() < maxToRead);
                    }
                }
            }
            finally {
                this.readContext.rollback();
            }
            if (this.tracer.debug) {
                this.tracer.log("Done " + this.readContext + ".", Tracer.Level.DEBUG);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final PktPacket readOne(long filePointer) throws IOException {
            block27: {
                block26: {
                    packet = null;
                    numReadFails = 0;
                    eofReached = false;
                    if (this.readOneContext == null) {
                        this.readOneContext = new ReadContext(this.pageSize);
                    }
                    currentFilePointer = this.file.getFilePointer();
                    this.readOneContext.init(filePointer);
                    if (this.tracer.debug) {
                        this.tracer.log("Reading from recovery log...", Tracer.Level.DEBUG);
                    }
                    this.file.seek(filePointer);
                    while (true) {
                        if (eofReached || ReadContext.access$400(this.readOneContext).count() != 0) break block26;
                        buffer = ReadContext.access$800(this.readOneContext);
                        if (this.tracer.debug) {
                            this.tracer.log("  Reading " + this.readOneContext + "...", Tracer.Level.DEBUG);
                        }
                        if ((bytesRead = this.fileChannel.read(buffer)) > 0) {
                            if (this.tracer.debug) {
                                this.tracer.log("  Read " + bytesRead + " bytes " + this.readOneContext + ".", Tracer.Level.DEBUG);
                            }
                            buffer.flip();
                            this.deserializeContext.setBuffer(buffer);
                            if (this.tracer.debug) {
                                this.tracer.log("  Prepared buffer for deserialize " + this.readOneContext + ".", Tracer.Level.DEBUG);
                            }
                            break block27;
                        }
                        if (bytesRead == 0) {
                            throw new InternalError("Zero bytes read [buffer=" + buffer + "]!");
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("  Hit EOF with no EOF marker", Tracer.Level.DEBUG);
                        }
                        this.onReadFail(++numReadFails, null, "EOF but no EOF marker");
                        continue;
                        break;
                    }
                    finally {
                        this.file.seek(currentFilePointer);
                    }
                }
                if (this.tracer.debug) {
                    this.tracer.log("Done " + this.readOneContext + ".", Tracer.Level.DEBUG);
                }
                if (ReadContext.access$400((ReadContext)this.readOneContext).count == 0) {
                    return null;
                }
                packet = (PktPacket)ReadContext.access$400(this.readOneContext).first();
                if (packet != null) {
                    packet.unlink();
                }
                return packet;
            }
            do {
                this.deserializeContext.reset();
                if (this.tracer.debug) {
                    this.tracer.log("  Deserializing...", Tracer.Level.DEBUG);
                }
                packet = null;
                try {
                    packet = PktFactory.getInstance().createPacket(this.deserializeContext, null);
                }
                catch (Throwable e) {
                    packetBufferPos = buffer.position();
                    packetBufferLimit = buffer.limit();
                    try {
                        if (this.tracer.debug) {
                            this.tracer.log("  LOG READ ERROR [Deserialization failed]", Tracer.Level.DEBUG);
                        }
                        this.readOneContext.rollback();
                        this.onReadFail(++numReadFails, e, null);
                        if (!this.tracer.debug) ** GOTO lbl-1000
                        this.tracer.log("  ...buffer prepared for next read " + this.readOneContext + ".", Tracer.Level.DEBUG);
                        ** GOTO lbl-1000
                    }
                    catch (EPktLogCorruptException e1) {
                        PktSerializable.DeserializeContext.dumpCorruptedPacketBuffer("Corrupted packet in file '" + this.filename + "' at offset " + ReadContext.access$900(this.readOneContext), buffer, packetBufferPos, packetBufferLimit, e, this.tracer);
                        throw e1;
                    }
                }
                if (packet != null) {
                    packetSize = this.deserializeContext.getNumBytes();
                    if (this.tracer.debug) {
                        this.tracer.log("  Deserialized full packet of size = " + packetSize + " bytes (type=" + packet.getBody().getType() + ")" + this.readOneContext + ".", Tracer.Level.DEBUG);
                    }
                    if (eofReached = packet.getBody().getType() == 262) {
                        this.readOneContext.rollback();
                        if (!this.tracer.debug) continue;
                        this.tracer.log("  EOF reached " + this.readOneContext + ".", Tracer.Level.DEBUG);
                        continue;
                    }
                    this.tagPacketWithFilePositionAndSize(packet, ReadContext.access$900(this.readOneContext), packetSize);
                    this.readOneContext.commit(packet, packetSize);
                    if (!this.tracer.debug) continue;
                    this.tracer.log("  EOF not reached " + this.readOneContext + ".", Tracer.Level.DEBUG);
                    continue;
                }
                numCurrentPacketBytesInBuffer = ReadContext.access$800(this.readOneContext).remaining();
                numAdditionalBytesNeededForCurrentPacket = this.deserializeContext.getNumBytes();
                minBytesNeeded = numCurrentPacketBytesInBuffer + numAdditionalBytesNeededForCurrentPacket;
                if (this.tracer.debug) {
                    this.tracer.log("  Deserialized partial packet (addtnl=" + numAdditionalBytesNeededForCurrentPacket + ") " + this.readOneContext + ".", Tracer.Level.DEBUG);
                }
                this.readOneContext.compact(minBytesNeeded);
                ** GOTO lbl-1000
            } while (!eofReached && ReadContext.access$400(this.readOneContext).count() == 0);
            ** continue;
        }

        private final Reader read() throws IOException {
            return this.read(Integer.MAX_VALUE);
        }

        public final void setPacketBodyDesyncDisabled(boolean packetBodyDesyncDisabled) {
            this.deserializeContext.setPacketBodyDesyncDisabled(packetBodyDesyncDisabled);
        }

        public final boolean isPacketBodyDesyncDisabled() {
            return this.deserializeContext.isPacketBodyDesyncDisabled();
        }

        public final PktPacket readAt(long position) throws IOException {
            if (position >= this.file.length()) {
                throw new EPktLogInvalidPositionException("Invalid position [position " + position + " is greater than the file length]");
            }
            if (position < 0L) {
                throw new EPktLogInvalidPositionException("Invalid position [position " + position + " must be greater than 0]");
            }
            try {
                return this.readOne(position);
            }
            catch (EPktLogCorruptException e) {
                throw new EPktLogInvalidPositionException((Throwable)((Object)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final File dumpAt(FilePosition filePosition) throws IOException {
            File dumpFile = File.createTempFile("PktRecoveryLog", ".dump");
            try (PrintStream out = new PrintStream(new FileOutputStream(dumpFile));){
                out.println("Log dump for " + this.filename + " starting at position '" + filePosition.getPosition() + "' of size " + filePosition.getSize() + " bytes");
                this.marker.mark();
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(filePosition.getSize());
                    this.file.seek(filePosition.getPosition());
                    int bytesRead = this.fileChannel.read(buffer);
                    buffer.flip();
                    out.println(UtlBuffer.dump((String)("Log contents (read size= " + bytesRead + ")"), (ByteBuffer)buffer, (int)0, (int)bytesRead));
                }
                finally {
                    this.marker.restore();
                }
                out.flush();
                File file = dumpFile;
                return file;
            }
        }

        private final PktPacket unlink() {
            PktPacket packet = (PktPacket)this.readContext.validPackets.first();
            if (packet != null) {
                packet.unlink();
            }
            return packet;
        }

        public final PktPacket first() throws IOException {
            return this.reset().read().unlink();
        }

        public final PktPacket next() throws IOException {
            if (this.readContext.validPackets.count() == 0) {
                this.read();
            }
            return this.unlink();
        }

        public final void seek(long pos) throws IOException {
            this.marker.mark();
            try {
                this.file.seek(pos);
                this.read(1);
                this.marker.clear();
            }
            catch (IOException thrown) {
                this.marker.restore();
                throw thrown;
            }
        }

        public final Reader reset() throws IOException {
            PktPacket packet;
            while ((packet = this.unlink()) != null) {
                packet.dispose();
            }
            this.file.seek(9L);
            return this;
        }

        public final long filePointer() throws IOException {
            return this.file.getFilePointer();
        }

        @Deprecated
        public final long lastValidFilePointer() throws IOException {
            return this.filePointer();
        }

        public final void close() throws IOException {
            if (this.tracer.debug) {
                this.tracer.log("Closing reader for '" + this.filename + "'", Tracer.Level.DEBUG);
            }
            this.file.close();
        }

        private final class ReadContext {
            private ByteBuffer buffer;
            private long lastValidFilePointer;
            private final UtlList validPackets;

            ReadContext(int pageSize) {
                this.buffer = ByteBuffer.allocateDirect(pageSize);
                this.validPackets = UtlList.create();
            }

            final void init(long filePointer) {
                this.buffer.clear();
                this.lastValidFilePointer = filePointer;
            }

            final void commit(PktPacket packet, int packetSize) {
                this.validPackets.append((UtlListElement)packet);
                this.lastValidFilePointer += (long)packetSize;
            }

            final void rollback() throws IOException {
                Reader.this.file.seek(this.lastValidFilePointer);
                this.buffer.clear();
            }

            final void compact(int minBytesNeeded) {
                if (minBytesNeeded > this.buffer.capacity()) {
                    ByteBuffer old = this.buffer;
                    int newSize = ((old.remaining() + minBytesNeeded) / Reader.this.pageSize + 1) * Reader.this.pageSize;
                    this.buffer = ByteBuffer.allocateDirect(newSize);
                    this.buffer.put(old);
                    if (((Reader)Reader.this).tracer.debug) {
                        Reader.this.tracer.log("  Allocated a new buffer (buffer=" + this.buffer + ")", Tracer.Level.DEBUG);
                    }
                } else {
                    this.buffer.compact();
                }
            }

            public final String toString() {
                try {
                    return "[buf=" + this.buffer + ", fp=" + Reader.this.file.getFilePointer() + ", lvfp=" + this.lastValidFilePointer + "]";
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            static /* synthetic */ ByteBuffer access$800(ReadContext x0) {
                return x0.buffer;
            }

            static /* synthetic */ long access$900(ReadContext x0) {
                return x0.lastValidFilePointer;
            }
        }

        private final class Marker {
            private final UtlList currentValidPackets = UtlList.create();
            private long currentFilePointer;

            private Marker() {
            }

            final void mark() throws IOException {
                PktPacket packet;
                this.currentFilePointer = Reader.this.file.getFilePointer();
                while ((packet = Reader.this.unlink()) != null) {
                    this.currentValidPackets.append((UtlListElement)packet);
                }
            }

            final void restore() throws IOException {
                PktPacket packet;
                Reader.this.reset();
                while ((packet = (PktPacket)this.currentValidPackets.first()) != null) {
                    packet.unlink();
                    Reader.this.readContext.validPackets.append((UtlListElement)packet);
                }
                Reader.this.file.seek(this.currentFilePointer);
            }

            final void clear() {
                PktPacket packet;
                this.currentFilePointer = 0L;
                while ((packet = (PktPacket)this.currentValidPackets.first()) != null) {
                    packet.unlink();
                    packet.dispose();
                }
            }
        }
    }

    public static final class MemoryMappedReader {
        private final Tracer tracer;
        private final String filename;
        private final int maxReadFailsForCorruption;
        private final IPacketBufferReceiver packetBufferReceiver;
        private final IPacketReceiver packetReceiver;
        private final RandomAccessFile raf;
        private final FileChannel fileChannel;
        private final PktSerializable.DeserializeContext deserializeContext;
        private long filePointer;
        private QuarkBuffer buffer;
        private long bufferFilePointer;
        private int bufferLength;
        private int bufferPos;
        private volatile boolean running;
        private volatile boolean stopped;
        private volatile boolean closed;

        private MemoryMappedReader(String filename, IPacketBufferReceiver packetBufferReceiver, IPacketReceiver packetReceiver, int maxReadFailsForCorruption, Tracer tracer) {
            this.filename = filename;
            this.tracer = tracer;
            this.maxReadFailsForCorruption = maxReadFailsForCorruption;
            this.packetBufferReceiver = packetBufferReceiver;
            this.packetReceiver = packetReceiver;
            try {
                this.raf = new RandomAccessFile(filename, "r");
                this.fileChannel = this.raf.getChannel();
            }
            catch (FileNotFoundException e) {
                throw new InternalError("file '" + filename + "' reported not found");
            }
            this.deserializeContext = PktSerializable.DeserializeContext.create();
            this.deserializeContext.setPolicy(1);
            this.filePointer = 9L;
        }

        MemoryMappedReader(String filename, IPacketBufferReceiver receiver, int maxReadFailsForCorruption, Tracer tracer) {
            this(filename, receiver, null, maxReadFailsForCorruption, tracer);
        }

        MemoryMappedReader(String filename, IPacketReceiver receiver, int maxReadFailsForCorruption, Tracer tracer) {
            this(filename, null, receiver, maxReadFailsForCorruption, tracer);
        }

        private final void map(long position, long maxFilePointer, boolean forceRemap) throws IOException {
            long logSize = this.raf.length();
            if (this.tracer.debug) {
                this.tracer.log("Checking to map file at position=" + position + " [forceRemap=" + forceRemap + ", maxFilePointer=" + maxFilePointer + ", logSize=" + logSize + ", bufferFilePointer=" + this.bufferFilePointer + ", bufferLength=" + this.bufferLength + "]", Tracer.Level.DEBUG);
            }
            if (forceRemap || this.buffer == null || position < this.bufferFilePointer || position >= this.bufferFilePointer + (long)this.bufferLength) {
                int bytesToMap = (int)Math.min(Math.min(logSize, maxFilePointer) - position, Integer.MAX_VALUE);
                this.bufferFilePointer = position;
                this.bufferLength = bytesToMap;
                MappedByteBuffer mapBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.bufferFilePointer, this.bufferLength);
                QuarkBuffer oldBuffer = this.buffer;
                this.buffer = QuarkBuffer.wrap((ByteBuffer)mapBuffer);
                this.bufferPos = 0;
                if (this.packetBufferReceiver != null) {
                    this.packetBufferReceiver.onBufferChange(oldBuffer, this.buffer);
                }
                if (oldBuffer != null) {
                    oldBuffer.dispose();
                }
                if (forceRemap) {
                    if (this.tracer.debug) {
                        this.tracer.log("Requested to forcibly remap to requested position. Created new mapped buffer [bufferFilePointer=" + this.bufferFilePointer + ", bufferLength=" + this.bufferLength + ", bufferPos=" + this.bufferPos + ", logSize=" + logSize + "]", Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log("Requested position not in currently mapped section. Created new mapped buffer [bufferFilePointer=" + this.bufferFilePointer + ", bufferLength=" + this.bufferLength + ", bufferPos=" + this.bufferPos + ", logSize=" + logSize + "]", Tracer.Level.DEBUG);
                }
            } else {
                this.bufferPos = (int)(position - this.bufferFilePointer);
                if (this.tracer.debug) {
                    this.tracer.log("Requested buffer position is in currently mapped section. Adjusted buffer position [bufferFilePointer=" + this.bufferFilePointer + ", bufferLength=" + this.bufferLength + ", bufferPos=" + this.bufferPos + ", logSize=" + logSize + "]", Tracer.Level.DEBUG);
                }
            }
        }

        private final void waitForMoreDataToBeWritten() {
            if (this.tracer.debug) {
                this.tracer.log("Assuming log data is partial. Waiting for more data to arrive in log...", Tracer.Level.DEBUG);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log("Done waiting.", Tracer.Level.DEBUG);
                }
            }
        }

        private final void onReadOneError(int errorCode, int numFails) {
            if (this.tracer.debug) {
                this.tracer.log("Read error (" + errorCode + ") (numFails=" + numFails + ")", Tracer.Level.DEBUG);
            }
            if (numFails > this.maxReadFailsForCorruption) {
                throw new EPktLogCorruptException(PktHeader.convertPreDeserializeErrorCodeToException(this.buffer.getBufferUnsafe(), this.bufferPos, errorCode).getMessage());
            }
            this.waitForMoreDataToBeWritten();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ReadCompletionReason readOneCore(long maxFilePointer) throws IOException {
            if (this.tracer.debug) {
                this.tracer.log("Reading one packet (fp=" + this.filePointer + ", mfp=" + maxFilePointer + ")...", Tracer.Level.DEBUG);
            }
            if (this.filePointer < maxFilePointer) {
                int numFails = 0;
                while (!this.stopped && !this.closed) {
                    int packetLength;
                    int remaining = this.buffer.getLength() - this.bufferPos;
                    if (this.tracer.debug) {
                        this.tracer.log(remaining + " bytes remaining in buffer.", Tracer.Level.DEBUG);
                    }
                    if ((packetLength = PktHeader.preDeserializeNoException(this.buffer.getBufferUnsafe(), this.bufferPos, remaining)) < 0) {
                        this.onReadOneError(packetLength, ++numFails);
                        continue;
                    }
                    if (packetLength == 0 || packetLength > remaining) {
                        if (this.tracer.debug) {
                            this.tracer.log("End of buffer (packetLength=" + packetLength + ", remaining=" + remaining + "). Mapping new buffer.", Tracer.Level.DEBUG);
                        }
                        this.map(this.filePointer, maxFilePointer, true);
                        remaining = this.buffer.getLength() - this.bufferPos;
                        if (this.tracer.debug) {
                            this.tracer.log("Buffer remapped (packetLength=" + packetLength + ", remaining=" + remaining + ").", Tracer.Level.DEBUG);
                        }
                        if (remaining > 0) {
                            packetLength = PktHeader.preDeserializeNoException(this.buffer.getBufferUnsafe(), this.bufferPos, remaining);
                            if (packetLength < 0) {
                                this.onReadOneError(packetLength, ++numFails);
                                continue;
                            }
                            if (packetLength == 0 || packetLength > remaining) {
                                throw new EPktLogCorruptException("incomplete packet at end of file");
                            }
                        } else {
                            throw new EPktLogCorruptException("EOF but no EOF marker");
                        }
                    }
                    if (PktHeader.getBodyType(this.buffer.getBufferUnsafe(), this.bufferPos) == 262) {
                        if (this.tracer.debug) {
                            this.tracer.log("End of file.", Tracer.Level.DEBUG);
                        }
                        return ReadCompletionReason.EndOfFile;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Dispatching packet (length=" + packetLength + ")", Tracer.Level.DEBUG);
                    }
                    if (this.packetBufferReceiver != null) {
                        this.packetBufferReceiver.onPacket(this.buffer, this.bufferPos, packetLength, this.filePointer);
                    }
                    if (this.packetReceiver != null) {
                        this.deserializeContext.setBuffer(this.buffer.getBufferUnsafe());
                        this.buffer.getBufferUnsafe().mark();
                        this.buffer.getBufferUnsafe().position(this.bufferPos);
                        try {
                            this.packetReceiver.onPacket(PktFactory.getInstance().createPacket(this.deserializeContext, null));
                        }
                        finally {
                            this.buffer.getBufferUnsafe().reset();
                        }
                    }
                    this.bufferPos += packetLength;
                    this.filePointer += (long)packetLength;
                    return null;
                }
                return this.closed ? ReadCompletionReason.Closed : ReadCompletionReason.Stopped;
            }
            return ReadCompletionReason.MaxFilePointerReached;
        }

        private final void closeCore() {
            if (this.buffer != null) {
                this.buffer.dispose();
                this.buffer = null;
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                this.tracer.log("Failed to close file underlying memory mapped reader [" + e + "]", Tracer.Level.WARNING);
            }
        }

        public final void setPacketBodyDesyncDisabled(boolean packetBodyDesyncDisabled) {
            this.deserializeContext.setPacketBodyDesyncDisabled(packetBodyDesyncDisabled);
        }

        public final boolean isPacketBodyDesyncDisabled() {
            return this.deserializeContext.isPacketBodyDesyncDisabled();
        }

        public final void seek(long pos) throws IOException {
            if (pos < 9L) {
                throw new IllegalArgumentException("cannot seek to before beginning of file");
            }
            if (pos >= this.raf.length()) {
                throw new IllegalArgumentException("cannot seek to beyond end of file");
            }
            if (this.running) {
                throw new IllegalStateException("cannot seek while running the reader");
            }
            if (this.closed) {
                throw new IllegalStateException("reader is closed");
            }
            this.map(pos, Long.MAX_VALUE, false);
            this.filePointer = pos;
        }

        public final long filePointer() {
            return this.filePointer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ReadCompletionReason readOne(long maxFilePointer) {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.closed) {
                        throw new IllegalStateException("reader is closed");
                    }
                    if (this.running) {
                        throw new IllegalStateException("already running");
                    }
                    this.stopped = false;
                    this.running = true;
                }
                if (this.tracer.debug) {
                    this.tracer.log("Reading one packet [maxFilePointer=" + maxFilePointer + "]", Tracer.Level.DEBUG);
                }
                this.map(this.filePointer, maxFilePointer, false);
                object = this.readOneCore(maxFilePointer);
                return object;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log("Exiting read...", Tracer.Level.DEBUG);
                }
                if (this.closed) {
                    this.closeCore();
                }
                this.running = false;
            }
        }

        public final ReadCompletionReason readOne() {
            return this.readOne(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ReadCompletionReason read(long maxFilePointer) {
            try {
                ReadCompletionReason completionReason;
                MemoryMappedReader memoryMappedReader = this;
                synchronized (memoryMappedReader) {
                    if (this.closed) {
                        throw new IllegalStateException("reader is closed");
                    }
                    if (this.running) {
                        throw new IllegalStateException("already running");
                    }
                    this.stopped = false;
                    this.running = true;
                }
                if (this.tracer.debug) {
                    this.tracer.log("Started read [maxFilePointer=" + maxFilePointer + "]", Tracer.Level.DEBUG);
                }
                this.map(this.filePointer, maxFilePointer, false);
                while (!this.stopped && !this.closed) {
                    completionReason = this.readOneCore(maxFilePointer);
                    if (completionReason == null) continue;
                    ReadCompletionReason readCompletionReason = completionReason;
                    return readCompletionReason;
                }
                completionReason = this.stopped ? ReadCompletionReason.Stopped : ReadCompletionReason.Closed;
                return completionReason;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log("Exiting read...", Tracer.Level.DEBUG);
                }
                if (this.closed) {
                    this.closeCore();
                }
                this.running = false;
            }
        }

        public final ReadCompletionReason read() {
            return this.read(Long.MAX_VALUE);
        }

        public final ReadCompletionReason readAt(long position) throws IOException {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Reading at position '" + position + "'...", Tracer.Level.DEBUG);
                }
                this.seek(position);
                return this.readOne(Long.MAX_VALUE);
            }
            catch (EPktLogCorruptException e) {
                throw new EPktLogInvalidPositionException((Throwable)((Object)e));
            }
        }

        public final boolean isValidAt(long position) throws IOException {
            if (this.tracer.debug) {
                this.tracer.log("Checking if position '" + position + "' contains a valid packet...", Tracer.Level.DEBUG);
            }
            if (position < this.raf.length()) {
                this.seek(position);
                int remaining = this.buffer.getLength() - this.bufferPos;
                int packetLength = PktHeader.preDeserializeNoException(this.buffer.getBufferUnsafe(), this.bufferPos, remaining);
                return packetLength > 0 && packetLength <= remaining;
            }
            return false;
        }

        public final void reset() throws IOException {
            this.seek(9L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() {
            MemoryMappedReader memoryMappedReader = this;
            synchronized (memoryMappedReader) {
                this.closed = true;
                if (!this.running) {
                    this.closeCore();
                }
            }
        }

        public static enum ReadCompletionReason {
            EndOfFile,
            MaxFilePointerReached,
            Stopped,
            Closed;

        }
    }

    public static final class FilePosition {
        long position;
        int size;

        public final void setPosition(long position) {
            this.position = position;
        }

        public final long getPosition() {
            return this.position;
        }

        public final void setSize(int size) {
            this.size = size;
        }

        public final int getSize() {
            return this.size;
        }

        public final String toString() {
            return "[pos=" + this.getPosition() + ", size=" + this.getSize() + "]";
        }
    }

    private final class Preamble {
        final byte formatVersion;
        long checkpointCount;

        Preamble(byte formatVersion) {
            this.formatVersion = formatVersion;
        }

        final void write(RandomAccessFile file) throws IOException {
            file.seek(0L);
            file.writeByte(this.formatVersion);
            file.writeLong(this.checkpointCount);
        }

        final void read(RandomAccessFile file) throws IOException {
            if (file.length() < (long)this.getSerializedLength()) {
                throw new EPktLogCorruptException("missing or partial preamble");
            }
            file.seek(1L);
            this.checkpointCount = file.readLong();
        }

        final int getSerializedLength() {
            return 9;
        }

        public final String toString() {
            return "[ver=" + this.formatVersion + " checkpoints=" + this.checkpointCount + "]";
        }
    }

    public static enum CheckpointState {
        DONE,
        SAVING_IMAGE,
        TRUNCATING_LOG;

    }

    public static enum FileOpenMode {
        r,
        rw,
        rws,
        rwd;

    }

    private final class IntegrityCheckPacketHandler
    implements IPacketBufferReceiver {
        private final ILogIntegrityChecker logIntegrityChecker;
        int numValidEntries;
        long validatedFileLength;

        IntegrityCheckPacketHandler(ILogIntegrityChecker logIntegrityChecker) {
            this.validatedFileLength = PktRecoveryLog.this.preamble.getSerializedLength();
            this.logIntegrityChecker = logIntegrityChecker;
            if (this.logIntegrityChecker != null) {
                this.logIntegrityChecker.init(PktRecoveryLog.this.preamble.getSerializedLength());
            }
        }

        final void done() {
            if (this.logIntegrityChecker != null) {
                this.logIntegrityChecker.done();
            }
        }

        final int numValidEntries() {
            return this.logIntegrityChecker != null && this.logIntegrityChecker.corruptionDetected() ? this.logIntegrityChecker.numValidEntries() : this.numValidEntries;
        }

        final long validatedFileLength() {
            return this.logIntegrityChecker != null && this.logIntegrityChecker.corruptionDetected() ? this.logIntegrityChecker.validatedFileLength() : this.validatedFileLength;
        }

        @Override
        public final void onPacket(QuarkBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
            ++this.numValidEntries;
            this.validatedFileLength = filePosition + (long)packetLength;
            if (this.logIntegrityChecker != null) {
                this.logIntegrityChecker.onPacket(buffer, bufferPosition, packetLength, filePosition);
            }
        }

        @Override
        public final void onBufferChange(QuarkBuffer from, QuarkBuffer to) {
        }
    }
}

