/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCdcProcessor;
import com.neeve.rog.log.RogLogCompactor;
import com.neeve.rog.log.test.unit.messages.proto.Customer;
import com.neeve.rog.log.test.unit.messages.proto.Factory;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class RogLogCdcProcessorTest
extends UnitTest {
    private Random random = new Random(System.currentTimeMillis());
    private RogLog log;
    private CDCRunner runner;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(new Factory());
    }

    @After
    public void cleanup() throws Exception {
        if (this.runner != null) {
            this.runner.stop();
        }
        if (this.log != null) {
            this.log.close();
            this.log.delete();
        }
    }

    private final String logFilename(String name, int number) {
        return name + (number == 0 ? "" : "." + String.valueOf(number)) + ".log";
    }

    private final RogLog openLog(String name, IStoreBinding.Role role) throws Exception {
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        props.setProperty("cdcEnabled", "true");
        this.log = RogLog.create(name, props);
        this.log.onRoleChange(role);
        this.log.open();
        return this.log;
    }

    private final void logPutSingle(int txnId, int stableTxnId, int checkpointVersion, boolean commitEnd, boolean sync) {
        Customer customer = Customer.create();
        customer.setTransactionId(txnId);
        customer.setStableTransactionId(stableTxnId);
        customer.setCheckpointVersion(checkpointVersion);
        customer.setCustomerId(this.random.nextLong());
        this.log.writeCommitEntry(StoreCommitEntry.create().init(IStoreBinding.Operation.Put, new UUID(), customer.getOfid(), customer.getType(), customer.getTransactionId(), customer.getStableTransactionId(), customer.getCheckpointVersion(), customer, customer.serializeToPacket(), customer.getContentEncodingType(), false, commitEnd), false, sync);
    }

    private final void logPut(int count, int txnId, int stableTxnId) {
        for (int i = 0; i < count; ++i) {
            this.logPutSingle(txnId, stableTxnId, txnId, i == count - 1, i == count - 1);
        }
    }

    private final int logPuts(int[] numEntriesByCheckpoint, int startTxnId) {
        int numExpectedEntriesDispatchedToCdc = 0;
        for (int i = 0; i < numEntriesByCheckpoint.length; ++i) {
            this.logPut(numEntriesByCheckpoint[i], i + startTxnId, i + startTxnId - 1);
            if (i >= numEntriesByCheckpoint.length - 1) continue;
            numExpectedEntriesDispatchedToCdc += numEntriesByCheckpoint[i];
        }
        this.log.flush(false);
        return numExpectedEntriesDispatchedToCdc;
    }

    private final int logPuts(int[] numEntriesByCheckpoint) {
        return this.logPuts(numEntriesByCheckpoint, 1);
    }

    private final void compact() throws Exception {
        System.out.println("ABOUT TO COMPACT: " + UtlFile.readableFileSize((long)this.log.getSize()));
        this.log.getCompactor().compact();
        while (this.log.getCompactor().getState() == RogLogCompactor.State.InProgress || this.log.getCompactor().getState() == RogLogCompactor.State.Compacted) {
            Thread.sleep(1000L);
        }
        System.out.println("COMPACTED: " + UtlFile.readableFileSize((long)this.log.getSize()));
    }

    private final void testCdcOnCdcDisabledLog(IStoreBinding.Role role) throws Exception {
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        this.log = RogLog.create(this.name.getMethodName(), props);
        this.log.onRoleChange(role);
        this.log.open();
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitForStop();
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)0L, (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)0L, (long)this.runner.numChanges);
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteErrorCauses.size());
    }

    @Test
    public void testCdcOnCdcDisabledLog_Primary() throws Exception {
        this.testCdcOnCdcDisabledLog(IStoreBinding.Role.Primary);
    }

    @Test
    public void testCdcOnCdcDisabledLog_Backup() throws Exception {
        this.testCdcOnCdcDisabledLog(IStoreBinding.Role.Backup);
    }

    @Test
    public void testCdcOnBackupCdcEnabledLog() throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Backup);
        int numExpectedEntriesDispatchedToCdc = this.logPuts(new int[]{5, 2, 1, 9, 8, 10});
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)0L, (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)0L, (long)this.runner.numChanges);
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteErrorCauses.size());
    }

    private final int openLogAndCdcToEnd(int[] numEntriesByCheckpoint) throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Primary);
        int numExpectedEntriesDispatchedToCdc = this.logPuts(numEntriesByCheckpoint);
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        return numExpectedEntriesDispatchedToCdc;
    }

    private final void testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime(int[] numEntriesByCheckpoint) throws Exception {
        int numExpectedEntriesDispatchedToCdc = this.openLogAndCdcToEnd(numEntriesByCheckpoint);
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)Math.max(0, numEntriesByCheckpoint.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)Math.max(0, numEntriesByCheckpoint.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)numExpectedEntriesDispatchedToCdc, (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime_EmptyLog() throws Exception {
        this.testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime(new int[0]);
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime_OneCheckpoint() throws Exception {
        this.testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime(new int[]{5});
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime_TwoCheckpoints() throws Exception {
        this.testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime(new int[]{2, 6});
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime_MultipleCheckpoints() throws Exception {
        this.testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime(new int[]{5, 2, 1, 9, 8});
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime_LiveLogIsNotFirstLog_AllLogsMissingButLiveLog() throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Primary);
        int[] numEntriesByCheckpoint1 = new int[]{5, 2, 1, 9, 8, 10, 1, 6, 7, 2};
        int numExpectedEntriesDispatchedToCdc1 = this.logPuts(numEntriesByCheckpoint1);
        this.compact();
        int[] numEntriesByCheckpoint2 = new int[]{12, 6, 1, 9, 15, 3};
        int numExpectedEntriesDispatchedToCdc2 = this.logPuts(numEntriesByCheckpoint2, 11);
        this.compact();
        int[] numEntriesByCheckpoint3 = new int[]{16, 2, 13, 14, 1, 5, 5};
        int numExpectedEntriesDispatchedToCdc3 = this.logPuts(numEntriesByCheckpoint3, 17);
        new File(XRuntime.getDataDirectory(), this.logFilename(this.name.getMethodName(), 0)).delete();
        new File(XRuntime.getDataDirectory(), this.logFilename(this.name.getMethodName(), 1)).delete();
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)(2 + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(2 + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numExpectedEntriesDispatchedToCdc1 + numEntriesByCheckpoint1[numEntriesByCheckpoint1.length - 1] + numExpectedEntriesDispatchedToCdc2 + numEntriesByCheckpoint2[numEntriesByCheckpoint2.length - 1] + numExpectedEntriesDispatchedToCdc3), (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime_LiveLogIsNotFirstLog_AllLogsMissingButFirstAndLiveLog() throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Primary);
        int[] numEntriesByCheckpoint1 = new int[]{5, 2, 1, 9, 8, 10, 1, 6, 7, 2};
        int numExpectedEntriesDispatchedToCdc1 = this.logPuts(numEntriesByCheckpoint1);
        this.compact();
        int[] numEntriesByCheckpoint2 = new int[]{12, 6, 1, 9, 15, 3};
        int numExpectedEntriesDispatchedToCdc2 = this.logPuts(numEntriesByCheckpoint2, 11);
        this.compact();
        int[] numEntriesByCheckpoint3 = new int[]{16, 2, 13, 14, 1, 5, 5};
        int numExpectedEntriesDispatchedToCdc3 = this.logPuts(numEntriesByCheckpoint3, 17);
        new File(XRuntime.getDataDirectory(), this.logFilename(this.name.getMethodName(), 1)).delete();
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.get(1).intValue());
        Assert.assertEquals((long)(numEntriesByCheckpoint1.length - 1 + 1 + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(numEntriesByCheckpoint1.length - 1 + 1 + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numExpectedEntriesDispatchedToCdc1 + numEntriesByCheckpoint2[numEntriesByCheckpoint2.length - 1] + numExpectedEntriesDispatchedToCdc3), (long)this.runner.numChanges);
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.get(1).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(1)));
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(1));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcStartFirstTime_LiveLogIsNotFirstLog_AllLogsMissingButNonFirstAndLiveLog() throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Primary);
        int[] numEntriesByCheckpoint1 = new int[]{5, 2, 1, 9, 8, 10, 1, 6, 7, 2};
        int numExpectedEntriesDispatchedToCdc1 = this.logPuts(numEntriesByCheckpoint1);
        this.compact();
        int[] numEntriesByCheckpoint2 = new int[]{12, 6, 1, 9, 15, 3};
        int numExpectedEntriesDispatchedToCdc2 = this.logPuts(numEntriesByCheckpoint2, 11);
        this.compact();
        int[] numEntriesByCheckpoint3 = new int[]{16, 2, 13, 14, 1, 5, 5};
        int numExpectedEntriesDispatchedToCdc3 = this.logPuts(numEntriesByCheckpoint3, 17);
        new File(XRuntime.getDataDirectory(), this.logFilename(this.name.getMethodName(), 0)).delete();
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.get(1).intValue());
        Assert.assertEquals((long)(2 + numEntriesByCheckpoint2.length - 1 + 1 + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(2 + numEntriesByCheckpoint2.length - 1 + 1 + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numExpectedEntriesDispatchedToCdc1 + numEntriesByCheckpoint1[numEntriesByCheckpoint1.length - 1] + numExpectedEntriesDispatchedToCdc2 + numEntriesByCheckpoint2[numEntriesByCheckpoint2.length - 1] + numExpectedEntriesDispatchedToCdc3), (long)this.runner.numChanges);
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.get(1).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(1)));
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(1));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcRestartFromPartlyBehindLive_SameLog() throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Primary);
        int[] numEntriesByCheckpoint = new int[]{5, 2, 1, 9, 8};
        int numExpectedEntriesDispatchedToCdc = this.logPuts(numEntriesByCheckpoint);
        this.runner = new CDCRunner(this.log.getName());
        this.runner.failOn(1);
        this.runner.start(this.log);
        this.runner.waitForStop();
        Assert.assertFalse((boolean)this.runner.running);
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)1L, (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)numEntriesByCheckpoint[0], (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Error), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNotNull((Object)this.runner.logCompleteErrorCauses.get(0));
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)(numEntriesByCheckpoint.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(numEntriesByCheckpoint.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numExpectedEntriesDispatchedToCdc - numEntriesByCheckpoint[0]), (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcRestartFromPartlyBehindLive_DifferentLog() throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Primary);
        int[] numEntriesByCheckpoint1 = new int[]{5, 2, 1, 9, 8};
        int numExpectedEntriesDispatchedToCdc1 = this.logPuts(numEntriesByCheckpoint1);
        this.runner = new CDCRunner(this.log.getName());
        this.runner.failOn(1);
        this.runner.start(this.log);
        this.runner.waitForStop();
        Assert.assertFalse((boolean)this.runner.running);
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)1L, (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)numEntriesByCheckpoint1[0], (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Error), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNotNull((Object)this.runner.logCompleteErrorCauses.get(0));
        int[] numEntriesByCheckpoint2 = new int[]{10, 1, 6, 7, 2};
        int numExpectedEntriesDispatchedToCdc2 = this.logPuts(numEntriesByCheckpoint2, 6);
        this.compact();
        int[] numEntriesByCheckpoint3 = new int[]{12, 6, 1, 9, 15, 3};
        int numExpectedEntriesDispatchedToCdc3 = this.logPuts(numEntriesByCheckpoint3, 11);
        this.compact();
        int[] numEntriesByCheckpoint4 = new int[]{16, 2, 13, 14, 1, 5, 5};
        int numExpectedEntriesDispatchedToCdc4 = this.logPuts(numEntriesByCheckpoint4, 17);
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)3L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.get(1).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.get(2).intValue());
        Assert.assertEquals((long)(numEntriesByCheckpoint1.length + numEntriesByCheckpoint2.length + numEntriesByCheckpoint3.length + numEntriesByCheckpoint4.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(numEntriesByCheckpoint1.length + numEntriesByCheckpoint2.length + numEntriesByCheckpoint3.length + numEntriesByCheckpoint4.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numExpectedEntriesDispatchedToCdc1 - numEntriesByCheckpoint1[0] + numEntriesByCheckpoint1[numEntriesByCheckpoint1.length - 1] + numExpectedEntriesDispatchedToCdc2 + numEntriesByCheckpoint2[numEntriesByCheckpoint2.length - 1] + numExpectedEntriesDispatchedToCdc3 + numEntriesByCheckpoint3[numEntriesByCheckpoint3.length - 1] + numExpectedEntriesDispatchedToCdc4), (long)this.runner.numChanges);
        Assert.assertEquals((long)3L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.get(1).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.get(2).intValue());
        Assert.assertEquals((long)3L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog), (Object)((Object)this.runner.logCompleteReasons.get(1)));
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(2)));
        Assert.assertEquals((long)3L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(1));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(2));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcRestartFromPartlyBehindLive_DifferentLog_AllLogsMissingButCdcAndLiveLog() throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Primary);
        int[] numEntriesByCheckpoint1 = new int[]{5, 2, 1, 9, 8, 10, 1, 6, 7, 2};
        int numExpectedEntriesDispatchedToCdc1 = this.logPuts(numEntriesByCheckpoint1);
        this.runner = new CDCRunner(this.log.getName());
        this.runner.failOn(1);
        this.runner.start(this.log);
        this.runner.waitForStop();
        Assert.assertFalse((boolean)this.runner.running);
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)1L, (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)numEntriesByCheckpoint1[0], (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Error), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNotNull((Object)this.runner.logCompleteErrorCauses.get(0));
        this.compact();
        int[] numEntriesByCheckpoint2 = new int[]{12, 6, 1, 9, 15, 3};
        int numExpectedEntriesDispatchedToCdc2 = this.logPuts(numEntriesByCheckpoint2, 11);
        this.compact();
        int[] numEntriesByCheckpoint3 = new int[]{16, 2, 13, 14, 1, 5, 5};
        int numExpectedEntriesDispatchedToCdc3 = this.logPuts(numEntriesByCheckpoint3, 17);
        new File(XRuntime.getDataDirectory(), this.logFilename(this.name.getMethodName(), 1)).delete();
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.get(1).intValue());
        Assert.assertEquals((long)(numEntriesByCheckpoint1.length - 1 + 1 + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(numEntriesByCheckpoint1.length - 1 + 1 + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numExpectedEntriesDispatchedToCdc1 - numEntriesByCheckpoint1[0] + numEntriesByCheckpoint2[numEntriesByCheckpoint2.length - 1] + numExpectedEntriesDispatchedToCdc3), (long)this.runner.numChanges);
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.get(1).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(1)));
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(1));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcRestartFromCaughtUpWithLive() throws Exception {
        int[] numEntriesByCheckpoint = new int[]{5, 2, 1, 9, 8};
        int numExpectedEntriesDispatchedToCdc = this.openLogAndCdcToEnd(numEntriesByCheckpoint);
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)Math.max(0, numEntriesByCheckpoint.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)Math.max(0, numEntriesByCheckpoint.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)numExpectedEntriesDispatchedToCdc, (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)0L, (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)0L, (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcRestartFromCaughtUpWithLive_WriteAdditional() throws Exception {
        this.openLogAndCdcToEnd(new int[]{5, 2, 1, 9, 8});
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.waitReached = false;
        int[] numEntriesByCheckpoint = new int[]{10, 1, 6, 7, 2};
        int numExpectedEntriesDispatchedToCdc = this.logPuts(numEntriesByCheckpoint, 6);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)(1 + numEntriesByCheckpoint.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(1 + numEntriesByCheckpoint.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numExpectedEntriesDispatchedToCdc + 8), (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcRestartFromCaughtUpWithLive_WriteAdditionalCompactAndWriteSomeMore() throws Exception {
        int[] numEntriesByCheckpoint = new int[]{5, 2, 1, 9, 8};
        this.openLogAndCdcToEnd(numEntriesByCheckpoint);
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        int[] numEntriesByCheckpoint1 = new int[]{10, 1, 6, 7, 2};
        int numExpectedEntriesDispatchedToCdc1 = this.logPuts(numEntriesByCheckpoint1, 6);
        this.compact();
        this.runner.waitReached = false;
        int[] numEntriesByCheckpoint2 = new int[]{12, 6, 1, 9, 15, 3};
        int numExpectedEntriesDispatchedToCdc2 = this.logPuts(numEntriesByCheckpoint2, 11);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.get(1).intValue());
        Assert.assertEquals((long)(1 + numEntriesByCheckpoint1.length + numEntriesByCheckpoint2.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(1 + numEntriesByCheckpoint1.length + numEntriesByCheckpoint2.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numEntriesByCheckpoint[numEntriesByCheckpoint.length - 1] + numExpectedEntriesDispatchedToCdc1 + numEntriesByCheckpoint1[numEntriesByCheckpoint1.length - 1] + numExpectedEntriesDispatchedToCdc2), (long)this.runner.numChanges);
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.get(1).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(1)));
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(1));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcRestartFromCaughtUpWithLive_WriteAdditionalCompactWriteSomeMoreCompactAndWriteSomeMore() throws Exception {
        int[] numEntriesByCheckpoint = new int[]{5, 2, 1, 9, 8};
        this.openLogAndCdcToEnd(numEntriesByCheckpoint);
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        int[] numEntriesByCheckpoint1 = new int[]{10, 1, 6, 7, 2};
        int numExpectedEntriesDispatchedToCdc1 = this.logPuts(numEntriesByCheckpoint1, 6);
        this.compact();
        int[] numEntriesByCheckpoint2 = new int[]{12, 6, 1, 9, 15, 3};
        int numExpectedEntriesDispatchedToCdc2 = this.logPuts(numEntriesByCheckpoint2, 11);
        this.compact();
        this.runner.waitReached = false;
        int[] numEntriesByCheckpoint3 = new int[]{16, 2, 13, 14, 1, 5, 5};
        int numExpectedEntriesDispatchedToCdc3 = this.logPuts(numEntriesByCheckpoint3, 17);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)3L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.get(1).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logStartNumbers.get(2).intValue());
        Assert.assertEquals((long)(1 + numEntriesByCheckpoint1.length + numEntriesByCheckpoint2.length + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)(1 + numEntriesByCheckpoint1.length + numEntriesByCheckpoint2.length + numEntriesByCheckpoint3.length - 1), (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)(numEntriesByCheckpoint[numEntriesByCheckpoint.length - 1] + numExpectedEntriesDispatchedToCdc1 + numEntriesByCheckpoint1[numEntriesByCheckpoint1.length - 1] + numExpectedEntriesDispatchedToCdc2 + numEntriesByCheckpoint2[numEntriesByCheckpoint2.length - 1] + numExpectedEntriesDispatchedToCdc3), (long)this.runner.numChanges);
        Assert.assertEquals((long)3L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logCompleteNumbers.get(0).intValue());
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.get(1).intValue());
        Assert.assertEquals((long)2L, (long)this.runner.logCompleteNumbers.get(2).intValue());
        Assert.assertEquals((long)3L, (long)this.runner.logCompleteReasons.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.MovedOntoNextLog), (Object)((Object)this.runner.logCompleteReasons.get(1)));
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(2)));
        Assert.assertEquals((long)3L, (long)this.runner.logCompleteErrorCauses.size());
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(1));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(2));
    }

    @Test
    public void testCdcOnPrimaryCdcEnabledLog_CdcRestartAfterLogRepairAfterWriteFail() throws Exception {
        this.openLog(this.name.getMethodName(), IStoreBinding.Role.Primary);
        this.logPutSingle(30433921, 30433906, 10899439, true, true);
        this.logPutSingle(30433922, 30433906, 10899440, true, true);
        this.logPutSingle(30433944, 30433943, 10899441, true, true);
        this.logPutSingle(30433924, 30433923, 10899440, true, true);
        this.logPutSingle(30433931, 30433930, 10899441, true, true);
        this.logPutSingle(30433932, 30433930, 10899442, true, true);
        this.logPutSingle(30433933, 30433930, 10899443, true, true);
        this.logPutSingle(30433934, 30433930, 10899444, true, true);
        this.logPutSingle(30433935, 30433930, 10899445, true, true);
        this.logPutSingle(30433936, 30433930, 10899446, true, true);
        this.logPutSingle(30433937, 30433930, 10899447, true, true);
        this.logPutSingle(30433937, 30433930, 10899448, true, true);
        this.logPutSingle(30433939, 30433930, 10899449, true, true);
        this.logPutSingle(30433940, 30433930, 10899450, true, true);
        this.logPutSingle(30433941, 30433930, 10899451, true, true);
        this.logPutSingle(30433942, 30433930, 10899452, true, true);
        this.logPutSingle(30433943, 30433930, 10899453, true, true);
        this.logPutSingle(30433944, 30433930, 10899454, true, true);
        this.logPutSingle(30433946, 30433944, 10899455, true, true);
        this.logPutSingle(30434002, 30433998, 10899456, true, true);
        this.runner = new CDCRunner(this.log.getName());
        this.runner.start(this.log);
        this.runner.waitTillNoMoreEntriesToCdc();
        Assert.assertTrue((boolean)this.runner.running);
        this.runner.stop();
        Assert.assertEquals((long)1L, (long)this.runner.logStartNumbers.size());
        Assert.assertEquals((long)0L, (long)this.runner.logStartNumbers.get(0).intValue());
        Assert.assertEquals((long)17L, (long)this.runner.numCheckpointsStarted);
        Assert.assertEquals((long)17L, (long)this.runner.numCheckpointsCompleted);
        Assert.assertEquals((long)17L, (long)this.runner.numChanges);
        Assert.assertEquals((long)1L, (long)this.runner.logCompleteNumbers.size());
        Assert.assertEquals((Object)((Object)IRogChangeDataCaptureHandler.LogCompletionReason.Closed), (Object)((Object)this.runner.logCompleteReasons.get(0)));
        Assert.assertNull((Object)this.runner.logCompleteErrorCauses.get(0));
    }

    private final class CDCRunner
    implements IRogChangeDataCaptureHandler,
    Runnable {
        volatile boolean started;
        volatile boolean running;
        List<Integer> logStartNumbers;
        int numCheckpointsStarted;
        int numChanges;
        int numCheckpointsCompleted;
        List<Integer> logCompleteNumbers;
        List<IRogChangeDataCaptureHandler.LogCompletionReason> logCompleteReasons;
        List<Throwable> logCompleteErrorCauses;
        private Thread thread;
        private String logName;
        private RogLog log;
        private RogLogCdcProcessor processor;
        int failOnCheckpointNumber;
        boolean waitReached;

        CDCRunner(String logName) {
            this.logName = logName;
            this.logStartNumbers = new ArrayList<Integer>();
            this.logCompleteNumbers = new ArrayList<Integer>();
            this.logCompleteReasons = new ArrayList<IRogChangeDataCaptureHandler.LogCompletionReason>();
            this.logCompleteErrorCauses = new ArrayList<Throwable>();
        }

        void failOn(int checkpointNumber) {
            this.failOnCheckpointNumber = checkpointNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitTillNoMoreEntriesToCdc() throws Exception {
            CDCRunner cDCRunner = this;
            synchronized (cDCRunner) {
                long remaining;
                long ts = System.currentTimeMillis();
                while (!this.waitReached && (remaining = 5000L - (System.currentTimeMillis() - ts)) > 0L) {
                    this.wait(remaining);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(RogLog log) throws Exception {
            Properties props = new Properties();
            props.setProperty("detachedPersist", "false");
            props.setProperty("storeRoot", XRuntime.getDataDirectory());
            props.setProperty("autoRepair", "false");
            props.setProperty("logMode", "r");
            props.setProperty("cdcEnabled", log.getMetadata().isCdcEnabled() ? "true" : "false");
            this.log = RogLog.create(this.logName, props);
            this.log.open();
            this.processor = this.log.createCdcProcessor(this);
            this.thread = new Thread((Runnable)this, "CDCRunner");
            this.thread.start();
            CDCRunner cDCRunner = this;
            synchronized (cDCRunner) {
                while (!this.started) {
                    this.wait();
                }
            }
        }

        public void waitForStop() throws InterruptedException {
            this.thread.join(5000L);
            this.log.close();
            Assert.assertTrue((!this.thread.isAlive() ? 1 : 0) != 0);
        }

        public void stop() throws InterruptedException {
            this.processor.close();
            this.waitForStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                System.out.println("[CDCRunner] CDC processor start.");
                CDCRunner cDCRunner = this;
                synchronized (cDCRunner) {
                    this.started = true;
                    this.notifyAll();
                }
                this.running = true;
                try {
                    this.processor.run();
                }
                finally {
                    System.out.println("[CDCRunner] CDC processor done.");
                    this.running = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public final void onLogStart(int logNumber) {
            this.logStartNumbers.add(logNumber);
            System.out.println("[CDCRunner] Log #" + logNumber + " start");
        }

        @Override
        public final void onCheckpointStart(long checkpointVersion) {
            ++this.numCheckpointsStarted;
            System.out.println("[CDCRunner] Checkpoint #" + checkpointVersion + " start");
        }

        @Override
        public boolean handleChange(UUID objectId, IRogChangeDataCaptureHandler.ChangeType changeType, List<IRogNode> entries) {
            ++this.numChanges;
            IRogNode object = entries.get(0);
            System.out.println("[CDCRunner] GOT " + (object != null ? object.getClass().getSimpleName() : "null") + "[" + objectId + "] " + (Object)((Object)changeType) + " (" + entries.size() + " changes)");
            return true;
        }

        @Override
        public final boolean onCheckpointComplete(long checkpointVersion) {
            ++this.numCheckpointsCompleted;
            System.out.println("[CDCRunner] Checkpoint #" + checkpointVersion + " done");
            if (this.numCheckpointsCompleted == this.failOnCheckpointNumber) {
                this.failOnCheckpointNumber = 0;
                throw new RuntimeException("force fail in checkpoint complete");
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onWait() {
            System.out.println("[CDCRunner] Waiting for more entries...");
            CDCRunner cDCRunner = this;
            synchronized (cDCRunner) {
                this.waitReached = true;
                this.notifyAll();
            }
        }

        @Override
        public final void onLogComplete(int logNumber, IRogChangeDataCaptureHandler.LogCompletionReason reason, Throwable errorCause) {
            this.logCompleteNumbers.add(logNumber);
            this.logCompleteReasons.add(reason);
            this.logCompleteErrorCauses.add(errorCause);
            System.out.println("[CDCRunner] Log #" + logNumber + " complete (reason=" + (Object)((Object)reason) + ")");
        }
    }
}

