/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.google.common.collect.Lists;
import com.neeve.query.Query;
import com.neeve.query.QueryException;
import com.neeve.query.QueryPlan;
import com.neeve.query.QueryResult;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryAbstractField;
import com.neeve.query.impl.QueryEngineImpl;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.mock.domain.Address;
import com.neeve.query.impl.mock.domain.Customer;
import com.neeve.query.impl.mock.domain.SalesOrder;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.test.UnitTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class QueryEngineApiTest
extends UnitTest {
    private static QueryEngineImpl<Integer, MockRecord> engine;
    private static MemQuerySetRepository<Integer, MockRecord> repo;
    private static boolean createIndexes;
    private static Date now;
    private static final IdxField.KeyMapping<Date> millis;

    @BeforeClass
    public static void init() throws Exception {
        engine = new QueryEngineImpl(MockRecord.class);
        repo = new MemQuerySetRepository<Integer, MockRecord>("mock", MockRecord.keyMapper);
        repo.open();
        engine.addRepository(repo, "mock");
        createIndexes = false;
        if (createIndexes) {
            repo.createIndex(MockRecord.customerId, true);
            repo.createIndex(MockRecord.customerZipcode, false);
        }
        int recordId = 0;
        for (int i = 1; i <= 25; ++i) {
            String name = "John Doe #" + i;
            Customer cust = new Customer(i, name);
            if (i % 2 == 0) {
                cust.setAddress(new Address("12345"));
            } else {
                cust.setAddress(new Address("22222"));
            }
            cust.setAttachment(now);
            MockRecord custRec = new MockRecord(++recordId, cust);
            repo.add(custRec);
            SalesOrder order = new SalesOrder(i, cust, "apple");
            MockRecord orderRec = new MockRecord(++recordId, order);
            repo.add(orderRec);
        }
        repo.flushIndexing();
    }

    @AfterClass
    public static void teardown() throws Exception {
        if (createIndexes) {
            repo.dropIndex(MockRecord.customerId);
            repo.dropIndex(MockRecord.customerZipcode);
        }
        engine.close();
    }

    @After
    public void after() {
        for (IdxIndex index : repo.getIndexes()) {
            IdxField field = index.getField();
            repo.dropIndex(field);
        }
    }

    @Test
    public void testEquals() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.is(3L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        QueryResultSet.Row row = (QueryResultSet.Row)iter.next();
        MockRecord record = (MockRecord)row.getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 3", (long)3L, (long)customer.getId());
        Assert.assertFalse((String)"only one row", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testLike() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerName.like("%Doe%"));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        Assert.assertEquals((String)"expected all 25 customers", (long)25L, (long)rs.getCount());
        rs.close();
        query = engine.createQuery();
        query.from("mock").where(MockRecord.customerName.like("%4"));
        rs = engine.execute(query);
        Assert.assertEquals((String)"expected customers: 4, 14, 24", (long)3L, (long)rs.getCount());
        rs.close();
        query = engine.createQuery();
        query.from("mock").where(MockRecord.customerName.like("%1_"));
        rs = engine.execute(query);
        Assert.assertEquals((String)"expected customers: 10-19", (long)10L, (long)rs.getCount());
        rs.close();
        query = engine.createQuery();
        query.from("mock").where(MockRecord.customerName.like("%xyz%"));
        rs = engine.execute(query);
        Assert.assertEquals((String)"expected no customers", (long)0L, (long)rs.getCount());
        rs.close();
    }

    @Test
    public void testRegexLike() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerName.regexLike(".*Doe.*"));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        Assert.assertEquals((String)"expected all 25 customers", (long)25L, (long)rs.getCount());
        rs.close();
    }

    @Test
    public void testLessThan() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.lessThan(3L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        QueryResultSet.Row row = (QueryResultSet.Row)iter.next();
        MockRecord record = (MockRecord)row.getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 1", (long)1L, (long)customer.getId());
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        row = (QueryResultSet.Row)iter.next();
        record = (MockRecord)row.getRecord();
        customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 2", (long)2L, (long)customer.getId());
        Assert.assertFalse((String)"only two rows", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testLessThanOrEqual() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.lessThanOrEqual(3L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 1", (long)1L, (long)customer.getId());
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 2", (long)2L, (long)customer.getId());
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 3", (long)3L, (long)customer.getId());
        Assert.assertFalse((String)"only three rows", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testGreaterThan() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.greaterThan(24L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 25", (long)25L, (long)customer.getId());
        Assert.assertFalse((String)"only three rows", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testGreaterThanOrEqual() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.greaterThanOrEqual(24L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        QueryResultSet.Row row = (QueryResultSet.Row)iter.next();
        MockRecord record = (MockRecord)row.getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 2", (long)24L, (long)customer.getId());
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        row = (QueryResultSet.Row)iter.next();
        record = (MockRecord)row.getRecord();
        customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 3", (long)25L, (long)customer.getId());
        Assert.assertFalse((String)"only three rows", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testBetween() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.between(12L, 14L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 12", (long)12L, (long)customer.getId());
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 13", (long)13L, (long)customer.getId());
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 14", (long)14L, (long)customer.getId());
        Assert.assertFalse((String)"only three rows", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testIn() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.in(Lists.newArrayList((Object[])new Long[]{10L, 20L})));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 10", (long)10L, (long)customer.getId());
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 20", (long)20L, (long)customer.getId());
        Assert.assertFalse((String)"only three rows", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testInVarArgs() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.in((Long[])new Long[]{10L, 20L}));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 10", (long)10L, (long)customer.getId());
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 20", (long)20L, (long)customer.getId());
        Assert.assertFalse((String)"only three rows", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testNestedField() {
        Query<MockRecord> query = engine.createQuery();
        IdxField orderCustId = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.customer.id", Long.class, SalesOrder.class);
        query.from("mock").where(orderCustId.lessThan(20L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        int numRows = 0;
        while (iter.hasNext()) {
            MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
            SalesOrder order = (SalesOrder)record.getObject();
            Customer customer = order.getCustomer();
            Assert.assertTrue((String)"custId < 20", (customer.getId() < 20L ? 1 : 0) != 0);
            ++numRows;
        }
        Assert.assertEquals((String)"19 orders/customer", (long)19L, (long)numRows);
        rs.close();
    }

    @Test
    public void testAnd() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.is(2L).and(MockRecord.customerZipcode.is("12345")));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        Customer customer = (Customer)record.getObject();
        Assert.assertEquals((String)"customer 2", (long)2L, (long)customer.getId());
        Assert.assertFalse((String)"only one row", (boolean)iter.hasNext());
        rs.close();
    }

    @Test
    public void testOr() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(MockRecord.customerId.equal(5L).or(MockRecord.customerZipcode.is("12345")));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        while (iter.hasNext()) {
            MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
            Customer customer = (Customer)record.getObject();
            long id = customer.getId();
            Assert.assertTrue((String)"even or 5", (id == 5L || id % 2L == 0L ? 1 : 0) != 0);
        }
        rs.close();
    }

    @Test
    public void testRepoName() {
        Query<MockRecord> query = engine.createQuery();
        IdxField repoNameField = engine.getField("", "x_repository_name");
        query.select(repoNameField).from("mock").where(MockRecord.customerId.lessThan(5L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            String repo = rs.getString(1);
            Assert.assertEquals((String)"repo is mock", (Object)"mock", (Object)repo);
        }
        rs.close();
        Assert.assertEquals((String)"four rows", (long)4L, (long)numRows);
    }

    @Test
    public void testHeterogenousEntities() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerId).select(MockRecord.customer).select(MockRecord.orderId).select(MockRecord.order).select(MockRecord.orderCustomerId).select(MockRecord.orderCustomer).from("mock").where(MockRecord.orderCustomerId.lessThan(10L).or(MockRecord.customerId.lessThan(10L)));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        int numRows = 0;
        int numCustomers = 0;
        int numOrders = 0;
        while (rs.next()) {
            ++numRows;
            MockRecord rawResult = rs.getRawResult();
            Object payload = rawResult.getObject();
            Assert.assertNotNull((Object)payload);
            Long custId = (Long)rs.getObject(1);
            Customer cust = (Customer)rs.getObject(2);
            Long orderId = (Long)rs.getObject(3);
            SalesOrder order = (SalesOrder)rs.getObject(4);
            Long orderCustId = (Long)rs.getObject(5);
            Customer orderCust = (Customer)rs.getObject(6);
            if (payload instanceof Customer) {
                Assert.assertNotNull((String)"customer id should not be null on customer row", (Object)custId);
                Assert.assertNotNull((String)"customer should not be null on customer row", (Object)cust);
                Assert.assertNull((String)"order id should be null on customer row", (Object)orderId);
                Assert.assertNull((String)"order should be null on customer row", (Object)order);
                ++numCustomers;
                continue;
            }
            if (!(payload instanceof SalesOrder)) continue;
            Assert.assertNull((String)"customer id should be null on order row", (Object)custId);
            Assert.assertNull((String)"customer should be null on order row", (Object)cust);
            Assert.assertNotNull((String)"order id not should be null on customer row", (Object)orderId);
            Assert.assertNotNull((String)"order should not be null on customer row", (Object)order);
            Assert.assertNotNull((String)"order customer id should not be null on order row", (Object)orderCustId);
            Assert.assertNotNull((String)"order customer should not be null on order row", (Object)orderCust);
            ++numOrders;
        }
        rs.close();
        Assert.assertEquals((long)9L, (long)numCustomers);
        Assert.assertEquals((long)9L, (long)numOrders);
        Assert.assertEquals((String)"18 rows", (long)18L, (long)numRows);
    }

    @Test
    public void testUntypedQuery() {
        Query<MockRecord> query = engine.createQuery();
        IdxField untypedId = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.id", Long.class, new Class[0]);
        query.select(untypedId).from("mock").where(untypedId.between(4L, 8L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        int numRows = 0;
        int numCustomers = 0;
        int numOrders = 0;
        while (rs.next()) {
            long id = rs.getLong(1);
            Assert.assertTrue((String)"is was outside [4,8]", (id >= 4L && id <= 8L ? 1 : 0) != 0);
            MockRecord rawResult = rs.getRawResult();
            Object payload = rawResult.getObject();
            Assert.assertNotNull((Object)payload);
            if (payload instanceof Customer) {
                ++numCustomers;
            } else if (payload instanceof SalesOrder) {
                ++numOrders;
            }
            ++numRows;
        }
        rs.close();
        Assert.assertEquals((long)5L, (long)numCustomers);
        Assert.assertEquals((long)5L, (long)numOrders);
        Assert.assertEquals((long)10L, (long)numRows);
    }

    @Test
    public void testCreateIndex() {
        engine.createIndex(MockRecord.customerId, true);
        engine.dropIndex(MockRecord.customerId);
        IdxField untypedId = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.id", Long.class, new Class[0]);
        engine.createIndex(untypedId, false);
        engine.dropIndex(untypedId);
    }

    @Test
    public void testOrderBy() {
        long customerId;
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerId).select(MockRecord.customerZipcode).from("mock").where(MockRecord.customerId.lessThan(15L)).orderBy(MockRecord.customerId, Query.SortOrder.DESCENDING);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        long expectedCustId = 14L;
        while (rs.next()) {
            customerId = rs.getLong(1);
            Assert.assertEquals((String)"expected descending customerIds", (long)expectedCustId, (long)customerId);
            --expectedCustId;
        }
        query = engine.createQuery();
        query.select(MockRecord.customerId).select(MockRecord.customerZipcode).from("mock").where(MockRecord.customerId.lessThan(15L)).orderBy(MockRecord.customerZipcode).orderBy(MockRecord.customerId);
        rs = engine.execute(query);
        expectedCustId = 2L;
        while (rs.next()) {
            customerId = rs.getLong(1);
            Assert.assertEquals((String)"expected descending customerIds", (long)expectedCustId, (long)customerId);
            expectedCustId = expectedCustId == 14L ? 1L : expectedCustId + 2L;
        }
        query = engine.createQuery();
        query.select(MockRecord.customerId).select(MockRecord.customerZipcode).from("mock").where(MockRecord.customerId.lessThan(15L)).orderBy(MockRecord.customerZipcode).orderBy(MockRecord.customerId, Query.SortOrder.DESCENDING);
        rs = engine.execute(query);
        expectedCustId = 14L;
        while (rs.next()) {
            customerId = rs.getLong(1);
            Assert.assertEquals((String)"expected descending customerIds", (long)expectedCustId, (long)customerId);
            expectedCustId = expectedCustId == 2L ? 13L : expectedCustId - 2L;
        }
        query = engine.createQuery();
        query.select(MockRecord.customerId).select(MockRecord.customerZipcode).from("mock").where(MockRecord.customerId.lessThan(15L)).orderBy(MockRecord.customerZipcode).orderBy(MockRecord.customerId, Query.SortOrder.DESCENDING).orderBy(MockRecord.customerName).orderBy(MockRecord.orderId).orderBy(MockRecord.orderCustomerId, Query.SortOrder.DESCENDING);
        rs = engine.execute(query);
        expectedCustId = 14L;
        while (rs.next()) {
            customerId = rs.getLong(1);
            Assert.assertEquals((String)"expected descending customerIds", (long)expectedCustId, (long)customerId);
            expectedCustId = expectedCustId == 2L ? 13L : expectedCustId - 2L;
        }
    }

    @Test(expected=QueryException.class)
    public void testOrderByInvalidField() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customer).select(MockRecord.customerZipcode).from("mock").where(MockRecord.customerId.lessThan(15L)).orderBy(MockRecord.customer);
        engine.execute(query);
    }

    @Ignore
    @Test(expected=QueryException.class)
    public void testOrderByTooManyFields() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerId).select(MockRecord.customerZipcode).from("mock").where(MockRecord.customerId.lessThan(15L)).orderBy(MockRecord.customerId).orderBy(MockRecord.customerId).orderBy(MockRecord.customerId).orderBy(MockRecord.customerId).orderBy(MockRecord.customerId).orderBy(MockRecord.customerId);
        engine.execute(query);
    }

    @Test
    public void testGroupByWithoutAggretateFunctions() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerZipcode).from("mock").where(MockRecord.customerId.lessThan(15L)).groupBy(MockRecord.customerZipcode);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        ArrayList zipcodes = Lists.newArrayList();
        while (rs.next()) {
            String zipcode = rs.getString(1);
            zipcodes.add(zipcode);
        }
        Collections.sort(zipcodes);
        Assert.assertEquals((String)"two zipcodes", (Object)Lists.newArrayList((Object[])new String[]{"12345", "22222"}), (Object)zipcodes);
        Assert.assertEquals((String)"est. two zipcodes", (long)2L, (long)rs.getEstimatedCount());
        Assert.assertEquals((String)"count two zipcodes", (long)2L, (long)rs.getCount());
        rs.close();
    }

    @Test(expected=QueryException.class)
    public void testInvalidGroupBySelection() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerZipcode).select(MockRecord.customerId).from("mock").where(MockRecord.customerId.lessThan(15L)).groupBy(MockRecord.customerZipcode);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        rs.close();
    }

    @Test
    public void testGroupByWithAggregateFunctions() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerZipcode).select(MockRecord.customerZipcode.count()).select(MockRecord.customerId.min()).select(MockRecord.customerId.max()).select(MockRecord.customerId.sumLong()).select(MockRecord.customerId.average()).from("mock").where(MockRecord.customerId.lessThan(15L)).groupBy(MockRecord.customerZipcode);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        while (rs.next()) {
            String zipcode = rs.getString(1);
            int cnt = rs.getInteger(2);
            long minId = rs.getLong(3);
            long maxId = rs.getLong(4);
            long idSum = rs.getLong(5);
            double idAvg = rs.getDouble(6);
            if (zipcode.equals("12345")) {
                Assert.assertEquals((String)"expected 7 even records less than 15", (long)7L, (long)cnt);
                Assert.assertEquals((String)"2 is lowest even id", (long)2L, (long)minId);
                Assert.assertEquals((String)"14 is greatest even id", (long)14L, (long)maxId);
                Assert.assertEquals((String)"56 is the even id sum", (long)56L, (long)idSum);
                Assert.assertEquals((String)"8 is the even id avg", (double)8.0, (double)idAvg, (double)0.0);
                continue;
            }
            if (zipcode.equals("22222")) {
                Assert.assertEquals((String)"expected 7 odd records", (long)7L, (long)cnt);
                Assert.assertEquals((String)"1 is lowest odd id", (long)1L, (long)minId);
                Assert.assertEquals((String)"13 is greatest odd id", (long)13L, (long)maxId);
                Assert.assertEquals((String)"7 is the even id sum", (double)7.0, (double)idAvg, (double)0.0);
                continue;
            }
            Assert.fail((String)("unexpected zipcode: " + zipcode));
        }
        rs.close();
    }

    @Test
    public void testGroupByOrderBy() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerZipcode).select(MockRecord.customerZipcode.count()).from("mock").groupBy(MockRecord.customerZipcode).orderBy(MockRecord.customerZipcode, Query.SortOrder.ASCENDING);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        Assert.assertTrue((String)"has first row", (boolean)rs.next());
        Assert.assertEquals((String)"zipcode 12345 first", (Object)"12345", (Object)rs.getString(1));
        Assert.assertEquals((String)"12345 has 12 records", (long)12L, (long)rs.getInteger(2));
        Assert.assertTrue((String)"has second row", (boolean)rs.next());
        Assert.assertEquals((String)"zipcode 22222 second", (Object)"22222", (Object)rs.getString(1));
        Assert.assertEquals((String)"22222 has 13 records", (long)13L, (long)rs.getInteger(2));
        Assert.assertFalse((String)"only two rows", (boolean)rs.next());
        query = engine.createQuery();
        query.select(MockRecord.customerZipcode).select(MockRecord.customerZipcode.count()).from("mock").groupBy(MockRecord.customerZipcode).orderBy(MockRecord.customerZipcode, Query.SortOrder.DESCENDING);
        rs = engine.execute(query);
        Assert.assertTrue((String)"has first row", (boolean)rs.next());
        Assert.assertEquals((String)"zipcode 22222 first", (Object)"22222", (Object)rs.getString(1));
        Assert.assertEquals((String)"22222 has 13 records", (long)13L, (long)rs.getInteger(2));
        Assert.assertTrue((String)"has second row", (boolean)rs.next());
        Assert.assertEquals((String)"zipcode 12345 second", (Object)"12345", (Object)rs.getString(1));
        Assert.assertEquals((String)"12345 has 12 records", (long)12L, (long)rs.getInteger(2));
        Assert.assertFalse((String)"only two rows", (boolean)rs.next());
        query = engine.createQuery();
        query.select(MockRecord.customerZipcode).select(MockRecord.customerZipcode.count()).from("mock").groupBy(MockRecord.customerZipcode).orderBy(MockRecord.customerZipcode.count(), Query.SortOrder.ASCENDING);
        rs = engine.execute(query);
        Assert.assertTrue((String)"has first row", (boolean)rs.next());
        Assert.assertEquals((String)"zipcode 12345 first", (Object)"12345", (Object)rs.getString(1));
        Assert.assertEquals((String)"12345 has 12 records", (long)12L, (long)rs.getInteger(2));
        Assert.assertTrue((String)"has second row", (boolean)rs.next());
        Assert.assertEquals((String)"zipcode 22222 second", (Object)"22222", (Object)rs.getString(1));
        Assert.assertEquals((String)"22222 has 13 records", (long)13L, (long)rs.getInteger(2));
        Assert.assertFalse((String)"only two rows", (boolean)rs.next());
        query = engine.createQuery();
        query.select(MockRecord.customerZipcode).select(MockRecord.customerZipcode.count()).from("mock").groupBy(MockRecord.customerZipcode).orderBy(MockRecord.customerZipcode.count(), Query.SortOrder.DESCENDING);
        rs = engine.execute(query);
        Assert.assertTrue((String)"has first row", (boolean)rs.next());
        Assert.assertEquals((String)"zipcode 22222 first", (Object)"22222", (Object)rs.getString(1));
        Assert.assertEquals((String)"22222 has 13 records", (long)13L, (long)rs.getInteger(2));
        Assert.assertTrue((String)"has second row", (boolean)rs.next());
        Assert.assertEquals((String)"zipcode 12345 second", (Object)"12345", (Object)rs.getString(1));
        Assert.assertEquals((String)"12345 has 12 records", (long)12L, (long)rs.getInteger(2));
        Assert.assertFalse((String)"only two rows", (boolean)rs.next());
    }

    @Test
    public void testHaving() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerZipcode).select(MockRecord.customerId.average()).from("mock").where(MockRecord.customerId.lessThan(15L)).groupBy(MockRecord.customerZipcode).having(MockRecord.customerId.average().greaterThan(7.5));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            String zipcode = rs.getString(1);
            double idAvg = rs.getDouble(2);
            Assert.assertEquals((String)"even rows average more than 7.5", (Object)"12345", (Object)zipcode);
            Assert.assertEquals((String)"average of 8.0", (double)8.0, (double)idAvg, (double)0.0);
        }
        rs.close();
        Assert.assertEquals((String)"one row expected", (long)1L, (long)numRows);
    }

    @Test
    public void testLimit() {
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerId).from("mock").where(MockRecord.customerId.lessThan(15L)).limit(10);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            long custId = rs.getLong(1);
            Assert.assertTrue((String)"expected custId [1-10]", (custId <= 10L ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"expected 10 rows", (long)10L, (long)numRows);
        rs.close();
        query = engine.createQuery();
        query.select(MockRecord.customer).from("mock").where(MockRecord.customerId.lessThan(15L)).orderBy(MockRecord.customerId, Query.SortOrder.DESCENDING).limit(10);
        rs = engine.execute(query);
        numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertTrue((String)"expected custId 14-5", (cust.getId() >= 5L ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"expected 10 rows", (long)10L, (long)numRows);
        rs.close();
        query = engine.createQuery();
        query.select(MockRecord.customer).from("mock").where(MockRecord.customerId.lessThan(15L)).orderBy(MockRecord.customerId).limit(5, 5);
        rs = engine.execute(query);
        numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertTrue((String)"expected custId 6-10", (cust.getId() >= 6L && cust.getId() <= 10L ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"expected 5 rows", (long)5L, (long)numRows);
        rs.close();
    }

    @Test
    public void testQueryStats() {
        engine.setQueryStatGeneration(true);
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerId).from("mock").where(MockRecord.customerId.lessThan(15L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        Assert.assertEquals((String)"found 14 rows", (long)14L, (long)numRows);
        QueryPlan plan = rs.getPlan("mock");
        plan.getQueryStats().compute();
        List<? extends QueryPlan.Step> steps = plan.getSteps();
        QueryPlan.Step firstStep = steps.get(0);
        Assert.assertEquals((String)"start with full read", (Object)"FullRead", (Object)firstStep.getName());
        Assert.assertEquals((String)"start with 50 records", (long)50L, (long)firstStep.getLatencies().sample());
        for (int i = 1; i < steps.size(); ++i) {
            QueryPlan.Step step = steps.get(i);
            Assert.assertEquals((String)"continue with filter", (Object)"FilterImpl", (Object)step.getName());
            int sampleCount = (int)step.getLatencies().sample();
            Assert.assertTrue((String)"filter 14 to 50 records", (sampleCount >= 14 && sampleCount <= 50 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testKeyMapping() {
        IdxField dateField = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.attachment", Date.class, Customer.class);
        repo.createIndex(dateField, false);
        IdxNonUniqueIndex dateIndex = repo.getNonUniqueIndex(dateField);
        Iterable recordIds = dateIndex.get(now);
        MockRecord records = repo.retrieve((Integer)((Object)recordIds));
        int count = 0;
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            MockRecord record = (MockRecord)iterator.next();
            ++count;
        }
        Assert.assertEquals((String)"iterated all customers", (long)25L, (long)count);
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customerId).from("mock").where(dateField.equal(now));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((String)"query all customers", (long)25L, (long)count);
        repo.dropIndex(dateField);
        QueryAbstractField df = (QueryAbstractField)dateField;
        df.setKeyMapping(millis);
        repo.createIndex(dateField, false);
        IdxNonUniqueIndex millisIndex = repo.getNonUniqueIndex(dateField);
        recordIds = millisIndex.get(now);
        records = repo.retrieve((Integer)((Object)recordIds));
        count = 0;
        Iterator iterator2 = records.iterator();
        while (iterator2.hasNext()) {
            MockRecord record = (MockRecord)iterator2.next();
            ++count;
        }
        Assert.assertEquals((String)"iterated all customers", (long)25L, (long)count);
        query = engine.createQuery();
        query.select(MockRecord.customerId).from("mock").where(dateField.equal(now));
        rs = engine.execute(query);
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((String)"query all customers", (long)25L, (long)count);
        query = engine.createQuery();
        query.select(MockRecord.customerId).from("mock").where(dateField.lessThanOrEqual(now));
        rs = engine.execute(query);
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((String)"query all customers", (long)25L, (long)count);
        query = engine.createQuery();
        query.select(MockRecord.customerId).from("mock").where(dateField.between(now, now));
        rs = engine.execute(query);
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((String)"query all customers", (long)25L, (long)count);
        query = engine.createQuery();
        query.select(MockRecord.customerId).from("mock").where(dateField.lessThan(now));
        rs = engine.execute(query);
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((String)"query no customers", (long)0L, (long)count);
        repo.dropIndex(dateField);
    }

    @Test
    public void testDistinct() {
        Query<MockRecord> query = engine.createQuery().select(MockRecord.customerZipcode).from(repo);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        Assert.assertEquals((String)"25 records in repo", (long)25L, (long)rs.getQueryResult().size());
        query.distinct();
        rs = engine.execute(query);
        Assert.assertEquals((String)"2 distinct zipcodes", (long)2L, (long)rs.getQueryResult().size());
    }

    static {
        createIndexes = false;
        now = new Date();
        millis = new IdxField.KeyMapping<Date>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getIndexKeyType() {
                return Long.class;
            }

            protected Object doForward(Date date) {
                return date.getTime();
            }

            protected Date doBackward(Object millis) {
                return new Date((Long)millis);
            }
        };
    }
}

