/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.io.IOElasticBuffer;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.impl.EStoreReplicatorMemberLinkException;
import com.neeve.ods.impl.StoreMemberReplicationStatus;
import com.neeve.ods.impl.StoreReplicator;
import com.neeve.ods.impl.StoreReplicatorEventMultiplexer;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.types.PktBodyOdsBackupInitEnd;
import com.neeve.pkt.types.PktBodyOdsBackupInitStart;
import com.neeve.pkt.types.PktBodyOdsCommitAck;
import com.neeve.pkt.types.PktBodyOdsMemberConnectRequestReply;
import com.neeve.pkt.types.PktBodyOdsPrimaryBackupHello;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;

final class StoreReplicatorMember
extends OdsObject
implements IStoreMember {
    private final StoreReplicator replicator;
    private final String name;
    private final IDiscoveryEntity entity;
    private final UtlPool<StoreMemberReplicationStatus> replicationStatusPool;
    private final PktPacket commitAckPacket;
    private ILnkPeerEndpoint pep;
    private volatile State state;
    private boolean ready;

    private final IllegalStateException prepareStateValidationErrorException() {
        switch (this.state) {
            case Init: {
                return new IllegalStateException("member has not been opened");
            }
            case Open: {
                return new IllegalStateException("member is open");
            }
            case Failing: {
                return new IllegalStateException("member is failing");
            }
            case Failed: {
                return new IllegalStateException("member has failed");
            }
            case Closed: {
                return new IllegalStateException("member is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    StoreReplicatorMember(StoreReplicator replicator, String name, IDiscoveryEntity entity) {
        super(null);
        this.replicator = replicator;
        this.name = name;
        this.entity = entity;
        this.replicationStatusPool = UtlPool.create((String)"ods_repstat", (String)name, (UtlPool.Factory)new StoreMemberReplicationStatusFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
        try {
            this.commitAckPacket = PktFactory.getInstance().createPacket(761);
        }
        catch (EPktException e) {
            throw new InternalError("Failed to create commit ack packet [" + e.toString() + "]");
        }
        this.state = State.Init;
    }

    private final void sendMemberConnectRequestReply(PktPacket packet) throws EStoreReplicatorMemberLinkException {
        PktBodyOdsMemberConnectRequestReply body = (PktBodyOdsMemberConnectRequestReply)packet.getBody();
        IStoreBinding.Role role = this.replicator.getRole();
        if (role != null) {
            body.setRole(role == IStoreBinding.Role.Primary ? PktBodyOdsMemberConnectRequestReply.Role.Primary : PktBodyOdsMemberConnectRequestReply.Role.Backup);
        }
        body.setMemberName(this.replicator.getMemberName());
        try {
            this.pep.enque((short)-1, packet, null, 16);
        }
        catch (ELnkInvalidStateException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (ELnkOpFailedException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (Exception e) {
            InternalError error = new InternalError("Received fatal exception '" + e.toString() + "' when sending member connect reply (using synchronous flush)!");
            error.initCause(e);
            throw error;
        }
    }

    final void sendPrimaryBackupHello(PktPacket packet, long lastCommittedTransactionId) throws EStoreReplicatorMemberLinkException {
        PktBodyOdsPrimaryBackupHello body = (PktBodyOdsPrimaryBackupHello)packet.getBody();
        body.setLastCommittedTransactionId(lastCommittedTransactionId);
        try {
            this.pep.enque((short)-1, packet, null, 16);
        }
        catch (ELnkInvalidStateException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (ELnkOpFailedException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (Exception e) {
            InternalError error = new InternalError("Received fatal exception '" + e.toString() + "' when sending primary hello (using synchronous flush)!");
            error.initCause(e);
            throw error;
        }
        finally {
            packet.dispose();
        }
    }

    private final void sendMemberConnect() throws EStoreReplicatorMemberLinkException {
        this.sendMemberConnectRequestReply(PktFactory.getInstance().createPacket(756));
    }

    private final void sendMemberConnectReply() throws EStoreReplicatorMemberLinkException {
        this.sendMemberConnectRequestReply(PktFactory.getInstance().createPacket(757));
    }

    private final boolean isInitEntry(PktPacket packet) {
        PktSubheaderODS subheaderODS = packet.getHeader().getODSSubheader();
        if (subheaderODS != null) {
            return subheaderODS.getFlagCommitEntryInInit();
        }
        this.tracer.log(this.replicator.getTracePrefix() + "received corrupt packet [type=" + packet.getBody().getType() + "] from member '" + this.name + "' [no ODS subheader]. Discarding...", Tracer.Level.SEVERE);
        throw new IllegalStateException("corrupt packet [no ODS subheader]");
    }

    final void onPacket(PktPacket packet) {
        block0 : switch (this.state) {
            case Init: {
                switch (packet.getBody().getType()) {
                    case 757: {
                        this.replicator.handleMemberConnectReply(this, packet);
                        break block0;
                    }
                    case 762: {
                        this.replicator.handlePrimaryHello(this, packet);
                        break block0;
                    }
                }
                this.tracer.log(this.replicator.getTracePrefix() + "received packet '" + packet.getBody().getClass().getSimpleName() + " before member is opened. Fatal error. Failing member...", Tracer.Level.WARNING);
                this.fail(null);
                break;
            }
            case Open: {
                switch (packet.getBody().getType()) {
                    case 762: {
                        this.replicator.handlePrimaryHello(this, packet);
                        break block0;
                    }
                    case 763: {
                        this.replicator.handleBackupHello(this, packet);
                        break block0;
                    }
                    case 779: {
                        this.replicator.handleInitStart(this, packet);
                        break block0;
                    }
                    case 778: {
                        this.replicator.handleInitComplete(this, packet);
                        break block0;
                    }
                    case 759: {
                        if (this.isInitEntry(packet)) {
                            this.replicator.handleInitEntry(this, packet);
                            break block0;
                        }
                        this.replicator.handleCommitEntry(this, packet);
                        break block0;
                    }
                    case 761: {
                        this.replicator.handleCommitAck(this, packet);
                        break block0;
                    }
                }
                if (this.isInitEntry(packet)) {
                    this.replicator.handleInitEntry(this, packet);
                    break;
                }
                this.replicator.handleCommitEntry(this, packet);
                break;
            }
            default: {
                this.tracer.log(this.replicator.getTracePrefix() + "received packet after member '" + this.name + "' has closed or failed. Discarding packet...", Tracer.Level.WARNING);
            }
        }
    }

    final void setFailing() {
        if (this.state != State.Failed && this.state != State.Closed) {
            this.state = State.Failing;
        }
    }

    final void open(boolean active) throws OdsException {
        if (this.state == State.Init) {
            if (this.pep == null) {
                throw new InternalError("member link not set at the time of open!");
            }
            try {
                if (active) {
                    this.sendMemberConnect();
                }
                this.sendMemberConnectReply();
                this.state = State.Open;
            }
            catch (Exception e) {
                throw new OdsException("Failed to send member connect " + (active ? "" : "reply ") + "packet [" + e.toString() + "]");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    final State getState() {
        return this.state;
    }

    final IDiscoveryEntity getEntity() {
        return this.entity;
    }

    final void setLink(ILnkPeerEndpoint pep) {
        if (this.state != State.Init) {
            throw this.prepareStateValidationErrorException();
        }
        this.pep = pep;
    }

    final ILnkPeerEndpoint getLink() {
        return this.pep;
    }

    final void setOpen() {
        this.state = State.Open;
    }

    final void setReady() {
        this.ready = true;
    }

    final void clearReady() {
        this.ready = false;
    }

    final boolean isReady() {
        return this.ready;
    }

    final void sendPrimaryHello(long lastCommittedTransactionId) throws EStoreReplicatorMemberLinkException {
        this.sendPrimaryBackupHello(PktFactory.getInstance().createPacket(762), lastCommittedTransactionId);
    }

    final void sendBackupHello(long lastCommittedTransactionId) throws EStoreReplicatorMemberLinkException {
        this.sendPrimaryBackupHello(PktFactory.getInstance().createPacket(763), lastCommittedTransactionId);
    }

    final void sendBackupInitStart(PktBuffer persisterMetadata) throws EStoreReplicatorMemberLinkException {
        PktPacket packet = PktFactory.getInstance().createPacket(779);
        PktBodyOdsBackupInitStart body = (PktBodyOdsBackupInitStart)packet.getBody();
        PktSubheaderODS subheaderODS = packet.getHeader().activateODSSubheader(false);
        subheaderODS.copyObjectMetadataFrom(null);
        subheaderODS.copyPersisterMetadataFrom((IOElasticBuffer)persisterMetadata);
        PktSubheaderODS.prepare((PktPacket)packet, null, (short)0, (short)0, (short)0, (long)0L, (long)0L, (long)0L, (long)0L, (byte)-128);
        try {
            this.pep.enque((short)-1, packet, null, 16);
        }
        catch (ELnkInvalidStateException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (ELnkOpFailedException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (Exception e) {
            InternalError error = new InternalError("Received fatal exception '" + e.toString() + "' when sending primary hello (using synchronous flush)!");
            error.initCause(e);
            throw error;
        }
        finally {
            packet.getHeader().deactivateODSSubheader();
            packet.dispose();
        }
    }

    final void sendBackupInitEnd(long transactionId) throws EStoreReplicatorMemberLinkException {
        PktPacket packet = PktFactory.getInstance().createPacket(778);
        PktBodyOdsBackupInitEnd body = (PktBodyOdsBackupInitEnd)packet.getBody();
        PktSubheaderODS subheaderODS = packet.getHeader().activateODSSubheader(false);
        subheaderODS.copyObjectMetadataFrom(null);
        PktSubheaderODS.prepare((PktPacket)packet, null, (short)0, (short)0, (short)0, (long)0L, (long)0L, (long)0L, (long)0L, (byte)-128);
        body.setTransactionId(transactionId);
        try {
            this.pep.enque((short)-1, packet, null, 16);
        }
        catch (ELnkInvalidStateException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (ELnkOpFailedException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (Exception e) {
            InternalError error = new InternalError("Received fatal exception '" + e.toString() + "' when sending primary hello (using synchronous flush)!");
            error.initCause(e);
            throw error;
        }
        finally {
            packet.getHeader().deactivateODSSubheader();
            packet.dispose();
        }
    }

    final void sendCommitEntry(PktPacket packet, int flushFlags) throws EStoreReplicatorMemberLinkException {
        if (this.state == State.Open) {
            PktHeader header = packet.getHeader();
            header.setSrc(0);
            header.setSrcPort((short)0);
            header.setDest(0);
            header.setDestPort((short)0);
            try {
                this.pep.enque((short)-1, packet, null, flushFlags);
            }
            catch (ELnkInvalidStateException e) {
                throw new EStoreReplicatorMemberLinkException(e);
            }
            catch (ELnkOpFailedException e) {
                throw new EStoreReplicatorMemberLinkException(e);
            }
            catch (Exception e) {
                InternalError error = new InternalError("Received fatal exception '" + e.toString() + "' when sending packet to member!");
                error.initCause(e);
                throw error;
            }
        } else if (this.state != State.Failing && this.state != State.Failed) {
            throw this.prepareStateValidationErrorException();
        }
    }

    final long sendCommitAck(long transactionId) throws EStoreReplicatorMemberLinkException {
        ((PktBodyOdsCommitAck)this.commitAckPacket.getBody()).setTransactionId(transactionId);
        try {
            this.pep.enque((short)-1, this.commitAckPacket, null, 16);
            return this.commitAckPacket.getOutTs();
        }
        catch (ELnkInvalidStateException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (ELnkOpFailedException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
        catch (Exception e) {
            InternalError error = new InternalError("Received fatal exception '" + e.toString() + "' when sending commit ack (using synchronous flush)!");
            error.initCause(e);
            throw error;
        }
    }

    final void flush() throws EStoreReplicatorMemberLinkException {
        if (this.state == State.Open) {
            try {
                this.pep.flush((short)-1, null);
            }
            catch (ELnkInvalidStateException e) {
                throw new EStoreReplicatorMemberLinkException(e);
            }
            catch (ELnkOpFailedException e) {
                throw new EStoreReplicatorMemberLinkException(e);
            }
            catch (Exception e) {
                InternalError error = new InternalError("Received fatal exception '" + e.toString() + "' when flushing member link (using synchronous flush)!");
                error.initCause(e);
                throw error;
            }
        } else if (this.state != State.Failing && this.state != State.Failed) {
            throw this.prepareStateValidationErrorException();
        }
    }

    final void close() {
        if (this.state != State.Closed) {
            try {
                if (this.pep != null) {
                    try {
                        this.pep.close((short)-1);
                    }
                    catch (ELnkOpFailedException e) {
                        this.tracer.log(this.replicator.getTracePrefix() + "failed to close member link [member='" + this.getName() + "', exception=" + e.toString() + "].", Tracer.Level.WARNING);
                    }
                }
            }
            finally {
                this.state = State.Closed;
                this.replicationStatusPool.close();
            }
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final StoreMemberReplicationStatus createReplicationStatus() {
        return (StoreMemberReplicationStatus)this.replicationStatusPool.get(null);
    }

    @Override
    public final void fail(Throwable cause) {
        if (this.state != State.Closed) {
            StoreReplicatorEventMultiplexer eventMultiplexer = this.replicator.getEventMultiplexer();
            if (eventMultiplexer.getDispatcherThread() == Thread.currentThread()) {
                if (this.state != State.Failed) {
                    this.tracer.log(this.replicator.getTracePrefix() + "dispatching member down for processing...", Tracer.Level.VERBOSE);
                    this.replicator.handleEntityDown(this.getEntity(), "memberFail");
                    this.state = State.Failed;
                } else {
                    this.tracer.log(this.replicator.getTracePrefix() + "member down already dispatched.", Tracer.Level.VERBOSE);
                }
            } else {
                eventMultiplexer.scheduleMemberFail(this);
            }
        }
    }

    public final String toString() {
        return this.name;
    }

    static enum State {
        Init,
        Open,
        Failing,
        Failed,
        Closed;

    }

    private final class StoreMemberReplicationStatusFactory
    implements UtlPool.Factory<StoreMemberReplicationStatus> {
        private StoreMemberReplicationStatusFactory() {
        }

        public final StoreMemberReplicationStatus createItem(Object object) {
            return new StoreMemberReplicationStatus(StoreReplicatorMember.this);
        }

        public final StoreMemberReplicationStatus[] createItemArray(int size) {
            return new StoreMemberReplicationStatus[size];
        }
    }
}

