/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.kafka;

import com.neeve.ci.XRuntime;
import com.neeve.event.IEventHandler;
import com.neeve.kafka.KafkaBindingConstants;
import com.neeve.kafka.KafkaMessageChannel;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.pkt.PktBuffer;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPlist;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public final class KafkaMessageBusBinding
extends MessageBusBindingBase {
    private final RebalanceListener rebalanceListener = new RebalanceListener();
    private final ProducerCallback producerCallback = new ProducerCallback();
    private String consumerCpuAffinityMask;
    private boolean autoAck;
    private int ackFrequency;
    private boolean flushOnSend;
    private UtlList sendContextList;
    private KafkaProducer<byte[], byte[]> producer;
    private KafkaConsumer<byte[], byte[]> consumer;
    private Poller poller;

    protected KafkaMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(null, userName, descriptor, eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OutstandingSendContext createOutstandingSendContext(KafkaMessageChannel sender, MessageView view) {
        OutstandingSendContext sendContext = new OutstandingSendContext();
        sendContext.sender = sender;
        sendContext.view = view;
        UtlList utlList = this.sendContextList;
        synchronized (utlList) {
            this.sendContextList.append((UtlListElement)sendContext);
        }
        return sendContext;
    }

    private final byte[] serialize(MessageMetadata metadata) {
        PktBuffer buffer = metadata.getBuffer();
        byte[] bytes = new byte[buffer.getLength()];
        buffer.getTo(0, bytes, 0, bytes.length);
        return bytes;
    }

    private final MessageMetadata deserialize(byte[] bytes) {
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        try {
            metadata.deserialize(ByteBuffer.wrap(bytes));
            return metadata;
        }
        catch (SmaException e) {
            throw new RuntimeException(e);
        }
    }

    final void subscribe(KafkaMessageChannel channel, String topic) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Subscribing to topic '" + topic + "' [channel=" + channel.getName() + "]", Tracer.Level.DEBUG);
        }
        if (topic.indexOf(42) >= 0 || topic.indexOf(62) >= 0) {
            throw new SmaPermanentException("Invalid subscription '" + topic + " ... Kafka does not support wildcard subscriptions ... an explicit channel filter is required for channel '" + channel.getName() + "'.");
        }
        SubscribeOperation subscribe = new SubscribeOperation(channel, topic);
        try {
            this.poller.enqueueOperation(subscribe);
            subscribe.get(60, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SmaException) {
                throw (SmaException)e.getCause();
            }
            throw new SmaException(this.tracePrefix + "Error subscribing to topic '" + topic + "' on channel '" + channel.getName() + "' [" + e.getMessage() + "]", (Throwable)e);
        }
        catch (Throwable t) {
            throw new SmaException(this.tracePrefix + "Error subscribing to topic '" + topic + "' on channel '" + channel.getName() + "' [" + t.getMessage() + "]", t);
        }
    }

    final void unsubscribe(KafkaMessageChannel channel, String topic) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Unsubscribing from topic '" + topic + "' [channel=" + channel.getName() + "]", Tracer.Level.DEBUG);
        }
        if (topic.indexOf(42) >= 0 || topic.indexOf(62) >= 0) {
            throw new SmaPermanentException("Invalid subscription '" + topic + " ... Kafka does not support wildcard subscriptionss ... an explicit channel filter is required for channel '" + channel.getName() + "'.");
        }
        UnsubscribeOperation unsubscribe = new UnsubscribeOperation(channel, topic);
        try {
            this.poller.enqueueOperation(unsubscribe);
            unsubscribe.get(60, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SmaException) {
                throw (SmaException)e.getCause();
            }
            throw new SmaException(this.tracePrefix + "Error unsubscribing from topic '" + topic + "' on channel '" + channel.getName() + "' [" + e.getMessage() + "]", (Throwable)e);
        }
        catch (Throwable t) {
            throw new SmaException(this.tracePrefix + "Error unsubscribing from topic '" + topic + "' on channel '" + channel.getName() + "' [" + t.getMessage() + "]", t);
        }
    }

    final boolean send(KafkaMessageChannel sender, MessageView view, MessageMetadata metadata, byte[] value, String topic, MessageChannel.Qos qos, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        boolean retval;
        long preWireTs;
        byte[] key = this.serialize(metadata);
        this.createOutstandingSendContext(sender, (MessageView)(qos == MessageChannel.Qos.Guaranteed ? view : null));
        long l = preWireTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Sending message [" + topic + ", " + key.length + ", " + value.length + ", " + qos + "]...", Tracer.Level.DEBUG);
        }
        this.producer.send(new ProducerRecord(topic, (Object)key, (Object)value), (Callback)this.producerCallback);
        if (this.flushOnSend || (flags & 1) == 1) {
            this.doFlush(flushContext);
            retval = true;
        } else {
            retval = this.populateFlushContext(flushContext, false);
        }
        if (MessageLatencyManager.captureMsgLatencyStats && view != null) {
            view.setPostWireSendTs(UtlTime.now());
            view.setPreWireTs(preWireTs);
            if (this.latencyManager != null) {
                this.latencyManager.update(view, MessageLatencyManager.MessagingDirection.Outbound);
            }
        }
        return retval;
    }

    final boolean markAsComplete(MessageBusBinding.FlushContext flushContext) {
        if (flushContext != null) {
            switch (flushContext.flushMode) {
                case SYNC_BLOCKING: {
                    MessageBusBinding.SynchronousBlockingFlushContext syncBlockingFlushContext = (MessageBusBinding.SynchronousBlockingFlushContext)flushContext;
                    syncBlockingFlushContext.complete = true;
                    break;
                }
                case SYNC_NON_BLOCKING: {
                    MessageBusBinding.SynchronousNonBlockingFlushContext syncNonBlockingFlushContext = (MessageBusBinding.SynchronousNonBlockingFlushContext)flushContext;
                    syncNonBlockingFlushContext.complete = true;
                    break;
                }
                case ASYNC: {
                    MessageBusBinding.AsynchronousFlushContext asyncFlushContext = (MessageBusBinding.AsynchronousFlushContext)flushContext;
                    asyncFlushContext.inProgress = false;
                    asyncFlushContext.syncComplete = true;
                    asyncFlushContext.status = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported flush mode '" + flushContext.flushMode + "'");
                }
            }
        }
        return true;
    }

    final boolean populateFlushContext(MessageBusBinding.FlushContext flushContext, boolean flushed) {
        if (flushContext != null) {
            switch (flushContext.flushMode) {
                case SYNC_BLOCKING: {
                    MessageBusBinding.SynchronousBlockingFlushContext syncBlockingFlushContext = (MessageBusBinding.SynchronousBlockingFlushContext)flushContext;
                    syncBlockingFlushContext.complete = flushed;
                    break;
                }
                case SYNC_NON_BLOCKING: {
                    MessageBusBinding.SynchronousNonBlockingFlushContext syncNonBlockingFlushContext = (MessageBusBinding.SynchronousNonBlockingFlushContext)flushContext;
                    syncNonBlockingFlushContext.complete = flushed;
                    break;
                }
                case ASYNC: {
                    MessageBusBinding.AsynchronousFlushContext asyncFlushContext = (MessageBusBinding.AsynchronousFlushContext)flushContext;
                    asyncFlushContext.inProgress = false;
                    asyncFlushContext.syncComplete = flushed;
                    asyncFlushContext.status = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported flush mode '" + flushContext.flushMode + "'");
                }
            }
        }
        return flushed;
    }

    final void onChannelClose(KafkaMessageChannel channel) {
    }

    protected final void doOpen() throws SmaException {
        this.sendContextList = UtlList.create();
        Properties providerConfig = this.descriptor.getProviderConfig();
        this.autoAck = UtlProps.getValue((Properties)providerConfig, (String)"auto_ack", (boolean)false);
        this.ackFrequency = UtlProps.getValue((Properties)providerConfig, (String)"ack_frequency", (int)0);
        this.consumerCpuAffinityMask = UtlProps.getValue((Properties)providerConfig, (String)"consumer_cpu_affinity_mask", (String)"0");
        this.flushOnSend = UtlProps.getValue((Properties)providerConfig, (String)"flush_on_send", (boolean)false);
        Properties providedProducerProps = new Properties();
        Properties providedConsumerProps = new Properties();
        for (Map.Entry<Object, Object> prop : providerConfig.entrySet()) {
            String propName = String.valueOf(prop.getKey()).replace('_', '.');
            if (propName.startsWith("producer.")) {
                providedProducerProps.put(propName.substring(9), prop.getValue());
                continue;
            }
            if (!propName.startsWith("consumer.")) continue;
            providedConsumerProps.put(propName.substring(9), prop.getValue());
        }
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", UtlProps.getValue((Properties)providerConfig, (String)"Address", (String)"localhost:9092"));
        producerProps.put("acks", "all");
        producerProps.put("retries", "0");
        producerProps.put("batch.size", String.valueOf(XRuntime.optimizeForLatency() ? 1 : 16384));
        producerProps.put("linger.ms", "1");
        producerProps.put("buffer.memory", "33554432");
        producerProps.putAll((Map<?, ?>)providedProducerProps);
        this.tracer.log(this.tracePrefix + "Producer configuration...", Tracer.Level.CONFIG);
        Enumeration<?> enumeration = producerProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String val = producerProps.getProperty(key);
            if (key.toLowerCase().contains("password")) {
                this.tracer.log(this.tracePrefix + "..." + key + "=<sanitized>", Tracer.Level.CONFIG);
                continue;
            }
            this.tracer.log(this.tracePrefix + "..." + key + "=" + val, Tracer.Level.CONFIG);
        }
        this.producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", UtlProps.getValue((Properties)providerConfig, (String)"Address", (String)"localhost:9092"));
        consumerProps.put("group.id", "X-SMA-" + this.getName() + "-" + this.getUserName());
        consumerProps.put("auto.offset.reset", "latest");
        if (this.autoAck) {
            consumerProps.put("enable.auto.commit", "true");
            consumerProps.put("auto.commit.interval.ms", String.valueOf(this.ackFrequency));
        } else {
            consumerProps.put("enable.auto.commit", "false");
        }
        consumerProps.putAll((Map<?, ?>)providedConsumerProps);
        this.tracer.log(this.tracePrefix + "Consumer configuration...", Tracer.Level.CONFIG);
        enumeration = consumerProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String val = consumerProps.getProperty(key);
            if (key.toLowerCase().contains("password")) {
                this.tracer.log(this.tracePrefix + "..." + key + "=<sanitized>", Tracer.Level.CONFIG);
                continue;
            }
            this.tracer.log(this.tracePrefix + "..." + key + "=" + val, Tracer.Level.CONFIG);
        }
        this.autoAck = UtlProps.getValue((Properties)providerConfig, (String)"enable.auto.commit", (boolean)false);
        this.consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.poller = new Poller();
    }

    protected final MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Creating new channel '" + descriptor.getName() + "'.", Tracer.Level.DEBUG);
        }
        return new KafkaMessageChannel(descriptor, this);
    }

    protected final void doStart() throws SmaException {
        if (this.consumer.subscription().size() > 0) {
            this.poller.start();
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Poller started successfully.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Not starting poller [no subscriptions].", Tracer.Level.DEBUG);
        }
    }

    protected void doFlush(MessageBusBinding.FlushContext flushContext) throws SmaException {
        this.producer.flush();
        this.populateFlushContext(flushContext, true);
    }

    protected final boolean doCanFail() {
        return true;
    }

    protected final boolean doAcksRequireFlush() {
        return false;
    }

    protected final void doClose() {
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
        if (this.poller != null) {
            this.poller.shutdown();
            while (true) {
                try {
                    this.poller.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.poller = null;
        }
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
    }

    public final void getStats(StringBuilder buffer) {
        KafkaConsumer<byte[], byte[]> consumer;
        KafkaProducer<byte[], byte[]> producer = this.producer;
        if (producer != null) {
            buffer.append("Producer {\n");
            for (Metric metric : producer.metrics().values()) {
                buffer.append("...").append(metric.metricName().name()).append("=").append(metric.metricValue()).append("\n");
            }
            buffer.append("}\n");
        }
        if ((consumer = this.consumer) != null) {
            buffer.append("Consumer {\n");
            for (Metric metric : consumer.metrics().values()) {
                buffer.append("...").append(metric.metricName().name()).append("=").append(metric.metricValue()).append("\n");
            }
            buffer.append("}");
        }
    }

    final class KafkaAcknowledger
    extends MessageBusBindingBase.Acknowledger<KafkaAcknowledger> {
        private volatile boolean acked;
        AcknowledgeOperation ackOperation;

        KafkaAcknowledger(String topic, int partition, long offset) {
            super((MessageBusBindingBase)KafkaMessageBusBinding.this);
            this.acked = false;
            this.ackOperation = new AcknowledgeOperation();
            this.ackOperation.topicPartition = new TopicPartition(topic, partition);
            this.ackOperation.offset = new OffsetAndMetadata(offset + 1L);
        }

        protected final void doAck() {
            block2: {
                this.acked = true;
                try {
                    KafkaMessageBusBinding.this.poller.enqueueOperation(this.ackOperation);
                }
                catch (IllegalStateException ise) {
                    if (!((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) break block2;
                    KafkaMessageBusBinding.this.tracer.log("Ignoring acknowledgement failure for " + this.ackOperation + " (binding closed)", Tracer.Level.DEBUG);
                }
            }
        }

        protected final void doReset() {
        }

        public final String toString() {
            return KafkaMessageBusBinding.this.tracePrefix + "::" + this.ackOperation;
        }
    }

    private final class Poller
    extends Thread {
        private final AtomicBoolean closed;
        private final AtomicBoolean started;
        private final ConsumerContext context;
        private final LinkedBlockingDeque<ConsumerOperation<?>> operationQueue;

        private Poller() {
            super("X-SMA-KafkaPoller-" + KafkaMessageBusBinding.this.getName() + "-" + KafkaMessageBusBinding.this.getUserName());
            this.closed = new AtomicBoolean(false);
            this.started = new AtomicBoolean(false);
            this.context = new ConsumerContext();
            this.operationQueue = new LinkedBlockingDeque(10240);
        }

        final void shutdown() {
            this.closed.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            block28: {
                this.started.set(true);
                UtlThread.setCPUAffinityMask((String)KafkaMessageBusBinding.this.consumerCpuAffinityMask);
                try {
                    long lastCommitTs = System.currentTimeMillis();
                    while (!this.closed.get()) {
                        long now;
                        block27: {
                            ConsumerRecords records;
                            if (KafkaMessageBusBinding.this.consumer.subscription().isEmpty() || KafkaMessageBusBinding.this.getState() != MessageBusBinding.State.Open) {
                                try {
                                    ConsumerOperation<?> task = this.operationQueue.poll(100L, TimeUnit.MILLISECONDS);
                                    if (task == null) break block27;
                                    task.run();
                                    break block27;
                                }
                                catch (InterruptedException e) {
                                    break;
                                }
                            }
                            try {
                                records = KafkaMessageBusBinding.this.consumer.poll(100L);
                            }
                            catch (WakeupException we) {
                                continue;
                            }
                            if (!records.isEmpty()) {
                                long postWireTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
                                for (ConsumerRecord record : records) {
                                    try {
                                        MessageTransportHeaders transportHeaders;
                                        KafkaAcknowledger acknowledger;
                                        byte[] serializedMetadata = (byte[])record.key();
                                        byte[] serializedMessage = (byte[])record.value();
                                        String topic = record.topic();
                                        if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                                            KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Received message [" + topic + ", offset: " + record.offset() + ", partition: " + record.partition() + ", metadatalen: " + (serializedMetadata != null ? Integer.valueOf(serializedMetadata.length) : "0") + ", payloadlen: " + (serializedMessage != null ? Integer.valueOf(serializedMessage.length) : "0") + "]...", Tracer.Level.DEBUG);
                                        }
                                        KafkaAcknowledger kafkaAcknowledger = acknowledger = !KafkaMessageBusBinding.this.autoAck ? new KafkaAcknowledger(topic, record.partition(), record.offset()) : null;
                                        if (acknowledger != null) {
                                            this.context.onReceipt(acknowledger);
                                        }
                                        MessageMetadata metadata = KafkaMessageBusBinding.this.deserialize(serializedMetadata);
                                        if (KafkaMessageBusBinding.this.enableInboundTransportHeaders) {
                                            transportHeaders = MessageTransportHeaders.create();
                                            transportHeaders.addHeader(KafkaBindingConstants.TRANSPORT_HEADER_PARTITION, record.partition());
                                            transportHeaders.addHeader(KafkaBindingConstants.TRANSPORT_HEADER_OFFSET, record.offset());
                                            transportHeaders.addHeader(KafkaBindingConstants.TRANSPORT_HEADER_TIMESTAMP, record.timestamp());
                                        } else {
                                            transportHeaders = null;
                                        }
                                        try {
                                            KafkaMessageChannel channel = (KafkaMessageChannel)KafkaMessageBusBinding.this.findMessageChannelForInboundMessageDispatch(metadata.getMessageChannelNameAsRaw(), metadata.getMessageChannelId());
                                            if (channel != null) {
                                                if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                                                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Dispatching message sent on channel '" + metadata.getMessageChannelName() + "' via channel '" + channel.getName() + "'.", Tracer.Level.DEBUG);
                                                }
                                                try {
                                                    channel.onMessage(serializedMessage, metadata, transportHeaders, topic, acknowledger, postWireTs);
                                                }
                                                catch (Throwable e) {
                                                    if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                                                        KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Fault in handling of inbound message by channel [" + e.toString() + "].", Tracer.Level.DEBUG);
                                                    }
                                                    KafkaMessageBusBinding.this.onInboundMessageHandlingFault(record.partition() + ":" + record.offset(), topic, metadata, record, serializedMetadata, serializedMessage, acknowledger, (Throwable)new SmaException("Fault in handling of inbound message by channel [offset=" + record.offset() + ", topic=" + topic + "]: " + e.getMessage(), e));
                                                }
                                                continue;
                                            }
                                            SmaException channelNotFoundException = new SmaException(KafkaMessageBusBinding.this.tracePrefix + "Channel (name=" + metadata.getMessageChannelName() + ", id=" + metadata.getMessageChannelId() + ") not found (or not joined) for inbound message with [id=" + record.offset() + ", topic=" + topic + "].");
                                            if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                                                KafkaMessageBusBinding.this.tracer.log(channelNotFoundException.getMessage(), Tracer.Level.DEBUG);
                                            }
                                            KafkaMessageBusBinding.this.onInboundMessageHandlingFault(record.partition() + ":" + record.offset(), topic, metadata, record, serializedMetadata, serializedMessage, acknowledger, (Throwable)channelNotFoundException);
                                        }
                                        finally {
                                            metadata.dispose();
                                            if (transportHeaders != null) {
                                                transportHeaders.dispose();
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        KafkaMessageBusBinding.this.onInboundMessageHandlingFault(record.partition() + ":" + record.offset(), record.topic(), null, record, (byte[])record.key(), (byte[])record.value(), null, (Throwable)new SmaException("Fault in unmarshalling of inbound message [offset=" + record.offset() + ", topic=" + record.topic() + "]: " + e.getMessage(), e));
                                    }
                                }
                            }
                        }
                        this.processQueuedOperations();
                        if (KafkaMessageBusBinding.this.autoAck || (now = System.currentTimeMillis()) - lastCommitTs < (long)KafkaMessageBusBinding.this.ackFrequency) continue;
                        this.context.commitProcessedOffsets(false);
                        lastCommitTs = now;
                    }
                }
                catch (WakeupException e) {
                    if (this.closed.get()) break block28;
                    throw e;
                }
            }
            if (!KafkaMessageBusBinding.this.autoAck && this.closed.get()) {
                this.processQueuedOperations();
                this.context.commitAllProcessedOffsets();
            }
        }

        private final void processQueuedOperations() {
            ConsumerOperation<?> operation = null;
            while ((operation = this.operationQueue.pollFirst()) != null) {
                if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Running consumer operation: " + operation, Tracer.Level.DEBUG);
                }
                operation.run();
            }
        }

        final void enqueueOperation(ConsumerOperation<?> operation) {
            if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Queueing consumer operation: " + operation, Tracer.Level.DEBUG);
            }
            if (!this.started.get()) {
                operation.run();
            } else if (!this.closed.get()) {
                this.operationQueue.offer(operation);
            } else {
                throw new IllegalStateException("Binding Closed");
            }
        }
    }

    private final class ConsumerContext {
        private final Map<TopicPartition, PartitionOffsetTracker> trackedOffsets = new XLinkedHashMap();
        private final Map<TopicPartition, OffsetAndMetadata> offsetsToCommit = new XLinkedHashMap();

        private ConsumerContext() {
        }

        public final void onReceipt(KafkaAcknowledger acknowledger) {
            PartitionOffsetTracker offsetTracker = this.trackedOffsets.get(acknowledger.ackOperation.topicPartition);
            if (offsetTracker == null) {
                offsetTracker = new PartitionOffsetTracker();
                offsetTracker.offset = -1L;
                offsetTracker.pendingAcks.append((Object)acknowledger);
                this.trackedOffsets.put(acknowledger.ackOperation.topicPartition, offsetTracker);
            } else {
                offsetTracker.pendingAcks.append((Object)acknowledger);
            }
        }

        public void onUnsubscribe(HashSet<TopicPartition> partitionsToLeave) {
            Map endOffsets = KafkaMessageBusBinding.this.consumer.endOffsets(partitionsToLeave);
            for (Map.Entry e : endOffsets.entrySet()) {
                PartitionOffsetTracker offsetTracker = this.trackedOffsets.get(e.getKey());
                if (offsetTracker != null) {
                    offsetTracker.offset = (Long)e.getValue();
                }
                this.offsetsToCommit.put((TopicPartition)e.getKey(), new OffsetAndMetadata(((Long)e.getValue()).longValue()));
            }
            if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Setting offsets on unsubscribe: leaving: " + partitionsToLeave + " offsets: " + this.offsetsToCommit, Tracer.Level.DEBUG);
            }
            this.commitAllProcessedOffsets();
        }

        public final void onAck(TopicPartition topicPartition, OffsetAndMetadata offset) {
            if (KafkaMessageBusBinding.this.checked && Thread.currentThread() != KafkaMessageBusBinding.this.poller) {
                throw new IllegalStateException("Attempt to record topic offsets on non-poller thread [" + Thread.currentThread().getName() + "]");
            }
            PartitionOffsetTracker offsetTracker = this.trackedOffsets.get(topicPartition);
            if (offsetTracker != null) {
                OffsetAndMetadata offsetToCommit = null;
                UtlPlist.Element ackElement = offsetTracker.pendingAcks.first();
                if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Processing ack on " + topicPartition + ":" + offset.offset(), Tracer.Level.DEBUG);
                }
                while (ackElement != null) {
                    KafkaAcknowledger acknowledger = (KafkaAcknowledger)((Object)ackElement.getObject());
                    if (acknowledger.ackOperation.offset.offset() > offset.offset()) {
                        if (!((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) break;
                        KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Done (reached offset " + acknowledger.ackOperation.offset.offset() + ")", Tracer.Level.DEBUG);
                        break;
                    }
                    if (!acknowledger.acked) {
                        if (!((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.fine) break;
                        KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Out of order ack detected: " + topicPartition + " was acked at offset " + offset + " but " + acknowledger.ackOperation.offset + " is still unacked", Tracer.Level.FINE);
                        break;
                    }
                    OffsetAndMetadata ackedOffset = acknowledger.ackOperation.offset;
                    if (ackedOffset.offset() > offsetTracker.offset) {
                        offsetToCommit = ackedOffset;
                    }
                    if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                        KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Unlinking offset " + acknowledger.ackOperation.offset.offset() + " (update=" + offsetToCommit + ", current=" + offsetTracker.offset + ")", Tracer.Level.DEBUG);
                    }
                    ackElement.unlink();
                    ackElement = offsetTracker.pendingAcks.first();
                }
                if (offsetToCommit != null) {
                    if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                        KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Updating commit offset to " + offsetToCommit.offset(), Tracer.Level.DEBUG);
                    }
                    offsetTracker.offset = offsetToCommit.offset();
                    this.offsetsToCommit.put(topicPartition, offsetToCommit);
                } else if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "No commit offset update", Tracer.Level.DEBUG);
                }
            } else if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                KafkaMessageBusBinding.this.tracer.log("Offset tracker for " + topicPartition + " not found on ack", Tracer.Level.DEBUG);
            }
        }

        public final void commitProcessedOffsets(boolean sync) {
            if (this.offsetsToCommit.size() > 0) {
                if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Committing offsets (count=" + this.offsetsToCommit.size() + ", sync=" + sync + ")", Tracer.Level.DEBUG);
                    for (Map.Entry<TopicPartition, OffsetAndMetadata> e : this.offsetsToCommit.entrySet()) {
                        KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Committing Ack for " + e.getKey() + ":" + e.getValue().offset(), Tracer.Level.DEBUG);
                    }
                }
                if (sync) {
                    KafkaMessageBusBinding.this.consumer.commitSync(this.offsetsToCommit);
                } else {
                    KafkaMessageBusBinding.this.consumer.commitAsync(this.offsetsToCommit, null);
                }
                this.offsetsToCommit.clear();
            }
        }

        public void commitAllProcessedOffsets() {
            for (Map.Entry<TopicPartition, PartitionOffsetTracker> e : this.trackedOffsets.entrySet()) {
                if (e.getValue().offset <= 0L) continue;
                KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Committing Ack for " + e.getKey() + ":" + e.getValue().offset, Tracer.Level.DEBUG);
                this.offsetsToCommit.put(e.getKey(), new OffsetAndMetadata(e.getValue().offset));
            }
            for (int i = 0; i < 5; ++i) {
                try {
                    KafkaMessageBusBinding.this.consumer.commitSync(this.offsetsToCommit);
                    this.offsetsToCommit.clear();
                    break;
                }
                catch (WakeupException we) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
    }

    private final class PartitionOffsetTracker {
        UtlPlist<KafkaAcknowledger> pendingAcks = UtlPlist.create();
        long offset;

        private PartitionOffsetTracker() {
        }
    }

    private final class AcknowledgeOperation
    extends ConsumerOperation<Void> {
        TopicPartition topicPartition;
        OffsetAndMetadata offset;

        AcknowledgeOperation() {
        }

        @Override
        Void execute() throws Exception {
            KafkaMessageBusBinding.this.poller.context.onAck(this.topicPartition, this.offset);
            return null;
        }

        public final String toString() {
            return "ACK[topic='" + this.topicPartition + "', offset='" + this.offset.offset() + "']";
        }
    }

    private final class UnsubscribeOperation
    extends ConsumerOperation<Void> {
        final KafkaMessageChannel channel;
        final String topic;

        UnsubscribeOperation(KafkaMessageChannel channel, String topic) {
            this.channel = channel;
            this.topic = topic;
        }

        @Override
        Void execute() throws Exception {
            HashSet subscriptions = new HashSet(KafkaMessageBusBinding.this.consumer.subscription());
            HashSet<TopicPartition> partitionsToLeave = new HashSet<TopicPartition>();
            for (TopicPartition partition : KafkaMessageBusBinding.this.consumer.assignment()) {
                if (!partition.topic().equals(this.topic)) continue;
                partitionsToLeave.add(partition);
            }
            if (!partitionsToLeave.isEmpty()) {
                KafkaMessageBusBinding.this.poller.context.onUnsubscribe(partitionsToLeave);
            }
            subscriptions.remove(this.topic);
            KafkaMessageBusBinding.this.consumer.subscribe(subscriptions, (ConsumerRebalanceListener)KafkaMessageBusBinding.this.rebalanceListener);
            return null;
        }

        public final String toString() {
            return "UNSUBSCRIBE[topic='" + this.topic + "', channel='" + this.channel.getName() + "']";
        }
    }

    private final class SubscribeOperation
    extends ConsumerOperation<Void> {
        final KafkaMessageChannel channel;
        final String topic;

        SubscribeOperation(KafkaMessageChannel channel, String topic) {
            this.channel = channel;
            this.topic = topic;
        }

        @Override
        Void execute() throws Exception {
            HashSet<String> subscriptions = new HashSet<String>(KafkaMessageBusBinding.this.consumer.subscription());
            subscriptions.add(this.topic);
            KafkaMessageBusBinding.this.consumer.subscribe(subscriptions, (ConsumerRebalanceListener)KafkaMessageBusBinding.this.rebalanceListener);
            return null;
        }

        public final String toString() {
            return "SUBSCRIBE[topic='" + this.topic + "', channel='" + this.channel.getName() + "']";
        }
    }

    private abstract class ConsumerOperation<R>
    implements Runnable {
        private final FutureTask<R> task = new FutureTask(new Callable<R>(){

            @Override
            public final R call() throws Exception {
                return ConsumerOperation.this.execute();
            }
        });

        private ConsumerOperation() {
        }

        @Override
        public final void run() {
            this.task.run();
        }

        public R get(int timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException, ExecutionException {
            return this.task.get(timeout, timeUnit);
        }

        abstract R execute() throws Exception;
    }

    private final class RebalanceListener
    implements ConsumerRebalanceListener {
        private RebalanceListener() {
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                for (TopicPartition partition : partitions) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Partition revoked: " + partition, Tracer.Level.DEBUG);
                }
            }
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            Map partitionBeginningOffsets = KafkaMessageBusBinding.this.consumer.beginningOffsets(partitions);
            Map partitionEndOffsets = KafkaMessageBusBinding.this.consumer.endOffsets(partitions);
            XLinkedHashMap offsetsToCommit = new XLinkedHashMap();
            for (TopicPartition partition : partitions) {
                OffsetAndMetadata offset = KafkaMessageBusBinding.this.consumer.committed(partition);
                if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Partition assigned " + partition, Tracer.Level.DEBUG);
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "...beg offset " + partitionBeginningOffsets.get(partition), Tracer.Level.DEBUG);
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "...end offset " + partitionEndOffsets.get(partition), Tracer.Level.DEBUG);
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "...com offset " + (offset != null ? offset.offset() : -1L), Tracer.Level.DEBUG);
                }
                if (offset != null && offset.offset() >= (Long)partitionBeginningOffsets.get(partition)) continue;
                offsetsToCommit.put(partition, new OffsetAndMetadata(((Long)partitionBeginningOffsets.get(partition)).longValue()));
            }
            if (offsetsToCommit.size() > 0) {
                if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Initializing committed offsets for partitions with no committed offsets (count=" + offsetsToCommit.size() + ")...", Tracer.Level.DEBUG);
                }
                KafkaMessageBusBinding.this.consumer.commitSync((Map)offsetsToCommit);
                if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Done", Tracer.Level.DEBUG);
                }
            }
        }
    }

    private final class ProducerCallback
    implements Callback {
        private ProducerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onCompletion(RecordMetadata metadata, Exception exception) {
            OutstandingSendContext sendContext;
            UtlList utlList = KafkaMessageBusBinding.this.sendContextList;
            synchronized (utlList) {
                sendContext = (OutstandingSendContext)KafkaMessageBusBinding.this.sendContextList.first();
                sendContext.unlink();
            }
            if (exception != null) {
                if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                    KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Received send completion failure [" + exception + "]", Tracer.Level.DEBUG);
                }
            } else if (((KafkaMessageBusBinding)KafkaMessageBusBinding.this).tracer.debug) {
                KafkaMessageBusBinding.this.tracer.log(KafkaMessageBusBinding.this.tracePrefix + "Received send completion success [" + this.toString(metadata) + "]", Tracer.Level.DEBUG);
            }
            if (sendContext.view != null) {
                sendContext.sender.onAckNack(sendContext.view, exception);
            }
        }

        private final String toString(RecordMetadata metadata) {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(metadata.topic()).append(",").append(metadata.partition()).append(",").append(metadata.serializedKeySize()).append(",").append(metadata.serializedValueSize()).append(",").append(metadata.offset()).append("]");
            return sb.toString();
        }
    }

    private final class OutstandingSendContext
    extends UtlListElement {
        KafkaMessageChannel sender;
        MessageView view;

        OutstandingSendContext() {
        }
    }
}

