/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.util.UtlDataTypes;
import org.junit.Assert;
import org.junit.Test;

public class UtlDataTypesTest {
    @Test
    public void testConvertString() {
        String result = UtlDataTypes.convert(String.class, null);
        Assert.assertNull((String)"null yields null", (Object)result);
        result = UtlDataTypes.convert(String.class, "asdf");
        Assert.assertEquals((String)"String yields String", (Object)"asdf", (Object)result);
        result = UtlDataTypes.convert(String.class, 123);
        Assert.assertEquals((String)"int yields String", (Object)"123", (Object)result);
        result = UtlDataTypes.convert(String.class, 123.0);
        Assert.assertEquals((String)"int yields String", (Object)"123.0", (Object)result);
        result = UtlDataTypes.convert(String.class, 123L);
        Assert.assertEquals((String)"int yields String", (Object)"123", (Object)result);
        result = UtlDataTypes.convert(String.class, 123.0);
        Assert.assertEquals((String)"int yields String", (Object)"123.0", (Object)result);
        result = UtlDataTypes.convert(String.class, (short)123);
        Assert.assertEquals((String)"int yields String", (Object)"123", (Object)result);
        result = UtlDataTypes.convert(String.class, (byte)123);
        Assert.assertEquals((String)"int yields String", (Object)"123", (Object)result);
    }

    @Test
    public void testEnum() {
        Color color = UtlDataTypes.convert(Color.class, 0);
        Assert.assertEquals((String)"0 yields RED", (Object)((Object)Color.RED), (Object)((Object)color));
        color = UtlDataTypes.convert(Color.class, 2);
        Assert.assertEquals((String)"2 yields GREEN", (Object)((Object)Color.GREEN), (Object)((Object)color));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnumIndexOutOfBound() {
        UtlDataTypes.convert(Color.class, 10);
    }

    @Test
    public void testNumeric() {
        int n = UtlDataTypes.convert(Integer.class, 40);
        Assert.assertEquals((long)40L, (long)n);
        n = UtlDataTypes.convert(Integer.class, 40.0);
        Assert.assertEquals((long)40L, (long)n);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDiscardDecimals() {
        UtlDataTypes.convert(Integer.class, 4.2);
    }

    @Test
    public void testCharacter() {
        char letter = UtlDataTypes.convert(Character.TYPE, 65).charValue();
        Assert.assertEquals((String)"found A", (long)65L, (long)letter);
        letter = UtlDataTypes.convert(Character.TYPE, "B").charValue();
        Assert.assertEquals((String)"found B", (long)66L, (long)letter);
    }

    private static enum Color {
        RED,
        BLUE,
        GREEN;

    }
}

