/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang.test.unit;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.neeve.lang.XByteCollection;
import com.neeve.lang.XByteIterator;
import com.neeve.lang.XByteLinkedHashMap;
import com.neeve.lang.XByteLinkedList;
import com.neeve.lang.XByteList;
import com.neeve.lang.XByteListIterator;
import com.neeve.lang.XByteMap;
import com.neeve.lang.XByteSet;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class ByteCollectionAdapters {
    ByteCollectionAdapters() {
    }

    static <V> Map<Byte, V> toLinkedByteMap(XByteMap<V> map) {
        return new XPrimitiveToByteMapAdapter<V>(map);
    }

    static <V> List<Byte> toByteList(XByteList list) {
        return new XPrimitiveToByteListAdapter(list);
    }

    private static byte adaptByte(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values not supported");
        }
        return (Byte)value;
    }

    private static Object adaptByteMapEntry(Object entry) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof Map.Entry) {
            try {
                return ByteCollectionAdapters.adaptByteMapEntry((Map.Entry)entry);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return entry;
    }

    private static <V> XByteMap.Entry<V> adaptByteMapEntry(Map.Entry<Byte, V> entry) {
        if (entry == null) {
            return null;
        }
        return new XByteToPrimitiveMapEntryAdapter<V>(entry);
    }

    private static Collection<?> adaptToPrimitiveByteMapEntryCollectionIfPossible(Collection<?> c) {
        if (c == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(ByteCollectionAdapters.adaptByteMapEntry(o));
        }
        return list;
    }

    private static <V> Collection<? extends XByteMap.Entry<V>> adaptToPrimitiveByteMapEntryCollection(Collection<? extends Map.Entry<Byte, V>> c) {
        if (c == null) {
            return null;
        }
        ArrayList<XByteMap.Entry<V>> list = new ArrayList<XByteMap.Entry<V>>(c.size());
        for (Map.Entry<Byte, V> e : c) {
            list.add(ByteCollectionAdapters.adaptByteMapEntry(e));
        }
        return list;
    }

    public static class Bytes
    extends SampleElements<Byte> {
        public Bytes() {
            super((Object)1, (Object)2, (Object)3, (Object)4, (Object)5);
        }
    }

    public static abstract class TestByteListGenerator
    implements TestListGenerator<Byte> {
        public SampleElements<Byte> samples() {
            return new Bytes();
        }

        public List<Byte> create(Object ... elements) {
            Byte[] array = new Byte[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Byte)e;
            }
            return this.create(array);
        }

        protected abstract List<Byte> create(Byte[] var1);

        public Byte[] createArray(int length) {
            return new Byte[length];
        }

        public List<Byte> order(List<Byte> insertionOrder) {
            return insertionOrder;
        }
    }

    public static abstract class TestByteMapGenerator
    implements TestMapGenerator<Byte, String> {
        public SampleElements<Map.Entry<Byte, String>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)1, (Object)"January"), (Object)Helpers.mapEntry((Object)2, (Object)"February"), (Object)Helpers.mapEntry((Object)3, (Object)"March"), (Object)Helpers.mapEntry((Object)4, (Object)"April"), (Object)Helpers.mapEntry((Object)5, (Object)"May"));
        }

        public Map<Byte, String> create(Object ... entries) {
            Map.Entry[] array = new Map.Entry[entries.length];
            int i = 0;
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                array[i++] = e;
            }
            return this.create(array);
        }

        protected abstract Map<Byte, String> create(Map.Entry<Byte, String>[] var1);

        public final Map.Entry<Byte, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public final Byte[] createKeyArray(int length) {
            return new Byte[length];
        }

        public final String[] createValueArray(int length) {
            return new String[length];
        }

        public Iterable<Map.Entry<Byte, String>> order(List<Map.Entry<Byte, String>> insertionOrder) {
            return insertionOrder;
        }
    }

    private static class XPrimtiveToByteEntrySetAdapter<V>
    extends AbstractSet<Map.Entry<Byte, V>>
    implements Set<Map.Entry<Byte, V>> {
        private final Set<XByteMap.Entry<V>> adaptee;

        public XPrimtiveToByteEntrySetAdapter(Set<XByteMap.Entry<V>> entrySet) {
            this.adaptee = entrySet;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(ByteCollectionAdapters.adaptByteMapEntry(o));
        }

        @Override
        public Iterator<Map.Entry<Byte, V>> iterator() {
            final Iterator<XByteMap.Entry<V>> toAdapt = this.adaptee.iterator();
            return new Iterator<Map.Entry<Byte, V>>(){

                @Override
                public boolean hasNext() {
                    return toAdapt.hasNext();
                }

                @Override
                public Map.Entry<Byte, V> next() {
                    XByteMap.Entry next = (XByteMap.Entry)toAdapt.next();
                    if (next == null) {
                        return null;
                    }
                    return new AbstractMap.SimpleEntry(next.getKey(), next.getValue());
                }

                @Override
                public void remove() {
                    toAdapt.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] toAdapt = this.adaptee.toArray();
            Object[] adapted = new Object[toAdapt.length];
            for (int i = 0; i < toAdapt.length; ++i) {
                if (toAdapt[i] == null) continue;
                XByteMap.Entry xEntry = (XByteMap.Entry)toAdapt[i];
                adapted[i] = new AbstractMap.SimpleEntry(xEntry.getKey(), xEntry.getValue());
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            XByteMap.Entry[] toAdapt = this.adaptee.toArray(new XByteMap.Entry[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < toAdapt.length; ++i) {
                a[i] = toAdapt[i] != null ? new AbstractMap.SimpleEntry(toAdapt[i].getKey(), toAdapt[i].getValue()) : null;
            }
            return a;
        }

        @Override
        public boolean add(Map.Entry<Byte, V> e) {
            return this.adaptee.add(ByteCollectionAdapters.adaptByteMapEntry(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(ByteCollectionAdapters.adaptByteMapEntry(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.adaptee.containsAll(ByteCollectionAdapters.adaptToPrimitiveByteMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Byte, V>> c) {
            return this.adaptee.addAll(ByteCollectionAdapters.adaptToPrimitiveByteMapEntryCollection(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.adaptee.retainAll(ByteCollectionAdapters.adaptToPrimitiveByteMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.adaptee.removeAll(ByteCollectionAdapters.adaptToPrimitiveByteMapEntryCollectionIfPossible(c));
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class XByteToPrimitiveMapEntryAdapter<V>
    extends XByteLinkedHashMap.Entry<V> {
        XByteToPrimitiveMapEntryAdapter(Map.Entry<Byte, V> entry) {
            this.setKey(entry.getKey());
            this.setValue(entry.getValue());
        }
    }

    private static class XPrimitiveToByteListIteratorAdapater
    extends XByteIteratorAdapater
    implements ListIterator<Byte> {
        final XByteListIterator adaptee;

        XPrimitiveToByteListIteratorAdapater(XByteListIterator iterator) {
            super(iterator);
            this.adaptee = iterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.adaptee.hasPrevious();
        }

        @Override
        public Byte previous() {
            return this.adaptee.previous();
        }

        @Override
        public int nextIndex() {
            return this.adaptee.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.adaptee.previousIndex();
        }

        @Override
        public void set(Byte e) {
            this.adaptee.set(ByteCollectionAdapters.adaptByte(e));
        }

        @Override
        public void add(Byte e) {
            this.adaptee.add(ByteCollectionAdapters.adaptByte(e));
        }
    }

    private static class XByteIteratorAdapater
    implements Iterator<Byte> {
        final XByteIterator iterator;

        XByteIteratorAdapater(XByteIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Byte next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class XPrimitiveToByteCollectionAdapter<S extends XByteCollection>
    extends AbstractCollection<Byte>
    implements Collection<Byte> {
        final S adaptee;

        XPrimitiveToByteCollectionAdapter(S collection) {
            this.adaptee = collection;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(ByteCollectionAdapters.adaptByte(o));
        }

        @Override
        public Iterator<Byte> iterator() {
            return new XByteIteratorAdapater(this.adaptee.iterator());
        }

        @Override
        public Object[] toArray() {
            byte[] val = this.adaptee.toArray();
            Object[] adapted = new Object[val.length];
            for (int i = 0; i < val.length; ++i) {
                adapted[i] = val[i];
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            byte[] toAdapt = this.adaptee.toArray(new byte[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < this.adaptee.size(); ++i) {
                a[i] = toAdapt[i];
            }
            if (a.length > this.adaptee.size()) {
                a[this.adaptee.size()] = null;
            }
            return a;
        }

        @Override
        public boolean add(Byte e) {
            return this.adaptee.add(ByteCollectionAdapters.adaptByte(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(ByteCollectionAdapters.adaptByte(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            XByteLinkedList adapter = new XByteLinkedList();
            for (Object o : c) {
                adapter.add(ByteCollectionAdapters.adaptByte(o));
            }
            return this.adaptee.containsAll(adapter);
        }

        @Override
        public boolean addAll(Collection<? extends Byte> c) {
            XByteLinkedList adapter = new XByteLinkedList();
            for (Byte by : c) {
                adapter.add(ByteCollectionAdapters.adaptByte(by));
            }
            return this.adaptee.addAll(adapter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            XByteLinkedList adapter = new XByteLinkedList();
            for (Object o : c) {
                try {
                    adapter.add(ByteCollectionAdapters.adaptByte(o));
                }
                catch (NullPointerException nullPointerException) {}
            }
            return this.adaptee.retainAll(adapter);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            XByteLinkedList adapter = new XByteLinkedList();
            for (Object o : c) {
                adapter.add(ByteCollectionAdapters.adaptByte(o));
            }
            return this.adaptee.removeAll(adapter);
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }
    }

    private static class XPrimitiveToByteListAdapter
    extends XPrimitiveToByteCollectionAdapter<XByteList>
    implements List<Byte> {
        XPrimitiveToByteListAdapter(XByteList set) {
            super(set);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Byte> c) {
            XByteLinkedList adapter = new XByteLinkedList();
            for (Byte by : c) {
                adapter.add(ByteCollectionAdapters.adaptByte(by));
            }
            return ((XByteList)this.adaptee).addAll(index, adapter);
        }

        @Override
        public Byte get(int index) {
            return ((XByteList)this.adaptee).get(index);
        }

        @Override
        public Byte set(int index, Byte element) {
            return ((XByteList)this.adaptee).set(index, ByteCollectionAdapters.adaptByte(element));
        }

        @Override
        public void add(int index, Byte element) {
            ((XByteList)this.adaptee).add(index, ByteCollectionAdapters.adaptByte(element));
        }

        @Override
        public Byte remove(int index) {
            return ((XByteList)this.adaptee).remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((XByteList)this.adaptee).indexOf(ByteCollectionAdapters.adaptByte(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((XByteList)this.adaptee).lastIndexOf(ByteCollectionAdapters.adaptByte(o));
        }

        @Override
        public ListIterator<Byte> listIterator() {
            return new XPrimitiveToByteListIteratorAdapater(((XByteList)this.adaptee).listIterator());
        }

        @Override
        public ListIterator<Byte> listIterator(int index) {
            return new XPrimitiveToByteListIteratorAdapater(((XByteList)this.adaptee).listIterator(index));
        }

        @Override
        public List<Byte> subList(int fromIndex, int toIndex) {
            return new XPrimitiveToByteListAdapter(((XByteList)this.adaptee).subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            ListIterator<Byte> e1 = this.listIterator();
            ListIterator e2 = ((List)o).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Byte o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Byte obj : this) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }
    }

    private static class XPrimitiveToByteSetAdapter
    extends XPrimitiveToByteCollectionAdapter<XByteSet>
    implements Set<Byte> {
        XPrimitiveToByteSetAdapter(XByteSet set) {
            super(set);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Byte obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            } else {
                Iterator<Byte> i = this.iterator();
                while (i.hasNext()) {
                    if (!c.contains(i.next())) continue;
                    i.remove();
                    modified = true;
                }
            }
            return modified;
        }
    }

    private static class XPrimitiveToByteMapAdapter<V>
    extends AbstractMap<Byte, V>
    implements Map<Byte, V> {
        private final XByteMap<V> map;

        public XPrimitiveToByteMapAdapter(XByteMap<V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(ByteCollectionAdapters.adaptByte(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(ByteCollectionAdapters.adaptByte(key));
        }

        @Override
        public V put(Byte key, V value) {
            return this.map.put(ByteCollectionAdapters.adaptByte(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(ByteCollectionAdapters.adaptByte(key));
        }

        @Override
        public void putAll(Map<? extends Byte, ? extends V> m) {
            XByteLinkedHashMap<V> adapter = new XByteLinkedHashMap<V>(m != null ? m.size() : 16);
            for (Map.Entry<Byte, V> entry : m.entrySet()) {
                adapter.put(ByteCollectionAdapters.adaptByte(entry.getKey()), entry.getValue());
            }
            this.map.putAll(adapter);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<Byte> keySet() {
            return new XPrimitiveToByteSetAdapter(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<Byte, V>> entrySet() {
            return new XPrimtiveToByteEntrySetAdapter<V>(this.map.entrySet());
        }
    }
}

