/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.EAepException;
import com.neeve.aep.test.unit.AepEngineInitTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import com.neeve.ods.StoreDescriptor;
import com.neeve.rog.log.RogLog;
import java.io.File;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineInitTest
extends AepEngineTest {
    @Test
    public void testInitNonClustered() throws Exception {
        AepEngineInitTestApp receiver = new AepEngineInitTestApp();
        this.startSenderStandaloneReceiverStandalone(null, null, null, receiver, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, false, false);
        Assert.assertEquals((long)0L, (long)receiver.initCompleteEventCount);
        Assert.assertEquals((long)0L, (long)receiver.messageCount);
    }

    private final void testInitClusteredRedundantEventSourcingNoPersister(boolean parallelLaunch) throws Exception {
        AepEngineInitTestApp receiver1 = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver2 = new AepEngineInitTestApp();
        int primary = this.startSenderStandaloneReceiverRedundant(null, null, null, receiver1, null, receiver2, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, false, parallelLaunch, 0);
        Assert.assertEquals((long)0L, (long)primary);
        receiver1.waitForInitToComplete(0);
        receiver2.waitForInitToComplete(0);
        Assert.assertEquals((long)2L, (long)receiver1.initCompleteEventCount);
        Assert.assertEquals((long)0L, (long)receiver1.messageCount);
        Assert.assertEquals((long)1L, (long)receiver2.initCompleteEventCount);
        Assert.assertEquals((long)0L, (long)receiver2.messageCount);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingNoPersisterSerialLaunch() throws Exception {
        this.testInitClusteredRedundantEventSourcingNoPersister(false);
    }

    @Ignore
    @Test
    public void testInitClusteredRedundantEventSourcingNoPersisterParallelLaunch() throws Exception {
        this.testInitClusteredRedundantEventSourcingNoPersister(true);
    }

    @Test
    public void testInitClusteredStandalonePersisterEmptyStore() throws Exception {
        AepEngineInitTestApp receiver = new AepEngineInitTestApp();
        this.startSenderStandaloneReceiverStandalone(null, null, null, receiver, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, true);
        Assert.assertEquals((long)1L, (long)receiver.initCompleteEventCount);
        Assert.assertEquals((long)0L, (long)receiver.messageCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=EAepException.class)
    public void testInitClusteredStandalonePersisterEmptyStorePersisterOpenFail() throws Exception {
        RogLog.failOpen((boolean)true);
        try {
            AepEngineInitTestApp app = new AepEngineInitTestApp();
            String engineName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
            AepEngine engine1 = this.createEngine(engineName, null, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, app, null, null, 0, false, false, null, null, null, false, false);
            engine1.start();
        }
        finally {
            RogLog.failOpen((boolean)false);
        }
    }

    private final void testInitClusteredRedundantEventSourcingPersisterEmptyStore(boolean parallelLaunch) throws Exception {
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineInitTestApp receiver1 = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver2 = new AepEngineInitTestApp();
        int primary = this.startSenderStandaloneReceiverRedundant(null, null, receiverName, receiver1, null, receiver2, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, parallelLaunch, 0);
        if (!parallelLaunch) {
            Assert.assertEquals((long)0L, (long)primary);
        }
        receiver1.waitForInitToComplete(0);
        receiver2.waitForInitToComplete(0);
        Assert.assertEquals((long)2L, (long)receiver1.initCompleteEventCount);
        Assert.assertEquals((long)0L, (long)receiver1.messageCount);
        Assert.assertEquals((long)1L, (long)receiver2.initCompleteEventCount);
        Assert.assertEquals((long)0L, (long)receiver2.messageCount);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterEmptyStoreSerialLaunch() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterEmptyStore(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterEmptyStoreSerialLaunchBackupPersisterOpenFail() throws Exception {
        AepEngineInitTestApp primary = new AepEngineInitTestApp();
        AepEngineInitTestApp backup = new AepEngineInitTestApp();
        String engineName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngine engine1 = this.createEngine(engineName, null, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, primary, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        RogLog.failOpen((boolean)true);
        try {
            this.createEngine(engineName, null, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 0, 0, backup, null, null, 0, false, false, null, null, null, false, false).start();
        }
        finally {
            RogLog.failOpen((boolean)false);
            Assert.assertEquals((long)2L, (long)primary.initCompleteEventCount);
            Assert.assertTrue((boolean)primary.waitForMembershipToStabilize(0));
        }
    }

    @Ignore
    @Test
    public void testInitClusteredRedundantEventSourcingPersisterEmptyStoreParallelLaunch() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterEmptyStore(true);
    }

    private final void testInitClusteredStandalonePersisterNonEmptyStore(AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineInitTestApp sender = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver = new AepEngineInitTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        this.startSenderStandaloneReceiverStandalone(sender, null, receiverName, receiver, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, true, false, 0, encodingType);
        for (int i = 0; i < 10; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, new AepEngineTestMessage(encodingType).getMessage());
        }
        Assert.assertTrue((boolean)receiver.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)receiver.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver.messageCount);
        this.testCleanup();
        this.testInitialize();
        receiver = new AepEngineInitTestApp();
        this.startSenderStandaloneReceiverStandalone(null, null, receiverName, receiver, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, true, false, 0, encodingType);
        Assert.assertTrue((boolean)receiver.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)receiver.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver.messageCount);
    }

    @Test
    public void testInitClusteredStandalonePersisterNonEmptyStoreXbuf() throws Exception {
        this.testInitClusteredStandalonePersisterNonEmptyStore(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testInitClusteredStandalonePersisterNonEmptyStoreProto() throws Exception {
        this.testInitClusteredStandalonePersisterNonEmptyStore(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testInitClusteredStandalonePersisterNonEmptyStoreJson() throws Exception {
        this.testInitClusteredStandalonePersisterNonEmptyStore(AepEngineTestObject.EncodingType.Json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=EAepException.class)
    public void testInitClusteredStandalonePersisterNonEmptyStoreInitFail() throws Exception {
        AepEngineInitTestApp sender = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver = new AepEngineInitTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        this.startSenderStandaloneReceiverStandalone(sender, null, receiverName, receiver, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, true);
        for (int i = 0; i < 10; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
        }
        Assert.assertTrue((boolean)receiver.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)receiver.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver.messageCount);
        this.testCleanup();
        this.testInitialize();
        receiver = new AepEngineInitTestApp();
        receiver.failMessageReceipt = true;
        try {
            this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, receiver, null, null, 0, false, false, null, null, null, false, false).start();
        }
        finally {
            Assert.assertEquals((long)0L, (long)receiver.messageCount);
        }
    }

    private final void testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(boolean parallelLaunch, final boolean detachedMemberInitialization, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine5;
        AepEngine engine4;
        int primary;
        AepEngine engine3;
        AepEngine engine2;
        AepEngineInitTestApp sender = new AepEngineInitTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineInitTestApp receiver1 = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver2 = new AepEngineInitTestApp();
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        AepEngineTest.BaseEngineCusomizer receiverCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setDetachedMemberInitialization(detachedMemberInitialization);
            }
        };
        String engineName = receiverName;
        receiver1.engine = engine2 = this.createEngine(engineName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 3, 1, receiver1, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        Thread thread = null;
        if (parallelLaunch) {
            thread = new Thread(){

                @Override
                public final void run() {
                    try {
                        engine2.start();
                        engine2.waitForMessagingToStart();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        } else {
            engine2.start();
            engine2.waitForMessagingToStart();
            Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
            Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        }
        receiver2.engine = engine3 = this.createEngine(engineName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 3, 1, receiver2, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine3.start();
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        int n = primary = engine2.isPrimary() ? 0 : 1;
        if (!parallelLaunch) {
            Assert.assertEquals((long)0L, (long)primary);
        }
        receiver1.waitForInitToComplete(0);
        receiver2.waitForInitToComplete(0);
        for (int i = 0; i < 10; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, new AepEngineTestMessage(encodingType).getMessage());
        }
        Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)2L, (long)receiver1.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver1.messageCount);
        Assert.assertTrue((boolean)receiver2.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)receiver2.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver2.messageCount);
        this.testCleanup();
        this.testInitialize();
        receiver1 = new AepEngineInitTestApp();
        receiver2 = new AepEngineInitTestApp();
        receiver1.engine = engine4 = this.createEngine(engineName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 3, 1, receiver1, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
        engine4.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        thread = null;
        if (parallelLaunch) {
            thread = new Thread(){

                @Override
                public final void run() {
                    try {
                        engine4.start();
                        engine4.waitForMessagingToStart();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        } else {
            engine4.start();
            engine4.waitForMessagingToStart();
            Assert.assertEquals((Object)((Object)engine4.getState()), (Object)((Object)AepEngine.State.Started));
            Assert.assertEquals((Object)((Object)engine4.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        }
        Assert.assertTrue((engine4.getStats().getNumMsgsResent() > 0L ? 1 : 0) != 0);
        receiver2.engine = engine5 = this.createEngine(engineName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 3, 1, receiver2, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
        engine5.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine5.start();
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((Object)((Object)engine4.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine4.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        receiver1.waitForInitToComplete(0);
        receiver2.waitForInitToComplete(0);
        Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)2L, (long)receiver1.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver1.messageCount);
        Assert.assertTrue((boolean)receiver2.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)receiver2.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver2.messageCount);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchAttachedInitXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(false, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchAttachedInitProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(false, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchAttachedInitJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(false, false, AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchDetachedInitXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(false, true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchDetachedInitProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(false, true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchDetachedInitJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(false, true, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreParallelLaunchXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(true, false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Ignore
    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreParallelLaunchProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(true, false, AepEngineTestObject.EncodingType.Proto);
    }

    @Ignore
    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreParallelLaunchJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStore(true, false, AepEngineTestObject.EncodingType.Json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFail(final boolean detachedMemberInitialization, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineInitTestApp sender = new AepEngineInitTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineInitTestApp receiver1 = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver2 = new AepEngineInitTestApp();
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, false, 0, encodingType);
        receiver1.waitForInitToComplete(0);
        receiver2.waitForInitToComplete(0);
        for (int i = 0; i < 10; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, new AepEngineTestMessage(encodingType).getMessage());
        }
        Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)2L, (long)receiver1.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver1.messageCount);
        Assert.assertTrue((boolean)receiver2.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)receiver2.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver2.messageCount);
        this.testCleanup();
        this.testInitialize();
        AepEngineTest.BaseEngineCusomizer receiverCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setDetachedMemberInitialization(detachedMemberInitialization);
            }
        };
        AepEngineInitTestApp primary = new AepEngineInitTestApp();
        AepEngineInitTestApp backup = new AepEngineInitTestApp();
        AepEngine engine1 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, primary, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        Assert.assertTrue((boolean)primary.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)primary.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)primary.messageCount);
        RogLog.failOpen((boolean)true);
        try {
            this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 0, 0, backup, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer).start();
        }
        finally {
            RogLog.failOpen((boolean)false);
            Assert.assertEquals((long)0L, (long)backup.messageCount);
            Assert.assertEquals((long)1L, (long)backup.memberUpEventCount);
            Assert.assertEquals((long)2L, (long)primary.initCompleteEventCount);
            Assert.assertTrue((boolean)primary.waitForMembershipToStabilize(0));
        }
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFailAttachedInitXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFail(false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFailAttachedInitProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFail(false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFailAttachedInitJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFail(false, AepEngineTestObject.EncodingType.Json);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFailDetachedInitXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFail(true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFailDetachedInitProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFail(true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFailDetachedInitJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupPersisterOpenFail(true, AepEngineTestObject.EncodingType.Json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFail(final boolean detachedMemberInitialization, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineInitTestApp sender = new AepEngineInitTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineInitTestApp receiver1 = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver2 = new AepEngineInitTestApp();
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, false, 0, encodingType);
        receiver1.waitForInitToComplete(0);
        receiver2.waitForInitToComplete(0);
        for (int i = 0; i < 10; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, new AepEngineTestMessage(encodingType).getMessage());
        }
        Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)2L, (long)receiver1.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver1.messageCount);
        Assert.assertTrue((boolean)receiver2.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)receiver2.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)receiver2.messageCount);
        this.testCleanup();
        this.testInitialize();
        AepEngineTest.BaseEngineCusomizer receiverCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setDetachedMemberInitialization(detachedMemberInitialization);
            }
        };
        AepEngineInitTestApp primary = new AepEngineInitTestApp();
        AepEngineInitTestApp backup = new AepEngineInitTestApp();
        AepEngine engine1 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, primary, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        Assert.assertTrue((boolean)primary.waitForExpectedMessageReceipt(10));
        Assert.assertEquals((long)1L, (long)primary.initCompleteEventCount);
        Assert.assertEquals((long)10L, (long)primary.messageCount);
        backup.failMessageReceipt = true;
        try {
            this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 0, 0, backup, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer).start();
        }
        finally {
            Assert.assertEquals((long)0L, (long)backup.messageCount);
            Assert.assertEquals((long)1L, (long)backup.memberUpEventCount);
            Assert.assertTrue((boolean)primary.waitForInitToComplete(1));
            Assert.assertTrue((boolean)primary.waitForMembershipToStabilize(0));
        }
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFailAttachedInitXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFail(false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFailAttachedInitProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFail(false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFailAttachedInitJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFail(false, AepEngineTestObject.EncodingType.Json);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFailDetachedInitXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFail(true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFailDetachedInitProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFail(true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFailDetachedInitJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchBackupInitFail(true, AepEngineTestObject.EncodingType.Json);
    }

    private final void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInit(final boolean detachedMemberInitialization, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineInitTestApp sender = new AepEngineInitTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineInitTestApp receiver1 = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver2 = new AepEngineInitTestApp();
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, false, 0, encodingType);
        receiver1.waitForInitToComplete(0);
        receiver2.waitForInitToComplete(0);
        int messageCount = 20000;
        for (int i = 0; i < 20000; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, new AepEngineTestMessage(encodingType).getMessage());
            if (i % 1000 != 0) continue;
            System.out.println(i);
        }
        Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(20000));
        Assert.assertEquals((long)2L, (long)receiver1.initCompleteEventCount);
        Assert.assertEquals((long)20000L, (long)receiver1.messageCount);
        Assert.assertTrue((boolean)receiver2.waitForExpectedMessageReceipt(20000));
        Assert.assertEquals((long)1L, (long)receiver2.initCompleteEventCount);
        Assert.assertEquals((long)20000L, (long)receiver2.messageCount);
        this.testCleanup();
        this.testInitialize();
        AepEngineTest.BaseEngineCusomizer receiverCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setDetachedMemberInitialization(detachedMemberInitialization);
            }
        };
        AepEngineInitTestApp primary = new AepEngineInitTestApp();
        AepEngineInitTestApp backup = new AepEngineInitTestApp();
        AepEngine engine1 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, primary, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        Assert.assertTrue((boolean)primary.waitForExpectedMessageReceipt(20000));
        Assert.assertEquals((long)1L, (long)primary.initCompleteEventCount);
        Assert.assertEquals((long)20000L, (long)primary.messageCount);
        backup.blockAfter = 10;
        new Unblocker(engine1, backup).start();
        this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 0, 0, backup, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer).start();
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInitAttachedInitXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInit(false, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInitAttachedInitProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInit(false, AepEngineTestObject.EncodingType.Proto);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInitAttachedInitJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInit(false, AepEngineTestObject.EncodingType.Json);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInitDetachedInitXbuf() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInit(true, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInitDetachedInitProto() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInit(true, AepEngineTestObject.EncodingType.Proto);
    }

    @Test(expected=EAepException.class)
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInitDetachedInitJson() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchPrimaryFailDuringInit(true, AepEngineTestObject.EncodingType.Json);
    }

    private void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchLiveInit(final boolean detachedMemberInitialization) throws Exception {
        AepEngineInitTestApp sender = new AepEngineInitTestApp();
        final String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineInitTestApp receiver1 = new AepEngineInitTestApp();
        AepEngineInitTestApp receiver2 = new AepEngineInitTestApp();
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, true, false, 0);
        receiver1.waitForInitToComplete(0);
        receiver2.waitForInitToComplete(0);
        for (int i = 0; i < 10000; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
        }
        Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(10000));
        Assert.assertEquals((long)2L, (long)receiver1.initCompleteEventCount);
        Assert.assertEquals((long)10000L, (long)receiver1.messageCount);
        Assert.assertTrue((boolean)receiver2.waitForExpectedMessageReceipt(10000));
        Assert.assertEquals((long)1L, (long)receiver2.initCompleteEventCount);
        Assert.assertEquals((long)10000L, (long)receiver2.messageCount);
        this.testCleanup();
        this.testInitialize();
        sender = new AepEngineInitTestApp();
        AepEngine engine1 = this.createEngine("engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++, null, null, null, null, null, false, false, false, false, null, 1, 1, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        final AepEngineTest.BaseEngineCusomizer receiverCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setDetachedMemberInitialization(detachedMemberInitialization);
            }
        };
        AepEngineInitTestApp primary = new AepEngineInitTestApp();
        AepEngine engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, primary, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        Assert.assertTrue((boolean)primary.waitForExpectedMessageReceipt(10000));
        Assert.assertEquals((long)10000L, (long)primary.messageCount);
        final AepEngineInitTestApp backup = new AepEngineInitTestApp();
        Thread thread = new Thread(){

            @Override
            public final void run() {
                try {
                    AepEngine engine3 = AepEngineInitTest.this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, backup, null, null, 0, false, false, null, null, null, false, false, receiverCustomizer);
                    engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
                    engine3.start();
                    Assert.assertTrue((boolean)backup.waitForExpectedMessageReceipt(30, 20000));
                    Assert.assertEquals((long)20000L, (long)backup.messageCount);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        for (int i = 0; i < 10000; ++i) {
            engine1.sendMessage(sender.channel1, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchLiveInitAttachedInit() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchLiveInit(false);
    }

    @Test
    public void testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchLiveInitDetachedInit() throws Exception {
        this.testInitClusteredRedundantEventSourcingPersisterNonEmptyStoreSerialLaunchLiveInit(true);
    }

    private final class Unblocker
    extends Thread {
        final AepEngine primaryEngine;
        final AepEngineInitTestApp backup;

        Unblocker(AepEngine primaryEngine, AepEngineInitTestApp backup) {
            this.primaryEngine = primaryEngine;
            this.backup = backup;
        }

        @Override
        public final void run() {
            try {
                Assert.assertTrue((boolean)this.backup.waitForExpectedMessageReceipt(10));
                for (int i = 0; i < 5; ++i) {
                    System.out.println("Unblocker: backup received " + this.backup.messageCount + " messages...");
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.primaryEngine.getStore().fail(new Exception("force fail by user"));
                this.backup.unblock();
                System.out.println("Unblocker: Done");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

