/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.test;

import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.AssumptionViolatedException;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public abstract class UnitTest {
    private static Thread processKillTimer;
    private static boolean testBedRootWasSet;
    private static boolean verbose;
    private static Boolean inMavenOrIDE;
    private int counter = 0;
    @Rule
    public TestName testcaseName = new TestName();
    @Rule
    public TestWatcher watcher = new TestWatcher(){
        private long startTime = System.currentTimeMillis();

        private long testDuration() {
            return (System.currentTimeMillis() - this.startTime) / 1000L;
        }

        protected void starting(Description description) {
            if (UnitTest.verbose()) {
                System.out.println("STARTING testcase " + description.getMethodName());
            }
        }

        protected void succeeded(Description description) {
            if (UnitTest.verbose() || System.currentTimeMillis() - this.startTime <= 10000L) {
                // empty if block
            }
            System.out.println("FINISHED testcase " + description.getMethodName() + " [SUCCESS] (" + this.testDuration() + "s)");
        }

        protected void failed(Throwable e, Description description) {
            System.out.println("FAILED testcase " + description.getMethodName() + "[FAILED" + (e != null ? " (" + e.getMessage() + ")]" : "]") + this.testDuration() + "s)");
        }

        protected void skipped(AssumptionViolatedException e, Description description) {
            System.out.println("SKIPPED testcase " + description.getMethodName() + "[SKIPPED" + e != null ? " (" + e.getMessage() + ")]" : "]");
        }
    };

    private static boolean isEclipse() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[stack.length - 1].toString().indexOf("eclipse") > 0;
    }

    private static boolean isIntelliJ() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[stack.length - 1].toString().contains("intellij");
    }

    private static boolean isMavenSurefire() {
        return System.getProperties().containsKey("surefire.test.class.path");
    }

    private static void deleteDirectory(File dir) throws IOException {
        File[] entries = dir.listFiles();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].isDirectory()) {
                    UnitTest.deleteDirectory(entries[i]);
                    continue;
                }
                entries[i].delete();
            }
        }
        dir.delete();
    }

    protected static File getProjectBaseDirectory() {
        String basedir = System.getProperty("basedir");
        if (basedir != null) {
            return new File(basedir);
        }
        return new File(".");
    }

    protected static void configureForInMemoryConfigRepo(Class<?> testClass) {
        boolean repoInitializedExists = false;
        try {
            repoInitializedExists = testClass.getResource("/META-INF/system.xcs") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (repoInitializedExists && !Boolean.getBoolean("nv.test.forceDurableConfigRepo")) {
            System.setProperty("nv.config.descriptor", "mem://.");
            System.setProperty("nv.local.config.descriptor", "mem://.");
        }
    }

    protected void testDesc(String s) {
        System.out.print("#" + ++this.counter + "-" + s);
    }

    protected static void testSuccess(String s) {
        System.out.println("OK [" + s + "]");
    }

    protected static void testFailure(String s) {
        System.out.println("FAIL [" + s + "]");
        throw new Error(s);
    }

    protected static boolean verbose() {
        return verbose;
    }

    protected static void setVerbose(boolean verbose) {
        UnitTest.verbose = verbose;
    }

    protected static File getTestbedRoot() {
        return new File(System.getProperty("NVROOT"));
    }

    @BeforeClass
    public static void initializeUnitTest() throws IOException {
        if (System.getProperty("NVROOT") == null) {
            long processTimeout;
            File rdat;
            File testRoot = UnitTest.getProjectBaseDirectory().getCanonicalFile();
            if (inMavenOrIDE == null) {
                inMavenOrIDE = UnitTest.isEclipse() || UnitTest.isIntelliJ() || UnitTest.isMavenSurefire();
            }
            if (inMavenOrIDE.booleanValue()) {
                if (new File(testRoot, "target").exists()) {
                    testRoot = new File(testRoot, "target/testbed");
                }
                System.setProperty("nv.data.directory", new File(testRoot, "rdat").getCanonicalPath());
            }
            System.setProperty("NVROOT", testRoot.getCanonicalPath());
            testBedRootWasSet = true;
            if (!testRoot.exists()) {
                testRoot.mkdirs();
            }
            if ((rdat = new File(testRoot, "rdat")).exists()) {
                UnitTest.deleteDirectory(rdat);
            }
            if ((processTimeout = Long.getLong("nv.test.timeout", -1L).longValue()) > 0L && processKillTimer == null) {
                System.out.println("Starting process kill timer");
                processKillTimer = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(processTimeout * 1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Runtime.getRuntime().halt(1);
                    }
                }, "KillTimer");
                processKillTimer.start();
            }
        }
        verbose = new Boolean(System.getProperty("nv.test.verbose", "false"));
    }

    @AfterClass
    public static void finalizeUnitTest() {
        if (testBedRootWasSet) {
            System.clearProperty("NVROOT");
            testBedRootWasSet = false;
        }
    }

    static {
        verbose = false;
        inMavenOrIDE = null;
        System.setProperty("nv.enable.unsupported", "true");
    }
}

