/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIntIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufRepeatedIntFieldBuffer;

public final class XbufVariableIntListField
extends XbufField {
    private final Values values;
    private static final int[] EMPTY = new int[0];

    private XbufVariableIntListField(short id, String name) {
        super(XbufField.Type.VARINTEGER_LIST, id, name, false, true);
        this.values = new Values(id);
    }

    public static XbufVariableIntListField create(short id, String name) {
        return new XbufVariableIntListField(id, name);
    }

    public static XbufRepeatedIntFieldBuffer createFieldBuffer(short id, int initialLength, boolean isNative) {
        return new XbufRepeatedIntFieldBuffer(id, initialLength, isNative);
    }

    private final Values getValues(boolean forWrite) {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (forWrite && this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        Values v = (Values)this.container.fieldValues[this.index];
        if (v == null) {
            this.values.reset();
            if (forWrite) {
                v = this.values;
                this.container.setValue(this, v, true);
            }
            return this.values;
        }
        if (forWrite) {
            this.container.markDirty(this, v);
        }
        return v;
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        Values v = this.getValuesOrNullIfNotSet();
        if (v != null) {
            return v.copyInto((IOElasticBuffer)buffer, offset);
        }
        return 0;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        int desyncLength = this.getValues(false).desyncAndAddValue(buffer, offset, length);
        this.container.setValue(this, this.values);
        return desyncLength;
    }

    @Override
    protected final int contentLength() {
        Values v = this.getValuesOrNullIfNotSet();
        if (v != null) {
            return v.serializedLength();
        }
        return 0;
    }

    @Override
    protected final String contentAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Values v = this.getValuesOrNullIfNotSet();
        v.toString(sb);
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected final boolean contentClear() {
        return this.container.clearValue(this);
    }

    public final void setValuesFrom(XbufVariableIntListField field) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (field == this) {
            field.values.toFirst();
            return;
        }
        Values v = this.getValues(true);
        v.setValuesFrom(field.getValues());
    }

    public final void setValuesFrom(XIntIterator val) {
        if (val == null) {
            throw new IllegalArgumentException("cannot set a list field to null");
        }
        Values v = this.getValues(true);
        if (v == val) {
            val.toFirst();
            return;
        }
        v.setValuesFrom(val);
    }

    public final void setValues(int[] val) {
        if (val == null) {
            throw new IllegalArgumentException("cannot set a list field to null");
        }
        Values v = this.getValues(true);
        v.reset();
        for (int i = 0; i < val.length; ++i) {
            v.add(val[i]);
        }
    }

    public final void addValue(int val) {
        this.getValues(true).add(val);
    }

    public final Values getValues() {
        return this.getValues(false);
    }

    public final Values getValuesOrNullIfNotSet() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        return (Values)this.container.fieldValues[this.index];
    }

    public final int[] getValuesAsArray() {
        Values v = this.getValuesOrNullIfNotSet();
        if (v == null || v.size() == 0) {
            return EMPTY;
        }
        int[] ret = new int[v.size()];
        int current = v.current;
        v.toFirst();
        int i = 0;
        while (v.hasNext()) {
            ret[i++] = v.next();
        }
        v.current = current;
        return ret;
    }

    public final Values getValueIterator() {
        return (Values)this.getValues(false).toFirst();
    }

    public static final class Values
    extends XbufRepeatedIntFieldBuffer {
        private final Iterator iterator = new Iterator();

        Values(short id) {
            super(id, 1, true);
        }

        @Deprecated
        public final Iterator iterator() {
            return this.iterator.init();
        }

        public int size() {
            return this.count();
        }

        @Deprecated
        public final class Iterator {
            final Iterator init() {
                Values.this.toFirst();
                return this;
            }

            public final boolean hasNext() {
                return Values.this.hasNext();
            }

            public final int next() {
                return Values.this.next();
            }
        }
    }
}

