/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufByteField
extends XbufField {
    private final Value value = new Value();

    private XbufByteField(short id, String name, boolean pinned) {
        super(XbufField.Type.BYTE, id, name, pinned);
    }

    public static final XbufByteField create(short id, String name, boolean pinned) {
        return new XbufByteField(id, name, pinned);
    }

    private final void serialize(PktBuffer buffer, int offset, byte val) {
        buffer.put(offset, val);
    }

    private final byte deserialize(PktBuffer buffer, int offset) {
        return buffer.get(offset);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        this.serialize(buffer, offset, this.getValue());
        return 1;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length != 1) {
            throw new InternalError("request to deserialize byte with length != 1 (length=" + length + ")");
        }
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return 1;
    }

    @Override
    protected final int contentLength() {
        return 1;
    }

    @Override
    protected final String contentAsString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, (byte)0);
            return true;
        }
        this.value.val = 0;
        return this.container.clearValue(this);
    }

    public final void setValue(byte val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, val);
        } else {
            this.value.val = val;
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueFrom(XbufByteField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final byte getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.pinned || this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : (byte)0;
    }

    private final class Value {
        byte val;

        private Value() {
        }
    }
}

