/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkFactory;
import com.neeve.perf.common.LatencyWriter;
import com.neeve.perf.common.SystemProperties;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlThread;
import java.text.DecimalFormat;

@AnnotatedCommand.Command(keywords={"StreamingLinkSender"}, description="A sender for testing streaming performance")
public final class StreamingSender
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="The connection descriptor to use e.g. tcp://192.168.1.7:12000&tcpnodelay=true")
    private String _descriptor;
    @AnnotatedCommand.Option(shortForm=109, longForm="messageSize", defaultValue="256", required=true, description="The size of the message to stream")
    private int _messageSize;
    @AnnotatedCommand.Option(shortForm=97, longForm="flushAfter", defaultValue="64", description="Flush after how many messages")
    private int _flushAfter;
    @AnnotatedCommand.Option(shortForm=116, longForm="testCount", defaultValue="100000000", description="The test count")
    private int _testCount;
    @AnnotatedCommand.Option(shortForm=114, longForm="testRate", defaultValue="10000000", description="The send rate")
    private int _testRate;
    @AnnotatedCommand.Option(shortForm=119, longForm="warmupTime", defaultValue="2", description="The warm up time, in seconds")
    private int _warmupTime;
    @AnnotatedCommand.Option(shortForm=99, longForm="cpuAffinityMask", description="which CPU(s) to affinitize the sending thread to")
    private String _cpuAffinityMask;
    @AnnotatedCommand.Option(shortForm=105, longForm="printIntervalStats", description="whether to output stats at periodic intervals instead of only at the end")
    private boolean _printIntervalStats;
    @AnnotatedCommand.Option(shortForm=102, longForm="dontWriteLatenciesToFile", description="whether to suppress writing latency values to a file")
    private boolean _dontWriteLatenciesToFile;

    private final ILnkPeerEndpoint connect(IEmxDispatcher dispatcher) throws Exception {
        ILnkClientEndpoint cep = LnkFactory.getInstance().createClientEndpoint(this._descriptor, null);
        System.out.println("[StreamingSender] Connecting to " + this._descriptor + "]...");
        ConnectCompleteEventHandler connectCompleteHandler = new ConnectCompleteEventHandler();
        cep.connectPost(dispatcher, (ILnkEventHandler)connectCompleteHandler, -1, 0);
        while (connectCompleteHandler.eventData == null) {
            dispatcher.run(-1);
        }
        if (connectCompleteHandler.eventData.status) {
            System.out.println("[StreamingSender] Connect success.");
            return connectCompleteHandler.eventData.pep;
        }
        throw connectCompleteHandler.eventData.e;
    }

    public void execute() throws Exception {
        if (this._cpuAffinityMask != null) {
            System.out.println("[StreamingSender] Affinitizing thread to CPU " + this._cpuAffinityMask);
            UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)this._cpuAffinityMask));
        }
        SystemProperties.dump();
        DecimalFormat dfmt = new DecimalFormat("#,###");
        System.out.println("[StreamingSender] Descriptor:" + this._descriptor);
        System.out.println("[StreamingSender] Message size:" + this._messageSize);
        System.out.println("[StreamingSender] Test count:" + dfmt.format(this._testCount));
        System.out.println("[StreamingSender] Warmup time:" + this._warmupTime + "s");
        System.out.println("[StreamingSender] Test rate:" + dfmt.format(this._testRate));
        System.out.println("[StreamingSender] CPU affinity mask:" + this._cpuAffinityMask);
        System.out.println("[StreamingSender] Print interval stats:" + this._printIntervalStats);
        System.out.println("[StreamingSender] Write latencies to file:" + !this._dontWriteLatenciesToFile);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, "StreamingReceiverDispatcher", null);
        ILnkPeerEndpoint pep = this.connect(dispatcher);
        pep.join((short)-1, (ILnkEventHandler)new EventHandler());
        System.out.println("[StreamingSender] Calculating nanoTime() overhead...");
        long nanoTimeOverhead = 0L;
        long start = System.nanoTime();
        int i = 0;
        while ((long)i < 100000000L) {
            System.nanoTime();
            ++i;
        }
        nanoTimeOverhead = (System.nanoTime() - start) / 100000000L;
        System.out.println("[StreamingSender] ..." + nanoTimeOverhead + "ns");
        LatencyWriter lw = new LatencyWriter("nw-write", this._dontWriteLatenciesToFile ? null : "latencies.write.bin", this._printIntervalStats);
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        ((PktBodyData)packet.getBody()).setBufferLength(this._messageSize);
        System.out.println("[StreamingSender] Warming up (" + this._warmupTime + " seconds)...");
        long warmupStart = System.currentTimeMillis();
        while (System.currentTimeMillis() - warmupStart < (long)this._warmupTime * 1000L) {
            pep.enque((short)-1, packet, null, 0);
        }
        pep.flush((short)-1, null);
        int numSent = 0;
        long nanosPerMsg = this._testRate > 0 ? 1000000000L / (long)this._testRate : 0L;
        System.out.println("[StreamingSender] Running test (" + dfmt.format(this._testCount) + " messages @ " + this._testRate + " msgs/sec)...");
        long next = System.nanoTime() + nanosPerMsg;
        lw.start(this._testRate, this._testCount);
        start = System.currentTimeMillis();
        while (numSent < this._testCount) {
            long ts1 = System.nanoTime();
            if (ts1 < next) continue;
            pep.enque((short)-1, packet, null, 0);
            if (++numSent % this._flushAfter == 0) {
                pep.flush((short)-1, null);
            }
            long ts2 = System.nanoTime();
            int writeTime = (int)(ts2 - ts1 - nanoTimeOverhead);
            lw.write(writeTime);
            next += nanosPerMsg;
        }
        long stop = System.currentTimeMillis();
        lw.close();
        pep.close((short)-1);
        long overallRate = (long)numSent * 1000L / (stop - start);
        System.out.println("[StreamingSender] Sent " + dfmt.format(numSent) + " messages at " + dfmt.format(overallRate) + " msgs/sec.");
        if (!this._dontWriteLatenciesToFile) {
            System.out.println("[StreamingSender] Test complete (run rumi-reporter on latencies.write.bin to calculate latency stats).");
        } else {
            System.out.println("[StreamingSender] Test complete.");
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.enablecpuaffinitymasks", "true");
        new StreamingSender().run(args);
    }

    private final class EventHandler
    implements ILnkEventHandler {
        private EventHandler() {
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int event, Object data) {
            switch (event) {
                case 8: {
                    System.out.println("[StreamingSender] Link (" + ep.toString() + ") failure [" + ((Exception)data).toString() + "]");
                    break;
                }
                default: {
                    throw new InternalError("Received event [type=" + event + " data=" + data + "]!");
                }
            }
        }
    }

    private final class ConnectCompleteEventHandler
    implements ILnkEventHandler {
        LnkEvents.ConnectAcceptCompleteEventData eventData;

        private ConnectCompleteEventHandler() {
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int event, Object data) {
            this.eventData = (LnkEvents.ConnectAcceptCompleteEventData)data;
        }
    }
}

