/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoField;
import com.neeve.sto.StoLongField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class StoLongFieldTest
extends UnitTest {
    private final void validate(StoLongField field, String name, ByteBuffer buffer, long val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.LONG), (Object)((Object)field.getType()));
        Assert.assertEquals((long)field.getValue(), (long)val);
    }

    private final void cloneAndValidate(StoLongField field, String name, long val) {
        StoLongField clone = (StoLongField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoLongField.getSerializedLength(null, 0), (long)8L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoLongField.put(buffer, 5, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoLongField.get(buffer, 5), (long)4294968296L);
        this.validate(buffer, 0, 100, 100);
        StoLongField.put(buffer, 5, 4295857941L);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoLongField.get(buffer, 5), (long)4295857941L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoLongField field = StoLongField.create(null);
        this.validate(field, null, null, 0L);
        this.cloneAndValidate(field, null, 0L);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoLongField field = StoLongField.create("name");
        this.validate(field, "name", null, 0L);
        this.cloneAndValidate(field, "name", 0L);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoLongField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoLongField field = StoLongField.create(null);
        field.setValue(4294968296L);
        this.validate(field, null, null, 4294968296L);
        this.cloneAndValidate(field, null, 4294968296L);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoLongField field = StoLongField.create("name");
        field.setValue(4294968296L);
        this.validate(field, "name", null, 4294968296L);
        this.cloneAndValidate(field, "name", 4294968296L);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoLongField field = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 0L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 0L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoLongField field = StoLongField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 0L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 0L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoLongField field = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(4294968296L);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoLongField field = StoLongField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(4294968296L);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoLongField field = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(4294968296L);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoLongField field = StoLongField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(4294968296L);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoLongField field = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(4294968296L);
        this.validate(field, null, buffer, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoLongField field = StoLongField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(4294968296L);
        this.validate(field, "name", buffer, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoLongField field = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(4294968296L);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoLongField field = StoLongField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(4294968296L);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoLongField field = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(4294968296L);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoLongField.get(buffer, field.shiftForHeader(45)), (long)4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoLongField field = StoLongField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(4294968296L);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoLongField.get(buffer, field.shiftForHeader(52)), (long)4294968296L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(4294968296L);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoLongField field2 = (StoLongField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoLongField field1 = StoLongField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(4294968296L);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoLongField field2 = (StoLongField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(4294968296L);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoLongField field2 = (StoLongField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoLongField field1 = StoLongField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(4294968296L);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoLongField field2 = (StoLongField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", 4294968296L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(4294968296L);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoLongField field2 = (StoLongField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoLongField field3 = (StoLongField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, 4294968296L);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, 4294968296L);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoLongField field1 = StoLongField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(42949656296L);
        field1.setBackingBuffer(buffer1, 35);
        this.validate(buffer1, 0, 100, 100);
        StoLongField field2 = (StoLongField)StoField.create(buffer1, 35);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoLongField field3 = (StoLongField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, 42949656296L);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", 42949656296L);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoLongField field2 = (StoLongField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 0L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoLongField field2 = (StoLongField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoLongField.create("name").contentsEquals(StoLongField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoLongField.create(null).contentsEquals(StoLongField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoLongField.create("name1").contentsEquals(StoLongField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        StoLongField field2 = StoLongField.create(null);
        field1.setValue(100L);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        StoLongField field2 = StoLongField.create(null);
        field2.setValue(100L);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        StoLongField field2 = StoLongField.create(null);
        field1.setValue(67L);
        field2.setValue(178L);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        StoLongField field2 = StoLongField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoLongField field1 = StoLongField.create("name");
        StoLongField field2 = StoLongField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoLongField field1 = StoLongField.create(null);
        StoLongField field2 = StoLongField.create(null);
        field1.setValue(42L);
        field2.setValue(42L);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoLongField field1 = StoLongField.create("name");
        StoLongField field2 = StoLongField.create("name");
        field1.setValue(66L);
        field2.setValue(66L);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

