/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.types.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.types.PktBodyCompressedText;
import com.neeve.pkt.types.PktBodyText;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import org.junit.Assert;
import org.junit.Test;

public final class PktBodyTextTest {
    private String text;
    private final Random random = new Random(System.currentTimeMillis());

    private final String randomString() {
        StringBuilder sb = new StringBuilder();
        int size = this.random.nextInt(512);
        for (int i = 0; i < size; ++i) {
            sb.append(this.random.nextInt(9));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int compressedLength(byte[] input) throws Exception {
        if (input.length == 0) {
            return 0;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DeflaterOutputStream compresser = new DeflaterOutputStream(baos);){
            compresser.write(input, 0, input.length);
            compresser.finish();
            compresser.flush();
            int n = baos.toByteArray().length;
            return n;
        }
    }

    private final int serializedLength(String str, boolean compressed) throws Exception {
        return 4 + (str != null ? (compressed ? this.compressedLength(str.getBytes("UTF-8")) : str.getBytes("UTF-8").length) : 0);
    }

    private final int expectedSerializedLength(boolean compressed) throws Exception {
        return this.serializedLength(this.text, compressed);
    }

    private void validate(PktBodyText body) throws Exception {
        Assert.assertEquals((long)this.expectedSerializedLength(body instanceof PktBodyCompressedText), (long)body.getSerializedLength());
        Assert.assertEquals((Object)this.text, (Object)body.getText());
    }

    private PktBodyText createBody(boolean compressed) {
        return (PktBodyText)(compressed ? PktBodyCompressedText.create() : PktBodyText.create());
    }

    private void reset(PktBodyText body) {
        body.reset();
        this.text = null;
    }

    private PktSerializable.SerializeContext serialize(PktBodyText body, PktSerializable.SerializeContext sc) {
        sc.setBufferCount(0);
        sc.addBuffer(IOBuffer.create((int)body.getSerializedLength(), (boolean)false));
        body.serialize(sc);
        return sc;
    }

    private PktBodyText deserialize(PktSerializable.SerializeContext sc, boolean compressed) {
        PktSerializable.DeserializeContext dc = PktSerializable.DeserializeContext.create();
        dc.setBuffer(sc.flipBuffers().getByteBuffer(0));
        PktBodyText body = this.createBody(compressed);
        body.deserialize(dc, dc.getBuffer().remaining(), null);
        return body;
    }

    private void testIOBufferIsNullOnCreate(boolean compressed) {
        Assert.assertNull((Object)this.createBody(compressed).getBuffer().getIOBuffer());
    }

    private void testTextReadOnlyOnDeserialize(boolean compressed) throws Exception {
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        PktBodyText body = this.createBody(compressed);
        this.deserialize(this.serialize(body, sc), compressed).setText("test");
    }

    private void testFieldPopulation(boolean compressed) throws Exception {
        PktBodyText body = this.createBody(compressed);
        this.validate(body);
        this.text = this.randomString();
        body.setText(this.text);
        this.validate(body);
        this.text = null;
        body.setText(null);
        this.validate(body);
        this.text = this.randomString();
        body.setText(this.text);
        this.validate(body);
        this.reset(body);
        this.validate(body);
        this.text = this.randomString();
        body.setText(this.text);
        System.out.println("Field population stress (compressed=" + compressed + ")...");
        long ts = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            switch (this.random.nextInt(1)) {
                case 0: {
                    this.text = this.randomString();
                    body.setText(this.text);
                }
            }
            this.validate(body);
            if (i % 100000 != 0) continue;
            System.out.println("..." + i);
        }
        System.out.println("...complete (1M packets)..." + (System.currentTimeMillis() - ts) / 1000L + " seconds");
    }

    private void testFieldPopulationWithSerialization(boolean compressed) throws Exception {
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        PktBodyText body = this.createBody(compressed);
        this.validate(body);
        this.text = this.randomString();
        body.setText(this.text);
        this.validate(this.deserialize(this.serialize(body, sc), compressed));
        this.text = null;
        body.setText(null);
        this.validate(this.deserialize(this.serialize(body, sc), compressed));
        this.text = this.randomString();
        body.setText(this.text);
        this.validate(this.deserialize(this.serialize(body, sc), compressed));
        this.reset(body);
        this.validate(this.deserialize(this.serialize(body, sc), compressed));
        this.text = this.randomString();
        body.setText(this.text);
        body = this.deserialize(this.serialize(body, sc), compressed);
        this.reset(body);
        this.validate(body);
        this.validate(this.deserialize(this.serialize(body, sc), compressed));
        this.text = this.randomString();
        body.setText(this.text);
        this.validate(body);
        this.validate(this.deserialize(this.serialize(body, sc), compressed));
        System.out.println("Field population with serialization stress (compressed=" + compressed + ")...");
        long ts = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            this.text = this.randomString();
            body.setText(this.text);
            this.validate(this.deserialize(this.serialize(body, sc), compressed));
            if (i % 100000 != 0) continue;
            System.out.println("..." + i);
        }
        System.out.println("...complete (1M packets)..." + (System.currentTimeMillis() - ts) / 1000L + " seconds");
    }

    @Test
    public void testIOBufferIsNullOnCreate() {
        this.testIOBufferIsNullOnCreate(false);
    }

    @Test
    public void testIOBufferIsNullOnCreate_Compressed() {
        this.testIOBufferIsNullOnCreate(true);
    }

    @Test(expected=IllegalStateException.class)
    public void testTextReadOnlyOnDeserialize() throws Exception {
        this.testTextReadOnlyOnDeserialize(false);
    }

    @Test(expected=IllegalStateException.class)
    public void testTextReadOnlyOnDeserialize_Compressed() throws Exception {
        this.testTextReadOnlyOnDeserialize(true);
    }

    @Test
    public void testFieldPopulation() throws Exception {
        this.testFieldPopulation(false);
    }

    @Test
    public void testFieldPopulation_Compressed() throws Exception {
        this.testFieldPopulation(true);
    }

    @Test
    public void testFieldPopulationWithSerialization() throws Exception {
        this.testFieldPopulationWithSerialization(false);
    }

    @Test
    public void testFieldPopulationWithSerialization_Compressed() throws Exception {
        this.testFieldPopulationWithSerialization(true);
    }
}

