/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.types.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.types.PktBodyRecoveryLogCheckpointState;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class PktBodyRecoveryLogCheckpointStateTest {
    private String state;
    private final Random random = new Random(System.currentTimeMillis());

    private final String randomString() {
        StringBuilder sb = new StringBuilder();
        int size = 1 + this.random.nextInt(20);
        for (int i = 0; i < size; ++i) {
            sb.append(this.random.nextInt(9));
        }
        return sb.toString();
    }

    private final int serializedLength(String str) throws Exception {
        return 2 + (str != null ? str.getBytes("UTF-8").length : 0);
    }

    private final int expectedSerializedLength() throws Exception {
        return this.serializedLength(this.state);
    }

    private void validate(PktBodyRecoveryLogCheckpointState body) throws Exception {
        Assert.assertEquals((long)this.expectedSerializedLength(), (long)body.getSerializedLength());
        Assert.assertEquals((Object)this.state, (Object)body.getState());
    }

    private void reset(PktBodyRecoveryLogCheckpointState body) {
        body.reset();
        this.state = null;
    }

    private PktSerializable.SerializeContext serialize(PktBodyRecoveryLogCheckpointState body, PktSerializable.SerializeContext sc) {
        sc.setBufferCount(0);
        sc.addBuffer(IOBuffer.create((int)body.getSerializedLength(), (boolean)false));
        body.serialize(sc);
        return sc;
    }

    private PktBodyRecoveryLogCheckpointState deserialize(PktSerializable.SerializeContext sc) {
        PktSerializable.DeserializeContext dc = PktSerializable.DeserializeContext.create();
        dc.setBuffer(sc.flipBuffers().getByteBuffer(0));
        PktBodyRecoveryLogCheckpointState body = (PktBodyRecoveryLogCheckpointState)PktBodyRecoveryLogCheckpointState.create();
        body.deserialize(dc, dc.getBuffer().remaining(), null);
        return body;
    }

    @Test
    public void testIOBufferIsNullOnCreate() {
        Assert.assertNull((Object)PktBodyRecoveryLogCheckpointState.create().getBuffer().getIOBuffer());
    }

    @Test(expected=IllegalStateException.class)
    public void testStateReadOnlyOnDeserialize() throws Exception {
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        PktBodyRecoveryLogCheckpointState body = (PktBodyRecoveryLogCheckpointState)PktBodyRecoveryLogCheckpointState.create();
        this.deserialize(this.serialize(body, sc)).setState("test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStateSetEmptyString() throws Exception {
        ((PktBodyRecoveryLogCheckpointState)PktBodyRecoveryLogCheckpointState.create()).setState("");
    }

    @Test
    public void testFieldPopulation() throws Exception {
        PktBodyRecoveryLogCheckpointState body = (PktBodyRecoveryLogCheckpointState)PktBodyRecoveryLogCheckpointState.create();
        this.validate(body);
        this.state = this.randomString();
        body.setState(this.state);
        this.validate(body);
        this.state = null;
        body.setState(null);
        this.validate(body);
        this.state = this.randomString();
        body.setState(this.state);
        this.validate(body);
        this.reset(body);
        this.validate(body);
        this.state = this.randomString();
        body.setState(this.state);
        this.validate(body);
        for (int i = 0; i < 1000000; ++i) {
            switch (this.random.nextInt(1)) {
                case 0: {
                    this.state = this.randomString();
                    body.setState(this.state);
                }
            }
            this.validate(body);
        }
    }

    @Test
    public void testFieldPopulationWithSerialization() throws Exception {
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        PktBodyRecoveryLogCheckpointState body = (PktBodyRecoveryLogCheckpointState)PktBodyRecoveryLogCheckpointState.create();
        this.validate(body);
        this.state = this.randomString();
        body.setState(this.state);
        this.validate(this.deserialize(this.serialize(body, sc)));
        this.state = null;
        body.setState(null);
        this.validate(this.deserialize(this.serialize(body, sc)));
        this.state = this.randomString();
        body.setState(this.state);
        this.validate(this.deserialize(this.serialize(body, sc)));
        this.reset(body);
        this.validate(this.deserialize(this.serialize(body, sc)));
        this.state = this.randomString();
        body.setState(this.state);
        this.validate(this.deserialize(this.serialize(body, sc)));
        body = this.deserialize(this.serialize(body, sc));
        this.reset(body);
        this.validate(body);
        this.validate(this.deserialize(this.serialize(body, sc)));
        this.state = this.randomString();
        body.setState(this.state);
        this.validate(body);
        for (int i = 0; i < 1000000; ++i) {
            switch (this.random.nextInt(1)) {
                case 0: {
                    this.state = this.randomString();
                    body.setState(this.state);
                }
            }
            this.validate(this.deserialize(this.serialize(body, sc)));
        }
    }
}

