/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.types;

import com.neeve.ci.XRuntime;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.sto.EStoInsufficientSpaceException;
import com.neeve.sto.IStoBufferManager;
import com.neeve.sto.StoFieldContainer;
import com.neeve.util.UtlProps;
import java.nio.ByteBuffer;
import java.util.Properties;

public abstract class PktBodyStoContainer
extends PktBodyData
implements IStoBufferManager {
    private static final int defaultBufferSize = UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.packet.sto.defaultbuffersize", (int)256);
    private StoFieldContainer container;
    private boolean inalloc;

    protected PktBodyStoContainer(int type, Properties props, boolean direct) {
        super(type, props, direct);
    }

    @Override
    protected final void postDeserialize(int len) {
        super.postDeserialize(len);
        ByteBuffer buffer = this.getBuffer().getIOBufferForWrite().getBufferUnsafe();
        if (this.container == null) {
            this.container = StoFieldContainer.create(buffer);
            this.container.setBackingBufferManager(this);
        } else if (this.container.getBackingBuffer() != buffer) {
            this.container.changeBackingBuffer(buffer);
        }
    }

    @Override
    protected final void doReset() {
        if (this.container != null) {
            this.container.reset();
        } else {
            super.doReset();
        }
    }

    @Override
    public final int doGetSerializedLength() {
        if (this.container != null && !this.inalloc) {
            try {
                this.container.sync();
                this.setBufferLength(this.container.getBackingBuffer().position());
            }
            catch (EStoInsufficientSpaceException e) {
                throw new InternalError("Insufficient space in backing packet buffer [" + this.container.getBackingBuffer() + "] to serialize STO container");
            }
        }
        return super.doGetSerializedLength();
    }

    @Override
    public final ByteBuffer allocate(int len) {
        this.inalloc = true;
        try {
            this.setBufferLength(len);
            ByteBuffer byteBuffer = this.getBuffer().getIOBufferForWrite().getBufferUnsafe();
            return byteBuffer;
        }
        finally {
            this.inalloc = false;
        }
    }

    public final StoFieldContainer getContainer() {
        if (this.container == null) {
            this.setBufferLength(defaultBufferSize);
            this.container = StoFieldContainer.create();
            this.container.setBackingBuffer(this.getBuffer().getIOBufferForWrite().getBufferUnsafe());
            this.container.setBackingBufferManager(this);
        }
        return this.container;
    }
}

