/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOElasticBuffer;
import com.neeve.rog.log.RogLogMetadata;
import com.neeve.test.UnitTest;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class RogLogMetadataTest
extends UnitTest {
    @Rule
    public TestName name = new TestName();

    @After
    public void cleanup() {
        File metadata = new File(XRuntime.getDataDirectory((boolean)true), this.name.getMethodName() + ".metadata");
        if (metadata.exists()) {
            metadata.delete();
        }
    }

    @Test
    public void testAllFieldsWithOpenClose() throws Exception {
        RogLogMetadata metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        UUID uuid = metadata.getLogUUID();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)0L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)false, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)0L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)false, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setCdcCheckpointVersion(10000L);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)false, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)false, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setCdcCursor(20000L);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)false, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)false, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setIsBackup(true);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setCdcEnabled(true);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)0L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)0L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setCdcEnabled(false);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setCdcLogNumber(30000);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setCdcEnabled(true);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setCdcCursor(20000L);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setLastValidatedPosition(40000L);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)40000L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)40000L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong checkpoint version", (long)0L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setLiveLogNumber(50000);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)50000L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)50000L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.setLastValidatedPosition(40000L);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)40000L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)50000L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)40000L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong checkpoint version", (long)50000L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        uuid = new UUID();
        metadata.setLogUUID(uuid);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)40000L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)50000L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)10000L, (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)20000L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)30000L, (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)true, (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)40000L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)50000L, (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)uuid, (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log name", (Object)this.name.getMethodName(), (Object)metadata.getName());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
        RogLogMetadata metadata2 = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), new UUID().toString());
        metadata2.open();
        metadata2.setCdcCheckpointVersion(metadata.getCdcCheckpointVersion() + 1L);
        metadata2.setCdcCursor(metadata.getCdcCursor() + 1L);
        metadata2.setCdcLogNumber(metadata.getCdcLogNumber() + 1);
        metadata2.setIsBackup(!metadata.getIsBackup());
        metadata2.setLastValidatedPosition(metadata.getLastValidatedPosition() + 1L);
        metadata2.setLiveLogNumber(metadata.getLiveLogNumber() + 1);
        metadata.setLogUUID(new UUID());
        IOElasticBuffer buffer = IOElasticBuffer.create(null, (int)1, (boolean)true);
        metadata2.serialize(buffer);
        metadata.open(buffer, null);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)metadata2.getCdcCheckpointVersion(), (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)metadata2.getCdcCursor(), (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)metadata2.getCdcLogNumber(), (long)metadata.getCdcLogNumber());
        Assert.assertEquals((String)"Wrong role value", (Object)metadata2.getIsBackup(), (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)metadata2.getLiveLogNumber(), (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)metadata2.getLogUUID(), (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log version", (long)metadata2.getVersion(), (long)metadata.getVersion());
        metadata.setCdcEnabled(false);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)metadata2.getCdcCheckpointVersion(), (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)metadata2.getIsBackup(), (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)metadata2.getLiveLogNumber(), (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)metadata2.getLogUUID(), (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log version", (long)metadata2.getVersion(), (long)metadata.getVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"Wrong checkpoint version", (long)metadata2.getCdcCheckpointVersion(), (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)metadata2.getIsBackup(), (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)metadata2.getLiveLogNumber(), (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)metadata2.getLogUUID(), (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log version", (long)metadata2.getVersion(), (long)metadata.getVersion());
        metadata.deserialize(buffer, null);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)metadata2.getCdcCheckpointVersion(), (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)metadata2.getCdcCursor(), (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)metadata2.getCdcLogNumber(), (long)metadata.getCdcLogNumber());
        Assert.assertTrue((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)metadata2.getIsBackup(), (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)metadata2.getLiveLogNumber(), (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)metadata2.getLogUUID(), (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log version", (long)metadata2.getVersion(), (long)metadata.getVersion());
        metadata2.setCdcEnabled(false);
        metadata2.serialize(buffer);
        metadata.deserialize(buffer, null);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)metadata2.getCdcCheckpointVersion(), (long)metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)metadata2.getCdcCursor(), (long)metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)metadata2.getCdcLogNumber(), (long)metadata.getCdcLogNumber());
        Assert.assertFalse((String)"Wrong cdc enabled state", (boolean)metadata.isCdcEnabled());
        Assert.assertEquals((String)"Wrong role value", (Object)metadata2.getIsBackup(), (Object)metadata.getIsBackup());
        Assert.assertEquals((String)"Wrong  last validated file position", (long)-1L, (long)metadata.getLastValidatedPosition());
        Assert.assertEquals((String)"Wrong live log number", (long)metadata2.getLiveLogNumber(), (long)metadata.getLiveLogNumber());
        Assert.assertEquals((String)"Wrong uuid", (Object)metadata2.getLogUUID(), (Object)metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log version", (long)metadata2.getVersion(), (long)metadata.getVersion());
    }

    @Test
    public void testLiveLogNumber() throws Exception {
        RogLogMetadata metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        metadata.setLiveLogNumber(20000);
        metadata.close();
        metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        Assert.assertEquals((String)"getLiveLogNumber doesn't match after open", (long)20000L, (long)metadata.getLiveLogNumber());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"getLiveLogNumber doesn't match after open", (long)20000L, (long)metadata.getLiveLogNumber());
    }

    @Test
    public void testCdcLogNumber() throws Exception {
        RogLogMetadata metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        metadata.setCdcLogNumber(20000);
        metadata.close();
        metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        Assert.assertEquals((String)"getCdcLogNumber doesn't match after open", (long)20000L, (long)metadata.getCdcLogNumber());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"getCdcLogNumber doesn't match after open", (long)20000L, (long)metadata.getCdcLogNumber());
    }

    @Test
    public void testCdcCheckpointVersion() throws Exception {
        RogLogMetadata metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        metadata.setCdcCheckpointVersion(20000L);
        metadata.close();
        metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        Assert.assertEquals((String)"getCdcCheckpointVersion doesn't match after open", (long)20000L, (long)metadata.getCdcCheckpointVersion());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"getCdcCheckpointVersion doesn't match after open", (long)20000L, (long)metadata.getCdcCheckpointVersion());
    }

    @Test
    public void testCdcCursor() throws Exception {
        RogLogMetadata metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        metadata.setCdcCursor(100L);
        metadata.close();
        metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        Assert.assertEquals((String)"getCdcCursor doesn't match after open", (long)100L, (long)metadata.getCdcCursor());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"getCdcCursor doesn't match after open", (long)100L, (long)metadata.getCdcCursor());
    }

    @Test
    public void testUUID() throws Exception {
        RogLogMetadata metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        UUID uuid = metadata.getLogUUID();
        Assert.assertNotNull((String)"UUID should not be null", (Object)uuid);
        Assert.assertNotEquals((String)"UUID is not initialized", (long)0L, (long)uuid.getClockSeqAndNode());
        Assert.assertNotEquals((String)"UUID is not initialized", (long)0L, (long)uuid.getTime());
        metadata.close();
        metadata = new RogLogMetadata(new File(XRuntime.getDataDirectory((boolean)true)), this.name.getMethodName());
        metadata.open();
        Assert.assertEquals((String)"UUID doesn't match after open", (Object)uuid, (Object)metadata.getLogUUID());
        metadata.close();
        metadata.open();
        Assert.assertEquals((String)"UUID doesn't match after open", (Object)uuid, (Object)metadata.getLogUUID());
    }

    @Test
    public void testDelete() throws Exception {
        File file = new File(XRuntime.getDataDirectory((boolean)true), this.name.getMethodName() + ".metadata");
        RogLogMetadata metadata = new RogLogMetadata(file.getParentFile(), this.name.getMethodName());
        metadata.open();
        metadata.setCdcCursor(100L);
        Assert.assertTrue((String)("metadata file '" + file + "' doesn't exist"), (boolean)file.exists());
        metadata.close();
        metadata = null;
        boolean deleted = false;
        for (int i = 0; i < 5; ++i) {
            deleted = file.delete();
            if (deleted || !file.exists()) {
                deleted = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)("Unable to delete file '" + file + "'"), (!file.exists() ? 1 : 0) != 0);
    }
}

