/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.neeve.ci.XRuntime;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.test.unit.messages.proto.OutMessage;
import com.neeve.test.UnitTest;
import java.io.File;
import java.util.Properties;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class RogLogBackupTest
extends UnitTest {
    private int logCount;
    private int valCount;
    private long sno;
    private Random random = new Random(System.currentTimeMillis());
    private RogLog log;

    private final void createLog(String name, boolean open) throws Exception {
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        props.setProperty("initialLogLength", "0.01");
        this.log = RogLog.create(name == null ? "logBackupTest-" + System.currentTimeMillis() + "-" + ++this.logCount : name, props);
        if (open) {
            this.log.open();
        }
    }

    private final void logMessages(int count, boolean hasInMsgsInTransaction, long txnId) {
        for (int i = 0; i < count; ++i) {
            OutMessage message = OutMessage.create();
            message.setTransactionId(txnId);
            message.setInMsgsInTransaction(hasInMsgsInTransaction);
            message.setMessageSequenceNumber(++this.sno);
            message.setVal("test-" + System.currentTimeMillis() + "-" + ++this.valCount);
            message.sync();
            this.log.log(message, i == count - 1);
        }
        this.log.flush(true);
    }

    private void testBackupLog(boolean shrink) throws Exception {
        int numEntries = 10 + this.random.nextInt(100);
        System.out.println("creating a new file and writing " + numEntries + " entries to it...");
        this.createLog(null, true);
        this.logMessages(numEntries, false, 0L);
        long size = this.log.getSize();
        System.out.println("size of file is '" + size + "' bytes.");
        String name = this.log.getName();
        this.log.close();
        System.out.println("backing up file...");
        this.createLog(name, false);
        long originalSize = this.log.getLogFile().length();
        String backupName = this.log.backupLog(shrink);
        System.out.println("backed up to '" + backupName + "'.");
        this.log.close();
        System.out.println("validating backed up file size...");
        File backupFile = new File(backupName);
        Assert.assertEquals((long)(shrink ? size : originalSize), (long)backupFile.length());
        backupFile.renameTo(new File(XRuntime.getDataDirectory() + File.separator + name + ".log"));
        System.out.println("validating backed up file can be reopened...");
        this.createLog(name, true);
        System.out.println("validating size as opened by the log...");
        Assert.assertEquals((long)size, (long)this.log.getSize());
    }

    @Test
    public void testBackupLogWithShrink() throws Exception {
        this.testBackupLog(true);
    }

    @Test
    public void testBackupLogWithoutShrink() throws Exception {
        this.testBackupLog(false);
    }
}

