/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.neeve.query.impl.QuerySortAreaImpl;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.test.UnitTest;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QuerySortAreaTest
extends UnitTest {
    private static final int largeTestSize = 100000;
    private static QuerySortAreaImpl<Integer, MockRecord> sortArea;

    @Before
    public void before() throws Exception {
        sortArea = new QuerySortAreaImpl();
        sortArea.open();
    }

    @After
    public void after() throws Exception {
        sortArea.close();
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        sortArea.awaitShutdown();
    }

    @Test
    public void testOpenClose() {
    }

    @Test
    public void testHashMap() {
        String id = sortArea.createCollectionId();
        Map<Integer, String> map = sortArea.getHashMap(id);
        for (int i = 0; i < 10; ++i) {
            map.put(i, "payload[" + i + "]");
        }
        Assert.assertEquals((String)"should contain 7", (Object)"payload[7]", map.get(7));
        Assert.assertEquals((String)"should be 10 elements", (long)10L, (long)map.size());
        sortArea.dropCollection(id);
    }

    @Test
    public void testLargeMap() {
        String smallCollectionId = sortArea.createCollectionId();
        Map<Integer, String> map = sortArea.getHashMap(smallCollectionId);
        for (int i = 0; i < 100; ++i) {
            map.put(i, "payload[" + i + "]");
        }
        long start = System.currentTimeMillis();
        sortArea.dropCollection(smallCollectionId);
        long smallCollectionDropMillis = System.currentTimeMillis() - start;
        if (QuerySortAreaTest.verbose()) {
            System.out.println("Small collection drop: " + smallCollectionDropMillis);
        }
        String id = sortArea.createCollectionId();
        map = sortArea.getHashMap(id);
        for (int i = 0; i < 100000; ++i) {
            map.put(i, "payload[" + i + "]");
        }
        Assert.assertEquals((String)"should contain 0", (Object)"payload[0]", map.get(0));
        Assert.assertEquals((String)"should contain 7", (Object)"payload[7]", map.get(7));
        int lastIndex = 99999;
        Assert.assertEquals((String)("should contain " + lastIndex), (Object)("payload[" + lastIndex + "]"), map.get(lastIndex));
        start = System.currentTimeMillis();
        sortArea.dropCollection(id);
        long dropMillis = System.currentTimeMillis() - start;
        if (QuerySortAreaTest.verbose()) {
            System.out.println("large collection drop: " + dropMillis);
        }
        long expectedMillis = smallCollectionDropMillis + 200L;
        Assert.assertTrue((String)("Dropping the collection took too long: " + dropMillis + "ms. Expected under " + expectedMillis + "ms"), (dropMillis < expectedMillis ? 1 : 0) != 0);
    }
}

