/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.akiban.sql.parser.CreateIndexNode;
import com.akiban.sql.parser.DropIndexNode;
import com.akiban.sql.parser.IndexColumn;
import com.akiban.sql.parser.IndexColumnList;
import com.akiban.sql.parser.StatementNode;
import com.google.common.collect.Lists;
import com.neeve.query.impl.QueryParser;
import com.neeve.util.UtlDataTypes;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ParserTest {
    private static QueryParser parser;
    private static final DateFormat dateTimeFormat;
    private static final DateFormat dateFormat;
    private static QueryParser.Column firstNameCol;
    private static QueryParser.Column lastNameCol;
    private static QueryParser.Column repoNameCol;
    private static QueryParser.Column zipPlus4Col;

    @BeforeClass
    public static void init() {
        parser = new QueryParser();
    }

    @Test
    public void testColumns() {
        String xsql = "select Customer.firstName, Customer.lastName from x";
        QueryParser.Result parseResult = parser.parseQuery(xsql);
        List<QueryParser.Column> columnList = parseResult.getColumnList();
        Assert.assertEquals((String)"simple fields", (Object)Lists.newArrayList((Object[])new QueryParser.Column[]{firstNameCol, lastNameCol}), columnList);
        xsql = "select Customer.firstName from x";
        parseResult = parser.parseQuery(xsql);
        columnList = parseResult.getColumnList();
        Assert.assertEquals((String)"single column", (Object)Lists.newArrayList((Object[])new QueryParser.Column[]{firstNameCol}), columnList);
        xsql = "select Customer.firstName, Customer.lastName, x_repository_name from x";
        parseResult = parser.parseQuery(xsql);
        columnList = parseResult.getColumnList();
        Assert.assertEquals((String)"fields and pseudo-column", (Object)Lists.newArrayList((Object[])new QueryParser.Column[]{firstNameCol, lastNameCol, repoNameCol}), columnList);
        xsql = "select Customer.firstName, Customer.address.zipcode.plus4 from x";
        parseResult = parser.parseQuery(xsql);
        columnList = parseResult.getColumnList();
        Assert.assertEquals((String)"fields and pseudo-column", (Object)Lists.newArrayList((Object[])new QueryParser.Column[]{firstNameCol, zipPlus4Col}), columnList);
    }

    @Test
    public void testFrom() {
        String xsql = "select Customer.lastName from aurora";
        QueryParser.Result parseResult = parser.parseQuery(xsql);
        List<String> fromList = parseResult.getFromList();
        Assert.assertEquals((String)"from repo", (Object)Lists.newArrayList((Object[])new String[]{"aurora"}), fromList);
        xsql = "select * from all_logs";
        parseResult = parser.parseQuery(xsql);
        fromList = parseResult.getFromList();
        Assert.assertEquals((String)"from view", (Object)Lists.newArrayList((Object[])new String[]{"all_logs"}), fromList);
    }

    @Test
    public void testWhere() {
        String xsql = "select Customer.lastName from log";
        QueryParser.Result parseResult = parser.parseQuery(xsql);
        QueryParser.Condition where = parseResult.getWhere();
        Assert.assertNull((String)"no where clause", (Object)where);
        xsql = "select Customer.lastName from log where x = 4";
        parseResult = parser.parseQuery(xsql);
        where = parseResult.getWhere();
        Assert.assertTrue((String)"leaf condition", (boolean)(where instanceof QueryParser.LeafCondition));
        QueryParser.LeafCondition leaf = (QueryParser.LeafCondition)where;
        QueryParser.Column columnName = leaf.getColumn();
        String operator = leaf.getOperator();
        List<Object> values = leaf.getValues();
        Assert.assertEquals((String)"column is x", (Object)new QueryParser.Column("x"), (Object)columnName);
        Assert.assertEquals((String)"operator is =", (Object)"=", (Object)operator);
        Assert.assertEquals((String)"value is 4", (Object)Lists.newArrayList((Object[])new Integer[]{4}), values);
        xsql = "select Customer.lastName from log where Customer.lastName >= 'Smith'";
        parseResult = parser.parseQuery(xsql);
        where = parseResult.getWhere();
        Assert.assertTrue((String)"leaf condition", (boolean)(where instanceof QueryParser.LeafCondition));
        leaf = (QueryParser.LeafCondition)where;
        columnName = leaf.getColumn();
        operator = leaf.getOperator();
        values = leaf.getValues();
        Assert.assertEquals((String)"column is x", (Object)lastNameCol, (Object)columnName);
        Assert.assertEquals((String)"operator is =", (Object)">=", (Object)operator);
        Assert.assertEquals((String)"value is 4", (Object)Lists.newArrayList((Object[])new String[]{"Smith"}), values);
    }

    @Test
    public void testCreateIndex() {
        String ddl = "create index customer_id on some_repo(Customer.id)";
        StatementNode stmt = parser.parseDDL(ddl);
        Assert.assertEquals((long)146L, (long)stmt.getNodeType());
        CreateIndexNode createIndex = (CreateIndexNode)stmt;
        Assert.assertEquals((Object)false, (Object)createIndex.getUniqueness());
        String indexName = createIndex.getObjectName().getFullTableName();
        Assert.assertEquals((Object)"customer_id", (Object)indexName);
        String tableName = createIndex.getIndexTableName().getFullTableName();
        Assert.assertEquals((Object)"some_repo", (Object)tableName);
        IndexColumnList indexColumns = createIndex.getColumnList();
        Assert.assertEquals((long)1L, (long)indexColumns.size());
        IndexColumn indexColumn = (IndexColumn)indexColumns.get(0);
        Assert.assertEquals((Object)"Customer", (Object)indexColumn.getTableName().getFullTableName());
        Assert.assertEquals((Object)"id", (Object)indexColumn.getColumnName());
        ddl = "create unique index customer_id on some_repo(Customer.id)";
        stmt = parser.parseDDL(ddl);
        Assert.assertEquals((long)146L, (long)stmt.getNodeType());
        createIndex = (CreateIndexNode)stmt;
        Assert.assertEquals((Object)true, (Object)createIndex.getUniqueness());
        indexName = createIndex.getObjectName().getFullTableName();
        Assert.assertEquals((Object)"customer_id", (Object)indexName);
        tableName = createIndex.getIndexTableName().getFullTableName();
        Assert.assertEquals((Object)"some_repo", (Object)tableName);
        indexColumns = createIndex.getColumnList();
        Assert.assertEquals((long)1L, (long)indexColumns.size());
        indexColumn = (IndexColumn)indexColumns.get(0);
        Assert.assertEquals((Object)"Customer", (Object)indexColumn.getTableName().getFullTableName());
        Assert.assertEquals((Object)"id", (Object)indexColumn.getColumnName());
        ddl = "create unique index customer_id on some_repo(Customer.mixedCase.path.finalField)";
        stmt = parser.parseDDL(ddl);
        Assert.assertEquals((long)146L, (long)stmt.getNodeType());
        createIndex = (CreateIndexNode)stmt;
        Assert.assertEquals((Object)true, (Object)createIndex.getUniqueness());
        indexName = createIndex.getObjectName().getFullTableName();
        Assert.assertEquals((Object)"customer_id", (Object)indexName);
        tableName = createIndex.getIndexTableName().getFullTableName();
        Assert.assertEquals((Object)"some_repo", (Object)tableName);
        indexColumns = createIndex.getColumnList();
        Assert.assertEquals((long)1L, (long)indexColumns.size());
        indexColumn = (IndexColumn)indexColumns.get(0);
        Assert.assertEquals((Object)"Customer", (Object)indexColumn.getTableName().getFullTableName());
        Assert.assertEquals((Object)"mixedCase.path.finalField", (Object)indexColumn.getColumnName());
        ddl = "create index customer_id on another_repo(com/company/Customer.id)";
        stmt = parser.parseDDL(ddl);
        Assert.assertEquals((long)146L, (long)stmt.getNodeType());
        createIndex = (CreateIndexNode)stmt;
        Assert.assertEquals((Object)false, (Object)createIndex.getUniqueness());
        indexName = createIndex.getObjectName().getFullTableName();
        Assert.assertEquals((Object)"customer_id", (Object)indexName);
        tableName = createIndex.getIndexTableName().getFullTableName();
        Assert.assertEquals((Object)"another_repo", (Object)tableName);
        indexColumns = createIndex.getColumnList();
        Assert.assertEquals((long)1L, (long)indexColumns.size());
        indexColumn = (IndexColumn)indexColumns.get(0);
        Assert.assertEquals((Object)"com.company.Customer", (Object)indexColumn.getTableName().getFullTableName());
        Assert.assertEquals((Object)"id", (Object)indexColumn.getColumnName());
        ddl = "create unique index customer_id on another_repo(com/company/Customer.mixedCase.path.finalField)";
        stmt = parser.parseDDL(ddl);
        Assert.assertEquals((long)146L, (long)stmt.getNodeType());
        createIndex = (CreateIndexNode)stmt;
        Assert.assertEquals((Object)true, (Object)createIndex.getUniqueness());
        indexName = createIndex.getObjectName().getFullTableName();
        Assert.assertEquals((Object)"customer_id", (Object)indexName);
        tableName = createIndex.getIndexTableName().getFullTableName();
        Assert.assertEquals((Object)"another_repo", (Object)tableName);
        indexColumns = createIndex.getColumnList();
        Assert.assertEquals((long)1L, (long)indexColumns.size());
        indexColumn = (IndexColumn)indexColumns.get(0);
        Assert.assertEquals((Object)"com.company.Customer", (Object)indexColumn.getTableName().getFullTableName());
        Assert.assertEquals((Object)"mixedCase.path.finalField", (Object)indexColumn.getColumnName());
        ddl = "create index customer_id on \"dir/path/some-file.log\"(Customer.id)";
        stmt = parser.parseDDL(ddl);
        Assert.assertEquals((long)146L, (long)stmt.getNodeType());
        createIndex = (CreateIndexNode)stmt;
        Assert.assertFalse((boolean)createIndex.getUniqueness());
        indexName = createIndex.getObjectName().getFullTableName();
        Assert.assertEquals((Object)"customer_id", (Object)indexName);
        tableName = createIndex.getIndexTableName().getFullTableName();
        Assert.assertEquals((Object)"dir/path/some-file.log", (Object)tableName);
        indexColumns = createIndex.getColumnList();
        Assert.assertEquals((long)1L, (long)indexColumns.size());
        indexColumn = (IndexColumn)indexColumns.get(0);
        Assert.assertEquals((Object)"Customer", (Object)indexColumn.getTableName().getFullTableName());
        Assert.assertEquals((Object)"id", (Object)indexColumn.getColumnName());
    }

    @Test
    public void testDropIndex() {
        StatementNode stmt = parser.parseDDL("drop index customer_id");
        Assert.assertEquals((long)63L, (long)stmt.getNodeType());
        DropIndexNode dropIndex = (DropIndexNode)stmt;
        Assert.assertEquals((Object)"customer_id", (Object)dropIndex.getIndexName());
    }

    @Test
    public void testDateTimeParse() throws ParseException {
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        Calendar pastDate = (Calendar)now.clone();
        pastDate.add(6, -1);
        this.checkParsedDate("yesterday", dateTimeFormat.parse(dateFormat.format(pastDate.getTime()) + " 00:00:00.000"));
        this.checkParsedDate("yesterday at noon", dateTimeFormat.parse(dateFormat.format(pastDate.getTime()) + " 12:00:00.000"));
        pastDate.add(1, -20);
        this.checkParsedDate("20 years ago yesterday", dateTimeFormat.parse(dateFormat.format(pastDate.getTime()) + " 00:00:00.000"));
        this.checkParsedDate("2005-05-01", dateTimeFormat.parse("05/01/2005 00:00:00.000"));
        this.checkParsedDate("1998-01-01 23:59:59.995", dateTimeFormat.parse("01/01/1998 23:59:59.995"));
        long offsetFromHawaii = TimeZone.getDefault().getOffset(now.getTimeInMillis()) - TimeZone.getTimeZone("HST").getOffset(now.getTimeInMillis());
        this.checkParsedDate(new Timestamp(now.getTimeInMillis()).toString() + " HST", new Date(now.getTimeInMillis() + offsetFromHawaii));
    }

    private void checkParsedDate(String parseValue, Date expected) throws ParseException {
        Date result = (Date)UtlDataTypes.convert(Date.class, (Object)parseValue);
        System.out.println(parseValue + ": " + dateTimeFormat.format(result));
        Assert.assertEquals((String)("Incorrect date parse for: " + parseValue), (Object)dateTimeFormat.format(expected), (Object)dateTimeFormat.format(result));
    }

    @Test
    public void testUntypedQuery() {
        parser.parseQuery("select Object.orderId from x");
    }

    @Test
    public void testEscapedRepoName() {
        String logLocation = "some/Path's/engine-1234.log";
        QueryParser.Result parsed = parser.parseQuery("select Object.orderId from \"" + logLocation + "\", another_repo");
        List<String> fromList = parsed.getFromList();
        Assert.assertEquals((String)"should be one repo", (long)2L, (long)fromList.size());
        Assert.assertEquals((String)"1st repo should be logLocation", (Object)logLocation, (Object)fromList.get(0));
        Assert.assertEquals((String)"2nd repo should be another_repo", (Object)"another_repo", (Object)fromList.get(1));
    }

    @Test
    public void testQuotation() {
        QueryParser.Result parsed = parser.parseQuery("select * from mock where foo='this''ll do'");
        QueryParser.Condition where = parsed.getWhere();
        List<Object> values = ((QueryParser.LeafCondition)where).getValues();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"this'll do"}), values);
        parsed = parser.parseQuery("select * from mock where foo='I said \"boo\"'");
        where = parsed.getWhere();
        values = ((QueryParser.LeafCondition)where).getValues();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"I said \"boo\""}), values);
    }

    @Test
    public void testSplitting() {
        String[] tokens;
        String sql = "select a,b, c from foo";
        String sql2 = sql.replaceAll(",\\b", ", ");
        System.out.println(sql2);
        for (String token : tokens = sql.split("(,\\b|\\W)")) {
            System.out.println(token);
        }
    }

    static {
        dateTimeFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss.SSS");
        dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        firstNameCol = new QueryParser.Column("Customer", "firstName");
        lastNameCol = new QueryParser.Column("Customer", "lastName");
        repoNameCol = new QueryParser.Column("x_repository_name");
        zipPlus4Col = new QueryParser.Column("Customer", "address.zipcode.plus4");
    }
}

