/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreIndex;
import com.neeve.ods.IStoreObject;
import com.neeve.query.IQueryAPICallerContext;
import com.neeve.query.impl.util.collect.UtlRangeBase;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxRange;
import java.util.Iterator;

abstract class StoreIndexBase<K, T extends IStoreObject>
implements IStoreIndex<K, T> {
    private final IdxIndex<K, ?> wrappedIndex;
    private final IQueryAPICallerContext callerContext;
    private final IStoreBinding store;
    private boolean valid = true;

    public <ID> StoreIndexBase(IdxIndex<K, ID> wrappedIndex, IQueryAPICallerContext callerContext, IStoreBinding store) {
        if (wrappedIndex == null) {
            throw new IllegalArgumentException("'wrappedIndex' cannot be null.");
        }
        this.wrappedIndex = wrappedIndex;
        this.callerContext = callerContext;
        if (store == null) {
            throw new IllegalArgumentException("'store' cannot be null.");
        }
        this.store = store;
    }

    protected final IdxIndex<K, ?> getWrappedIndex() {
        return this.wrappedIndex;
    }

    protected final IStoreBinding getStore() {
        return this.store;
    }

    public final void invalidate() {
        this.valid = false;
    }

    protected final void checkValid() {
        this.checkCallerContextValid();
        this.checkInstanceValid();
    }

    protected final void checkCallerContextValid() {
        if (this.callerContext != null) {
            this.callerContext.checkAPIContextValid();
        }
    }

    protected void checkInstanceValid() {
        if (!this.valid) {
            throw new IllegalStateException("This index view instance can no longer be used after index is dropped.");
        }
    }

    protected <KEY extends Comparable<KEY>> IdxRange<KEY> createRange(KEY start, KEY end, boolean includeStart, boolean includeEnd) {
        UtlRangeBase<KEY> range = new UtlRangeBase<KEY>(start, end);
        range.setIncludeStart(includeStart);
        range.setIncludeEnd(includeEnd);
        return range;
    }

    @Override
    public String getName() {
        this.checkValid();
        return this.wrappedIndex.getName();
    }

    @Override
    public int getKeyCardinality() {
        this.checkValid();
        return this.wrappedIndex.getStats().getKeyCardinality();
    }

    @Override
    public int getCardinality() {
        this.checkValid();
        return this.wrappedIndex.getStats().getCardinality();
    }

    @Override
    public K getLowKey() {
        this.checkValid();
        return this.wrappedIndex.getStats().getLowKey();
    }

    @Override
    public K getHighKey() {
        this.checkValid();
        return this.wrappedIndex.getStats().getHighKey();
    }

    @Override
    public boolean containsKey(K key) {
        this.checkValid();
        return this.wrappedIndex.containsKey(key);
    }

    @Override
    public String getFieldCanonicalName() {
        return this.wrappedIndex.getField().getCanonicalName();
    }

    @Override
    public Iterable<T> allValues(boolean ascending) {
        this.checkValid();
        Iterable<UUID> ids = this.getWrappedIndex().allIds(ascending);
        return new StoreIndexIteratableAdapater(ids);
    }

    @Override
    public <KEY extends Comparable<KEY>> Iterable<T> get(KEY start, KEY end, boolean includeStart, boolean includeEnd) {
        this.checkValid();
        Iterable<UUID> ids = this.getWrappedIndex().getIds(this.createRange(start, end, includeStart, includeEnd));
        return new StoreIndexIteratableAdapater(ids);
    }

    protected final class StoreIndexIteratableAdapater
    implements Iterable<T> {
        final Iterator<UUID> indexIter;

        public StoreIndexIteratableAdapater(Iterable<UUID> indexIterable) {
            this.indexIter = indexIterable.iterator();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public final boolean hasNext() {
                    return StoreIndexIteratableAdapater.this.indexIter.hasNext();
                }

                @Override
                public final T next() {
                    IStoreObject value = StoreIndexBase.this.store.get(StoreIndexIteratableAdapater.this.indexIter.next());
                    return value;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("It is not possible to remove value through iterator.");
                }
            };
        }
    }
}

