/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.event.IEventHandler;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessagingProviderRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.SmaPermanentException;
import com.neeve.util.UtlLinkedHashMap;
import java.util.Properties;

public final class MessageBusBindingFactory
extends SmaObject {
    private static final MessageBusBindingFactory instance = new MessageBusBindingFactory();

    private MessageBusBindingFactory() {
        super(null);
    }

    public static final MessageBusBindingFactory getInstance() {
        return instance;
    }

    public final MessageBusBinding createBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        String providerName;
        if (userName == null) {
            throw new IllegalArgumentException("user name cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        Properties providerConfig = descriptor.getProviderConfig();
        String string = providerName = providerConfig == null ? null : providerConfig.getProperty("Provider");
        if (providerName == null) {
            throw new SmaPermanentException("a provider has not been configured for the bus");
        }
        return MessagingProviderRegistry.getInstance().getProvider(providerName).createMessageBusBinding(userName, descriptor, eventHandler);
    }

    public final MessageBusBinding createBinding(String userName, String busName, IEventHandler eventHandler) throws SmaException {
        return this.createBinding(userName, MessageBusDescriptor.load(busName, userName), eventHandler);
    }

    public static final MessageChannel.RawKeyResolutionTable createRawKeyResolutionTable() {
        return new DefaultRawKeyResolutionTable();
    }

    private static class DefaultRawKeyResolutionTable
    extends UtlLinkedHashMap<String, XString>
    implements MessageChannel.RawKeyResolutionTable {
        private static final long serialVersionUID = 1L;

        private DefaultRawKeyResolutionTable() {
        }

        @Override
        public XString get(String key) {
            return (XString)super.get((Object)key);
        }

        @Override
        public XString remove(String key) {
            return (XString)super.remove((Object)key);
        }

        @Override
        public boolean containsKey(String key) {
            return super.containsKey((Object)key);
        }

        @Override
        public XString setProperty(String key, XString value) {
            return (XString)super.put((Object)key, (Object)value);
        }

        @Override
        public XString getProperty(String key) {
            return (XString)super.get((Object)key);
        }
    }
}

