/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import cern.colt.list.DoubleArrayList;
import com.neeve.lang.XIntIterator;
import com.neeve.server.controller.SrvController;
import com.neeve.server.mon.SrvMonIntSeries;
import com.neeve.stats.IStats;
import com.neeve.stats.StatsFactory;
import com.neeve.test.UnitTest;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.HdrHistogram.IntCountsHistogram;
import org.junit.Assert;
import org.junit.Test;

public class LatenciesTest
extends UnitTest {
    @Test
    public void testLatenyCollector() throws InterruptedException {
        this.testLatencyCollection(1024, 10, 1000);
    }

    @Test
    public void testLatenyCollectorUndersampling() throws InterruptedException {
        this.testLatencyCollection(1024, 5, 2000);
    }

    private void testLatencyCollection(int sampleSize, int wrapCount, int sampleFrequency) throws InterruptedException {
        LatenciesTest.setVerbose((boolean)true);
        IStats.Latencies test = StatsFactory.createLatencyStat((String)"test", (int)sampleSize);
        CollectionThread collector = new CollectionThread(test, sampleFrequency);
        collector.start();
        IntCountsHistogram expectedHistogram = new IntCountsHistogram(600000000L, 3);
        if (LatenciesTest.verbose()) {
            System.out.println("Expected Historgram tracking size: " + expectedHistogram.getEstimatedFootprintInBytes() + " bytes.");
        }
        int max = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 1; i <= sampleSize * wrapCount; ++i) {
            test.add((double)i);
            expectedHistogram.recordValue((long)i);
            Thread.sleep(1L);
            max = Math.max(max, i);
            min = Math.min(min, i);
        }
        collector.finish();
        collector.join();
        int lastValue = 0;
        int timingCount = 0;
        int skipCount = 0;
        IStats.Latencies comparison = StatsFactory.createLatencyStat((String)"test", (int)(sampleSize * wrapCount));
        for (SrvMonIntSeries t : collector.timingsCollected) {
            ++timingCount;
            XIntIterator values = t.getDataPointsIterator();
            boolean skipExpected = t.getSkippedDatapoints() > (long)skipCount;
            int c = 0;
            while (values.hasNext()) {
                ++c;
                int v = values.next();
                if (!skipExpected) {
                    Assert.assertEquals((String)("Unexpected value reported for value " + c + " in timings: " + timingCount), (long)(lastValue + 1), (long)v);
                } else {
                    skipExpected = false;
                }
                lastValue = v;
                comparison.add((double)v);
            }
            Assert.assertEquals((String)"Reported raw value size doesn't match num data points", (long)t.getNumDataPoints(), (long)c);
        }
        SrvMonIntSeries timings = (SrvMonIntSeries)collector.timingsCollected.get(collector.timingsCollected.size() - 1);
        Assert.assertEquals((String)"Wrong running sampleSize", (long)expectedHistogram.getTotalCount(), (long)(timings.getRunningStats().getSampleSize() + timings.getSkippedDatapoints()));
        if (timings.getSkippedDatapoints() == 0L) {
            Assert.assertEquals((String)"Wrong running min", (long)min, (long)timings.getRunningStats().getMinimum());
            Assert.assertEquals((String)"Wrong running max", (long)max, (long)timings.getRunningStats().getMaximum());
            Assert.assertEquals((String)"Wrong running mean", (long)((int)expectedHistogram.getMean()), (long)timings.getRunningStats().getMean());
            Assert.assertEquals((String)"Wrong running median", (long)expectedHistogram.getValueAtPercentile(50.0), (long)timings.getRunningStats().getMedian());
            Assert.assertEquals((String)"Wrong running pct 75", (long)expectedHistogram.getValueAtPercentile(75.0), (long)timings.getRunningStats().getPct75());
            Assert.assertEquals((String)"Wrong running pct 90", (long)expectedHistogram.getValueAtPercentile(90.0), (long)timings.getRunningStats().getPct90());
            Assert.assertEquals((String)"Wrong running pct 99", (long)expectedHistogram.getValueAtPercentile(99.0), (long)timings.getRunningStats().getPct99());
            Assert.assertEquals((String)"Wrong running pct 99.9", (long)expectedHistogram.getValueAtPercentile(99.9), (long)timings.getRunningStats().getPct999());
            Assert.assertEquals((String)"Wrong running pct 99.99", (long)expectedHistogram.getValueAtPercentile(99.99), (long)timings.getRunningStats().getPct9999());
        }
        StringBuilder builder = new StringBuilder();
        comparison.compute();
        comparison.get(builder, NumberFormat.getInstance());
        if (LatenciesTest.verbose()) {
            System.out.println("Raw Values computation: " + builder);
        }
    }

    private class CollectionThread
    extends Thread {
        private final IStats.Latencies latencies;
        private final SrvController.IntSeriesCollector collector;
        private final long collectionInterval;
        private final SrvController.IntHistogramComputer intervalComputer;
        private final ArrayList<SrvMonIntSeries> timingsCollected;
        private volatile boolean finished;

        CollectionThread(IStats.Latencies latencies, long collectionInterval) {
            super("CollectionThread");
            this.intervalComputer = new SrvController.IntHistogramComputer();
            this.timingsCollected = new ArrayList();
            this.finished = false;
            this.latencies = latencies;
            this.collector = new SrvController.IntSeriesCollector((IStats.Series)latencies, new DoubleArrayList(), true);
            this.collectionInterval = collectionInterval;
        }

        @Override
        public void run() {
            boolean finishAfter = false;
            while (true) {
                long nextCollection = System.currentTimeMillis() + this.collectionInterval;
                this.timingsCollected.add(this.collector.collect(this.intervalComputer));
                if (LatenciesTest.verbose()) {
                    StringBuilder sb = new StringBuilder();
                    SrvController.StatsRunner.formatForPrint("", this.latencies.getName(), this.timingsCollected.get(this.timingsCollected.size() - 1), sb);
                    System.out.println(sb);
                }
                try {
                    Thread.sleep(nextCollection - System.currentTimeMillis());
                }
                catch (InterruptedException e) {
                    return;
                }
                if (finishAfter) {
                    return;
                }
                if (!this.finished) continue;
                finishAfter = true;
            }
        }

        public void finish() {
            this.finished = true;
        }
    }
}

