/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.link;

import com.neeve.event.IEventHandler;
import com.neeve.lang.XLinkedList;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.server.link.SrvLinkSmaMessageChannel;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.trace.Tracer;

public final class SrvLinkSmaMessageBusBinding
extends MessageBusBindingBase {
    private XLinkedList<SrvLinkSmaMessageChannel> clients;

    SrvLinkSmaMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(null, userName, descriptor, eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushBlocking(ILnkPeerEndpoint.SynchronousBlockingFlushContext flushContext) {
        XLinkedList<SrvLinkSmaMessageChannel> xLinkedList = this.clients;
        synchronized (xLinkedList) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Flushing client channels (channel count=" + this.clients.size() + ") (flush context=" + flushContext + ")...", Tracer.Level.DEBUG);
            }
            try {
                for (SrvLinkSmaMessageChannel channel : this.clients) {
                    try {
                        channel.flush((ILnkPeerEndpoint.FlushContext)flushContext);
                    }
                    catch (SmaException e) {
                        this.tracer.log(this.tracePrefix + "Failed to flush channel " + (Object)((Object)channel) + " [" + e.toString() + "].", Tracer.Level.WARNING);
                    }
                }
                return;
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Flush complete (flush context=" + flushContext + ")...", Tracer.Level.DEBUG);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushNonBlocking(ILnkPeerEndpoint.SynchronousNonBlockingFlushContext flushContext) {
        XLinkedList<SrvLinkSmaMessageChannel> xLinkedList = this.clients;
        synchronized (xLinkedList) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Flushing client channels (channel count=" + this.clients.size() + ") (flush context=" + flushContext + ")...", Tracer.Level.DEBUG);
            }
            try {
                for (SrvLinkSmaMessageChannel channel : this.clients) {
                    try {
                        flushContext.reset();
                        channel.flush((ILnkPeerEndpoint.FlushContext)flushContext);
                        if (flushContext.complete) continue;
                    }
                    catch (SmaException e) {
                        this.tracer.log(this.tracePrefix + "Failed to flush channel " + (Object)((Object)channel) + " [" + e.toString() + "].", Tracer.Level.WARNING);
                        continue;
                    }
                    return;
                }
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Flush complete (flush context=" + flushContext + ")...", Tracer.Level.DEBUG);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onClientConnected(SrvLinkSmaMessageChannel channel) {
        XLinkedList<SrvLinkSmaMessageChannel> xLinkedList = this.clients;
        synchronized (xLinkedList) {
            this.clients.add((Object)channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onClientDisconnected(SrvLinkSmaMessageChannel channel) {
        XLinkedList<SrvLinkSmaMessageChannel> xLinkedList = this.clients;
        synchronized (xLinkedList) {
            int index = this.clients.indexOf((Object)channel);
            if (index >= 0) {
                this.clients.remove(index);
            }
        }
    }

    protected final void doOpen() throws SmaException {
        this.clients = new XLinkedList(256);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Binding opened for user '" + this.userName + "'.", Tracer.Level.DEBUG);
        }
    }

    protected final MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Creating new channel '" + descriptor.getName() + "'.", Tracer.Level.DEBUG);
        }
        return new SrvLinkSmaMessageChannel(descriptor, this);
    }

    protected final void doStart() throws SmaException {
    }

    protected final void doFlush(MessageBusBinding.FlushContext flushContext) throws SmaException {
        ILnkPeerEndpoint.FlushContext linkFlushContext;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Flushing (flushContext=" + flushContext + ")...", Tracer.Level.DEBUG);
        }
        if ((linkFlushContext = this.toLinkFlushContext(flushContext)) == null) {
            this.flushBlocking(null);
        } else {
            switch (linkFlushContext.flushMode) {
                case SYNC_BLOCKING: {
                    this.flushBlocking((ILnkPeerEndpoint.SynchronousBlockingFlushContext)linkFlushContext);
                    break;
                }
                case SYNC_NON_BLOCKING: {
                    this.flushNonBlocking((ILnkPeerEndpoint.SynchronousNonBlockingFlushContext)linkFlushContext);
                    break;
                }
                case ASYNC: {
                    throw new UnsupportedOperationException("server binding does not support async flush");
                }
                default: {
                    throw new IllegalArgumentException("unknown flush mode '" + linkFlushContext.flushMode + "'");
                }
            }
        }
        this.toSmaFlushContext(linkFlushContext);
    }

    protected final boolean doCanFail() {
        return false;
    }

    protected final boolean doAcksRequireFlush() {
        return false;
    }

    protected final void doClose() throws SmaException {
    }
}

