/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XDoubleArrayIterator;
import com.neeve.lang.XDoubleIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class XbufDoubleArrayField
extends XbufVariableLengthField<double[]> {
    private final Iterator iterator = new Iterator();

    private XbufDoubleArrayField(short id, String name) {
        super(XbufField.Type.DOUBLE_ARRAY, id, name);
    }

    public static XbufDoubleArrayField create(short id, String name) {
        return new XbufDoubleArrayField(id, name);
    }

    @Override
    protected final int serializedLength(double[] val) {
        return val == null ? 0 : val.length * 8;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, double[] val) {
        buffer.putFrom(offset, val, 0, val.length);
        return val.length * 8;
    }

    @Override
    protected final double[] deserialize(PktBuffer buffer, int offset, int length) {
        double[] val = new double[length / 8];
        if (length > 0) {
            buffer.getTo(offset, val, 0, val.length);
        }
        return val;
    }

    public final void setValues(double[] values) {
        super.setValue(values);
    }

    public final double[] getValuesAsArray() {
        return (double[])super.getValue();
    }

    public final void setValuesFrom(XDoubleIterator val) {
        double[] v;
        if (val instanceof Iterator) {
            v = ((Iterator)val).array();
        } else if (val instanceof XDoubleArrayIterator) {
            XDoubleArrayIterator a = (XDoubleArrayIterator)val;
            v = a.array();
            if (v.length != a.length()) {
                v = new double[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                ++size;
                val.next();
            }
            v = new double[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                v[i] = val.next();
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(double val) {
        double[] vArray;
        double[] existing = (double[])this.getValue();
        if (this.getValue() == null) {
            vArray = new double[1];
        } else {
            vArray = new double[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    @Override
    protected final String toString(double[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XDoubleIterator {
        int current = 0;

        public double[] array() {
            return (double[])XbufDoubleArrayField.this.getValue();
        }

        public final boolean hasNext() {
            double[] value = (double[])XbufDoubleArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public double next() {
            double[] val = (double[])XbufDoubleArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((double[])XbufDoubleArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }
    }
}

