/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmArray;
import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEntityArray;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmEnumerationArray;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmPrimitiveArray;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.AdmType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

final class AdmJsonGenerator
extends AdmGenerator {
    AdmJsonGenerator() {
    }

    @Override
    protected final void appendFieldImport(AdmEntity container, AdmField field, boolean forInterface, TreeSet<String> imports) {
        AdmPrimitive.Type primitiveType;
        super.appendFieldImport(container, field, forInterface, imports);
        AdmType fieldType = field.getType();
        if (fieldType instanceof AdmPrimitive && (primitiveType = ((AdmPrimitive)fieldType).getType()).hasRawValue()) {
            imports.add(primitiveType.getRawValueTypeImpl());
        }
    }

    private final void writeClassDeclaration(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        if (collection.isDeprecated()) {
            codeBuilder.last().appendln("@Deprecated");
        }
        AdmGenerator.writeAdmGeneratedAnnotations(this.getClass(), AdmEncodingType.Json, collection.getModel(), codeBuilder);
        AdmGenerator.writeFactoryTypeInfoAnnotation(collection, codeBuilder);
        codeBuilder.last().append("final public class " + collection.getName() + " extends ");
        switch (collection.getType()) {
            case List: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogList}<");
                break;
            }
            case Queue: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogQueue}<");
                break;
            }
            case ByteMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXByteMap}<");
                break;
            }
            case CharMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXCharMap}<");
                break;
            }
            case ShortMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXShortMap}<");
                break;
            }
            case IntMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXIntMap}<");
                break;
            }
            case LongMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXLongMap}<");
                break;
            }
            case FloatMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXFloatMap}<");
                break;
            }
            case DoubleMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXDoubleMap}<");
                break;
            }
            case StringMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogStringMap}<");
                break;
            }
            default: {
                throw new IllegalStateException("unknown collection type '" + (Object)((Object)collection.getType()) + "'");
            }
        }
        codeBuilder.last().append(collection.getContains().getTemplatedJavaTypeName() + "> implements " + AdmJsonGenerator.interfaceTemplatedTypeName(collection));
        codeBuilder.last().append(", %{com.neeve.rog.IRogJsonizable}");
        codeBuilder.last().appendln(" {");
    }

    private final void writeClassDeclaration(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        AdmJsonGenerator.writeJavadocTypeComment("", entity, codeBuilder);
        AdmGenerator.writeAdmGeneratedAnnotations(this.getClass(), AdmEncodingType.Json, entity.getModel(), codeBuilder);
        AdmGenerator.writeFactoryTypeInfoAnnotation(entity, codeBuilder);
        AdmGenerator.writeJsonPropertyOrderAnnotation(entity, fields, codeBuilder);
        codeBuilder.last().append(entity.isFinal() ? "final " : "").append("public class " + entity.getName());
        if (!entity.isEmbedded()) {
            if (entity.isRoot()) {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogRootNode}");
            } else if (entity.containsChildren()) {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogContainerNode}");
            } else {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogNode}");
            }
            codeBuilder.last().append(" implements " + AdmJsonGenerator.interfaceTemplatedTypeName(entity) + ", %{com.neeve.rog.IRogJsonizable}");
            if (entity.isMessage()) {
                codeBuilder.last().append(", %{com.neeve.sma.MessageReflector}");
            }
        } else if (entity.getGenerateEmbeddedEntityInterfaces()) {
            codeBuilder.last().append(" implements ");
            codeBuilder.last().append(AdmJsonGenerator.interfaceTemplatedTypeName(entity));
        } else {
            codeBuilder.last().append(" implements %{com.neeve.rog.IRogValidatable}");
        }
        codeBuilder.last().appendln(" {");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("   /**");
        codeBuilder.last().appendln("    * A preallocated empty array used to avoid garbage when returning empty arrays of this type.");
        codeBuilder.last().appendln("    */");
        codeBuilder.last().appendln("   final public static " + entity.getTemplatedJavaTypeName() + "[] EMPTY_ARRAY = new " + entity.getTemplatedJavaTypeName() + "[0];");
    }

    private final void writeInitializer(List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Initializer -----");
        codeBuilder.last().appendln("    {");
        this.writeFieldBitmaskInitializer(fields, codeBuilder);
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- Initializer -----");
    }

    private final void writeConstructors(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Constructors -----");
        codeBuilder.last().appendln("    " + collection.getName() + "(final %{com.eaio.uuid.UUID} id) {");
        codeBuilder.last().appendln("        super(" + collection.getFactory().getName() + ".OFID,");
        codeBuilder.last().appendln("              " + collection.getFactory().getName() + ".VFID,");
        codeBuilder.last().appendln("              " + collection.getFactory().getName() + ".ID_" + collection.getName() + ",");
        codeBuilder.last().appendln("              id,");
        codeBuilder.last().appendln("              " + collection.isTransactional() + ");");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    " + collection.getName() + "() {");
        codeBuilder.last().appendln("        this(null);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    public static " + collection.getName() + " create() {return " + collection.getFactory().getName() + ".create" + collection.getName() + "();}");
        codeBuilder.last().appendln("    // -----Constructors -----");
    }

    private final void writeConstructors(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Constructors -----");
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("    public " + entity.getName() + "() {");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    " + entity.getName() + "(final String json) throws Exception {");
            codeBuilder.last().appendln("        if (json != null) {");
            codeBuilder.last().appendln("            " + entity.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(json);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonCreator}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create() {return new " + entity.getName() + "();}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromJson(final String json) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return new " + entity.getName() + "(json);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedJson(final %{java.nio.ByteBuffer} serializedJson) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return new " + entity.getName() + "(com.google.protobuf.ByteString.copyFrom(serializedJson).toStringUtf8());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedJson(final byte[] serializedJson) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return new " + entity.getName() + "(com.google.protobuf.ByteString.copyFrom(serializedJson).toStringUtf8());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final byte[] serializedJson) {return createFromSerializedJson(serializedJson);}");
        } else if (entity.isRoot()) {
            codeBuilder.last().appendln("    " + entity.getName() + "() throws Exception {");
            codeBuilder.last().appendln("        this(-1, null, null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    " + entity.getName() + "(final int grid, final %{com.eaio.uuid.UUID} id, final String json) throws Exception {");
            codeBuilder.last().appendln("        super(" + entity.getFactory().getName() + ".OFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".VFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".ID_" + entity.getName() + ",");
            codeBuilder.last().appendln("              id,");
            codeBuilder.last().appendln("              " + entity.isTransactional() + ",");
            codeBuilder.last().appendln("              grid);");
            codeBuilder.last().appendln("        if (json != null) {");
            codeBuilder.last().appendln("            deserializeFromJson(json);");
            codeBuilder.last().appendln("        }");
            if (entity.isMessage()) {
                codeBuilder.last().appendln("        setMessageReflector(this);");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final int grid) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(grid);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final int grid, final %{com.eaio.uuid.UUID} id) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(grid, id);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromRawJson(final int grid, final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromRawJson(grid, json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromJson(final int grid, final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromJson(grid, json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedJson(final int grid, final %{java.nio.ByteBuffer} serializedJson) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedJson(grid, serializedJson);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedJson(final int grid, final byte[] serializedJson) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedJson(grid, serializedJson);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final int grid, final byte[] serializedJson) {return createFromSerializedJson(grid, serializedJson);}");
        } else {
            codeBuilder.last().appendln("    " + entity.getName() + "() throws Exception {");
            codeBuilder.last().appendln("        this(null, null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    " + entity.getName() + "(final %{com.eaio.uuid.UUID} id, final String json) throws Exception {");
            codeBuilder.last().appendln("        super(" + entity.getFactory().getName() + ".OFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".VFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".ID_" + entity.getName() + ",");
            codeBuilder.last().appendln("              id,");
            codeBuilder.last().appendln("              " + entity.isTransactional() + ");");
            codeBuilder.last().appendln("        if (json != null) {");
            codeBuilder.last().appendln("            deserializeFromJson(json);");
            codeBuilder.last().appendln("        }");
            if (entity.isMessage()) {
                codeBuilder.last().appendln("        setMessageReflector(this);");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create() {return " + entity.getFactory().getName() + ".create" + entity.getName() + "();}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final %{com.eaio.uuid.UUID} id) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(id);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromRawJson(final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromRawJson(json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromJson(final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromJson(json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedJson(final %{java.nio.ByteBuffer} serializedJson) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedJson(serializedJson);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedJson(final byte[] serializedJson) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedJson(serializedJson);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final byte[] serializedJson) {return createFromSerializedJson(serializedJson);}");
        }
        codeBuilder.last().appendln("    // -----Constructors -----");
    }

    final void writeClearContentMethod(List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public void clearContent() {");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmCollection || fieldType instanceof AdmEntity && !((AdmEntity)fieldType).isEmbedded()) continue;
            if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                codeBuilder.last().appendln("        if (" + AdmJsonGenerator.fieldGetterMethodName(field) + "() != null) {");
                codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldGetterMethodName(field) + "().clearContent();");
                codeBuilder.last().appendln("        }");
            } else if (fieldType instanceof AdmEntityArray) {
                codeBuilder.last().appendln("        if (" + AdmJsonGenerator.fieldGetterMethodName(field) + "() != null) {");
                codeBuilder.last().appendln("            for (" + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + " v : " + AdmJsonGenerator.fieldGetterMethodName(field) + "()) {");
                codeBuilder.last().appendln("                if (v != null) {");
                codeBuilder.last().appendln("                    v.clearContent();");
                codeBuilder.last().appendln("                }");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldClearerMethodName(field) + "();");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToProtobufMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public com.google.protobuf.Message serializeToProtobuf() {");
        codeBuilder.last().appendln("        throw new UnsupportedOperationException();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToRawJsonMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public String serializeToRawJson() {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            sync();");
        codeBuilder.last().appendln("            return (String)getMessage(); ");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, null);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToJsonMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public String serializeToJson() {");
        codeBuilder.last().appendln("        return serializeToRawJson(); ");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromProtobufMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromProtobuf(final com.google.protobuf.Message message) {");
        codeBuilder.last().appendln("        throw new UnsupportedOperationException();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromRawJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromRawJson(final String json) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        return this;");
        } else {
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            clearContent();");
            codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(json);");
            codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, null);");
            codeBuilder.last().appendln("            return this;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            throw new RuntimeException(e);");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromJson(final String json) {");
        codeBuilder.last().appendln("        return deserializeFromRawJson(json);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedIRogNodeMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- IRogNode methods -----");
        this.writeSerializeToProtobufMethod(type, codeBuilder);
        this.writeSerializeToRawJsonMethod(type, codeBuilder);
        this.writeSerializeToJsonMethod(type, codeBuilder);
        this.writeDeserializeFromProtobufMethod(type, codeBuilder);
        this.writeDeserializeFromRawJsonMethod(type, codeBuilder);
        this.writeDeserializeFromJsonMethod(type, codeBuilder);
        codeBuilder.last().appendln("    // ----- IRogNode methods -----");
    }

    private final void writeOverridenRogNodeMethods(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- RogNode methods -----");
        this.writeReadOnlyGetterSetterMethods(type, fields, codeBuilder);
        codeBuilder.last().appendln("    // ----- RogNode methods -----");
    }

    private final void writeUserPrimitiveFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmPrimitive fieldType = (AdmPrimitive)field.getType();
        AdmPrimitive.Type primitiveType = fieldType.getType();
        String javaPrimitive = fieldType.getTemplatedPrimitiveTypeName();
        boolean hasInterface = (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) && !field.getName().startsWith("xRog");
        codeBuilder.last().appendln("    private " + javaPrimitive + " " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        String finalModifier = AdmJsonGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonProperty}(\"" + field.getJsonName() + "\")");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "(final " + javaPrimitive + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("       final " + javaPrimitive + " old = " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
            if (primitiveType == AdmPrimitive.Type.String || primitiveType == AdmPrimitive.Type.Date) {
                codeBuilder.last().appendln("        if ((val == null && val != old) || (val != null && !val.equals(old))) {");
            } else {
                codeBuilder.last().appendln("        if (val != old) {");
            }
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmJsonGenerator.fieldIdxFieldVarName(field) + ", old, val);");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
        switch (primitiveType) {
            case Byte: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Char: {
                codeBuilder.last().appendln("        _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                break;
            }
            case String: 
            case Date: 
            case Currency: 
            case UUID: {
                codeBuilder.last().appendln("        if (val != null) {");
                codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("        }");
            }
        }
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        switch (primitiveType) {
            case Byte: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Char: {
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                break;
            }
            case String: 
            case Date: 
            case Currency: 
            case UUID: {
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonProperty}(\"" + field.getJsonName() + "\")");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonInclude}(value=JsonInclude.Include.NON_NULL)");
                break;
            }
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("    }");
        switch (primitiveType) {
            case Byte: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Char: {
                codeBuilder.newCodeSegment();
                this.writeDeprecationComment("    ", field, codeBuilder);
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                this.writeJsonGetterAnnotations(field, codeBuilder);
                codeBuilder.last().appendln("    " + finalModifier + "public " + primitiveType.getJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "AsObject() {");
                codeBuilder.last().appendln("        if (!" + AdmJsonGenerator.fieldCheckerMethodName(field) + "()) return null;");
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
                break;
            }
        }
        if (primitiveType == AdmPrimitive.Type.Date) {
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterAsTimestampMethodName(field) + "(final long val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        final Date valAsDate = val >= 0l ? new Date(val) : null;");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final long old = " + AdmJsonGenerator.fieldGetterAsTimestampMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != old) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmJsonGenerator.fieldIdxFieldVarName(field) + ", old >= 0l ? new Date(old) : null, valAsDate);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = valAsDate;");
            codeBuilder.last().appendln("        if (valAsDate != null) {");
            codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public long " + AdmJsonGenerator.fieldGetterAsTimestampMethodName(field) + "() {");
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " == null ? -1l : " + AdmJsonGenerator.fieldValueVarName(field) + ".getTime();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public Long " + AdmJsonGenerator.fieldGetterMethodName(field) + "AsTimestampObject() {");
            codeBuilder.last().appendln("        if (!" + AdmJsonGenerator.fieldCheckerMethodName(field) + "()) return null;");
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterMethodName(field) + "AsTimestamp();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterAsInstantMethodName(field) + "(final %{java.time.Instant} val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        final %{java.time.Instant} existing = " + AdmJsonGenerator.fieldGetterAsInstantMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmJsonGenerator.fieldIdxFieldVarName(field) + ", " + AdmJsonGenerator.fieldGetterMethodName(field) + "(), val != null ? new Date(val.toEpochMilli()) : null);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("           " + AdmJsonGenerator.fieldSetterAsTimestampMethodName(field) + "(val.toEpochMilli());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("           " + AdmJsonGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public %{java.time.Instant} " + AdmJsonGenerator.fieldGetterAsInstantMethodName(field) + "() {");
            codeBuilder.last().appendln("        if (!" + AdmJsonGenerator.fieldCheckerMethodName(field) + "()) return null;");
            codeBuilder.last().appendln("        return %{java.time.Instant}.ofEpochMilli(" + AdmJsonGenerator.fieldGetterAsTimestampMethodName(field) + "());");
            codeBuilder.last().appendln("    }");
        }
        if (primitiveType == AdmPrimitive.Type.String) {
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldLenderMethodName(field) + "(final %{com.neeve.lang.XString} val) {");
            codeBuilder.last().appendln("        if (val == null || !val.isInitialized() || val.isNull()) {" + AdmJsonGenerator.fieldSetterMethodName(field) + "((String)null); return;}");
            codeBuilder.last().appendln("        if (!val.isImmutable()) {throw new IllegalArgumentException(\"value is mutable\");}");
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(val.getValue());");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterFromMethodName(field) + "(final long val) {");
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(String.valueOf(val));");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "AsLong(final long val) {");
                codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterFromMethodName(field) + "(val);");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public <T extends %{com.neeve.lang.XString}> T " + AdmJsonGenerator.fieldGetterToMethodName(field) + "(final %{com.neeve.lang.XString}.Factory<T> factory) {");
            codeBuilder.last().appendln("        final " + field.getType().getTemplatedJavaTypeName() + " val = " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            return factory.create(val, false);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            return null;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public <T extends %{com.neeve.lang.XString}> T " + AdmJsonGenerator.fieldCopyFactoryMethodName(field) + "(final %{com.neeve.lang.XString}.Factory<T> factory) {");
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterToMethodName(field) + "(factory);");
                codeBuilder.last().appendln("    }");
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "Value(final String val){");
                codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(val);");
                codeBuilder.last().appendln("    }");
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public String " + AdmJsonGenerator.fieldGetterMethodName(field) + "Value() {");
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
            }
        }
        if (primitiveType.hasRawValue()) {
            String rawType = "%{" + primitiveType.getRawValueType() + "}";
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterFromMethodName(field) + "(final " + rawType + " val) {");
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(val != null ? val.getValue() : null);");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.last().appendln();
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "AsRaw(final " + rawType + " val) {");
                codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterFromMethodName(field) + "(val);");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldGetterToMethodName(field) + "(final " + rawType + " val) {");
            codeBuilder.last().appendln("        val.setValue(" + AdmJsonGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public " + rawType + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "AsRaw() {");
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterUnsafeMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public " + rawType + " " + AdmJsonGenerator.fieldGetterUnsafeMethodName(field) + "() {");
            codeBuilder.last().appendln("        return %{" + primitiveType.getRawValueTypeImpl() + "}.create(" + AdmJsonGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("    }");
        }
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldClearerMethodName(field) + "() {");
        switch (primitiveType) {
            case Byte: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = (byte)0;");
                break;
            }
            case Short: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = (short)0;");
                break;
            }
            case Integer: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = 0;");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = 0;");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = (float)0.0;");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = 0.0;");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = false;");
                break;
            }
            case Char: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = (char)0;");
                break;
            }
            case String: 
            case Date: 
            case Currency: 
            case UUID: {
                codeBuilder.last().appendln("       " + AdmJsonGenerator.fieldValueVarName(field) + " = null;");
            }
        }
        codeBuilder.last().appendln("        _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmJsonGenerator.fieldCheckerMethodName(field) + "() {");
        codeBuilder.last().appendln("        return (_fieldBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) == (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserPrimitiveArrayFieldMethods(AdmEntity entity, AdmField field, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        boolean hasInterface;
        AdmPrimitiveArray fieldType = (AdmPrimitiveArray)field.getType();
        String javaPrimitive = fieldType.getType().getTemplatedPrimitiveTypeName();
        String iteratorType = fieldType.getType().getTemplatedXIteratorType();
        String zgIteratorType = fieldType.getType().getTemplatedZGXIteratorType();
        String arrayIteratorType = fieldType.getType().getTemplatedXArrayIteratorType();
        boolean bl = hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        if (field.isDeprecated()) {
            codeBuilder.last().appendln("    @Deprecated");
        }
        codeBuilder.last().appendln("    private " + javaPrimitive + "[] " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        String finalModifier = AdmJsonGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "(final " + javaPrimitive + "[] val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        if (val != " + AdmJsonGenerator.fieldValueVarName(field) + ") {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmJsonGenerator.fieldFidVarName(field) + ", " + AdmJsonGenerator.fieldValueVarName(field) + ");");
            codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
        }
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterFromMethodName(field) + "(final " + iteratorType + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        codeBuilder.last().appendln("        if(val == null) {");
        codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldSetterMethodName(field) + "(null);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        val.toFirst();");
        codeBuilder.last().appendln("        if (!val.hasNext()) {");
        switch (fieldType.getType()) {
            case Byte: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BYTE_ARRAY);");
                break;
            }
            case Char: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CHAR_ARRAY);");
                break;
            }
            case Short: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_SHORT_ARRAY);");
                break;
            }
            case Integer: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "( %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_INT_ARRAY);");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_LONG_ARRAY);");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_FLOAT_ARRAY);");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DOUBLE_ARRAY);");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BOOLEAN_ARRAY);");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_UUID_ARRAY);");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DATE_ARRAY);");
                break;
            }
            case String: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_STRING_ARRAY);");
                break;
            }
            case Currency: {
                codeBuilder.last().appendln("         " + AdmJsonGenerator.fieldSetterMethodName(field) + "(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CURRENCY_ARRAY);");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + javaPrimitive + "[] vArray;");
        codeBuilder.last().appendln("        if (val instanceof %{" + fieldType.getType().getXArrayIteratorTypeRaw() + "}) {");
        codeBuilder.last().appendln("            final " + arrayIteratorType + " a = (" + fieldType.getType().getXArrayIteratorType() + ") val;");
        codeBuilder.last().appendln("            vArray = a.array();");
        codeBuilder.last().appendln("            if(vArray.length != a.length()) {");
        codeBuilder.last().appendln("                vArray = new " + javaPrimitive + "[a.length()];");
        codeBuilder.last().appendln("                java.lang.System.arraycopy(a.array(), a.offset(), vArray, 0, a.length());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            int len = 0;");
        codeBuilder.last().appendln("            while(val.hasNext()) {");
        codeBuilder.last().appendln("               val.next();");
        codeBuilder.last().appendln("               len++;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            vArray = new " + javaPrimitive + "[len];");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("            for(int i = 0; i < len; i++)  {");
        codeBuilder.last().appendln("               vArray[i] = val.next();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldAdderMethodName(field) + "(final " + javaPrimitive + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        codeBuilder.last().appendln("        " + javaPrimitive + "[] vArray;");
        codeBuilder.last().appendln("        if(" + AdmJsonGenerator.fieldValueVarName(field) + " == null) {");
        codeBuilder.last().appendln("            vArray = new " + javaPrimitive + "[1];");
        codeBuilder.last().appendln("            vArray[0] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            vArray = new " + javaPrimitive + "[" + AdmJsonGenerator.fieldValueVarName(field) + ".length + 1];");
        codeBuilder.last().appendln("            java.lang.System.arraycopy(" + AdmJsonGenerator.fieldValueVarName(field) + ", 0, vArray, 0, " + AdmJsonGenerator.fieldValueVarName(field) + ".length);");
        codeBuilder.last().appendln("            vArray[vArray.length - 1] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + "[] " + AdmJsonGenerator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterMethodName(field) + "EmptyIfNull();");
        } else {
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + "[] " + AdmJsonGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        switch (fieldType.getType()) {
            case Byte: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BYTE_ARRAY;");
                break;
            }
            case Char: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CHAR_ARRAY;");
                break;
            }
            case Short: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_SHORT_ARRAY;");
                break;
            }
            case Integer: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_INT_ARRAY;");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_LONG_ARRAY;");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_FLOAT_ARRAY;");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DOUBLE_ARRAY;");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BOOLEAN_ARRAY;");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_UUID_ARRAY;");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DATE_ARRAY;");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_STRING_ARRAY;");
                break;
            }
            case Currency: {
                codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CURRENCY_ARRAY;");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public " + zgIteratorType + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return new " + arrayIteratorType + "(" + AdmJsonGenerator.fieldGetterMethodName(field) + "EmptyIfNull());");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("        _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityArrayFieldMethods(AdmEntity entity, AdmField field, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        boolean hasInterface;
        AdmEntityArray fieldType = (AdmEntityArray)field.getType();
        boolean bl = hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        if (field.isDeprecated()) {
            codeBuilder.last().appendln("    @Deprecated");
        }
        codeBuilder.last().appendln("    private " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        String finalModifier = AdmJsonGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        if (val != " + AdmJsonGenerator.fieldValueVarName(field) + ") {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmJsonGenerator.fieldFidVarName(field) + ", " + AdmJsonGenerator.fieldValueVarName(field) + ");");
            codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
        }
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        codeBuilder.last().appendln("        if(val == null) {");
        codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldSetterMethodName(field) + "(null);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        val.toFirst();");
        codeBuilder.last().appendln("        if (!val.hasNext()) {");
        codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldSetterMethodName(field) + "(new " + fieldType.getType().getTemplatedJavaTypeName() + "[0]);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + fieldType.getTemplatedJavaTypeName() + " vArray;");
        codeBuilder.last().appendln("        if (val instanceof %{com.neeve.lang.XArrayIterator}) {");
        codeBuilder.last().appendln("            final %{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> a = (%{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + ">) val;");
        codeBuilder.last().appendln("            vArray = a.array();");
        codeBuilder.last().appendln("            if(vArray.length != a.length()) {");
        codeBuilder.last().appendln("                vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[a.length()];");
        codeBuilder.last().appendln("                java.lang.System.arraycopy(a.array(), a.offset(), vArray, 0, a.length());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            int len = 0;");
        codeBuilder.last().appendln("            while(val.hasNext()) {");
        codeBuilder.last().appendln("               val.next();");
        codeBuilder.last().appendln("               len++;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[len];");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("            for(int i = 0; i < len; i++)  {");
        codeBuilder.last().appendln("               vArray[i] = val.next();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldAdderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("        " + fieldType.getType().getTemplatedJavaTypeName() + "[] vArray;");
        codeBuilder.last().appendln("        if(" + AdmJsonGenerator.fieldValueVarName(field) + " == null) {");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[1];");
        codeBuilder.last().appendln("            vArray[0] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[" + AdmJsonGenerator.fieldValueVarName(field) + ".length + 1];");
        codeBuilder.last().appendln("            java.lang.System.arraycopy(" + AdmJsonGenerator.fieldValueVarName(field) + ", 0, vArray, 0, " + AdmJsonGenerator.fieldValueVarName(field) + ".length);");
        codeBuilder.last().appendln("            vArray[vArray.length - 1] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldLenderMethodName(field) + "From(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterFromMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldAdderMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : new " + fieldType.getType().getTemplatedJavaTypeName() + "[0];");
        } else {
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
        } else {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        return val != null ? val : new " + fieldType.getType().getTemplatedJavaTypeName() + "[0];");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmJsonGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return new %{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + ">(" + AdmJsonGenerator.fieldGetterMethodName(field) + "EmptyIfNull());");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldTakerMethodName(field) + "() {");
        codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("        _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEnumerationArrayFieldMethods(AdmEntity entity, AdmField field, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        boolean hasInterface;
        AdmEnumerationArray fieldType = (AdmEnumerationArray)field.getType();
        boolean bl = hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        if (field.isDeprecated()) {
            codeBuilder.last().appendln("    @Deprecated");
        }
        codeBuilder.last().appendln("    private " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        String finalModifier = AdmJsonGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        if (val != " + AdmJsonGenerator.fieldValueVarName(field) + ") {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmJsonGenerator.fieldFidVarName(field) + ", " + AdmJsonGenerator.fieldValueVarName(field) + ");");
            codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
        }
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        codeBuilder.last().appendln("        if(val == null) {");
        codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldSetterMethodName(field) + "(null);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        val.toFirst();");
        codeBuilder.last().appendln("        if (!val.hasNext()) {");
        codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldSetterMethodName(field) + "(new " + fieldType.getType().getTemplatedJavaTypeName() + "[0]);");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + fieldType.getTemplatedJavaTypeName() + " vArray;");
        codeBuilder.last().appendln("        if (val instanceof %{com.neeve.lang.XArrayIterator}) {");
        codeBuilder.last().appendln("            final %{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> a = (%{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + ">) val;");
        codeBuilder.last().appendln("            vArray = a.array();");
        codeBuilder.last().appendln("            if(vArray.length != a.length()) {");
        codeBuilder.last().appendln("                vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[a.length()];");
        codeBuilder.last().appendln("                java.lang.System.arraycopy(a.array(), a.offset(), vArray, 0, a.length());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            int len = 0;");
        codeBuilder.last().appendln("            while(val.hasNext()) {");
        codeBuilder.last().appendln("               val.next();");
        codeBuilder.last().appendln("               len++;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[len];");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("            for(int i = 0; i < len; i++)  {");
        codeBuilder.last().appendln("               vArray[i] = val.next();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            val.toFirst();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldAdderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        codeBuilder.last().appendln("        " + fieldType.getType().getTemplatedJavaTypeName() + "[] vArray;");
        codeBuilder.last().appendln("        if(" + AdmJsonGenerator.fieldValueVarName(field) + " == null) {");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[1];");
        codeBuilder.last().appendln("            vArray[0] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            vArray = new " + fieldType.getType().getTemplatedJavaTypeName() + "[" + AdmJsonGenerator.fieldValueVarName(field) + ".length + 1];");
        codeBuilder.last().appendln("            java.lang.System.arraycopy(" + AdmJsonGenerator.fieldValueVarName(field) + ", 0, vArray, 0, " + AdmJsonGenerator.fieldValueVarName(field) + ".length);");
        codeBuilder.last().appendln("            vArray[vArray.length - 1] = val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(vArray);");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "List(final %{java.util.List}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmJsonGenerator.fieldFidVarName(field) + ", " + AdmJsonGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        if (val != null && !val.isEmpty()) {");
        codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = new " + fieldType.getType().getTemplatedJavaTypeName() + "[val.size()];");
        codeBuilder.last().appendln("            for (int i = 0; i < val.size(); i++) {");
        codeBuilder.last().appendln("                " + AdmJsonGenerator.fieldValueVarName(field) + "[i] = val.get(i);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + " != null ? " + AdmJsonGenerator.fieldValueVarName(field) + " : " + fieldType.getType().getTemplatedJavaTypeName() + ".EMPTY_ARRAY;");
        } else {
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
        } else {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        return val != null ? val : " + fieldType.getType().getTemplatedJavaTypeName() + ".EMPTY_ARRAY;");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmJsonGenerator.fieldGetterMethodName(field) + "List() {");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
        codeBuilder.last().appendln("        %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> list = null;");
        codeBuilder.last().appendln("        if (" + AdmJsonGenerator.fieldValueVarName(field) + " != null) {");
        codeBuilder.last().appendln("            list = new %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + ">(" + AdmJsonGenerator.fieldValueVarName(field) + ".length);");
        codeBuilder.last().appendln("            for(int i = 0; i < " + AdmJsonGenerator.fieldValueVarName(field) + ".length; i++) {");
        codeBuilder.last().appendln("                list.add(" + AdmJsonGenerator.fieldValueVarName(field) + "[i]);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            list = new %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + ">(0);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return list;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmJsonGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return new %{com.neeve.lang.XArrayIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + ">(" + AdmJsonGenerator.fieldGetterMethodName(field) + "EmptyIfNull());");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("        _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEnumerationFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        boolean hasInterface;
        AdmEnumeration fieldType = (AdmEnumeration)field.getType();
        boolean bl = hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        if (field.isDeprecated()) {
            codeBuilder.last().appendln("    @Deprecated");
        }
        codeBuilder.last().appendln("    private " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        String finalModifier = AdmJsonGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " old = " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != old) {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmJsonGenerator.fieldIdxFieldVarName(field) + ", old, val);");
            codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
        }
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("        _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmJsonGenerator.fieldCheckerMethodName(field) + "() {");
        codeBuilder.last().appendln("        return (_fieldBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) == (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmEntity fieldType = (AdmEntity)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmJsonGenerator.fieldAccessorFinalModifier(entity);
        if (entity.isEmbedded() || fieldType.isEmbedded()) {
            codeBuilder.last().appendln("    private " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldValueVarName(field) + ";");
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonSetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " old = " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != old) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmJsonGenerator.fieldIdxFieldVarName(field) + ", old, val);");
                codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
                codeBuilder.last().appendln("        }");
            } else {
                codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = val;");
            }
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            this.writeFieldFluentMethods(entity, field, codeBuilder);
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonGetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "() {");
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldValueVarName(field) + ";");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldGetterToMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " to) {");
            codeBuilder.last().appendln("        if(" + AdmJsonGenerator.fieldCheckerMethodName(field) + "()) {");
            codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldGetterMethodName(field) + "().copyInto(to);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            to.clearContent();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldTakerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("    }");
            this.writeOptionalGetterMethods(entity, field, codeBuilder);
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldClearerMethodName(field) + "() {");
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldValueVarName(field) + " = null;");
            codeBuilder.last().appendln("        _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmJsonGenerator.fieldCheckerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return (_fieldBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) == (1L << " + (field.getIndex() & 0x3F) + ");");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            codeBuilder.last().appendln("        if (val != " + AdmJsonGenerator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            setChild(" + AdmJsonGenerator.fieldFidVarName(field) + ", val);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            this.writeFieldFluentMethods(entity, field, codeBuilder);
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "() {");
            codeBuilder.last().appendln("        return (" + fieldType.getTemplatedJavaTypeName() + ")getChild(" + AdmJsonGenerator.fieldFidVarName(field) + ");");
            codeBuilder.last().appendln("    }");
            this.writeOptionalGetterMethods(entity, field, codeBuilder);
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmJsonGenerator.fieldClearerMethodName(field) + "() {");
            codeBuilder.last().appendln("        " + AdmJsonGenerator.fieldSetterMethodName(field) + "(null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmJsonGenerator.fieldCheckerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return (_fieldBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) == (1L << " + (field.getIndex() & 0x3F) + ");");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeUserCollectionFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmCollection fieldType = (AdmCollection)field.getType();
        String finalModifier = AdmJsonGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmJsonGenerator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + fieldType.getTemplatedJavaTypeName() + " val = (" + fieldType.getTemplatedJavaTypeName() + ")getChild(" + AdmJsonGenerator.fieldFidVarName(field) + ");");
        codeBuilder.last().appendln("        if (val == null) {");
        codeBuilder.last().appendln("            setChild(" + AdmJsonGenerator.fieldFidVarName(field) + ", val = " + fieldType.getTemplatedJavaTypeName() + ".create());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return val;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserFieldMethods(AdmEntity entity, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder, AdmField field) {
        AdmType fieldType = field.getType();
        this.writeFieldIdMethods(entity, field, codeBuilder);
        if (fieldType instanceof AdmPrimitive) {
            this.writeUserPrimitiveFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmArray) {
            if (fieldType instanceof AdmPrimitiveArray) {
                this.writeUserPrimitiveArrayFieldMethods(entity, field, generateArrayGetterEmptyIfNull, codeBuilder);
            } else if (fieldType instanceof AdmEntityArray) {
                this.writeUserEntityArrayFieldMethods(entity, field, generateArrayGetterEmptyIfNull, codeBuilder);
            } else if (fieldType instanceof AdmEnumerationArray) {
                this.writeUserEnumerationArrayFieldMethods(entity, field, generateArrayGetterEmptyIfNull, codeBuilder);
            }
        } else if (fieldType instanceof AdmEnumeration) {
            this.writeUserEnumerationFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmEntity) {
            this.writeUserEntityFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmCollection) {
            this.writeUserCollectionFieldMethods(entity, field, codeBuilder);
        } else {
            throw new IllegalArgumentException("unknown field type '" + fieldType.getTemplatedJavaTypeName() + "' (class=" + ((Object)((Object)fieldType)).getClass().getName() + ")");
        }
    }

    private final void writeFieldMethods(AdmEntity entity, List<AdmField> fields, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Field getter/setter methods -----");
        this.writeContainedEntityCollectionElementMethods(entity, codeBuilder);
        Iterator<AdmField> fieldIterator = fields.iterator();
        while (fieldIterator.hasNext()) {
            this.writeUserFieldMethods(entity, generateArrayGetterEmptyIfNull, codeBuilder, fieldIterator.next());
        }
        codeBuilder.last().appendln("    // ----- Field getter/setter methods -----");
    }

    private final void writeSerializeToByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public byte[] serializeToByteArray() {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            sync();");
        codeBuilder.last().appendln("            try {");
        codeBuilder.last().appendln("                return ((String)getMessage()).getBytes(\"UTF-8\");");
        codeBuilder.last().appendln("            } ");
        codeBuilder.last().appendln("            catch (%{java.io.IOException} e) {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, null);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{java.nio.ByteBuffer} serializeToByteBuffer() {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            return %{java.nio.ByteBuffer}.wrap(serializeToByteArray());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, null);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToPacketMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} serializeToPacket() {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            sync();");
        codeBuilder.last().appendln("            final %{com.neeve.pkt.PktPacket} packet = %{com.neeve.pkt.PktFactory}.getInstance().createPacket(%{com.neeve.pkt.types.PktBodyTypesBase}.TEXT);");
        codeBuilder.last().appendln("            ((%{com.neeve.pkt.types.PktBodyText})packet.getBody()).setText((String)getMessage());");
        codeBuilder.last().appendln("            return packet;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, null);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteArrayMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromByteArray(final byte[] array) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        return this;");
        } else {
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final String val = com.google.protobuf.ByteString.copyFrom(array).toStringUtf8();");
            codeBuilder.last().appendln("            clearContent();");
            codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(val);");
            codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, null);");
            codeBuilder.last().appendln("            return this;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            throw new RuntimeException(e);");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromByteBuffer(final %{java.nio.ByteBuffer} buffer) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        return this;");
        } else {
            codeBuilder.last().appendln("        buffer.mark();");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final String val = com.google.protobuf.ByteString.copyFrom(buffer, buffer.remaining()).toStringUtf8();");
            codeBuilder.last().appendln("            clearContent();");
            codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(val);");
            codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, null);");
            codeBuilder.last().appendln("            return this;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            throw new RuntimeException(e);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        finally {");
            codeBuilder.last().appendln("            buffer.reset();");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromPacketMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromPacket(final %{com.neeve.pkt.PktPacket} packet) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        return this;");
        } else {
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final String val = ((%{com.neeve.pkt.types.PktBodyText})(packet.getBody())).getText();");
            codeBuilder.last().appendln("            clearContent();");
            codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(val);");
            codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, null);");
            codeBuilder.last().appendln("            return this;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            throw new RuntimeException(e);");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
    }

    protected final void writeSyncMethod(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public void sync() {");
        codeBuilder.last().appendln("        setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, \"{\\\"xRogType\\\":\" + getType() + \"}\");");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSyncMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonProperty}(\"xRogType\")");
            codeBuilder.last().appendln("    private short _xRogType;");
        }
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public void sync() {");
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("        _xRogType = getType();");
        }
        codeBuilder.last().appendln("        final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            " + entity.getFactory().getName() + ".mapper.writeValue(baos, this);");
        codeBuilder.last().appendln("            setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON, new String(baos.toByteArray(), \"utf-8\"));");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeCopyMethods(AdmEntity type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (type instanceof AdmMessage) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " copy() {");
        codeBuilder.last().appendln("        final " + type.getTemplatedJavaTypeName() + " copy = " + type.getTemplatedJavaTypeName() + ".create();");
        codeBuilder.last().appendln("        copyInto(copy);");
        codeBuilder.last().appendln("        return copy;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        if (type instanceof AdmMessage) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public void copyInto(final " + type.getTemplatedJavaTypeName() + " copy) {");
        codeBuilder.last().appendln("        if (copy.readOnly) {throw new IllegalStateException(\"copy target is read only\");}");
        for (AdmField field : fields) {
            String copyFieldName;
            String copierFieldName;
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmPrimitive) {
                codeBuilder.last().appendln("        if(" + AdmJsonGenerator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("           copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "(this." + AdmJsonGenerator.fieldGetterMethodName(field) + "());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("           copy." + AdmJsonGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("");
                continue;
            }
            if (fieldType instanceof AdmPrimitiveArray) {
                copierFieldName = "copier_" + field.getName();
                codeBuilder.last().appendln("        final " + fieldType.getTemplatedPrimitiveTypeName() + " " + copierFieldName + " = this." + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("        if (" + copierFieldName + " != null) {");
                codeBuilder.last().appendln("            copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "(" + copierFieldName + ".clone());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            copy." + AdmJsonGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("");
                continue;
            }
            if (fieldType instanceof AdmEntity) {
                copierFieldName = "copier_" + field.getName();
                this.writeSuppressDeprecationWarnings("        ", type, field.getType(), codeBuilder);
                codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " " + copierFieldName + " = this." + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("        if (" + copierFieldName + " != null) {");
                codeBuilder.last().appendln("            copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "((" + fieldType.getTemplatedJavaTypeName() + ")" + copierFieldName + ".clone());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "(null);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("");
                continue;
            }
            if (fieldType instanceof AdmEntityArray) {
                copierFieldName = "copier_" + field.getName();
                copyFieldName = "copy_" + field.getName();
                this.writeSuppressDeprecationWarnings("        ", type, field.getType(), codeBuilder);
                codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " " + copierFieldName + " = " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("        if (" + copierFieldName + " != null) {");
                this.writeSuppressDeprecationWarnings("            ", type, field.getType(), codeBuilder);
                codeBuilder.last().appendln("            final " + fieldType.getTemplatedJavaTypeName() + " " + copyFieldName + " = new " + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + "[" + copierFieldName + ".length];");
                codeBuilder.last().appendln("            for (int i = 0 ; i < " + copierFieldName + ".length ; i++) {");
                codeBuilder.last().appendln("                " + copyFieldName + "[i] = (" + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + ")" + copierFieldName + "[i].clone();");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "(" + copyFieldName + ");");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "(null);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("");
                continue;
            }
            if (fieldType instanceof AdmEnumeration) {
                codeBuilder.last().appendln("        if(" + AdmJsonGenerator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("           copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "(this." + AdmJsonGenerator.fieldGetterMethodName(field) + "());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("           copy." + AdmJsonGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("");
                continue;
            }
            if (!(fieldType instanceof AdmEnumerationArray)) continue;
            copierFieldName = "copier_" + field.getName();
            copyFieldName = "copy_" + field.getName();
            this.writeSuppressDeprecationWarnings("        ", type, field.getType(), codeBuilder);
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " " + copierFieldName + " = " + AdmJsonGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (" + copierFieldName + " != null) {");
            this.writeSuppressDeprecationWarnings("            ", type, field.getType(), codeBuilder);
            codeBuilder.last().appendln("            final " + fieldType.getTemplatedJavaTypeName() + " " + copyFieldName + " = new " + ((AdmEnumerationArray)fieldType).getType().getTemplatedJavaTypeName() + "[" + copierFieldName + ".length];");
            codeBuilder.last().appendln("            for (int i = 0 ; i < " + copierFieldName + ".length ; i++) {");
            codeBuilder.last().appendln("                " + copyFieldName + "[i] = " + copierFieldName + "[i];");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "(" + copyFieldName + ");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            copy." + AdmJsonGenerator.fieldSetterMethodName(field) + "(null);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
        }
        if (type instanceof AdmMessage) {
            codeBuilder.last().appendln("        copyCopyableFieldsToCopy(copy);");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeMessageViewSerializerMethods(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- MessageView methods -----");
        this.writeSerializeToByteArrayMethod(entity, codeBuilder);
        this.writeSerializeToByteBufferMethod(entity, codeBuilder);
        this.writeSerializeToPacketMethod(entity, codeBuilder);
        this.writeDeserializeFromByteArrayMethod(entity, codeBuilder);
        this.writeDeserializeFromByteBufferMethod(entity, codeBuilder);
        this.writeDeserializeFromPacketMethod(entity, codeBuilder);
        this.writeSyncMethod(entity, codeBuilder);
        if (entity instanceof AdmMessage) {
            this.writeCopyMethods(entity, fields, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- MessageView methods -----");
    }

    private final void writeEmbeddedEntityIsBufferBacked(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public boolean isBufferBacked() {");
        codeBuilder.last().appendln("        return false;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityGetSerializeToNativeLength(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    final public int getSerializeToNativeLength() {");
        codeBuilder.last().appendln("        return serializeToByteArray().length;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializeToNativeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public int serializeToNative(final long address, final int addressOffset) {");
        codeBuilder.last().appendln("        final byte[] bytes = serializeToByteArray();");
        codeBuilder.last().appendln("        final %{com.neeve.io.IOBuffer} buf = %{com.neeve.io.IOBuffer}.create(bytes.length, true);");
        codeBuilder.last().appendln("        buf.getBufferUnsafe().put(bytes, 0, bytes.length);");
        codeBuilder.last().appendln("        %{com.neeve.util.UtlBuffer}.copyToNative(buf.getBufferUnsafe(), 0, address, addressOffset, bytes.length);");
        codeBuilder.last().appendln("        buf.dispose();");
        codeBuilder.last().appendln("        return bytes.length;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromNativeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromNative(final long address, final int addressOffset, final int length) {");
        codeBuilder.last().appendln("        final %{com.neeve.io.IOBuffer} buf = %{com.neeve.io.IOBuffer}.create(length, true);");
        codeBuilder.last().appendln("        %{com.neeve.util.UtlBuffer}.copyFromNative(address, addressOffset, buf.getBufferUnsafe(), 0, length);");
        codeBuilder.last().appendln("        deserializeFromByteBuffer(buf.takeBuffer());");
        codeBuilder.last().appendln("        buf.releaseBuffer().dispose();");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializeToByteArrayMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public byte[] serializeToByteArray() {");
        codeBuilder.last().appendln("        final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            " + entity.getFactory().getName() + ".mapper.writeValue(baos, this);");
        codeBuilder.last().appendln("            return baos.toByteArray();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializeToByteBufferMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public %{java.nio.ByteBuffer} serializeToByteBuffer() {");
        codeBuilder.last().appendln("        return %{java.nio.ByteBuffer}.wrap(serializeToByteArray());");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromByteArrayMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public " + entity.getName() + " deserializeFromByteArray(final byte[] array) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            final String val = com.google.protobuf.ByteString.copyFrom(array).toStringUtf8();");
        codeBuilder.last().appendln("            clearContent();");
        codeBuilder.last().appendln("            " + entity.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(val);");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromByteBufferMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public " + entity.getName() + " deserializeFromByteBuffer(final %{java.nio.ByteBuffer} buffer) {");
        codeBuilder.last().appendln("        buffer.mark();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            final String val = com.google.protobuf.ByteString.copyFrom(buffer, buffer.remaining()).toStringUtf8();");
        codeBuilder.last().appendln("            clearContent();");
        codeBuilder.last().appendln("            " + entity.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(val);");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            buffer.reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializerMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Serialize/Deserialize methods -----");
        this.writeEmbeddedEntitySerializeToByteArrayMethod(entity, codeBuilder);
        this.writeEmbeddedEntitySerializeToByteBufferMethod(entity, codeBuilder);
        this.writeEmbeddedEntityIsBufferBacked(entity, codeBuilder);
        this.writeEmbeddedEntityGetSerializeToNativeLength(entity, codeBuilder);
        this.writeEmbeddedEntitySerializeToNativeMethod(entity, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromByteArrayMethod(entity, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromByteBufferMethod(entity, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromNativeMethod(entity, codeBuilder);
        codeBuilder.last().appendln("    // ----- Serialize/Deserialize methods -----");
    }

    private final void writeEmbeddedEntityPoolingMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Pooling related methods -----");
        codeBuilder.last().appendln("    final public boolean isReferenceCounted() {");
        codeBuilder.last().appendln("        return false;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public " + entity.getName() + " acquire() {");
        codeBuilder.last().appendln("        // NO-OP");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public int getOwnerCount() {");
        codeBuilder.last().appendln("        return Integer.MAX_VALUE;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public void dispose() {");
        codeBuilder.last().appendln("        // NO-OP");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- Pooling related methods -----");
    }

    private final void writeGetContentEncodingMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public EncodingType getContentEncodingType() {");
        codeBuilder.last().appendln("        return EncodingType.Json;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} serialize() {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        return serializeForStoreCommit();");
        } else {
            codeBuilder.last().appendln("        return serializeToPacket();");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserialize(final %{com.neeve.pkt.PktPacket} packet) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        deserializeFromStoreReplicationOrInit(packet);");
            codeBuilder.last().appendln("        return this;");
        } else {
            codeBuilder.last().appendln("        return deserializeFromPacket(packet);");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeSetFieldValueMethod(AdmType type, List<AdmField> fields, boolean transactional, AdmSourceCodeBuilder codeBuilder) {
        if (!type.isDeprecated() && transactional && this.getDeprecatedFieldCount(type, fields, false, false) > 0) {
            codeBuilder.last().appendln("    @SuppressWarnings(\"deprecation\")");
        }
        codeBuilder.last().appendln("    final public %{com.neeve.ods.IStoreObject} setFieldValue(final int id, final Object val) {");
        if (transactional) {
            codeBuilder.last().appendln("        boolean processed = false;");
            for (AdmField field : fields) {
                AdmType fieldType = field.getType();
                if (fieldType instanceof AdmPrimitive) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmJsonGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedJavaTypeName() + ")val;");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmPrimitiveArray) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmJsonGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedPrimitiveTypeName() + ")val;");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmJsonGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedJavaTypeName() + ")val;");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmJsonGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedJavaTypeName() + ")val;");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEnumeration) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmJsonGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedJavaTypeName() + ")val;");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                codeBuilder.last().appendln("        if (!processed && id == " + AdmJsonGenerator.fieldFidVarName(field) + ") {");
                codeBuilder.last().appendln("            " + AdmJsonGenerator.fieldValueVarName(field) + " = (" + fieldType.getTemplatedJavaTypeName() + ")val;");
                codeBuilder.last().appendln("            processed = true;");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (!processed) {");
            codeBuilder.last().appendln("            super.setFieldValue(id, val);");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        // this method will never be called since this class was generated as a non-transactional entity");
        }
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedIStoreObjectMethods(AdmFactoryType type, List<AdmField> fields, boolean transactional, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- IStoreObject methods -----");
        this.writeGetContentEncodingMethod(type, codeBuilder);
        this.writeSerializeMethod(type, codeBuilder);
        this.writeDeserializeMethod(type, codeBuilder);
        if (!(type instanceof AdmCollection)) {
            this.writeSetFieldValueMethod(type, fields, transactional, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- IStoreObject methods -----");
    }

    private final void writeImplementedCollectionMethods(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        switch (collection.getType()) {
            case List: 
            case Queue: {
                break;
            }
            case ByteMap: 
            case CharMap: 
            case ShortMap: 
            case IntMap: 
            case LongMap: 
            case FloatMap: 
            case DoubleMap: 
            case StringMap: {
                AdmType keyType = collection.getKeyType();
                AdmEntity valueType = collection.getContains();
                AdmField keyField = this.keyFieldFor(collection);
                if (keyField == null) {
                    throw new IllegalStateException("No key field of type '" + keyType.getName() + "' in entity '" + valueType.getQualifiedName(collection.getModel()) + "' which is declared as value of " + (Object)((Object)collection.getType()) + " collection '" + collection.getName() + "'");
                }
                String keyJavaType = "%{" + keyType.getJavaTypeName() + "}";
                if (keyType instanceof AdmPrimitive) {
                    AdmPrimitive primitiveKeyType = (AdmPrimitive)keyType;
                    switch (primitiveKeyType.getType()) {
                        case Long: {
                            keyJavaType = "long";
                            break;
                        }
                        case Boolean: {
                            keyJavaType = "boolean";
                            break;
                        }
                        case Byte: {
                            keyJavaType = "byte";
                            break;
                        }
                        case Char: {
                            keyJavaType = "char";
                            break;
                        }
                        case Double: {
                            keyJavaType = "double";
                            break;
                        }
                        case Float: {
                            keyJavaType = "float";
                            break;
                        }
                        case Integer: {
                            keyJavaType = "int";
                            break;
                        }
                        case Short: {
                            keyJavaType = "short";
                            break;
                        }
                        case String: {
                            keyJavaType = "String";
                            break;
                        }
                        case Date: 
                        case Currency: 
                        case UUID: {
                            keyJavaType = "%{" + keyType.getJavaTypeName() + "}";
                        }
                    }
                }
                codeBuilder.last().appendln("    // ----- Rog Map methods -----");
                codeBuilder.last().appendln("    @Override");
                codeBuilder.last().appendln("    final protected " + keyJavaType + " getMapElementKey(final %{" + valueType.getFullName() + "} value) {");
                codeBuilder.last().appendln("        return value." + AdmJsonGenerator.fieldGetterMethodName(keyField) + "();");
                codeBuilder.last().appendln("    }");
                codeBuilder.last().appendln("");
                codeBuilder.last().appendln("    @Override");
                codeBuilder.last().appendln("    final protected void setMapElementKey(final %{" + valueType.getFullName() + "} value, final " + keyJavaType + " key) {");
                codeBuilder.last().appendln("        value." + AdmJsonGenerator.fieldSetterMethodName(keyField) + "(key);");
                codeBuilder.last().appendln("    }");
                codeBuilder.last().appendln("    // ----- Rog Map methods -----");
                break;
            }
        }
    }

    final void generateClass(AdmEntity entity, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        List<AdmField> fields = this.prepareFieldList(entity);
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(entity, fields, codeBuilder);
        if (!entity.isEmbedded() && (entity.containsChildren() || !entity.containedInSet().isEmpty() || entity.isTransactional())) {
            this.writeFieldFidDeclarations(entity, fields, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeIndexFieldDeclarations(entity, fields, codeBuilder);
            codeBuilder.last().appendln("");
        }
        if (entity.isMessage()) {
            this.writeRogMessageReflectorFieldDeclarations(entity, fields, AdmEncodingType.Json.toString(), codeBuilder);
            codeBuilder.last().appendln("");
        }
        this.writeFieldBitmaskDeclaration(codeBuilder);
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeReadOnlyFieldDeclaration(entity, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeInitializer(fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeConstructors(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeClearContentMethod(fields, codeBuilder);
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIRogNodeMethods(entity, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeOverridenRogNodeMethods(entity, fields, codeBuilder);
        } else {
            codeBuilder.last().appendln("");
            this.writeReadOnlyGetterSetterMethods(entity, fields, codeBuilder);
        }
        if (entity.isRoot() || entity.containsChildren()) {
            codeBuilder.last().appendln("");
            this.writeOverridenRogContainerNodeMethods(entity, fields, codeBuilder);
        }
        if (entity.isPojoShadow()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIRogPojoShadowNodeMethods(entity, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeFieldMethods(entity, fields, generateArrayGetterEmptyIfNull, codeBuilder);
        codeBuilder.last().appendln("");
        if (!entity.isEmbedded()) {
            this.writeMessageViewSerializerMethods(entity, fields, codeBuilder);
        } else {
            this.writeEmbeddedEntitySerializerMethods(entity, codeBuilder);
        }
        if (entity.isMessage()) {
            codeBuilder.last().appendln("");
            this.writeRogMessageReflectorMethods(entity, fields, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIStoreObjectMethods(entity, fields, entity.isTransactional(), codeBuilder);
        }
        if (entity.isEmbedded()) {
            this.writeEmbeddedEntityPoolingMethods(entity, codeBuilder);
        }
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeCloneMethod(entity, fields, codeBuilder);
            this.writeCopyMethods(entity, fields, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeToJsonStringMethod(codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeVisitFieldsMethod(fields, codeBuilder);
        }
        this.writeIndexFieldsGetter(entity, fields, codeBuilder);
        this.writeValidatorMethods(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToStringMethod(fields, !entity.isEmbedded(), codeBuilder);
        codeBuilder.last().appendln("}");
    }

    final void generateClass(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        ArrayList<AdmField> fields = new ArrayList<AdmField>();
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(collection, codeBuilder);
        this.writeConstructors(collection, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeImplementedIStoreObjectMethods(collection, fields, true, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeImplementedCollectionMethods(collection, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToJsonStringMethod(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToStringMethod(fields, true, codeBuilder);
    }
}

