/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.test.unit.AepEngineMessagingTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.proto.GracefulShutdownTriggerMessage;
import com.neeve.ci.XRuntime;
import com.neeve.rog.IRogCopyableNode;
import com.neeve.rog.IRogMessage;
import com.neeve.util.UtlReferenceTracker;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineMessagingTest
extends AepEngineTest {
    private static final int MESSAGE_COUNT = 1000;
    private final boolean POPULATE_MESSAGES = true;

    private final AepEngineTestMessage createMessage(AepEngineTestObject.EncodingType encodingType) {
        return new AepEngineTestMessage(encodingType, true);
    }

    private final List<AepEngineTestMessage> createMessages(AepEngineTestObject.EncodingType encodingType) {
        ArrayList<AepEngineTestMessage> list = new ArrayList<AepEngineTestMessage>();
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message = this.createMessage(encodingType);
            message.setIntField(i + 1);
            list.add(message);
        }
        return list;
    }

    private final void compareMessages(List<AepEngineTestMessage> expected, List<IRogMessage> actual) throws Exception {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            if (UtlReferenceTracker.enabled(expected.get(i).getMessage().getClass())) {
                if (expected.get(i).getMessage().getOwnershipCount() != 1) {
                    expected.get(i).getMessage().referenceTracker().dump();
                }
                if (actual.get(i).getOwnershipCount() != 1) {
                    actual.get(i).referenceTracker().dump();
                }
            }
            Assert.assertEquals((long)1L, (long)expected.get(i).getMessage().getOwnershipCount());
            Assert.assertEquals((long)1L, (long)actual.get(i).getOwnershipCount());
            expected.get(i).compareAgainst(actual.get(i));
        }
    }

    private final void scheduleShutdown(AepEngine engine, AepEngineTestObject.EncodingType encodingType) {
        switch (encodingType) {
            case Xbuf: {
                engine.injectMessage(com.neeve.aep.test.unit.generated.xbuf.GracefulShutdownTriggerMessage.create());
                break;
            }
            case Proto: {
                engine.injectMessage(GracefulShutdownTriggerMessage.create());
                break;
            }
            case Json: {
                engine.injectMessage(com.neeve.aep.test.unit.generated.json.GracefulShutdownTriggerMessage.create());
                break;
            }
            case Raw: {
                engine.injectMessage(GracefulShutdownTriggerMessage.create());
                break;
            }
            default: {
                throw new InternalError("unknown message encoding type '" + (Object)((Object)encodingType) + "'");
            }
        }
    }

    private final void testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy haPolicy, boolean hasStore, AepEngineTestMessage message) throws Exception {
        AepEngine engine1 = this.createEngine("engine1", haPolicy, null, null, null, null, hasStore, false, false, false, null, 1, 1, null, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        Assert.assertTrue((boolean)engine1.isPrimary());
        engine1.sendMessage(null, message.getMessage());
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneNonHASender_EventSourcing_Xbuf() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.EventSourcing, false, this.createMessage(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneNonHASender_EventSourcing_Proto() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.EventSourcing, false, this.createMessage(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneNonHASender_EventSourcing_Json() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.EventSourcing, false, this.createMessage(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneNonHASender_StateReplication_Xbuf() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.StateReplication, false, this.createMessage(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneNonHASender_StateReplication_Proto() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.StateReplication, false, this.createMessage(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneNonHASender_StateReplication_Json() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.StateReplication, false, this.createMessage(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneHASender_EventSourcing_Xbuf() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.EventSourcing, true, this.createMessage(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneHASender_EventSourcing_Proto() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.EventSourcing, true, this.createMessage(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneHASender_EventSourcing_Json() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.EventSourcing, true, this.createMessage(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneHASender_StateReplication_Xbuf() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.StateReplication, true, this.createMessage(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneHASender_StateReplication_Proto() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.StateReplication, true, this.createMessage(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test(expected=IllegalArgumentException.class)
    public void testSendOnNullChannel_StandaloneHASender_StateReplication_Json() throws Exception {
        this.testSendOnNullChannel_StandaloneSender(AepEngine.HAPolicy.StateReplication, true, this.createMessage(AepEngineTestObject.EncodingType.Json));
    }

    private final void testSendStabilityFail(AepEngine.HAPolicy haPolicy, AepEngineTestMessage message) throws Exception {
        AepEngineMessagingTestApp sender = super.registerTestApp(new AepEngineMessagingTestApp());
        this.startSenderStandaloneReceiverStandalone(sender, null, null, null, null, 15, 15, 15, 0, haPolicy, false, false, message.getEncodingType());
        this.messagingController.failNextSend("aeptest1", ((AepEngine)((Object)this.engines.get(0))).getDescriptor().getName());
        message.getMessage().acquire();
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel4, message.getMessage());
        Assert.assertTrue((boolean)sender.waitForStabilityNotification(1));
        Assert.assertEquals((long)0L, (long)sender.totalMessageCount);
        Assert.assertEquals((long)0L, (long)sender.totalStabilitySuccessCount);
        Assert.assertEquals((long)1L, (long)sender.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel4StabilitySuccessCount);
        Assert.assertEquals((long)1L, (long)sender.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilityFailCount);
    }

    @Ignore
    @Test
    public void testSendStabilityFail_EventSourcing_Xbuf() throws Exception {
        this.testSendStabilityFail(AepEngine.HAPolicy.EventSourcing, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendStabilityFail_StateReplication_Xbuf() throws Exception {
        this.testSendStabilityFail(AepEngine.HAPolicy.StateReplication, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendStabilityFail_EventSourcing_Proto() throws Exception {
        this.testSendStabilityFail(AepEngine.HAPolicy.EventSourcing, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendStabilityFail_StateReplication_Proto() throws Exception {
        this.testSendStabilityFail(AepEngine.HAPolicy.StateReplication, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendStabilityFail_EventSourcing_Json() throws Exception {
        this.testSendStabilityFail(AepEngine.HAPolicy.EventSourcing, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendStabilityFail_StateReplication_Json() throws Exception {
        this.testSendStabilityFail(AepEngine.HAPolicy.StateReplication, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Json));
    }

    private final void testSendReceive_StandaloneReceiver_NoHandlers(boolean guaranteed, AepEngine.HAPolicy haPolicy, List<AepEngineTestMessage> messages) throws Exception {
        AepEngineMessagingTestApp sender = super.registerTestApp(new AepEngineMessagingTestApp());
        this.startSenderStandaloneReceiverStandalone(sender, null, null, null, null, guaranteed ? 15 : 1, guaranteed ? 15 : 1, guaranteed ? 15 : 1, 0, haPolicy, false, false, messages.get(0).getEncodingType());
        for (AepEngineTestMessage message : messages) {
            message.getMessage().acquire();
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(guaranteed ? sender.channel4 : sender.channel1, message.getMessage());
        }
        Assert.assertTrue((boolean)(guaranteed ? sender.waitForStabilityNotification(1000) : sender.noStabilityReceived()));
        Assert.assertEquals((long)0L, (long)sender.totalMessageCount);
        Assert.assertEquals((long)(guaranteed ? 1000L : 0L), (long)sender.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel4MessageCount);
        Assert.assertEquals((long)(guaranteed ? 1000L : 0L), (long)sender.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilityFailCount);
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneReceiver_NoHandlers_EventSourcing_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(false, AepEngine.HAPolicy.EventSourcing, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneReceiver_NoHandlers_StateReplication_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(false, AepEngine.HAPolicy.StateReplication, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneReceiver_NoHandlers_EventSourcing_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(true, AepEngine.HAPolicy.EventSourcing, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneReceiver_NoHandlers_StateReplication_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(true, AepEngine.HAPolicy.StateReplication, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneReceiver_NoHandlers_EventSourcing_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(false, AepEngine.HAPolicy.EventSourcing, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneReceiver_NoHandlers_StateReplication_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(false, AepEngine.HAPolicy.StateReplication, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneReceiver_NoHandlers_EventSourcing_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(true, AepEngine.HAPolicy.EventSourcing, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneReceiver_NoHandlers_StateReplication_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(true, AepEngine.HAPolicy.StateReplication, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneReceiver_NoHandlers_EventSourcing_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(false, AepEngine.HAPolicy.EventSourcing, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneReceiver_NoHandlers_StateReplication_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(false, AepEngine.HAPolicy.StateReplication, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneReceiver_NoHandlers_EventSourcing_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(true, AepEngine.HAPolicy.EventSourcing, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneReceiver_NoHandlers_StateReplication_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver_NoHandlers(true, AepEngine.HAPolicy.StateReplication, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    private final void testSendReceive_StandaloneReceiver(boolean guaranteed, AepEngine.HAPolicy haPolicy, boolean hasStore, boolean hasStorePersister, boolean detachedStorePersister, boolean adaptiveBatching, List<AepEngineTestMessage> messages) throws Exception {
        AepEngine engine2;
        AepEngine engine1;
        AepEngineMessagingTestApp sender = super.registerTestApp(new AepEngineMessagingTestApp());
        sender.engine = engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, guaranteed ? 15 : 1, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineMessagingTestApp receiver = super.registerTestApp(new AepEngineMessagingTestApp());
        String receiverName = "engine-" + System.currentTimeMillis();
        receiver.engine = engine2 = this.createEngine(receiverName, haPolicy, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
        if (messages.get(0).getEncodingType() == AepEngineTestObject.EncodingType.Raw) {
            engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        }
        engine2.start();
        engine2.waitForMessagingToStart();
        for (AepEngineTestMessage message : messages) {
            message.getMessage().acquire();
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(guaranteed ? sender.channel4 : sender.channel1, message.getMessage());
        }
        Assert.assertTrue((boolean)receiver.waitForMessageReceipt(2000));
        Assert.assertTrue((boolean)(guaranteed ? sender.waitForStabilityNotification(1000) : sender.noStabilityReceived()));
        this.scheduleShutdown(engine1, messages.get(0).getEncodingType());
        Assert.assertTrue((boolean)sender.waitForEngineToStop());
        this.scheduleShutdown(engine2, messages.get(0).getEncodingType());
        Assert.assertTrue((boolean)receiver.waitForEngineToStop());
        Assert.assertEquals((long)0L, (long)sender.totalMessageCount);
        Assert.assertEquals((long)(guaranteed ? 1000L : 0L), (long)sender.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel4MessageCount);
        Assert.assertEquals((long)(guaranteed ? 1000L : 0L), (long)sender.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilityFailCount);
        Assert.assertEquals((long)2000L, (long)receiver.totalMessageCount);
        Assert.assertEquals((long)0L, (long)receiver.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver.totalStabilityFailCount);
        Assert.assertEquals((long)(guaranteed ? 0L : 1000L), (long)receiver.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)receiver.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver.channel1StabilityFailCount);
        if (!guaranteed) {
            this.compareMessages(messages, receiver.channel1Messages);
        }
        Assert.assertEquals((long)0L, (long)receiver.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)receiver.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)receiver.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver.channel3StabilityFailCount);
        Assert.assertEquals((long)(guaranteed ? 1000L : 0L), (long)receiver.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)receiver.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver.channel4StabilityFailCount);
        if (guaranteed) {
            this.compareMessages(messages, receiver.channel4Messages);
        }
        Assert.assertEquals((long)0L, (long)receiver.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)receiver.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)receiver.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver.channel6StabilityFailCount);
        if (hasStorePersister) {
            receiver = super.registerTestApp(new AepEngineMessagingTestApp());
            receiver.engine = engine2 = this.createEngine(receiverName, haPolicy, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
            engine2.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
            if (messages.get(0).getEncodingType() == AepEngineTestObject.EncodingType.Raw) {
                engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            }
            engine2.start();
            engine2.waitForMessagingToStart();
            Assert.assertEquals((long)(haPolicy == AepEngine.HAPolicy.EventSourcing ? 1000L : 0L), (long)receiver.totalMessageCount);
            Assert.assertEquals((long)0L, (long)receiver.totalStabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.totalStabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel1MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel1StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel1StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel2MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel2StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel2StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel3MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel3StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel3StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel4MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel4StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel4StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel5MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel5StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel5StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel6MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel6StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel6StabilityFailCount);
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                Assert.assertEquals((long)1000L, (long)receiver.channelGMessageCount);
                this.compareMessages(messages, receiver.channelGMessages);
            }
        }
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneNonHAReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHANonPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHAAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_StandaloneHADetachedPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneNonHAReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHANonPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHAAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_StandaloneHADetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_StandaloneReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    private final void testSendReceive_RedundantReceiver(boolean guaranteed, AepEngine.HAPolicy haPolicy, boolean hasStorePersister, boolean detachedStorePersister, boolean adaptiveBatching, List<AepEngineTestMessage> messages) throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineMessagingTestApp sender = super.registerTestApp(new AepEngineMessagingTestApp());
        sender.engine = engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, guaranteed ? 15 : 1, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineMessagingTestApp receiver1 = super.registerTestApp(new AepEngineMessagingTestApp());
        AepEngineMessagingTestApp receiver2 = super.registerTestApp(new AepEngineMessagingTestApp());
        receiver1.engine = engine2 = this.createEngine(receiverName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver1, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
        engine2.start();
        engine2.waitForMessagingToStart();
        receiver2.engine = engine3 = this.createEngine(receiverName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m2", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver2, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
        if (messages.get(0).getEncodingType() == AepEngineTestObject.EncodingType.Raw) {
            engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        }
        engine3.start();
        for (AepEngineTestMessage message : messages) {
            message.getMessage().acquire();
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(guaranteed ? sender.channel4 : sender.channel1, message.getMessage());
        }
        Assert.assertTrue((boolean)receiver1.waitForMessageReceipt(2000));
        if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
            Assert.assertTrue((boolean)receiver2.waitForMessageReceipt(1000));
        }
        Assert.assertTrue((boolean)(guaranteed ? sender.waitForStabilityNotification(1000) : sender.noStabilityReceived()));
        this.scheduleShutdown(engine1, messages.get(0).getEncodingType());
        Assert.assertTrue((boolean)sender.waitForEngineToStop());
        this.scheduleShutdown(engine2, messages.get(0).getEncodingType());
        Assert.assertTrue((boolean)receiver1.waitForEngineToStop());
        Assert.assertTrue((boolean)receiver2.waitForEngineToStop());
        Thread.sleep(1000L);
        Assert.assertEquals((long)0L, (long)sender.totalMessageCount);
        Assert.assertEquals((long)(guaranteed ? 1000L : 0L), (long)sender.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel4MessageCount);
        Assert.assertEquals((long)(guaranteed ? 1000L : 0L), (long)sender.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilityFailCount);
        Assert.assertEquals((long)2000L, (long)receiver1.totalMessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.totalStabilityFailCount);
        Assert.assertEquals((long)(guaranteed ? 0L : 1000L), (long)receiver1.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel1StabilityFailCount);
        if (!guaranteed) {
            this.compareMessages(messages, receiver1.channel1Messages);
        }
        Assert.assertEquals((long)0L, (long)receiver1.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel3StabilityFailCount);
        Assert.assertEquals((long)(guaranteed ? 1000L : 0L), (long)receiver1.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel4StabilityFailCount);
        if (guaranteed) {
            this.compareMessages(messages, receiver1.channel4Messages);
        }
        Assert.assertEquals((long)0L, (long)receiver1.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6StabilityFailCount);
        Assert.assertEquals((long)(haPolicy == AepEngine.HAPolicy.EventSourcing ? 1000L : 0L), (long)receiver2.totalMessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6StabilityFailCount);
        if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
            Assert.assertEquals((long)1000L, (long)receiver2.channelGMessageCount);
            this.compareMessages(messages, receiver2.channelGMessages);
        }
        if (hasStorePersister) {
            receiver1 = super.registerTestApp(new AepEngineMessagingTestApp());
            receiver1.engine = engine2 = this.createEngine(receiverName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver1, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
            engine2.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
            if (messages.get(0).getEncodingType() == AepEngineTestObject.EncodingType.Raw) {
                engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            }
            engine2.start();
            Assert.assertEquals((long)(haPolicy == AepEngine.HAPolicy.EventSourcing ? 1000L : 0L), (long)receiver1.totalMessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.totalStabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.totalStabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel1MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel1StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel1StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel2MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel2StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel2StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel3MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel3StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel3StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel4MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel4StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel4StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel5MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel5StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel5StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel6MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel6StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel6StabilityFailCount);
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                Assert.assertEquals((long)1000L, (long)receiver1.channelGMessageCount);
                this.compareMessages(messages, receiver1.channelGMessages);
            } else {
                Assert.assertEquals((long)0L, (long)receiver1.channelGMessageCount);
            }
            this.scheduleShutdown(engine2, messages.get(0).getEncodingType());
            Assert.assertTrue((boolean)receiver1.waitForEngineToStop());
            receiver2 = super.registerTestApp(new AepEngineMessagingTestApp());
            receiver2.engine = engine3 = this.createEngine(receiverName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m2", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver2, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
            engine3.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
            if (messages.get(0).getEncodingType() == AepEngineTestObject.EncodingType.Raw) {
                engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            }
            engine3.start();
            Assert.assertEquals((long)(haPolicy == AepEngine.HAPolicy.EventSourcing ? 1000L : 0L), (long)receiver2.totalMessageCount);
            Assert.assertEquals((long)0L, (long)receiver2.totalStabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver2.totalStabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel1MessageCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel1StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel1StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel2MessageCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel2StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel2StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel3MessageCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel3StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel3StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel4MessageCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel4StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel4StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel5MessageCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel5StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel5StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel6MessageCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel6StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver2.channel6StabilityFailCount);
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                Assert.assertEquals((long)1000L, (long)receiver2.channelGMessageCount);
                this.compareMessages(messages, receiver2.channelGMessages);
            } else {
                Assert.assertEquals((long)0L, (long)receiver1.channelGMessageCount);
            }
            receiver1 = super.registerTestApp(new AepEngineMessagingTestApp());
            receiver1.engine = engine2 = this.createEngine(receiverName, haPolicy, null, null, null, null, true, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 15 : 1, guaranteed ? 15 : 1, receiver1, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
            engine2.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
            if (messages.get(0).getEncodingType() == AepEngineTestObject.EncodingType.Raw) {
                engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            }
            engine2.start();
            Assert.assertEquals((long)(haPolicy == AepEngine.HAPolicy.EventSourcing ? 1000L : 0L), (long)receiver1.totalMessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.totalStabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.totalStabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel1MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel1StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel1StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel2MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel2StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel2StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel3MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel3StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel3StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel4MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel4StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel4StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel5MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel5StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel5StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel6MessageCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel6StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver1.channel6StabilityFailCount);
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                Assert.assertEquals((long)1000L, (long)receiver1.channelGMessageCount);
                this.compareMessages(messages, receiver1.channelGMessages);
            } else {
                Assert.assertEquals((long)0L, (long)receiver1.channelGMessageCount);
            }
        }
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_StateReplication_AdaptiveBatching_Raw() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Raw));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_StateReplication_AdaptiveBatching_Xbuf() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Raw() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Raw));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_StateReplication_AdaptiveBatching_Proto() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Proto));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantNonPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.EventSourcing, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_BestEffort_RedundantDetachedPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantNonPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, false, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_EventSourcing_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_EventSourcing_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.EventSourcing, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_StateReplication_NoAdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(true, AepEngine.HAPolicy.StateReplication, true, true, false, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantAttachedPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, false, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    @Ignore
    @Test
    public void testSendReceive_Guaranteed_RedundantDetachedPersistentReceiver_StateReplication_AdaptiveBatching_Json() throws Exception {
        this.testSendReceive_RedundantReceiver(false, AepEngine.HAPolicy.StateReplication, true, true, true, this.createMessages(AepEngineTestObject.EncodingType.Json));
    }

    private final void testSendReceive_PartitionedReceiver(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineMessagingTestApp sender = super.registerTestApp(new AepEngineMessagingTestApp());
        sender.engine = engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 4, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        String receiver1Name = "engine-p1";
        AepEngineMessagingTestApp receiver1 = super.registerTestApp(new AepEngineMessagingTestApp());
        receiver1.engine = engine2 = this.createEngine(receiver1Name, haPolicy, null, null, null, null, true, false, false, false, null, 4, 4, receiver1, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        engine2.start();
        engine2.waitForMessagingToStart();
        String receiver2Name = "engine-p2";
        AepEngineMessagingTestApp receiver2 = super.registerTestApp(new AepEngineMessagingTestApp());
        receiver2.engine = engine3 = this.createEngine(receiver2Name, haPolicy, null, null, null, null, true, false, false, false, null, 4, 4, receiver2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(encodingType));
        if (encodingType == AepEngineTestObject.EncodingType.Raw) {
            engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        }
        engine3.start();
        AepEngineTestMessage message = this.createMessage(encodingType);
        message.setForPartition(1);
        message.getMessage().acquire();
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel3, message.getMessage());
        Assert.assertTrue((boolean)receiver1.waitForMessageReceipt(2));
        Assert.assertFalse((boolean)receiver2.waitForMessageReceipt(1));
        Assert.assertTrue((boolean)sender.noStabilityReceived());
        Assert.assertEquals((long)0L, (long)sender.totalMessageCount);
        Assert.assertEquals((long)0L, (long)sender.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilityFailCount);
        Assert.assertEquals((long)2L, (long)receiver1.totalMessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel2StabilityFailCount);
        Assert.assertEquals((long)1L, (long)receiver1.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.totalMessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6StabilityFailCount);
        message = this.createMessage(encodingType);
        message.setForPartition(2);
        message.getMessage().acquire();
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel3, message.getMessage());
        Assert.assertFalse((boolean)receiver1.waitForMessageReceipt(3));
        Assert.assertTrue((boolean)receiver2.waitForMessageReceipt(2));
        Assert.assertTrue((boolean)sender.noStabilityReceived());
        Assert.assertEquals((long)0L, (long)sender.totalMessageCount);
        Assert.assertEquals((long)0L, (long)sender.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel2StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)sender.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)sender.channel6StabilityFailCount);
        Assert.assertEquals((long)2L, (long)receiver1.totalMessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel2StabilityFailCount);
        Assert.assertEquals((long)1L, (long)receiver1.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver1.channel6StabilityFailCount);
        Assert.assertEquals((long)2L, (long)receiver2.totalMessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.totalStabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.totalStabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel1StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel2StabilityFailCount);
        Assert.assertEquals((long)1L, (long)receiver2.channel3MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel3StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel3StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel4StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel5StabilityFailCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6MessageCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6StabilitySuccessCount);
        Assert.assertEquals((long)0L, (long)receiver2.channel6StabilityFailCount);
    }

    @Ignore
    @Test
    public void testSendReceive_PartitionedReceiver_BestEffort_EventSourcing_Xbuf() throws Exception {
        this.testSendReceive_PartitionedReceiver(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Ignore
    @Test
    public void testSendReceive_PartitionedReceiver_BestEffort_StateReplication_Xbuf() throws Exception {
        this.testSendReceive_PartitionedReceiver(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Ignore
    @Test
    public void testSendReceive_PartitionedReceiver_BestEffort_EventSourcing_Proto() throws Exception {
        this.testSendReceive_PartitionedReceiver(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto);
    }

    @Ignore
    @Test
    public void testSendReceive_PartitionedReceiver_BestEffort_StateReplication_Proto() throws Exception {
        this.testSendReceive_PartitionedReceiver(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto);
    }

    @Ignore
    @Test
    public void testSendReceive_PartitionedReceiver_BestEffort_EventSourcing_Json() throws Exception {
        this.testSendReceive_PartitionedReceiver(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Json);
    }

    @Ignore
    @Test
    public void testSendReceive_PartitionedReceiver_BestEffort_StateReplication_Json() throws Exception {
        this.testSendReceive_PartitionedReceiver(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Json);
    }

    private final void testSendForwarderReceive_StandaloneForwarder(final boolean guaranteed, AepEngine.HAPolicy haPolicy, boolean hasStore, boolean hasStorePersister, boolean detachedStorePersister, boolean adaptiveBatching, List<AepEngineTestMessage> messages) throws Exception {
        AepEngine receiverEngine;
        AepEngine forwarderEngine;
        AepEngine senderEngine;
        AepEngineMessagingTestApp sender = super.registerTestApp(new AepEngineMessagingTestApp());
        sender.engine = senderEngine = this.createEngine("sender", null, null, null, null, null, false, false, false, false, null, guaranteed ? 8 : 1, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        senderEngine.start();
        senderEngine.waitForMessagingToStart();
        AepEngineMessagingTestApp forwarder = new AepEngineMessagingTestApp(){

            @Override
            protected void onChannelGMessageHandler(IRogMessage message) {
                IRogMessage forwardCopy = (IRogMessage)((IRogCopyableNode)message).copy();
                forwardCopy.setMessageBus("aeptest1");
                forwardCopy.setMessageChannel(guaranteed ? "channel5" : "channel2");
                this.engine.sendMessage(guaranteed ? this.channel5 : this.channel2, forwardCopy);
                super.onChannelGMessageHandler(message);
            }
        };
        super.registerTestApp(forwarder);
        String forwarderName = "forwarder-" + System.currentTimeMillis();
        forwarder.engine = forwarderEngine = this.createEngine(forwarderName, haPolicy, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 24 : 3, guaranteed ? 8 : 1, forwarder, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
        forwarderEngine.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
        if (messages.get(0).getEncodingType() == AepEngineTestObject.EncodingType.Raw) {
            forwarderEngine.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        }
        forwarderEngine.start();
        forwarderEngine.waitForMessagingToStart();
        AepEngineMessagingTestApp receiver = super.registerTestApp(new AepEngineMessagingTestApp());
        String receiverName = "engine-" + System.currentTimeMillis();
        receiver.engine = receiverEngine = this.createEngine(receiverName, haPolicy, null, null, null, null, false, false, false, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 56 : 7, guaranteed ? 16 : 2, receiver, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
        receiverEngine.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
        receiverEngine.start();
        receiverEngine.waitForMessagingToStart();
        for (AepEngineTestMessage message : messages) {
            message.getMessage().acquire();
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(guaranteed ? sender.channel4 : sender.channel1, message.getMessage());
        }
        Assert.assertTrue((boolean)receiver.waitForMessageReceipt(2000));
        Assert.assertTrue((boolean)(guaranteed ? sender.waitForStabilityNotification(1000) : sender.noStabilityReceived()));
        this.scheduleShutdown(forwarderEngine, messages.get(0).getEncodingType());
        Assert.assertTrue((boolean)forwarder.waitForEngineToStop());
        if (hasStorePersister) {
            forwarder = new AepEngineMessagingTestApp(){

                @Override
                protected void onChannelGMessageHandler(IRogMessage message) {
                    IRogMessage forwardCopy = (IRogMessage)((IRogCopyableNode)message).copy();
                    forwardCopy.setMessageBus("aeptest1");
                    forwardCopy.setMessageChannel(guaranteed ? "channel5" : "channel2");
                    this.engine.sendMessage(guaranteed ? this.channel5 : this.channel2, forwardCopy);
                    super.onChannelGMessageHandler(message);
                }
            };
            super.registerTestApp(forwarder);
            forwarder.engine = forwarderEngine = this.createEngine(forwarderName, haPolicy, null, null, null, null, hasStore, hasStorePersister, detachedStorePersister, false, XRuntime.getDataDirectory() + File.separator + "m1", guaranteed ? 56 : 7, guaranteed ? 16 : 2, forwarder, null, null, adaptiveBatching ? 64 : 0, false, false, null, null, null, false, false);
            forwarderEngine.registerFactory(AepEngineTestMessage.getFactory(messages.get(0).getEncodingType()));
            if (messages.get(0).getEncodingType() == AepEngineTestObject.EncodingType.Raw) {
                forwarderEngine.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
            }
            forwarderEngine.start();
            forwarderEngine.waitForMessagingToStart();
            Assert.assertEquals((long)(haPolicy == AepEngine.HAPolicy.EventSourcing ? 2000L : 0L), (long)receiver.totalMessageCount);
            Assert.assertEquals((long)0L, (long)receiver.totalStabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.totalStabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel1MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel1StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel1StabilityFailCount);
            Assert.assertEquals((long)(haPolicy == AepEngine.HAPolicy.EventSourcing && !guaranteed ? 1000L : 0L), (long)receiver.channel2MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel2StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel2StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel3MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel3StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel3StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel4MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel4StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel4StabilityFailCount);
            Assert.assertEquals((long)(haPolicy == AepEngine.HAPolicy.EventSourcing && guaranteed ? 1000L : 0L), (long)receiver.channel5MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel5StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel5StabilityFailCount);
            Assert.assertEquals((long)0L, (long)receiver.channel6MessageCount);
            Assert.assertEquals((long)0L, (long)receiver.channel6StabilitySuccessCount);
            Assert.assertEquals((long)0L, (long)receiver.channel6StabilityFailCount);
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                Assert.assertEquals((long)1000L, (long)receiver.channelGMessageCount);
                this.compareMessages(messages, receiver.channelGMessages);
            } else {
                Assert.assertEquals((long)0L, (long)receiver.totalMessageCount);
            }
        }
    }

    @Test
    public void testSendForwarderReceive_Guaranteed_StandaloneHAAttachedPersistentForwarder_EventSourcing_NoAdaptiveBatching_Xbuf() throws Exception {
        this.testSendForwarderReceive_StandaloneForwarder(true, AepEngine.HAPolicy.EventSourcing, true, true, false, false, this.createMessages(AepEngineTestObject.EncodingType.Xbuf));
    }
}

