/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.event.AepBusBindingCreatedEvent;
import com.neeve.aep.event.AepBusBindingDestroyedEvent;
import com.neeve.aep.event.AepBusBindingOpenedEvent;
import com.neeve.aep.event.AepBusBindingOpeningEvent;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineActiveEvent;
import com.neeve.aep.event.AepEngineCreatedEvent;
import com.neeve.aep.event.AepEngineStartedEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepEngineStoppingEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.aep.test.unit.AepEngineLifecycleEventsTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.ci.XRuntime;
import com.neeve.ods.impl.StoreBindingRoleChangedEvent;
import com.neeve.ods.impl.StoreMemberDownEvent;
import com.neeve.ods.impl.StoreMemberInitCompleteEvent;
import com.neeve.ods.impl.StoreMemberUpEvent;
import java.io.File;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineLifecycleEventsTest
extends AepEngineTest {
    @Test
    public final void testCommonLifecycleEventDispatch() throws Exception {
        AepEngineLifecycleEventsTestApp app = new AepEngineLifecycleEventsTestApp();
        this.createEngine("engine", null, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        Iterator<Object> iterator = app.eventsFromLifecycleEvent.iterator();
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineCreatedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.eventsFromLifecycleEvent.clear();
        iterator = app.eventsFromILifecycleEvent.iterator();
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineCreatedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = app.events.iterator();
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineCreatedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private final void testLifecycleEvents_NonHA(AepEngine.HAPolicy haPolicy) throws Exception {
        AepEngineLifecycleEventsTestApp app = new AepEngineLifecycleEventsTestApp();
        AepEngine engine = this.createEngine("engine", null, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        Iterator<Object> iterator = app.events.iterator();
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineCreatedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.events.clear();
        engine.start();
        engine.waitForMessagingToStart();
        iterator = app.events.iterator();
        this.assertExpectedEventType(AepEngineStartedEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpeningEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpenedEvent.class, iterator.next());
        this.assertExpectedEventType(AepChannelUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepMessagingPrestartEvent.class, iterator.next());
        this.assertExpectedEventType(AepMessagingStartedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineActiveEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.events.clear();
        engine.stop();
        Assert.assertTrue((boolean)app.waitForEngineToStop());
        iterator = app.events.iterator();
        this.assertExpectedEventType(AepEngineStoppingEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingDestroyedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineStoppedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public final void testLifecycleEvents_NonHA_EventSourcing() throws Exception {
        this.testLifecycleEvents_NonHA(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public final void testLifecycleEvents_NonHA_StateReplication() throws Exception {
        this.testLifecycleEvents_NonHA(AepEngine.HAPolicy.StateReplication);
    }

    private final void testLifecycleEvents_HA(AepEngine.HAPolicy haPolicy, boolean hasStorePersister) throws Exception {
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineLifecycleEventsTestApp receiver1 = new AepEngineLifecycleEventsTestApp();
        AepEngineLifecycleEventsTestApp receiver2 = new AepEngineLifecycleEventsTestApp();
        AepEngine engine1 = this.createEngine(receiverName, haPolicy, null, null, null, null, true, hasStorePersister, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 67, 67, receiver1, null, null, 0, false, false, null, null, null, false, false);
        Iterator<Object> iterator = receiver1.events.iterator();
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineCreatedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver1.events.clear();
        engine1.start();
        engine1.waitForMessagingToStart();
        iterator = receiver1.events.iterator();
        this.assertExpectedEventType(StoreMemberInitCompleteEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineStartedEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpeningEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpenedEvent.class, iterator.next());
        this.assertExpectedEventType(AepChannelUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepChannelUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpeningEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpenedEvent.class, iterator.next());
        this.assertExpectedEventType(AepChannelUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepMessagingPrestartEvent.class, iterator.next());
        this.assertExpectedEventType(AepMessagingStartedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineActiveEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver1.events.clear();
        AepEngine engine2 = this.createEngine(receiverName, haPolicy, null, null, null, null, true, hasStorePersister, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 67, 67, receiver2, null, null, 0, false, false, null, null, null, false, false);
        iterator = receiver2.events.iterator();
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineCreatedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver2.events.clear();
        engine2.start();
        iterator = receiver2.events.iterator();
        this.assertExpectedEventType(StoreMemberUpEvent.class, iterator.next());
        this.assertExpectedEventType(StoreMemberInitCompleteEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineStartedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver2.events.clear();
        iterator = receiver1.events.iterator();
        this.assertExpectedEventType(StoreMemberUpEvent.class, iterator.next());
        this.assertExpectedEventType(StoreMemberInitCompleteEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver1.events.clear();
        engine2.stop();
        receiver2.waitForEngineToStop();
        iterator = receiver2.events.iterator();
        this.assertExpectedEventType(AepEngineStoppingEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingDestroyedEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingDestroyedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineStoppedEvent.class, iterator.next());
        receiver2.events.clear();
        Thread.sleep(100L);
        iterator = receiver1.events.iterator();
        this.assertExpectedEventType(StoreMemberDownEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver1.events.clear();
        engine2 = this.createEngine(receiverName, haPolicy, null, null, null, null, true, hasStorePersister, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 67, 67, receiver2, null, null, 0, false, false, null, null, null, false, false);
        iterator = receiver2.events.iterator();
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingCreatedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineCreatedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver2.events.clear();
        engine2.start();
        iterator = receiver2.events.iterator();
        this.assertExpectedEventType(StoreMemberUpEvent.class, iterator.next());
        this.assertExpectedEventType(StoreMemberInitCompleteEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineStartedEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver2.events.clear();
        iterator = receiver1.events.iterator();
        this.assertExpectedEventType(StoreMemberUpEvent.class, iterator.next());
        this.assertExpectedEventType(StoreMemberInitCompleteEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver1.events.clear();
        engine1.stop();
        receiver1.waitForEngineToStop();
        iterator = receiver1.events.iterator();
        this.assertExpectedEventType(AepEngineStoppingEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingDestroyedEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingDestroyedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineStoppedEvent.class, iterator.next());
        receiver1.events.clear();
        engine2.waitForMessagingToStart();
        iterator = receiver2.events.iterator();
        this.assertExpectedEventType(StoreMemberDownEvent.class, iterator.next());
        this.assertExpectedEventType(StoreBindingRoleChangedEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpeningEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpenedEvent.class, iterator.next());
        this.assertExpectedEventType(AepChannelUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepChannelUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpeningEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingOpenedEvent.class, iterator.next());
        this.assertExpectedEventType(AepChannelUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepBusBindingUpEvent.class, iterator.next());
        this.assertExpectedEventType(AepMessagingPrestartEvent.class, iterator.next());
        this.assertExpectedEventType(AepMessagingStartedEvent.class, iterator.next());
        this.assertExpectedEventType(AepEngineActiveEvent.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        receiver2.events.clear();
    }

    private final void assertExpectedEventType(Class<?> c, Object object) {
        Assert.assertSame((String)("Expected event to be of type " + c.getSimpleName() + " but got '" + object + "'"), c, object.getClass());
    }

    @Test
    public final void testLifecycleEvents_HA_NonPersistent_EventSourcing() throws Exception {
        this.testLifecycleEvents_HA(AepEngine.HAPolicy.EventSourcing, false);
    }

    @Test
    public final void testLifecycleEvents_HA_Persistent_EventSourcing() throws Exception {
        this.testLifecycleEvents_HA(AepEngine.HAPolicy.EventSourcing, true);
    }

    @Test
    public final void testLifecycleEvents_HA_NonPersistent_StateReplication() throws Exception {
        this.testLifecycleEvents_HA(AepEngine.HAPolicy.StateReplication, false);
    }

    @Test
    public final void testLifecycleEvents_HA_Persistent_StateReplication() throws Exception {
        this.testLifecycleEvents_HA(AepEngine.HAPolicy.StateReplication, true);
    }
}

