/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepBusBindingDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepMessagingFailedEvent;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.event.MessageStabilityEvent;
import java.util.ArrayList;

public final class AepEngineFailoverTestApp {
    AepEngineFailoverTestApp sender;
    Object sendFlowControlObject = new Object();
    Object bindingFailedObject = new Object();
    Object messagingFailedObject = new Object();
    Object engineStoppedObject = new Object();
    boolean sendDone;
    int numSent;
    int numReceived;
    int bindingUpEventCount;
    int bindingDownEventCount;
    int messagingFailedEventCount;
    int stabilityCount;
    boolean bindingFailed;
    boolean messagingFailed;
    boolean stopReceived;
    MessageChannel channel4;
    ArrayList<IRogMessage> messages = new ArrayList();
    long nextSno = 1L;

    AepEngineFailoverTestApp(AepEngineFailoverTestApp sender) {
        this.sender = sender;
    }

    AepEngineFailoverTestApp() {
        this(null);
    }

    private final void onMessage(IRogMessage message) {
        message.acquire();
        this.messages.add(message);
        long sno = message.getMessageSequenceNumber();
        if (sno < this.nextSno) {
            System.out.println("Dup [sno=" + sno + "]");
        } else if (sno > this.nextSno) {
            System.out.println("Gap [exp=" + this.nextSno + ", actual=" + sno + "]");
        }
        this.nextSno = Math.max(this.nextSno, sno + 1L);
        this.sender.onReceive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSend() {
        Object object = this.sendFlowControlObject;
        synchronized (object) {
            ++this.numSent;
            while (!this.sendDone && this.numSent - this.numReceived > 1000) {
                try {
                    this.sendFlowControlObject.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendDone() {
        Object object = this.sendFlowControlObject;
        synchronized (object) {
            this.sendDone = true;
            this.sendFlowControlObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onReceive() {
        Object object = this.sendFlowControlObject;
        synchronized (object) {
            ++this.numReceived;
            this.sendFlowControlObject.notifyAll();
        }
    }

    final boolean waitForExpectedMessageReceipt(int expectedMessageCount) {
        for (int i = 0; i < 20; ++i) {
            System.out.println(Thread.currentThread().getId() + ": received " + this.messages.size() + "...");
            if (this.messages.size() < expectedMessageCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    final boolean waitForExpectedMessageStability(int expectedStabilityCount) {
        for (int i = 0; i < 20; ++i) {
            System.out.println(Thread.currentThread().getId() + ": stable " + this.stabilityCount + "...");
            if (this.stabilityCount < expectedStabilityCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForBindingToFail() {
        Object object = this.bindingFailedObject;
        synchronized (object) {
            while (!this.bindingFailed) {
                try {
                    this.bindingFailedObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForMessagingToFail() {
        Object object = this.messagingFailedObject;
        synchronized (object) {
            while (!this.messagingFailed) {
                try {
                    this.messagingFailedObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForEngineToStop() {
        Object object = this.engineStoppedObject;
        synchronized (object) {
            while (!this.stopReceived) {
                try {
                    this.engineStoppedObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    final void dumpMessages() {
        System.out.println("Messages {");
        for (IRogMessage message : this.messages) {
            System.out.println("...sno=" + message.getMessageSequenceNumber());
        }
        System.out.println("}");
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4UpEventHandler(AepChannelUpEvent event) {
        this.channel4 = event.getMessageChannel();
    }

    @EventHandler
    public void onXbufMessageHandler(com.neeve.aep.test.unit.generated.xbuf.Message message) {
        this.onMessage(message);
    }

    @EventHandler
    public void onProtoMessageHandler(com.neeve.aep.test.unit.generated.proto.Message message) {
        this.onMessage(message);
    }

    @EventHandler
    public void onJsonMessageHandler(Message message) {
        this.onMessage(message);
    }

    @EventHandler
    public void onStability(MessageStabilityEvent event) {
        ++this.stabilityCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onBindingDownEventHandler(AepBusBindingDownEvent event) {
        ++this.bindingDownEventCount;
        Object object = this.bindingFailedObject;
        synchronized (object) {
            this.bindingFailed = true;
            this.bindingFailedObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onMessagingFailed(AepMessagingFailedEvent event) {
        ++this.messagingFailedEventCount;
        Object object = this.messagingFailedObject;
        synchronized (object) {
            this.messagingFailed = true;
            this.messagingFailedObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onEngineStopped(AepEngineStoppedEvent event) {
        Object object = this.engineStoppedObject;
        synchronized (object) {
            this.stopReceived = true;
            this.engineStoppedObject.notifyAll();
        }
    }
}

