/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.config.IConfigRepository;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageEncodingTypeDescriptor;
import com.neeve.sma.MessageViewFactoryDescriptor;
import com.neeve.sma.MessagingProviderDescriptor;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.trace.Tracer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class SmaConfigToolPlugin {
    private final LinkedHashMap<String, MessagingProviderDescriptor> providers;
    private final LinkedHashMap<String, MessageBusDescriptor> buses;
    private final LinkedHashMap<String, MessageEncodingTypeDescriptor> encodingTypes;
    private final LinkedHashMap<String, MessageViewFactoryDescriptor> viewFactories;
    private final IConfigRepository repo;
    private final Tracer tracer;

    private SmaConfigToolPlugin(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        this.tracer = tracer;
        this.repo = repo;
        interactiveTool.registerCommand((Command)new CreateBusProvider());
        interactiveTool.registerCommand((Command)new ListBusProviders());
        interactiveTool.registerCommand((Command)new DeleteBusProvider());
        interactiveTool.registerCommand((Command)new CreateBus());
        interactiveTool.registerCommand((Command)new ListBuses());
        interactiveTool.registerCommand((Command)new DeleteBus());
        interactiveTool.registerCommand((Command)new LocalizeBus());
        interactiveTool.registerCommand((Command)new UnlocalizeBus());
        interactiveTool.registerCommand((Command)new AddChannel());
        interactiveTool.registerCommand((Command)new RemoveChannel());
        interactiveTool.registerCommand((Command)new DeleteChannel());
        interactiveTool.registerCommand((Command)new SetChannelId());
        interactiveTool.registerCommand((Command)new SetChannelQos());
        interactiveTool.registerCommand((Command)new SetChannelKey());
        interactiveTool.registerCommand((Command)new SetChannelFilter());
        interactiveTool.registerCommand((Command)new CreateEncodingType());
        interactiveTool.registerCommand((Command)new ListEncodingTypes());
        interactiveTool.registerCommand((Command)new DeleteEncodingType());
        interactiveTool.registerCommand((Command)new CreateViewFactory());
        interactiveTool.registerCommand((Command)new ListViewFactories());
        interactiveTool.registerCommand((Command)new DeleteViewFactory());
        this.providers = new LinkedHashMap();
        this.initProviderDescriptorTable();
        this.buses = new LinkedHashMap();
        this.initBusDescriptorTable();
        this.encodingTypes = new LinkedHashMap();
        this.initEncodingTypeDescriptorTable();
        this.viewFactories = new LinkedHashMap();
        this.initViewFactoryDescriptorTable();
    }

    private final void initProviderDescriptorTable() throws Exception {
        this.tracer.log("Loading configured messaging providers...", Tracer.Level.INFO);
        this.providers.clear();
        Set<MessagingProviderDescriptor> providerSet = MessagingProviderDescriptor.loadAll(this.repo);
        if (providerSet.size() > 0) {
            for (MessagingProviderDescriptor provider : providerSet) {
                this.tracer.log("...." + provider.getName().toLowerCase(), Tracer.Level.INFO);
                this.providers.put(provider.getName().toLowerCase(), provider);
            }
        } else {
            this.tracer.log("....No configured providers", Tracer.Level.INFO);
        }
    }

    private final void initBusDescriptorTable() throws Exception {
        this.tracer.log("Loading configured buses...", Tracer.Level.INFO);
        this.buses.clear();
        Set<MessageBusDescriptor> busSet = MessageBusDescriptor.loadAll(this.repo, null);
        if (busSet.size() > 0) {
            for (MessageBusDescriptor bus : busSet) {
                this.tracer.log("...." + bus.getName(), Tracer.Level.INFO);
                this.buses.put(bus.getName(), bus);
            }
        } else {
            this.tracer.log("....No configured buses", Tracer.Level.INFO);
        }
    }

    private final void initEncodingTypeDescriptorTable() throws Exception {
        this.tracer.log("Loading configured encoding types...", Tracer.Level.INFO);
        this.encodingTypes.clear();
        Collection<MessageEncodingTypeDescriptor> encodingTypeCollection = MessageEncodingTypeDescriptor.loadAll(this.repo).values();
        if (encodingTypeCollection.size() > 0) {
            for (MessageEncodingTypeDescriptor encodingType : encodingTypeCollection) {
                this.tracer.log("...." + encodingType.getName().toLowerCase(), Tracer.Level.INFO);
                this.encodingTypes.put(encodingType.getName().toLowerCase(), encodingType);
            }
        } else {
            this.tracer.log("....No configured encoding types", Tracer.Level.INFO);
        }
    }

    private final void initViewFactoryDescriptorTable() throws Exception {
        this.tracer.log("Loading configured view factories...", Tracer.Level.INFO);
        this.viewFactories.clear();
        Collection<MessageViewFactoryDescriptor> viewFactoryCollection = MessageViewFactoryDescriptor.loadAll(this.repo).values();
        if (viewFactoryCollection.size() > 0) {
            for (MessageViewFactoryDescriptor viewFactory : viewFactoryCollection) {
                this.tracer.log("...." + viewFactory.getName().toLowerCase(), Tracer.Level.INFO);
                this.viewFactories.put(viewFactory.getName().toLowerCase(), viewFactory);
            }
        } else {
            this.tracer.log("....No configured view factories", Tracer.Level.INFO);
        }
    }

    public static final Object create(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        return new SmaConfigToolPlugin(interactiveTool, repo, tracer);
    }

    public final class DeleteViewFactory
    extends Command {
        public final void doDelete(String viewFactoryName) {
            MessageViewFactoryDescriptor viewFactory = (MessageViewFactoryDescriptor)((Object)SmaConfigToolPlugin.this.viewFactories.get(viewFactoryName.toLowerCase()));
            if (viewFactory != null) {
                SmaConfigToolPlugin.this.tracer.log("Deleting message view factory '" + viewFactory.getName() + "'...", Tracer.Level.INFO);
                try {
                    viewFactory.delete(SmaConfigToolPlugin.this.repo);
                    SmaConfigToolPlugin.this.viewFactories.remove(viewFactoryName);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to delete view factory '" + viewFactoryName + "' [" + e.toString() + "]", Tracer.Level.INFO);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("message view factory '" + viewFactoryName + "' cannot be deleted because it does not exist.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: view_factory_delete <viewFactoryName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("view_factory_delete");
            System.out.println("  Deletes a message view factory from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"view_factory_delete"};
        }
    }

    public final class ListViewFactories
    extends Command {
        public final void doList() {
            if (SmaConfigToolPlugin.this.viewFactories.size() > 0) {
                Iterator iterator = SmaConfigToolPlugin.this.viewFactories.keySet().iterator();
                while (iterator.hasNext()) {
                    MessageViewFactoryDescriptor viewFactory = (MessageViewFactoryDescriptor)((Object)SmaConfigToolPlugin.this.viewFactories.get(((String)iterator.next()).toLowerCase()));
                    System.out.println("  " + viewFactory.getName() + " - " + (Object)((Object)viewFactory));
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("No message view factories in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: view_factories");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("view_factories");
            System.out.println("  Lists the message view factories in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"view_factories"};
        }
    }

    public final class CreateViewFactory
    extends Command {
        public final void doCreate(String viewFactoryName, short viewFactoryId, String viewFactoryClassName) {
            if (SmaConfigToolPlugin.this.viewFactories.get(viewFactoryName.toLowerCase()) == null) {
                SmaConfigToolPlugin.this.tracer.log("Creating new message view factory '" + viewFactoryName + "'...", Tracer.Level.INFO);
                try {
                    MessageViewFactoryDescriptor viewFactory = MessageViewFactoryDescriptor.create(viewFactoryName.toLowerCase(), viewFactoryId, viewFactoryClassName);
                    viewFactory.save(SmaConfigToolPlugin.this.repo);
                    SmaConfigToolPlugin.this.viewFactories.put(viewFactoryName.toLowerCase(), viewFactory);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to create view factory '" + viewFactoryName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("message view factory '" + viewFactoryName + "' cannot be created because it already exists.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: view_factory_create <viewFactoryName> <viewFactoryId> <viewFactoryClassName>");
            } else {
                this.doCreate(args[0], Short.valueOf(args[1]), args[2]);
            }
        }

        public final void help() {
            System.out.println("view_factory_create");
            System.out.println("  Creates a new message view factory in the repository");
        }

        public final String[] keywords() {
            return new String[]{"view_factory_create"};
        }
    }

    public final class DeleteEncodingType
    extends Command {
        public final void doDelete(String encodingTypeName) {
            MessageEncodingTypeDescriptor encodingType = (MessageEncodingTypeDescriptor)((Object)SmaConfigToolPlugin.this.encodingTypes.get(encodingTypeName.toLowerCase()));
            if (encodingType != null) {
                SmaConfigToolPlugin.this.tracer.log("Deleting message encoding type '" + encodingType.getName() + "'...", Tracer.Level.INFO);
                try {
                    encodingType.delete(SmaConfigToolPlugin.this.repo);
                    SmaConfigToolPlugin.this.encodingTypes.remove(encodingTypeName);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to delete encoding type '" + encodingTypeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("message encoding type '" + encodingTypeName + "' cannot be deleted because it does not exist.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: encoding_type_delete <encodingTypeName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("encoding_type_delete");
            System.out.println("  Deletes a message encoding type from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"encoding_type_delete"};
        }
    }

    public final class ListEncodingTypes
    extends Command {
        public final void doList() {
            if (SmaConfigToolPlugin.this.encodingTypes.size() > 0) {
                Iterator iterator = SmaConfigToolPlugin.this.encodingTypes.keySet().iterator();
                while (iterator.hasNext()) {
                    MessageEncodingTypeDescriptor encodingType = (MessageEncodingTypeDescriptor)((Object)SmaConfigToolPlugin.this.encodingTypes.get(((String)iterator.next()).toLowerCase()));
                    System.out.println("  " + encodingType.getName() + " - " + (Object)((Object)encodingType));
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("No message encoding types in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: encoding_types");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("encoding_types");
            System.out.println("  Lists the message encoding types in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"encoding_types"};
        }
    }

    public final class CreateEncodingType
    extends Command {
        public final void doCreate(String encodingTypeName, int encodingTypeId, String serializerClassName, String reflectorClassName) {
            if (SmaConfigToolPlugin.this.encodingTypes.get(encodingTypeName.toLowerCase()) == null) {
                SmaConfigToolPlugin.this.tracer.log("Creating new message encoding type '" + encodingTypeName + "'...", Tracer.Level.INFO);
                try {
                    MessageEncodingTypeDescriptor encodingType = MessageEncodingTypeDescriptor.create(encodingTypeName.toLowerCase(), encodingTypeId, serializerClassName, reflectorClassName);
                    encodingType.save(SmaConfigToolPlugin.this.repo);
                    SmaConfigToolPlugin.this.encodingTypes.put(encodingTypeName.toLowerCase(), encodingType);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to create encoding type '" + encodingTypeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("message encoding type '" + encodingTypeName + "' cannot be created because it already exists.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 4) {
                System.out.println("Syntax error: encoding_type_create <encodingTypeName> <encodingTypeId> <encodingTypeSerializerClassName> <encodingTypeReflectorClassName>");
            } else {
                this.doCreate(args[0], Integer.valueOf(args[1]), args[2], args[3]);
            }
        }

        public final void help() {
            System.out.println("encoding_type_create");
            System.out.println("  Creates a new message encoding type in the repository");
        }

        public final String[] keywords() {
            return new String[]{"encoding_type_create"};
        }
    }

    @AnnotatedCommand.Command(keywords={"channel_set_filter"}, description="Sets the filter for a message channel.")
    public final class SetChannelFilter
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="busName", position=0, required=true, description="The name of the bus")
        String busName;
        @AnnotatedCommand.Argument(name="channelName", position=1, required=true, description="The name of channel")
        String channelName;
        @AnnotatedCommand.Argument(name="filter", position=2, required=true, description="The filter value ( (use a value of 'null' to clear the filter)")
        String filter;

        public void execute() throws Exception {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(this.busName));
            if (bus != null) {
                MessageChannelDescriptor channel = bus.getChannel(this.channelName);
                if (channel != null) {
                    SmaConfigToolPlugin.this.tracer.log("Setting channel '" + this.channelName + "' filter to '" + this.filter + "'...", Tracer.Level.INFO);
                    try {
                        channel.setChannelFilter(this.filter);
                        bus.save(SmaConfigToolPlugin.this.repo, null);
                        SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        SmaConfigToolPlugin.this.tracer.log("Failed to set channel filter to '" + this.filter + "' for channel '" + this.channelName + "' in bus '" + this.busName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SmaConfigToolPlugin.this.tracer.log("Channel '" + this.channelName + "' not in bus '" + this.busName + "', cannot set channel filter to '" + this.filter + "'.", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + this.busName + "' does not exist, cannot set channel filter for channel '" + this.channelName + "' to '" + this.filter + "'.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"channel_set_key"}, description="Sets the key for a message channel.")
    public final class SetChannelKey
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="busName", position=0, required=true, description="The name of the bus")
        String busName;
        @AnnotatedCommand.Argument(name="channelName", position=1, required=true, description="The name of channel")
        String channelName;
        @AnnotatedCommand.Argument(name="key", position=2, required=true, description="The key value  (use a value of 'null' to clear the key)")
        String key;

        public void execute() throws Exception {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(this.busName));
            if (bus != null) {
                MessageChannelDescriptor channel = bus.getChannel(this.channelName);
                if (channel != null) {
                    SmaConfigToolPlugin.this.tracer.log("Setting channel '" + this.channelName + "' key to '" + this.key + "'...", Tracer.Level.INFO);
                    try {
                        channel.setChannelKey(this.key);
                        bus.save(SmaConfigToolPlugin.this.repo, null);
                        SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        SmaConfigToolPlugin.this.tracer.log("Failed setting channel '" + this.channelName + "' key to '" + this.key + "' in bus '" + this.busName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SmaConfigToolPlugin.this.tracer.log("Channel '" + this.channelName + "' not in bus '" + this.busName + "', cannot set its key to '" + this.key + ".", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + this.busName + "' does not exist, cannot set channel key for channel '" + this.channelName + "' to '" + this.key + "'.", Tracer.Level.SEVERE);
            }
        }
    }

    public final class SetChannelQos
    extends Command {
        public final void doSet(String busName, String channelName, String qosstr) {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(busName));
            if (bus != null) {
                MessageChannelDescriptor channel = bus.getChannel(channelName);
                if (channel != null) {
                    try {
                        MessageChannel.Qos qos = MessageChannel.Qos.valueOf(qosstr);
                        SmaConfigToolPlugin.this.tracer.log("Setting channel '" + channelName + "' QOS to '" + (Object)((Object)qos) + "'...", Tracer.Level.INFO);
                        channel.setChannelQos(qos);
                        bus.save(SmaConfigToolPlugin.this.repo, null);
                        SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                    }
                    catch (IllegalArgumentException e) {
                        SmaConfigToolPlugin.this.tracer.log("Invalid QOS '" + qosstr + "' for channel '" + channelName + "' in bus '" + busName + "'.", Tracer.Level.SEVERE);
                    }
                    catch (Exception e) {
                        SmaConfigToolPlugin.this.tracer.log("Failed to set QOS to '" + qosstr + "' for channel '" + channelName + "' in bus '" + busName + "'. " + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SmaConfigToolPlugin.this.tracer.log("Channel '" + channelName + "' not in bus '" + busName + "', cannot set its QOS.", Tracer.Level.WARNING);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' does not exist.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: channel_set_qos <busName> <channelName> <qos>");
            } else {
                this.doSet(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("channel_set_qos");
            System.out.println("  Sets a channel QOS.");
        }

        public final String[] keywords() {
            return new String[]{"channel_set_qos"};
        }
    }

    public final class SetChannelId
    extends Command {
        public final void doSet(String busName, String channelName, short id) {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(busName));
            if (bus != null) {
                MessageChannelDescriptor channel = bus.getChannel(channelName);
                if (channel != null) {
                    SmaConfigToolPlugin.this.tracer.log("Setting channel '" + channelName + "' id to " + id + "...", Tracer.Level.INFO);
                    try {
                        channel.setChannelId(id);
                        bus.save(SmaConfigToolPlugin.this.repo, null);
                        SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        SmaConfigToolPlugin.this.tracer.log("Failed to set channel id for channel '" + channelName + "' in bus '" + busName + "'. [" + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SmaConfigToolPlugin.this.tracer.log("Channel '" + channelName + "' not in bus '" + busName + "', cannot set channel id.", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' does not exist, cannot set channel id for channel '" + channelName + "'.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: channel_set_id <busName> <channelName> <id>");
            } else {
                this.doSet(args[0], args[1], Short.parseShort(args[2]));
            }
        }

        public final void help() {
            System.out.println("channel_set_id");
            System.out.println("  Sets a channel id (use a value of -1 to clear the id).");
        }

        public final String[] keywords() {
            return new String[]{"channel_set_id"};
        }
    }

    public final class DeleteChannel
    extends Command {
        public final void doDelete(String busName, String channelName) {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(busName));
            if (bus != null) {
                MessageChannelDescriptor channel = bus.getChannel(channelName);
                if (channel != null) {
                    SmaConfigToolPlugin.this.tracer.log("Deleting channel '" + channelName + "' from message bus '" + busName + "'...", Tracer.Level.INFO);
                    try {
                        bus.removeChannel(channelName);
                        channel.delete(SmaConfigToolPlugin.this.repo);
                        bus.save(SmaConfigToolPlugin.this.repo, null);
                        SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        SmaConfigToolPlugin.this.tracer.log("Failed [" + e.toString() + "]", Tracer.Level.INFO);
                    }
                } else {
                    SmaConfigToolPlugin.this.tracer.log("Channel '" + channelName + "' not in bus '" + busName + "' so it cannot be deleted.", Tracer.Level.WARNING);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' does not exist, channel '" + channelName + "' cannot be deleted from it.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: channel_delete <busName> <channelName>");
            } else {
                this.doDelete(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("channel_delete");
            System.out.println("  Deletes a channel from a message bus (includes removing the channel from the repository)");
        }

        public final String[] keywords() {
            return new String[]{"channel_delete"};
        }
    }

    public final class RemoveChannel
    extends Command {
        public final void doRemove(String busName, String channelName) {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(busName));
            if (bus != null) {
                if (bus.getChannel(channelName) != null) {
                    SmaConfigToolPlugin.this.tracer.log("Removing channel '" + channelName + "' from message bus '" + busName + "'...", Tracer.Level.INFO);
                    try {
                        bus.removeChannel(channelName);
                        bus.save(SmaConfigToolPlugin.this.repo, null);
                        SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        SmaConfigToolPlugin.this.tracer.log("Failed to remove channel '" + channelName + "' from bus '" + busName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SmaConfigToolPlugin.this.tracer.log("Channel '" + channelName + "' not in bus '" + busName + "' so it cannot be removed.", Tracer.Level.WARNING);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' does not exist, cannot remove channel '" + channelName + "' from it.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: channel_remove <busName> <channelName>");
            } else {
                this.doRemove(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("channel_remove");
            System.out.println("  Removes a channel from a message bus (channel remains in repository)");
        }

        public final String[] keywords() {
            return new String[]{"channel_remove"};
        }
    }

    public final class AddChannel
    extends Command {
        public final void doAdd(String busName, String channelName) {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(busName));
            if (bus != null) {
                if (bus.getChannel(channelName) == null) {
                    SmaConfigToolPlugin.this.tracer.log("Adding channel '" + channelName + "' to message bus '" + busName + "'...", Tracer.Level.INFO);
                    try {
                        if (MessageChannelDescriptor.exists(SmaConfigToolPlugin.this.repo, busName, channelName)) {
                            SmaConfigToolPlugin.this.tracer.log("  Channel in repository but not in bus. Adding to bus...", Tracer.Level.INFO);
                            bus.addChannel(MessageChannelDescriptor.load(SmaConfigToolPlugin.this.repo, bus, channelName, null));
                        } else {
                            SmaConfigToolPlugin.this.tracer.log("  Channel not in repository. Creating fresh...", Tracer.Level.INFO);
                            bus.addChannel(MessageChannelDescriptor.create(channelName, bus));
                        }
                        bus.save(SmaConfigToolPlugin.this.repo, null);
                        SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        SmaConfigToolPlugin.this.tracer.log("Failed to add channel '" + channelName + "' to bus '" + busName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SmaConfigToolPlugin.this.tracer.log("Channel '" + channelName + "' already in bus '" + busName + "'.", Tracer.Level.WARNING);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' does not exist, cannot add channel '" + channelName + "'", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: channel_add <busName> <channelName>");
            } else {
                this.doAdd(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("channel_add");
            System.out.println("  Creates and adds a channel to a message bus");
        }

        public final String[] keywords() {
            return new String[]{"channel_add"};
        }
    }

    public final class UnlocalizeBus
    extends Command {
        public final void doClear(String busName) {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(busName));
            if (bus != null) {
                SmaConfigToolPlugin.this.tracer.log("Clearing message bus '" + bus.getName() + "' localization information...", Tracer.Level.INFO);
                try {
                    bus.getProviderConfig().clear();
                    bus.save(SmaConfigToolPlugin.this.repo, null);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to unlocalize bus '" + busName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' cannot be unlocalized because it does not exist.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: bus_unlocalize <busName>");
            } else {
                this.doClear(args[0]);
            }
        }

        public final void help() {
            System.out.println("bus_unlocalize");
            System.out.println("  Clear a message bus's provider configuration.");
        }

        public final String[] keywords() {
            return new String[]{"bus_unlocalize"};
        }
    }

    public final class LocalizeBus
    extends Command {
        public final void doSet(String busName, String descriptorStr, boolean force) {
            block5: {
                MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(busName));
                if (bus != null) {
                    SmaConfigToolPlugin.this.tracer.log("Localizing message bus '" + bus.getName() + "' using '" + descriptorStr + "' (force=" + force + ")...", Tracer.Level.INFO);
                    try {
                        bus.getProviderConfig().clear();
                        bus.setProviderConfig(descriptorStr);
                        String provider = bus.getProviderConfig().getProperty("Provider");
                        if (force || SmaConfigToolPlugin.this.providers.get(provider.toLowerCase()) != null) {
                            bus.save(SmaConfigToolPlugin.this.repo, null);
                            SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                            break block5;
                        }
                        SmaConfigToolPlugin.this.tracer.log("Failed to localize bus '" + busName + "': invalid messaging provider '" + provider + "'", Tracer.Level.SEVERE);
                        bus.getProviderConfig().clear();
                    }
                    catch (Exception e) {
                        SmaConfigToolPlugin.this.tracer.log("Failed to localize bus '" + busName + "' with '" + descriptorStr + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' cannot be localized  with '" + descriptorStr + "' because it does not exist.", Tracer.Level.SEVERE);
                }
            }
        }

        public final void run(String[] args) {
            if (args.length != 2 && args.length != 3) {
                System.out.println("Syntax error: bus_localize <busName> <descriptorStr> [force]");
            } else {
                this.doSet(args[0], args[1], args.length == 2 ? false : args[2].equalsIgnoreCase("force"));
            }
        }

        public final void help() {
            System.out.println("bus_localize");
            System.out.println("  Sets a message bus's provider configuration.");
        }

        public final String[] keywords() {
            return new String[]{"bus_localize"};
        }
    }

    public final class DeleteBus
    extends Command {
        public final void doDelete(String busName) {
            MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(busName));
            if (bus != null) {
                SmaConfigToolPlugin.this.tracer.log("Deleting message bus '" + bus.getName() + "'...", Tracer.Level.INFO);
                try {
                    bus.delete(SmaConfigToolPlugin.this.repo);
                    SmaConfigToolPlugin.this.buses.remove(busName);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to delete bus '" + bus.getName() + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' cannot be deleted because it does not exist.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: bus_delete <busName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("bus_delete");
            System.out.println("  Deletes a message bus from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"bus_delete"};
        }
    }

    public final class ListBuses
    extends Command {
        public final void doList() {
            if (SmaConfigToolPlugin.this.buses.size() > 0) {
                Iterator iterator = SmaConfigToolPlugin.this.buses.keySet().iterator();
                while (iterator.hasNext()) {
                    MessageBusDescriptor bus = (MessageBusDescriptor)((Object)SmaConfigToolPlugin.this.buses.get(iterator.next()));
                    Set<MessageChannelDescriptor> channels = bus.getChannels();
                    Iterator<MessageChannelDescriptor> iterator1 = channels.iterator();
                    System.out.println("\n  Bus " + (Object)((Object)bus));
                    if (channels.size() > 0) {
                        while (iterator1.hasNext()) {
                            System.out.println("  ....Channel " + (Object)((Object)iterator1.next()));
                        }
                        continue;
                    }
                    System.out.println("  ....<no channels>");
                }
                System.out.println("");
            } else {
                SmaConfigToolPlugin.this.tracer.log("No buses in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: buses");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("buses, buses");
            System.out.println("  Lists the message buses in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"buses"};
        }
    }

    public final class CreateBus
    extends Command {
        public final void doCreate(String busName) {
            if (SmaConfigToolPlugin.this.buses.get(busName) == null) {
                SmaConfigToolPlugin.this.tracer.log("Creating new message bus '" + busName + "'...", Tracer.Level.INFO);
                try {
                    MessageBusDescriptor bus = MessageBusDescriptor.create(busName);
                    bus.save(SmaConfigToolPlugin.this.repo, null);
                    SmaConfigToolPlugin.this.buses.put(busName, bus);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to create bus '" + busName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("Bus '" + busName + "' already exists.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: bus_create <busName>");
            } else {
                this.doCreate(args[0]);
            }
        }

        public final void help() {
            System.out.println("bus_create");
            System.out.println("  Creates a new message bus in the repository");
        }

        public final String[] keywords() {
            return new String[]{"bus_create"};
        }
    }

    public final class DeleteBusProvider
    extends Command {
        public final void doDelete(String providerName) {
            MessagingProviderDescriptor provider = (MessagingProviderDescriptor)((Object)SmaConfigToolPlugin.this.providers.get(providerName.toLowerCase()));
            if (provider != null) {
                SmaConfigToolPlugin.this.tracer.log("Deleting messaging provider '" + provider.getName() + "'...", Tracer.Level.INFO);
                try {
                    provider.delete(SmaConfigToolPlugin.this.repo);
                    SmaConfigToolPlugin.this.providers.remove(providerName);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to delete messaging provider '" + provider.getName() + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("messaging provider '" + providerName + "' cannot be deleted because it does not exist.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: bus_provider_delete <providerName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("bus_provider_delete");
            System.out.println("  Deletes a messaging provider from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"bus_provider_delete"};
        }
    }

    public final class ListBusProviders
    extends Command {
        public final void doList() {
            if (SmaConfigToolPlugin.this.providers.size() > 0) {
                Iterator iterator = SmaConfigToolPlugin.this.providers.keySet().iterator();
                while (iterator.hasNext()) {
                    MessagingProviderDescriptor provider = (MessagingProviderDescriptor)((Object)SmaConfigToolPlugin.this.providers.get(((String)iterator.next()).toLowerCase()));
                    System.out.println("  " + provider.getName() + " - " + (Object)((Object)provider));
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("No messaging providers in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: bus_providers");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("bus_providers");
            System.out.println("  Lists the messaging providers in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"bus_providers"};
        }
    }

    public final class CreateBusProvider
    extends Command {
        public final void doCreate(String providerName, String providerClassName) {
            if (SmaConfigToolPlugin.this.providers.get(providerName.toLowerCase()) == null) {
                SmaConfigToolPlugin.this.tracer.log("Creating new messaging provider '" + providerName + "'...", Tracer.Level.INFO);
                try {
                    MessagingProviderDescriptor provider = MessagingProviderDescriptor.create(providerName.toLowerCase(), providerClassName);
                    provider.save(SmaConfigToolPlugin.this.repo);
                    SmaConfigToolPlugin.this.providers.put(providerName.toLowerCase(), provider);
                    SmaConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SmaConfigToolPlugin.this.tracer.log("Failed to create bus provider '" + providerName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SmaConfigToolPlugin.this.tracer.log("messaging provider '" + providerName + "' cannot be created because it already exists.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: bus_provider_create <providerName> <providerClassName>");
            } else {
                this.doCreate(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("bus_provider_create");
            System.out.println("  Creates a new messaging provider in the repository");
        }

        public final String[] keywords() {
            return new String[]{"bus_provider_create"};
        }
    }
}

