/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.root.RootConfig;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.SmaConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;

public final class MessageWaypointListenerRegistry {
    private static final Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)SmaConfig.getConfig());
    private static volatile MessageWaypointListener registeredListener;

    public static final void registerMessageWaypointListener(MessageWaypointListener listener) {
        registeredListener = listener;
    }

    public static final void dispatch(MessageWaypointListener.Waypoint waypoint, MessageWaypointListener.MessagingDirection direction, Object message) {
        MessageWaypointListener listener = registeredListener;
        if (listener != null) {
            try {
                listener.onWaypoint(waypoint, direction, message);
            }
            catch (Throwable thrown) {
                tracer.log("[WAYPOINT LISTENER] Error in MessageWaypointListener listener ... ignoring: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            }
        }
    }
}

