/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XCollectionIterator;
import com.neeve.lang.XIntIterator;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XIntMap;
import com.neeve.lang.XIntSet;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogIntMap;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogCollectionNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RogXIntMap<V extends IRogCollectionNodeElement>
extends RogCollectionNode<V>
implements IRogIntMap<V> {
    private final int initialCapacity = XRuntime.getValue((String)("nv.rog.map." + this.getClass().getName() + ".initialCapacity"), (int)0);
    private final XIntLinkedHashMap<V> map = this.initialCapacity > 0 ? new XIntLinkedHashMap(this.initialCapacity) : new XIntLinkedHashMap();
    private Set<Map.Entry<Integer, V>> boxedEntrySet;
    private Set<Integer> boxedKeySet;

    protected RogXIntMap(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
        this.map.setSupportsIteratorModifications(false);
    }

    protected abstract int getMapElementKey(V var1);

    protected abstract void setMapElementKey(V var1, int var2);

    @Override
    protected final void onChildAddRollback(RogNode element) {
        this.map.remove(this.getMapElementKey((IRogCollectionNodeElement)((Object)element)));
    }

    @Override
    protected final void onChildRemoveRollback(RogNode element) {
        this.add((IRogCollectionNodeElement)((Object)element));
    }

    private final V add(V element) {
        return (V)((IRogCollectionNodeElement)this.map.put(this.getMapElementKey(element), element));
    }

    @Override
    protected final void visitFields(RogGraphVisitor visitor) {
        int i = 0;
        XCollectionIterator iterator = this.map.reuseableEntryIterator();
        while (iterator.hasNext()) {
            XIntMap.Entry entry = (XIntMap.Entry)iterator.next();
            this.visitField(visitor, "Key " + i, entry.getKey());
            this.visitField(visitor, "Value " + i, (RogNode)entry.getValue());
            ++i;
        }
    }

    @Override
    protected PktPacket getStoreCommitPacket() {
        return PktFactory.getInstance().createPacket(257);
    }

    @Override
    public final void clear() {
        XIntIterator iterator = this.map.reuseableKeyIterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
            this.map.reuseableKeyIterator();
        }
        this.map.clear();
    }

    @Override
    public final boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public final boolean containsKey(Integer key) {
        if (key == null) {
            return false;
        }
        return this.containsKey((int)key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    @Override
    public final boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    @Override
    public final Set<Map.Entry<Integer, V>> entrySet() {
        if (this.boxedEntrySet == null) {
            this.boxedEntrySet = new EntrySet();
        }
        return this.boxedEntrySet;
    }

    @Override
    public final Set<Integer> keySet() {
        if (this.boxedKeySet == null) {
            this.boxedKeySet = new KeySet();
        }
        return this.boxedKeySet;
    }

    public final XIntSet keyIntSet() {
        return this.map.keySet();
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    @Override
    public final boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public final V get(int key) {
        return (V)((IRogCollectionNodeElement)this.map.get(key));
    }

    public final V get(Integer key) {
        if (key == null) {
            return null;
        }
        return this.get((int)key);
    }

    @Override
    public final V get(Object key) {
        if (key instanceof Integer) {
            return this.get((Integer)key);
        }
        return null;
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final XIntIterator reuseableKeyIterator() {
        return this.map.reuseableKeyIterator();
    }

    @Override
    public final XIterator<V> reuseableValueIterator() {
        return this.map.reuseableValueIterator();
    }

    @Override
    public XIterator<XIntMap.Entry<V>> reuseableEntryIterator() {
        return this.map.reuseableEntryIterator();
    }

    @Override
    public final V put(int key, V value) {
        V rc;
        if (value.getParent() == this && key == this.getMapElementKey(value)) {
            return value;
        }
        if (this.getMapElementKey(value) != key) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove(key);
                this.map.put(key, rc);
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final V put(Integer key, V value) {
        if (key == null) {
            throw new NullPointerException("Null values not supported");
        }
        return this.put((int)key, value);
    }

    public final void putAll(XIntMap<? extends V> from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends Integer, ? extends V> from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(int key) {
        IRogCollectionNodeElement element = (IRogCollectionNodeElement)this.map.remove(key);
        if (element != null) {
            this.setMapElementKey(element, key + 1);
            this.removeChild(element);
        }
        return (V)element;
    }

    public final V remove(Integer key) {
        if (key == null) {
            return null;
        }
        return this.remove((int)key);
    }

    @Override
    public final V remove(Object key) {
        if (key instanceof Integer) {
            return this.remove((Integer)key);
        }
        return null;
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final void addChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.put(this.getMapElementKey(mapElement), (V)mapElement);
    }

    @Override
    public final void removeChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.remove(this.getMapElementKey(mapElement));
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.map.clear();
        }
        return count;
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return RogXIntMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXIntMap.this.isEmpty();
        }

        @Override
        public final Iterator<Map.Entry<Integer, V>> iterator() {
            final Iterator it = RogXIntMap.this.map.entrySet().iterator();
            return new Iterator<Map.Entry<Integer, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<Integer, V> next() {
                    final XIntMap.Entry e = (XIntMap.Entry)it.next();
                    return new Map.Entry<Integer, V>(){

                        @Override
                        public Integer getKey() {
                            return e.getKey();
                        }

                        @Override
                        public V getValue() {
                            return (IRogCollectionNodeElement)e.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(Map.Entry<Integer, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Integer, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<Integer> {
        KeySet() {
        }

        @Override
        public int size() {
            return RogXIntMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXIntMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return RogXIntMap.this.containsKey(o);
        }

        @Override
        public Iterator<Integer> iterator() {
            final XIntIterator it = RogXIntMap.this.map.keySet().iterator();
            return new Iterator<Integer>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Integer next() {
                    return it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        }

        @Override
        public boolean add(Integer e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

