/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoBooleanArrayField;
import com.neeve.sto.StoField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class StoBooleanArrayFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final boolean[] createArray(int len) {
        boolean[] array = new boolean[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = random.nextBoolean();
        }
        return array;
    }

    public static final boolean[] cloneArray(boolean[] original) {
        boolean[] clone = new boolean[original.length];
        System.arraycopy(original, 0, clone, 0, original.length);
        return clone;
    }

    public static final void compare(boolean[] array1, boolean[] array2, boolean same) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (same) {
            Assert.assertSame((Object)array1, (Object)array2);
        } else if (array2 == null) {
            Assert.fail();
        } else if (array1.length != array2.length) {
            Assert.fail();
        } else {
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                Assert.fail();
            }
        }
    }

    private final void validate(StoBooleanArrayField field, String name, ByteBuffer buffer, boolean[] val, boolean same) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.BOOLEAN_ARRAY), (Object)((Object)field.getType()));
        StoBooleanArrayFieldTest.compare(val, (boolean[])field.getValue(), same);
    }

    private final void cloneAndValidate(StoBooleanArrayField field, String name, boolean[] val) {
        StoBooleanArrayField clone = (StoBooleanArrayField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val, false);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoBooleanArrayField.getSerializedLength(StoBooleanArrayFieldTest.createArray(5)), (long)7L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoBooleanArrayField.put(buffer, 5, null);
        Assert.assertEquals((long)StoBooleanArrayField.getSerializedLength(buffer, 5), (long)2L);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayFieldTest.compare(StoBooleanArrayField.get(buffer, 5), null, false);
        this.validate(buffer, 0, 100, 100);
        boolean[] array1 = StoBooleanArrayFieldTest.createArray(0);
        StoBooleanArrayField.put(buffer, 5, array1);
        Assert.assertEquals((long)StoBooleanArrayField.getSerializedLength(buffer, 5), (long)2L);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayFieldTest.compare(StoBooleanArrayField.get(buffer, 5), array1, false);
        this.validate(buffer, 0, 100, 100);
        array1 = StoBooleanArrayFieldTest.createArray(5);
        boolean[] array2 = StoBooleanArrayFieldTest.createArray(5);
        StoBooleanArrayField.put(buffer, 5, array1);
        Assert.assertEquals((long)StoBooleanArrayField.getSerializedLength(buffer, 5), (long)7L);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayFieldTest.compare(StoBooleanArrayField.get(buffer, 5), array1, false);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayField.put(buffer, 5, array2);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayFieldTest.compare(StoBooleanArrayField.get(buffer, 5), array2, false);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create(null);
        this.validate(field, null, null, null, true);
        this.cloneAndValidate(field, null, null);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create("name");
        this.validate(field, "name", null, null, true);
        this.cloneAndValidate(field, "name", null);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertTrue((boolean)StoBooleanArrayField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create(null);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(field, null, null, array, true);
        this.cloneAndValidate(field, null, array);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create("name");
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(field, "name", null, array, true);
        this.cloneAndValidate(field, "name", array);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, null, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, null, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayFieldTest.compare(StoBooleanArrayField.get(buffer, field.shiftForHeader(45)), array, false);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoBooleanArrayField field = StoBooleanArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field.setValue(array);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayFieldTest.compare(StoBooleanArrayField.get(buffer, field.shiftForHeader(52)), array, false);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoBooleanArrayField field3 = (StoBooleanArrayField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, array, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, array);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer1, 32);
        this.validate(buffer1, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer1, 32);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoBooleanArrayField field3 = (StoBooleanArrayField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, array, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", array);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetNullValueDeserialize() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(null);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetEmptyValueDeserialize() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        boolean[] array = StoBooleanArrayFieldTest.createArray(0);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoBooleanArrayField field2 = (StoBooleanArrayField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 65);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoBooleanArrayField.create("name").contentsEquals(StoBooleanArrayField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoBooleanArrayField.create(null).contentsEquals(StoBooleanArrayField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoBooleanArrayField.create("name1").contentsEquals(StoBooleanArrayField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        StoBooleanArrayField field2 = StoBooleanArrayField.create(null);
        field1.setValue(StoBooleanArrayFieldTest.createArray(5));
        field2.setValue(null);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        StoBooleanArrayField field2 = StoBooleanArrayField.create(null);
        field1.setValue(null);
        field2.setValue(StoBooleanArrayFieldTest.createArray(5));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffLengths() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        StoBooleanArrayField field2 = StoBooleanArrayField.create(null);
        field1.setValue(StoBooleanArrayFieldTest.createArray(5));
        field2.setValue(StoBooleanArrayFieldTest.createArray(4));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        StoBooleanArrayField field2 = StoBooleanArrayField.create(null);
        field1.setValue(StoBooleanArrayFieldTest.createArray(5));
        field2.setValue(StoBooleanArrayFieldTest.createArray(5));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        StoBooleanArrayField field2 = StoBooleanArrayField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create("name");
        StoBooleanArrayField field2 = StoBooleanArrayField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create(null);
        StoBooleanArrayField field2 = StoBooleanArrayField.create(null);
        field1.setValue(StoBooleanArrayFieldTest.createArray(5));
        field2.setValue(StoBooleanArrayFieldTest.cloneArray((boolean[])field1.getValue()));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoBooleanArrayField field1 = StoBooleanArrayField.create("name");
        StoBooleanArrayField field2 = StoBooleanArrayField.create("name");
        field1.setValue(StoBooleanArrayFieldTest.createArray(5));
        field2.setValue(StoBooleanArrayFieldTest.cloneArray((boolean[])field1.getValue()));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

